import numpy as np
import time
import sys
import os
from numpy import linalg as LA
import scipy.stats as ss
from sklearn.linear_model import LinearRegression
import serv_manager as svm

Dir_ics = "./ics_original_010/"
PPC = 10
TAG = "O010"

alphabet2number = {
    "0":0,  "1":1,  "2":2,  "3":3,
    "4":4,  "5":5,  "6":6,  "7":7,
    "8":8,  "9":9,  "a":10, "b":11,
    "c":12, "d":13, "e":14, "f":15
}

Bits = np.matrix(np.load("Bits.npy"))

def training(byte, group):
  SETnum = 400
  Total_Tnum = SETnum*160
  print("==============")
  print([byte, group])
  ints = byte//4
  icsname = Dir_ics+"ics_"+group+"_i"+str(ints).zfill(2)+".npy"
  ICS = svm.Load(icsname)
  Pnum = PPC*len(ICS)
  print("Loading Intermediate Values (in bits)...", time.asctime())
  intername = "./intermediate_B_"+group+"/"+group+"_b"+str(byte).zfill(3)+".npy"
  InterBits = svm.Load(intername)
  print("Loading Resampled Trace Data", time.asctime())
  Re_Traces = np.zeros((0, Pnum))
  set_dir = "./Ints_"+group+"_i"+str(ints).zfill(2)+"/"
  for t_set in range(0, SETnum):
    setname = set_dir+"set_"+str(t_set).zfill(3)+".npy"
    rTraces = svm.Load(setname)
    Re_Traces= np.vstack([Re_Traces, rTraces])
  Re_Traces = np.transpose(Re_Traces)
  rTraces = []
  ## Get Models ##################
  print(len(Re_Traces), len(Re_Traces[0]), time.asctime())
  Models = []
  Zero = []
  for p in range(0, Pnum):
    if p%PPC==0:
      print("point ", p,"/",Pnum)
    Zero.append(0.0)
    model = []
    samples = Re_Traces[p]
    reg = LinearRegression().fit(InterBits, samples)
    expect = reg.predict(InterBits)
    bb = reg.coef_
    aa = reg.intercept_
    whole = aa
    for b in range(0, 8):
      model.append(bb[b])
    model.append(aa)
    Models.append(model)
  Model_matx = np.transpose(np.matrix(Models))
  Models = []
  #######################################################
  Re_Traces = np.transpose(Re_Traces)
  InterBits = np.matrix(np.hstack([InterBits, np.ones((Total_Tnum, 1))]))
  ## Adding B #########################################
  print("  Adding B", time.asctime())
  AVE_mat = np.matrix(np.ones((Total_Tnum, 1)))*np.matrix([[0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0]])
  sub_inter = (InterBits-AVE_mat)*Model_matx
  Bmat = np.transpose(sub_inter)*sub_inter
  ## Adding W #########################################
  print("  Adding W", time.asctime())
  sub_inner = np.matrix(Re_Traces)-InterBits*Model_matx
  Wmat = np.transpose(sub_inner)*sub_inner
  #####################################################
  print("  Finding A", time.asctime())
  AVectors = np.zeros((Pnum, 0))
  Target = (Wmat.I)*Bmat
  EigVLs, EigVRs = LA.eig(Target)
  tempEigVLs = abs(EigVLs)
  non_zero = 0
  for VIndx in range(0, len(tempEigVLs)):
    if tempEigVLs[VIndx]>(0.001*sum(tempEigVLs)):
      print(VIndx, tempEigVLs[VIndx])
      non_zero+=1
      A = EigVRs[:,VIndx]
      AVectors = np.hstack([AVectors, A])
  print("There are "+str(non_zero)+" non-zero vectors")
  print("Total: ", sum(tempEigVLs))
  print("  Compressing", time.asctime())
  Scov = np.transpose(AVectors)*Wmat*AVectors
  Scov *= 1.0/(float(Total_Tnum-9))
  #######################################################
  fname = "./templateLDA_NEW/template_"+group+"/template"
  Sname = fname+"_scov_b"+str(byte).zfill(3)+".npy"
  svm.Save(Sname, Scov)
  Aname = fname+"_avts_b"+str(byte).zfill(3)+".npy"
  svm.Save(Aname, AVectors)
  Expects = Bits*Model_matx*AVectors
  Ename = fname+"_expect_b"+str(byte).zfill(3)+".npy"
  svm.Save(Ename, Expects)
  print("  Finished.", time.asctime())
  return

if __name__=='__main__':
  tS = time.time()
  print(time.asctime())
  Gr = sys.argv[1]
  lower = int(sys.argv[2])
  upper = int(sys.argv[3])
  for ints in range(lower, upper):
    os.system("kinit -R")
    Name_Int = "Ints_"+Gr+"_i"+str(ints).zfill(2)
    cmd = "unzip -qq ./ICS/"+Name_Int+".zip"
    print(cmd)
    svm.System(cmd)
    for byte in range((ints*4),(ints*4+4)):
      training(byte, Gr)
    cmd = "rm -r "+Name_Int+"/"
    print(cmd)
    svm.System(cmd)
    print(time.asctime())
  tE = time.time()
  print("Exe. time = ", tE-tS)


