import numpy as np
import chipwhisperer as cw
import time
import sys
import KECCAK
class Test:
  def __init__(self, FCPU = 0):
    self.log = []
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    cw.program_target(self.scope, cw.programmers.STM32FProgrammer, "./simpleserial-sha3-CWLITEARM.hex")
    time.sleep(1)
    self.scope.io.target_pwr = False
    self.scope.dis()
    self.scope = cw.scope()
    self.scope.default_setup()
    if FCPU!=0:
      self.scope.clock.clkgen_freq = FCPU
      print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    time.sleep(1)
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    self.scope.io.target_pwr = True
    self.target = cw.target(self.scope)
    self.scope.io.target_pwr = False
    time.sleep(0.5)
    self.scope.io.target_pwr = True
    time.sleep(0.1)
    print("HELLO?", self.target.read().strip('\n'))
    return

  def test1(self, p, d):
    d_it = d>>3
    d_tail = d%8
    P_size = int(len(p)/2)
    #print(P_size)
    size_tag = hex(P_size%256)[2:].zfill(2)+hex(P_size>>8)[2:].zfill(2)
    #print(size_tag)
    d_tag = hex(d%256)[2:].zfill(2)+hex(d>>8)[2:].zfill(2)
    self.target.write(("x06"+size_tag+d_tag+"\n"))
    time.sleep(0.1)
    discard = self.target.read()
    print(discard[0:8])
    print("Input :", p)
    N_input = int(P_size/8)
    for p_frag in range(0, (N_input+1)):
      if p_frag==N_input:
        frag = "i"+(p[(p_frag*16):].ljust(16, '0'))+"\n"
      else:
        frag = "i"+p[(p_frag*16):(p_frag*16+16)]+"\n"
      #print("Set plaintext "+frag)     
      self.target.write(frag)
      time.sleep(0.1)
      discard = self.target.read()
      #print(discard)
    self.target.write("k\n")
    print("Executing Keccak")
    time.sleep(1.0)
    discard = (self.target.read())
    cipher = ""
    for c_frag in range(0, d_it+1):
      self.target.write("o\n")
      #print("Find out cipher part "+str(c_frag))
      time.sleep(0.1)
      cccc = self.target.read()
      #print(cccc)
      if c_frag==d_it:
        cipher += cccc[1:(2*d_tail+1)]
      else:
        cipher += cccc[1:17]
    print("Output:", cipher)
    self.log.append(cipher)
    return cipher.lower()

  def log_print(self):
    for t in self.log:
      print(t)
    return

  def close(self):
    self.scope.io.target_pwr = False
    time.sleep(2)
    self.scope.io.target_pwr = True
    self.target.dis()
    self.scope.dis()
    return

if __name__=='__main__':
  FC = 5000000
  Temp = Test(FC)
  print("=====================================================================================")
  plain = "11"
  B = 32
  cipher = "f2c70a81ec65bbd0c0ccaa020d3a8dc4940f0333bd845b66933d0bfabbec846f"
  own = KECCAK.SHAKE256(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00"
  B = 16
  cipher = "b8d01df855f7075882c636f6ddeacf41"
  own = KECCAK.SHAKE256(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566"
  B = 36
  cipher = "fec79241315505e51ed9a86def9589352a795146e4bec92138587641fdecce12469d13c2"
  own = KECCAK.SHAKE256(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff0011223344556677"
  B = 81
  cipher = "42c58c381b72b03a9e213f4d912fbcf6515e0f6777c0e83d1d81b7ae67199940377b0a3703d33857f47e0143b6527a991307c05776d2a938a5ada3cd67a4566fee3effbca6faf005760e45960dccdb2da3"
  own = KECCAK.SHAKE256(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "2580d82d0d1a4868e89f706d48aa6013137fc502e8dd3c8987c2ed333146dde0f5bec88672a3484ea6678d5c6530703c152b386071fb5cbd6ad6ef4a051730fc431e21cd1dd3eb054e3562e5ea827c6786cddf2707ff77de73c3834a3dbaa3794cb333cb5b53b3428dc5a2773697cf4510bb59627f2f26676cf337e06aeef7ef4b4594d042fbf010f6da257266c8b97b240bb9505d2c8a01b618cb3a824d08643bef7a9288c679fe8eb781185007bc569859bceb84496833eaaa5a3894e67a421968ab6643f055feed003c301274898748df4439081d2135dda1f04ce1cfaba6e3d5045de23e9617780cb524be1a5a29c83e4ceca91ee7ad1c18f282d5350524dccf79012044f1aa347306e9c54ffe2055b283161e3eda536609d209efe4971b29ffdd54a546bd1e19d0ade50128c57d0345af1127120c2824739e58d4352f24b1832cc8eb917a4b3ea6978fe27b143517797f57c39b80925f19894b0e97aa4ffad5124cb0ab236ca1865ce16e43421c06d021ae5ad49f8b8fa975fe9884cc8bbcc6c9ccb8873daca8547d524a2ca4a28151c3d4c24fa1647df1d264f9db81775d4636b1fd71e397b5c304d54f61640cabcb5d577fe2dc61ea804f0978db0ad4746e73e8fa4dd1541ad63a4540add493007f8ef44f1a4e6d25001a895ada9a7ee042ff1c2a2415f95d64600117997731c07b0825"
  B = 331
  cipher = "14c3a60fded29b3b979f8fd0ee9124acff7dbc970d109f6ede27f8ddd2e19613aa606ef9b2cb8af046d65a8b94baa4764815c82a61a4593a954d6275d5ecfa8e2699df088d318b6ef9b6ba472190c0c339febbb69031a7eee722e4755b5d8c352558c812ce2b1914876531ff8847507e7989adf7634134e81fef84f323846b54cba2b44a0d113244532fd22cd4ac8707421a47eb24422f60c6494a176e8fe8cb1ca965b65d7af093c1d13e66a206bdbc4c1c990babfefa2b0868c6c35d0c68dde0f51ba2e1305dd31bf843a923be3ceceec848172354c6a9f91e9f898687f4e3c62da836c4fb5678e6ca0de2fb389e6ffdae435f304e9d5ff325552c5132c80d74e9fbf3e5503712e2c19bedd4305bbb973c1f934262b098bc1919c8c05645e52193187957de5513701de2facb4166ef3d85aa5b542f4734d50a754804a3189e62df07322d3ae5b2c094dc"
  own = KECCAK.SHAKE256(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  #Temp.log_print()
  Temp.close()

