import time
import niscope
from array import array
import matplotlib.pyplot as plt

class NIScope:
  def __init__(self, numb, S_rate, Nsample):
    self.numb = numb
    self.session = niscope.Session('scope')
    self.session.input_clock_source = "VAL_PXI_CLK"
    self.session.channels[0].configure_vertical(range=0.1, coupling=niscope.VerticalCoupling.DC)
    self.session.channels[0].input_impedance = 50
    self.session.channels[1].configure_vertical(range=0.1, coupling=niscope.VerticalCoupling.DC)
    self.session.channels[1].input_impedance = 50
    self.session.configure_horizontal_timing(S_rate, Nsample, 1.0, self.numb, True)
    self.session.configure_trigger_edge(trigger_source='TRIG', level=1.4, trigger_coupling=niscope.TriggerCoupling.DC)
    self.session.trigger_impedance = 1000000

  def check_locked(self):
    print(self.session.input_clock_source)
    print(self.session.ref_clk_rate)
    print(self.session.trigger_source)
    print("Locked: ", self.session.pll_lock_status)
    print("Imp ch0: ", self.session.channels[0].input_impedance)
    print("Imp ch1: ", self.session.channels[1].input_impedance)
    print("Imp trig:", self.session.trigger_impedance)
    print("Max Freq ch0:", self.session.channels[0].max_input_frequency)
    print("Max Freq ch1:", self.session.channels[1].max_input_frequency)

  def record(self, outname):
    with self.session.initiate():
      #self.check_locked()
      waveforms = self.session.channels[0].fetch(num_records = self.numb, timeout = 20.0)
      #print(len(waveforms[0].samples))
      for wfm in waveforms:
        if wfm.channel=='0' or wfm.channel=='1':
          fname = outname+'_'+str(wfm.record)+'_ch'+str(wfm.channel)+'.bin'
          output_file = open(fname, 'wb')
          float_array = array('d', wfm.samples)
          float_array.tofile(output_file)
          output_file.close()
      
  def plot_wave(self, inname):
    input_file = open(inname, 'rb')
    float_array = array('d')
    float_array.fromstring(input_file.read())
    plt.plot(float_array)
    plt.show()
    input_file.close()

  def close(self):
    self.session.reset()


