function [bytes] = get_bytes_class(classname)
%GET_BYTES_CLASS Returns the number of bytes occuppied by a numeric class
%   [bytes] = GET_BYTES_CLASS(classname)
%   returns the number of bytes occuppied by a numerical Matlab class (e.g.
%   uint8, int64, float, double, etc.).
if strcmp(classname,'double') || ...
        strcmp(classname,'uint64') || ...
        strcmp(classname,'int64') || ...
        strcmp(classname,'integer*4') || ...
        strcmp(classname,'float64') || ...
        strcmp(classname,'real*8')
    bytes = 8;
elseif strcmp(classname,'single') || ...
        strcmp(classname,'uint32') || ...
        strcmp(classname,'int32') || ...
        strcmp(classname,'uint') || ...
        strcmp(classname,'int') || ...
        strcmp(classname,'float') || ...
        strcmp(classname,'float32') || ...
        strcmp(classname,'integer*3') || ...
        strcmp(classname,'real*4')
    bytes = 4;
elseif strcmp(classname,'uint16') || ...
         strcmp(classname,'ushort') || ...
        strcmp(classname,'int16') || ...
        strcmp(classname,'integer*2') || ...
        strcmp(classname,'short')      
    bytes = 2;
elseif strcmp(classname,'uint8') || ...
        strcmp(classname,'uchar') || ...
        strcmp(classname,'int8') || ...
        strcmp(classname,'integer*1') || ...
        strcmp(classname,'schar') || ...
        strcmp(classname,'char*1')
    bytes = 1;
else
    error('Unknown numerical class format');
end        
