/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package uk.org.pjt.jmaxellanotostream;


public class PenTester {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			
			boolean polling = true;
			PenStreamingConnection psc = PenStreamingConnection.createInstanceFromPortName("COM20", new MyPenListener(),true,polling);
			
			if(polling) {
				while(true) {
					Thread.sleep(100);
					psc.poll();
				}
			}
		} catch(Throwable e) {
			e.printStackTrace();
		}
	}
	
	
	private static class MyPenListener implements PenListener {

		//long t = 0;
		public void sample(int x, int y, int f) {
			//long tt = System.currentTimeMillis();
			//System.out.println((tt-t));
			//t=tt;
			System.out.println("x="+x+" y="+y+" f="+f);
		}

		public void penUp() {
			System.out.println("Pen up");
			
		}		
	}

}
