/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios.swing;

import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.logging.Logger;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;

class OuterFrame extends JFrame implements WindowStateListener {
	public JDesktopPane outerFrameContent;

	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.swing");
	public OuterFrame() {
		super("Outer frame for SwingFramePortfolios");
		outerFrameContent = new JDesktopPane(); //a specialized layered pane
	    this.setContentPane(outerFrameContent);
	    if(SwingFramePortfolio.DEBUG_SWING) {
	    	this.setBounds(200,200,500,700);
	    	if(SwingFramePortfolio.DEBUG_SWING_ONTOP) {
	    		this.setAlwaysOnTop(true);
	    	}
	    } else {
	    	this.setBounds(200,200,10,10);
	    	this.setResizable(false);
	    	this.setFocusable(false);
	    }
	    this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
	    this.addWindowStateListener(this);
	    this.setVisible(true);
	}
	
	public void windowStateChanged(WindowEvent e) {
		if(e.getNewState()!=NORMAL) { this.setState(NORMAL); }
	}
}