/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Logger;

import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;

/*
 * this class is completely thread safe
 * 
 * there are three ways it can draw popups:
 * 
 * A.
 * contents' parent is a JPanel
 * whose parent is null
 * 
 * B. (Only happens if on screen or partly on screen)
 * contents' parent is a JPanel
 * whose parent is a JLayeredPane (belonging to the OuterFrame)
 * whose parent is a JRootPane (belonging to the OuterFrame)
 * whose parent is an OuterFrame
 * 
 * C.
 * content's parent is a JPanel (belonging to the HeavyWeightWindow)
 * whose parent is a JLayeredPane (belonging to the HeavyWeightWindow)
 * whose parent is a JRootPane  (belonging to the HeavyWeightWindow)
 * whose parent is a javax.swing.Popup$HeavyWeightWindow which is an instance of a JWindow
 */

class MyPopup extends Popup {
	
	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.swing");
	
	public final MyPopupFactory pf;
	public final JComponent contents;
	public final JRootPane sourceRootPane;
	public final Popup p;
	private final Point desiredPosnRelToSourceRootPane;
	
	public MyPopup(Popup p, JComponent contents, int desiredScreenX, int desiredScreenY, MyPopupFactory pf, JRootPane sourceRootPane) {
		super();
		this.p = p;
		this.contents = contents;
		this.pf = pf;
		this.sourceRootPane = sourceRootPane;
		
		// need to work out desired x,y, w and h rel to soureRootPane
		Point desiredPosnRelToOuterFrame = new Point(
				desiredScreenX-SwingFramePortfolio.outerFrame.getX(),
				desiredScreenY-SwingFramePortfolio.outerFrame.getY()
			);
				
		this.desiredPosnRelToSourceRootPane = SwingFramePortfolio.convertPointDownTreeWithoutUsingScreenCoords(
				desiredPosnRelToOuterFrame,
				SwingFramePortfolio.outerFrame,
				this.sourceRootPane
			);		
	}
	
	public void hide() {
		pf.notifyOfHide(this);
		p.hide();
	}
	public void show() {
		pf.notifyOfShow(this);
		p.show();
	}
	
	public Rectangle getRDesiredPopupBoundsInFrameOfRefOfSourceRootPane() {
		// contents width and height are often not known at time of creation of the popup
		return new Rectangle(
			desiredPosnRelToSourceRootPane.x,
			desiredPosnRelToSourceRootPane.y,
			this.contents.getWidth(), 
			this.contents.getHeight()
		);
	}
}