/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;




/**
 * Represents the root portfolio, of which all other portfolio are anscestors.
 * It has no tile and by default it is visible and located in DESK space at
 * (0,0) with scale factor 1 and no rotation.
 * 
 * @author pjt40
 *
 */
public class RootPortfolio extends Portfolio {

	public RootPortfolio(PortfolioServer t3){
		super(true, t3, null, new CannotDragWRTParent(), false, 0, 0, 0, 0);
		this.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0, 0,0,0) );
		this.setVisibleWhenParentVisible(true);
	}
	
	
	public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
		
	}
	
	protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
		return false;
	}	
	
	protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		
	}
	
	protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		
	}
	
	

}
