/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios;

/**
 * A data structure class representing a pid device type and button number.
 * Two instances with identical field data will return true when compared using the .equals() method.
 * 
 * @author pjt40
 *
 */
public final class PointInputDeviceTypeAndButton {
	public final int pointInputDeviceType;
	public final int button;
	public PointInputDeviceTypeAndButton(int pointInputDeviceType, int button) {
		this.pointInputDeviceType = pointInputDeviceType;
		this.button = button;
	}
	public boolean equals(Object o) {
		return o instanceof PointInputDeviceTypeAndButton
		&& ((PointInputDeviceTypeAndButton) o).button==this.button
		&& ((PointInputDeviceTypeAndButton) o).pointInputDeviceType==this.pointInputDeviceType;
	}
	public int hashCode() {
		// toopt
		return (this.button<<8)+(this.pointInputDeviceType);
	}
	public String toString() {
		return super.toString() + " pidType="+this.pointInputDeviceType+" button="+this.button;
	}

	public static final int DRAGPEN = 0;
	public static final int DRAGBUTTON = 1;
}