/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.state;

import Jama.Matrix;

/**
 * 
 * Version of ScaRotTraTransformImmutable but with uniform scale.
 * @author pjt40
 *
 */
public class ScaRotTraTransformImmutableUniformScale extends ScaRotTraTransformImmutable {

		
	public ScaRotTraTransformImmutableUniformScale(double scale, double thetaClockwise, double tx, double ty) {
		super(scale, scale, thetaClockwise, tx, ty);	
	}

	public ScaRotTraTransformImmutableUniformScale(Matrix mh2) {
		super(mh2);
	}
	
	public double getScale() { return this.getSx(); }

}
