/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;

import java.net.ServerSocket;

import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioServer;


public class RunPTests {
    static PortfolioServer ps;
   
    
    public static void main(String[] args) throws Exception {
        
        // create a new server
        ps = new PortfolioServer(new ServerSocket(2000),new ServerSocket(2001), false);
        
        
        try {
            System.out.println("Attach the client. You have 80s...");
            sendInfo("Waiting to start");
            Thread.currentThread().sleep(120000);
            
            /*{   // vary spanning
              double targetframerate=60.0;
            int ts=1024;
            double dsize=200.0;
            int span1 = 1, span2=2, span3=4;
            runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize, targetframerate, 1, true, span1, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize, targetframerate, 1, true, span2, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize, targetframerate, 1, true, span3, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            }
            
            {   // vary dsize
                double targetframerate=60.0;
                int ts=1000;
                double dsize1=100.0, dsize2=200.0, dsize3=400.0;
                int spanning=4;
                runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize1, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
                runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize2, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
                runPTest( new PTestOptions(ForcedUpdate.class, ts,dsize3, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            }*/
            
            {
            // various bits
            double targetframerate=60.0;
            int ts1 = 100, ts2=500, ts3=700, ts4=1000;
            int spanning = 4;
            double dsize=400.0;
            // normal
            runPTest( new PTestOptions(ForcedUpdate.class, ts1,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts2,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts3,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts4,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            
            // no rle
            /*runPTest( new PTestOptions(ForcedUpdate.class, ts1,dsize, targetframerate, 1, false, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts2,dsize, targetframerate, 1, false, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts3,dsize, targetframerate, 1, false, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdate.class, ts4,dsize, targetframerate, 1, false, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            
            // forced movement
            runPTest( new PTestOptions(ForcedMovement.class, 100,100/2.4, 60.0, 200, false, 1, 0, 0));
            runPTest( new PTestOptions(ForcedMovement.class, 100,100/2.4, 60.0, 400, false, 1, 0, 0));
            runPTest( new PTestOptions(ForcedMovement.class, 100,100/2.4, 60.0, 600, false, 1, 0, 0));
            runPTest( new PTestOptions(ForcedMovement.class, 100,100/2.4, 60.0, 800, false, 1, 0, 0));
            */
            /*
            // swing
            runPTest( new PTestOptions(ForcedUpdateSwing.class, ts1,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdateSwing.class, ts2,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdateSwing.class, ts3,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(ForcedUpdateSwing.class, ts4,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            
            
            // interactive
            runPTest( new PTestOptions(InteractiveUpdate.class, ts1,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdate.class, ts2,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdate.class, ts3,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdate.class, ts4,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            
            // swing interactive
            runPTest( new PTestOptions(InteractiveUpdateSwing.class, ts1,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdateSwing.class, ts2,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdateSwing.class, ts3,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            runPTest( new PTestOptions(InteractiveUpdateSwing.class, ts4,dsize, targetframerate, 1, true, spanning, Portfolio.FLAG_PREALLOCATE_IMAGE_BUFFERS, 0));
            */
            } 
            
            //runPTest( new PTestOptions(InteractiveMovement.class, 100,100/2.4, 45.0, 4, false, 1, 0, 0));
            //runPTest( new PTestOptions(InteractiveMovement.class, 100,100/2.4, 45.0, 200, false, 1, 0, 0));
            //runPTest( new PTestOptions(InteractiveMovement.class, 100,100/2.4, 45.0, 400, false, 1, 0, 0));
            //runPTest( new PTestOptions(InteractiveMovement.class, 100,100/2.4, 45.0, 600, false, 1, 0, 0));
            //runPTest( new PTestOptions(InteractiveMovement.class, 100,100/2.4, 45.0, 800, false, 1, 0, 0));
            
            sendInfo("Finished all tests. Close the client.");
        } catch(Throwable e) {
            ps.fatalError(e);
        }
    }
    

    public static void runPTest(PTestOptions pto) throws Throwable{
        final AbstractPTest pt = (AbstractPTest) pto.ptest.getConstructor(new Class[] {}).newInstance(new Object[] {});
        sendInfo(pto,"Setting up");

        pt.setupGeneric(pto, ps);
        ps.performActionAsynchronouslyByCurrentThread(
                new Runnable() {
                    public void run() { try { 
                        pt.createBgTile();pt.setupPTest(); } catch(Throwable e) {ps.fatalError(e);} }
                }
        );
        sendInfo(pto,"Now manual setup");
        Thread.currentThread().sleep(10000);
        sendInfo(pto,"BEGINS");
        Thread.currentThread().sleep(30000);
        sendInfo(pto,"FINISHED");

        ps.performActionAsynchronouslyByCurrentThread(
                new Runnable() {
                    public void run() { try { pt.finishPTest(); } catch(Throwable e) {ps.fatalError(e);} }
                }
        );
        sendInfo(pto,"Destroyed");
        // time for client to destroy stuff, recover
        Thread.currentThread().sleep(5000);
    }
    
    public static void sendInfo(PTestOptions pto, String s) {
        sendInfo(s+" - "+pto.toString());
    }
    
    public static void sendInfo(final String s) {
        ps.performActionAsynchronouslyByCurrentThread(
                new Runnable() {
                    public void run() { ps.sendLogMessageToAllClients(s); }
                }
        );
    }
    
    
}

