/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;

import javax.swing.JPanel;

import t3.hrd.state.JOGLHelper;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSLimiter;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.portfolios.swing.SwingFramePortfolio;


public class ForcedUpdateSwing extends AbstractPTest {
    public ForcedUpdateSwing() {}

    SwingFramePortfolio p;
    SwingAnimatorThread pat;
    
    public void setupPTest() throws Throwable {
        p = new SwingFramePortfolio(
                ps,
                ps.rootPortfolio,
                c,
                pto.tilew,
                pto.tileh,
                pto.tflags, pto.pflags
            );
        final MyComponent mycomp = new MyComponent();
        p.getFrame().add(mycomp);
        this.setPortSizePosnVisAndCHints(p);
        pat = new SwingAnimatorThread(getTargetMSBetweenFrames()) {
            int i = 0;
            public void runOnEachLoop() {
                // TODO Auto-generated method stub
                i++;
                if(i>pto.tileh) {
                    i=0;
                }
                final int j = i;
                fpst.oneFrame();
                mycomp.setXandYandrepaint(j,j);
            }
            public void runOnComplete() {
            }
        };
        pat.start();        
        
    }
    
    public void finishPTest() throws Throwable {
        pat.reqToComplete();
        while(pat.isAlive()) { Thread.currentThread().yield(); }
        p.setVisibleWhenParentVisible(false);
        p.destroyThisAndAllDescendants();        
    }

	
	
public class MyComponent extends JPanel {
        
        public MyComponent() {
            super();            
        }
        
        int x=0; int y=0;
        public void paintComponent(Graphics g) {
            paintTestTile(g,x,y);             
        }
        
        public void setXandYandrepaint(int x, int y) {
            this.x=x;
            this.y=y;
            this.repaint();
        }
        
    }

public abstract class SwingAnimatorThread extends Thread {
    private volatile boolean reqToComplete = false;
    private final FPSLimiter fpsLimiter;
    private long startTime;
    
    public final void reqToComplete() {
        this.reqToComplete = true;
    }
        
    public SwingAnimatorThread(long targetMsBetweenFrames) {
        this.fpsLimiter = new FPSLimiter(targetMsBetweenFrames);
    }
    
    public abstract void runOnEachLoop();
    public void runOnComplete() { }
    
    public final void run() {
        try {
            this.setPriority(Thread.MIN_PRIORITY);
            this.startTime = System.currentTimeMillis();
            
            while(!this.reqToComplete) {
                SwingAnimatorThread.this.runOnEachLoop();
                if(!this.reqToComplete) {
                    this.fpsLimiter.oneFrame();
                    Thread.currentThread().yield();
                } else {
                    // we'll be finished soon anyway
                }
            }
            SwingAnimatorThread.this.runOnComplete();
        } catch(InterruptedException e) {
            ps.fatalError(e);
        }
    }

    public final long getStartTime() {
        return startTime;
    }
    
    
    
}
    	 

	
}
