/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;

import t3.hrd.state.JOGLHelper;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSLimiter;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.remotehrd.protocol.OpUpdateTileContents;


public class ForcedUpdate extends AbstractPTest {
    public ForcedUpdate() {}

    MyPortfolio p;
    AnimatorThread pat;
    
    public void setupPTest() throws Throwable {
        p = new MyPortfolio(ps, ps.rootPortfolio);
        this.setPortSizePosnVisAndCHints(p);
        pat = new AnimatorThread(getTargetMSBetweenFrames(), ps) {
            int i = 0;
            public void runOnEachLoop() {
                i++;
                if(i>pto.tileh) {
                    i=0;
                }
                final int j = i;
                fpst.oneFrame();
                p.changeXAndYAndRepaint(j,j);
            }
            @Override
            public void runOnComplete() {
                p.setVisibleWhenParentVisible(false);
                p.destroyThisAndAllDescendants();
            }
            
        };
        pat.start();
    }
    
    public void finishPTest() throws Throwable {
        pat.reqToComplete();
    }

	
	
	public class MyPortfolio extends Portfolio {
        int x = 0, y=0;
		public MyPortfolio(PortfolioServer ps, Portfolio parent) {
			super(false, ps, parent, c, true, pto.tilew, pto.tileh, pto.tflags,  pto.pflags);
		}

		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
			assert false;			
		}

		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			return false;
		}

		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
			assert false;			
		}

		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
            paintTestTile(g,x,y);
		}
		
        public void changeXAndYAndRepaint(int x, int y) {
            this.x=x;
            this.y=y;
            this.triggerRepaintEntireTile();
        }
        
	}
    	 

	
}
