/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3examples.twopagedocdemo;

import java.awt.Color;

/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

import java.net.ServerSocket;

import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.portfolios.PlainPortfolio;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.portfolios.swing.SwingFramePortfolio;

public class TwoPageDocDemo {

	/*
	 * a4 is 210*297
	 * 
	 * 
	 */
    public static double DARKEN = 0.5;
	public static PortfolioServer ps;
	
	public static void main(String[] args) throws Exception{
		
		// create a new server
		ps = new PortfolioServer(new ServerSocket(2000),new ServerSocket(2001), false);
		
		try {
		
			// common behaviour allows our portfolio to be dragged
			PortfolioCommonBehaviour c = new RotateNTranslateWithTranslateOnlyRegion(
					new PointInputDeviceTypeAndButtonSet(
						new PointInputDeviceTypeAndButton(0,1)
					),
					0.3);
			
			double pxpermm=2.2;
			int tflags = 0;
            
            PlainPortfolio bg = new PlainPortfolio(ps, ps.rootPortfolio, new CannotDragWRTParent(), new Color(0,(int)(255*DARKEN),(int)(255*DARKEN)),0/*Tile.FLAG_BI_USHORT555RGB_NOT_INTARGB*/);
            bg.triggerRepaintEntireTile();
            bg.setTileWidthAndHeightInPORT(1500.0,1000.0);
            bg.setPORTtoPPORT(
                new ScaRotTraTransformImmutableUniformScale(
                    1.0,
                    0.0,
                    500.0,
                    300.0
                ));
            bg.setVisibleWhenParentVisible(true);
			
			final TwoPageOpenDoc my2pp = new TwoPageOpenDoc(
				ps, 
				ps.rootPortfolio, 
				new RotateNTranslateWithTranslateOnlyRegion(new PointInputDeviceTypeAndButtonSet(new PointInputDeviceTypeAndButton(0,1)), 0.3),
				210.0,
				297.0,
				10,210,297,210.0*2,297.0,
                DARKEN);			
			my2pp.setPORTtoDESK(new ScaRotTraTransformImmutableUniformScale(1.0,0.0, 120,120) );
			
			PageForTwoPageOpenDoc.createAndAddToTwoPageDocFromImageFiles(
				my2pp,
				"png60c/exampledoc2_Page_",
				".png",
                DARKEN
			);
			
			my2pp.setVisibleWhenParentVisible(true);
			my2pp.enterThumbnailMode();
			
			/*final TwoPageOpenDoc my2ppp = new TwoPageOpenDoc(
					ps, 
					ps.rootPortfolio, 
					new RotateNTranslateWithTranslateOnlyRegion(new PointInputDeviceTypeAndButtonSet(new PointInputDeviceTypeAndButton(0,1)), 0.3),
					210.0,
					297.0,
					10,210,297,210.0*2,297.0,
                    DARKEN);			
				my2ppp.setPORTtoDESK(new ScaRotTraTransformImmutableUniformScale(1.0,0.0, 120,120) );
				
				PageForTwoPageOpenDoc.createAndAddToTwoPageDocFromImageFiles(
					my2ppp,
					"png60/second-yr-report_Page_",
					".png",
                    DARKEN
				);
				
				my2ppp.setVisibleWhenParentVisible(true);
				my2ppp.enterThumbnailMode();
			*/
			
				
			System.out.println("Done!");
			
		} catch(Throwable e) {
			ps.fatalError(e);
		}
	}
	
	
	
	private static class WebPagePortfolio extends SwingFramePortfolio {
		public WebPagePortfolio(PortfolioServer ps, Portfolio p, String url, int w, int h, PortfolioCommonBehaviour c, int tflags,int pflags) {
			super(ps, p, c,  w, h, tflags, pflags);
			try {
				JEditorPane myJEditorPane;
				try {
					myJEditorPane = new JEditorPane(url);
				} catch(Exception e) {
					myJEditorPane = new JEditorPane("text/html",url);
				}
				myJEditorPane.setEditable(false);
				myJEditorPane.addHyperlinkListener(new Hyperactive());
				/*JScrollPane scrollPane = new JScrollPane(myJEditorPane);
				scrollPane.setPreferredSize(new Dimension(w,h));
				scrollPane.setMinimumSize(new Dimension(10,10));
				scrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
				this.getFrame().add(scrollPane);*/
				this.getFrame().add(myJEditorPane);
			} catch(Throwable e) {
				ps.fatalError(e);
			}
		}
	}
	
	 private static class Hyperactive implements HyperlinkListener {
		 
         public void hyperlinkUpdate(HyperlinkEvent e) {
 	          if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
 		      JEditorPane pane = (JEditorPane) e.getSource();
 		      if (e instanceof HTMLFrameHyperlinkEvent) {
 		          HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
 		          HTMLDocument doc = (HTMLDocument)pane.getDocument();
 		          doc.processHTMLFrameHyperlinkEvent(evt);
 		      } else {
 		          try {
 			      pane.setPage(e.getURL());
 		          } catch (Throwable t) {
 			      t.printStackTrace();
 		          }
 		      }
 	          }
 	      }
     }
	 
	 

	
}
