/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3examples.twopagedocdemo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

import javax.imageio.ImageIO;

import t3.hrd.state.JOGLHelper;
import t3.portfolios.PointInputDevice;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;

public class PageForTwoPageOpenDoc extends Portfolio {

	public static void createAndAddToTwoPageDocFromImageFiles(TwoPageOpenDoc parent, String prefix, String postfix, double darken) {
		int n=1;
		while(new File(prefix+n+postfix).exists()) {
			n++;
		}
		n = n -1;
		int i=1;
		while(new File(prefix+i+postfix).exists()) {
			try {
				BufferedImage fromFile = ImageIO.read(new File(prefix+i+postfix));
				parent.setChildIsPage(new PageForTwoPageOpenDoc(parent, n, i-1, fromFile, darken));
				i++;
			} catch(IOException e) {
				throw new RuntimeException(e);
			}
		}
		parent.addedAllChildren();
	}
	
	private final BufferedImage bi;
	private static final int buttonSize=50;
	private static final int thumbsButtonW=25;
	private static final int thumbsButtonH=100;
	private final Polygon prevButtonAreaA;
	private final Polygon prevButtonAreaB;
	private final Polygon nextButtonAreaA;
	private final Polygon nextButtonAreaB;
	private final Rectangle thumbsButtonArea;
	
	
	public PageForTwoPageOpenDoc(TwoPageOpenDoc parent, int nPages, int pageIndex, BufferedImage fileImage, double darken) {
		super(false, parent.portfolioServer, (Portfolio)parent, new CannotDragWRTParent(), true, fileImage.getWidth(), fileImage.getHeight(), 0, 0);
		this.bi = this.createCompatibleBufferedImage(this.getTileWidthInTILE(),this.getTileHeightInTILE());
		Graphics2D g = bi.createGraphics();
        g.drawImage(fileImage,0,0,null);
        g.setColor(new Color(0,0,0,(int)(255*(1.0-darken))));
        g.fillRect(0,0,this.getTileWidthInTILE(),this.getTileHeightInTILE());
        double tabalpha=0.25;
		g.setColor(new Color(0,0,(int)(255*darken),(int)(255*tabalpha)));
		int maxX = this.getTileWidthInTILE()-1;
		int maxY = this.getTileHeightInTILE()-1;
		if(TwoPageOpenDoc.isLeftPage(pageIndex) && TwoPageOpenDoc.isThereAPrevPageBeforeThisDoublePage(pageIndex)) {
			this.prevButtonAreaA = new Polygon(new int[] {0,0,buttonSize}, new int[] {0,buttonSize,0}, 3);
			this.prevButtonAreaB = new Polygon(new int[] {0,0,buttonSize}, new int[] {maxY,maxY-buttonSize,maxY}, 3);
			g.fillPolygon(this.prevButtonAreaA);
			g.fillPolygon(this.prevButtonAreaB);
		} else {
			this.prevButtonAreaA = null;
			this.prevButtonAreaB = null;
		}
		if(!TwoPageOpenDoc.isLeftPage(pageIndex) && TwoPageOpenDoc.isThereANextPageAfterThisDoublePage(pageIndex, nPages)) {
			this.nextButtonAreaA = new Polygon(new int[] {maxX,maxX,maxX-buttonSize}, new int[] {0,buttonSize,0}, 3);
			this.nextButtonAreaB = new Polygon(new int[] {maxX,maxX,maxX-buttonSize}, new int[] {maxY,maxY-buttonSize,maxY}, 3);
			g.fillPolygon(this.nextButtonAreaA);
			g.fillPolygon(this.nextButtonAreaB);
		} else {
			this.nextButtonAreaA = null;
			this.nextButtonAreaB = null;
		}
		if(TwoPageOpenDoc.isLeftPage(pageIndex)) {
			this.thumbsButtonArea = new Rectangle(maxX-thumbsButtonW,maxY/2-thumbsButtonH/2, thumbsButtonW, thumbsButtonH);
			g.fill(this.thumbsButtonArea);
		} else {
			this.thumbsButtonArea = new Rectangle(0,maxY/2-thumbsButtonH/2, thumbsButtonW, thumbsButtonH);
			g.fill(this.thumbsButtonArea);
		}
		fileImage = null;
		this.triggerRepaintEntireTile();
	}

	@Override
	protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
		if(	
			e.eventType==e.EVENT_PID_CLICK 
			&& e.pointInputDevice.pointInputDeviceType==0
			&& e.pidButton==0
		) {
			Point p = new Point( e.getTILEx(this), e.getTILEy(this));
			if(
				(this.prevButtonAreaA!=null && this.prevButtonAreaA.contains(p))
				|| 
				(this.prevButtonAreaB!=null && this.prevButtonAreaB.contains(p))
			){
				((TwoPageOpenDoc)this.getParent()).turnToPrevPage();
				return true;
			}
			else if(
				(this.nextButtonAreaA!=null && this.nextButtonAreaA.contains(p))
				|| 
				(this.nextButtonAreaB!=null && this.nextButtonAreaB.contains(p))
			){
				((TwoPageOpenDoc)this.getParent()).turnToNextPage();
				return true;
			} else if(this.thumbsButtonArea.contains(p)) {
				((TwoPageOpenDoc)this.getParent()).enterThumbnailMode();
				return true;
			} else {
				return false;
			}
		} else if(
			e.eventType==e.EVENT_PID_MOVE 
			&& !bubbled
			&& e.oldPositionKnown
			&& e.pointInputDevice.pointInputDeviceType==0 
			&& portfolioServer.isButtonDown(e.pidButtons,0)
			&& e.isOldPointOnTile(this)
		) {
			int tileX = e.getTILEx(this);
			int tileY = e.getTILEy(this);
			int tileXold = e.getTILExOld(this);
			int tileYold = e.getTILEyOld(this);
			if(tileXold>=0 && tileYold>=0 && tileXold<this.getTileWidthInTILE() && tileYold<this.getTileHeightInTILE()) {
				Rectangle r = new Rectangle(
					Math.min(tileX, tileXold),
					Math.min(tileY, tileYold),
					Math.abs(tileX-tileXold)+1,
					Math.abs(tileY-tileYold)+1
				);
				try {
					Graphics2D g = (Graphics2D) bi.createGraphics();
					g.setColor( Color.BLUE );
					g.drawLine(tileXold, tileYold, tileX, tileY);
					this.triggerRepaintTile(r);
				} catch(Exception ee) {
					throw new RuntimeException(ee);
				}
				return true;
			} else {
				// old coord not on tile so don't draw
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
		JOGLHelper.pastePartOfImageAIntoPartOfImageBWithoutSharing(0,0,r.x,r.y,r.width,r.height,this.bi,update);		
	}
	

}
