/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3examples;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;


import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.RotateNTranslate;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;


public class Example4 {

	
	public static PortfolioServer ps;
	
	public static void main(String[] args) throws Exception{
		
		// create a new server
		ps = new PortfolioServer(new ServerSocket(2000),new ServerSocket(2001), false);
		
		try {
		
			// common behaviour allows our portfolio to be dragged
			PortfolioCommonBehaviour c = new RotateNTranslateWithTranslateOnlyRegion(
					new PointInputDeviceTypeAndButtonSet(
						new PointInputDeviceTypeAndButton(0,1)
					),
					0.3);
			// create a portfolio
			final MyPortfolio myp = new MyPortfolio(ps, ps.rootPortfolio, c);
			
			// make it visible
			myp.setVisibleWhenParentVisible(true);
			
			// set its position to be at (300,300) with scale factor 1.0 and rotation 0.1rad
			myp.setPORTtoDESK(new ScaRotTraTransformImmutableUniformScale(1.0,0.1,300.0,300.0));
			
			//create another portfolio, but this time it's a child of the other portfolio.
			MyPortfolio myp2 = new MyPortfolio(ps, myp, c);
			
			// make it visible
			myp2.setVisibleWhenParentVisible(true);
			
			// set its position to be at (500,500) with scale factor 2.0 and rotation 0.5rad
			myp2.setPORTtoDESK(new ScaRotTraTransformImmutableUniformScale(2.0,0.5,500.0,500.0));

			
			
			// now set a thread which makes the portfolio bigger and bigger.
			// because this is outside event handling methods, we need to 
			// synchronize on stateManager and make sure we call endOfBurst
			Thread animator = new AnimatorThread(1000/30, ps) {
                public void runOnEachLoop() {
                    myp.setPORTtoDESK(
                            new ScaRotTraTransformImmutableUniformScale(
                                myp.gettPORTtoDESK().getScale()+0.005,
                                myp.gettPORTtoDESK().getThetaClockwise(),
                                myp.gettPORTtoDESK().getTx(),
                                myp.gettPORTtoDESK().getTy()
                            )
                        );
                }
			};

			animator.start();
			
		} catch(Throwable e) {
			ps.fatalError(e);
		}
	}
	
	
	public static class MyPortfolio extends Portfolio {
		
		private boolean clicked;
		
		// constructor creates a portfolio with a tile of with 100px*100px
		// and makes it appear 80.0*80.0 units big in portfolio space. 
		public MyPortfolio(PortfolioServer ps, Portfolio parent, PortfolioCommonBehaviour c) {
			super(false, ps, parent, c, true, 100, 100, 0, 0);
			this.setTileWidthAndHeightInPORT(80.0, 80.0);
			this.clicked = false;
		}

		// we never enter fdop mode so this should never be called
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
			assert false;			
		}

		// clicking on the tile toggles the drawing of a circle in it
		// entering the tile increases the size
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			if(e.eventType == e.EVENT_PID_CLICK && !bubbled) {
				this.clicked = !this.clicked;
				this.triggerRepaintEntireTile();
				return true;
			} else {
				return false;
			}
		}

		// we never enter fdop mode so this should never be called
		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
			assert false;			
		}

		// painting our tile is very basic
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
			g.setColor(Color.BLUE);
			g.fillRect(0,0,100,100);
			if(this.clicked) {
				g.setColor(Color.YELLOW);
				g.fillOval(0,0,100,100);
			}			
			g.setColor(Color.RED);
			g.fillRect(0,0,50,50);
		}
		
	}
}
