/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SNURBSVISWINDOW_H
#define SNURBSVISWINDOW_H

#include <QMainWindow>
#include "ui_snurbs-vis.h"
class ParitySpinBox;
class QDoubleSpinBox;
class QSpinBox;

class SnurbsVisWindow : public QMainWindow, private Ui::SnurbsVisWindow
{
    Q_OBJECT

public:
    SnurbsVisWindow(QWidget *parent = 0);

public slots:
    void newKnotSpacing               (double interval);

private slots:
    void on_actionOpen_triggered                 (void);
    void on_actionSave_As_triggered              (void);
    void on_actionSave_Image_triggered           (void);
    void display_ModelView_Matrix                (void);
    void display_Selected_Knot_Details           (void);
    void changeSubdivLevel                       (int newLevel);
    void changeDegree                            (int newDegree);

private:
    ParitySpinBox  *subdivDegreeSpinBox;
    QSpinBox       *subdivLevelSpinBox;
    QDoubleSpinBox *knotSpacingSpinBox;
    QWidget        *knotSpacingHolder;

    void autoCropAndSaveGLWidget(QString fileName, bool withAlpha);
};

#endif
