/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PARITYSPINBOX_H
#define PARITYSPINBOX_H

#include <QSpinBox>

class ParitySpinBox : public QSpinBox
{
    Q_OBJECT

public:
    ParitySpinBox(QWidget *parent = 0) : QSpinBox(parent) {};

    QValidator::State validate(QString &input, int &pos) const
    {
        QValidator::State state = QSpinBox::validate(input, pos);

        if (state == QValidator::Acceptable && input.toInt() % 2 == 0)
        {
            state = QValidator::Intermediate;
        }

        return state;
    };

    void fixup(QString &input) const
    {
        if (input.toInt() % 2 == 0)
        {
            input.setNum(input.toInt() - 1);
        }

        QSpinBox::fixup(input);
    };
};

#endif
