/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cassert>
#include "patchtreeroot.h"

namespace snurbs {

using namespace std;

PatchTreeRoot::PatchTreeRoot(PatchTreeLeaf *patchTreeLeaf,
                             HalfEdge *halfEdge) :
                                 AbstractUnaryPatchTree(patchTreeLeaf),
                                 edge(halfEdge)
{
}

PatchTree::Direction PatchTreeRoot::dirFromParent(void) const
{
    throw logic_error("Called dirFromParent on PatchTreeRoot");
}

PatchTree *&PatchTreeRoot::getParent(void)
{
    throw logic_error("Called getParent on PatchTreeRoot");
}

void PatchTreeRoot::setParent(PatchTree* /* newParent */)
{
    throw logic_error("Called setParent on PatchTreeRoot");
}

void PatchTreeRoot::stream(ostream &os, unsigned char level) const
{
    assert(level == 0);
    os << this << " : edge " << edge << endl;
    child->stream(os, 1);
}

ostream &operator<<(ostream &os, const PatchTreeRoot &patch)
{
    patch.stream(os, 0);
    return os;
}

}
