/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <boost/lambda/bind.hpp>
#include <boost/lambda/lambda.hpp>
#include "halfedge.h"

namespace snurbs {

using namespace boost;
using namespace std;

HalfEdge::HalfEdge(PatchNode *node, PatchTreeRoot *patch) : next(NULL),
                                                            pair(NULL),
                                                            node(node),
                                                            patch(patch)
{
}

HalfEdge *HalfEdge::prev(void)
{
    PatchIterator iter = find_circular(PatchIterator(this),
                                       this == lambda::bind(&HalfEdge::getNext,
                                                            lambda::_1));
    return *iter;
}

unsigned char HalfEdge::stepsTo(const HalfEdge* const edge)
{
    PatchIterator iter = find_circular(PatchIterator(this),
                                       lambda::_1 == edge);

    return distance(PatchIterator(this), iter);
}

ostream &operator<<(ostream &os, const HalfEdge &edge)
{
    os << &edge << " : next " << edge.getNext() << ", pair " << edge.getPair();
    os << ", node " << edge.getNode() << ", patch " << edge.getPatch() << endl;
    return os;
}

}
