/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "abstractunarypatchtree.h"
#include "patchtreeleaf.h"

namespace snurbs {

using namespace std;

AbstractUnaryPatchTree::AbstractUnaryPatchTree(PatchTreeLeaf *patchTreeLeaf) :
                                                   PatchTree         (),
                                                   child(patchTreeLeaf)
{
}

AbstractUnaryPatchTree::~AbstractUnaryPatchTree(void)
{
    delete child;
    child = NULL;
}

PatchTree::Direction AbstractUnaryPatchTree::childDir(const PatchTree
                                                            *findChild) const
{
    if (child == findChild)
    {
        return CHILD;
    }
    else
    {
        throw child_not_found();
    }
}

PatchTree *&AbstractUnaryPatchTree::getChild (Direction /* dir */)
{
    return child;
}

void AbstractUnaryPatchTree::stream(ostream &os, unsigned char level) const
{
    streamDepthMarkers(os, level);
    os << " " << this << endl;
    child->stream(os, level + 1);
}

}
