/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TYPES_H
#define TYPES_H

/**
 * @file
 * Contains global typedefs and defaults which are useful in several places.
 * This means that nearly every header ends up including this file one way or
 * another. So changes to this file will result in a lot of recompilation.
 */

namespace snurbs {

/** The type used for Vertex co-ordinates. */
typedef double VertexPrecision;
/** The type used for knot intervals. */
typedef float  KnotPrecision;

/**
 * The knot spacing to assign to any unspecified knot intervals.
 */
const KnotPrecision defaultKnotSpacing = 1;

/**
 * Test for Not a Number
 */
template <typename T>
inline bool is_nan(const T& v)
{
    return (v != v);
}

}

#endif
