/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef DUALPATCHTREELEAF_H
#define DUALPATCHTREELEAF_H

#include "patchtreeleaf.h"
#include "vertex.h"

namespace snurbs {

/**
 * Contains a pointer to one vertex, which is conceptually in the centre of
 * this PatchTreeLeaf.
 *
 * @ingroup Mesh
 */
class DualPatchTreeLeaf : public PatchTreeLeaf
{
public:
    /** DualPatchTreeLeaf constructor. */
    DualPatchTreeLeaf(void);

    /**
     * @name Getter functions
     * @{
     */
    Vertex*& getVertex(void);
    /** @} */

    bool isReal(void) const;

    /**
     * @name Subdivision functions
     * @{
     */
    void            makeInsertionRequests();
    PatchTree      *refineTree           ();
    void            extraordinaryRefine  (unsigned char degree,
                                          Direction extNode,
                                          unsigned char valency);
    void            smooth               (unsigned char degree,
                                          unsigned char stage);
    VertexPrecision extraordinarySmooth  (unsigned char degree,
                                          unsigned char stage,
                                          Direction extNode,
                                          unsigned char valency);
    /** @} */

private:
    /** Pointer to the single vertex member of this DualPatchTreeLeaf. */
    Vertex *vertex;
};

inline Vertex*& DualPatchTreeLeaf::getVertex(void)
{
    return vertex;
}

inline bool DualPatchTreeLeaf::isReal(void) const
{
    return vertex->isReal();
}

}

#endif
