#pragma once

using namespace System;
using namespace System::Collections::Generic;
using namespace VideoLib::Params::GpGpu;

namespace Stereo { namespace GpGpuLib {
	
	/// <summary>
	/// An implementation of ITechniqueParameterTarget, which provides cacheing of values,
	/// and propagation of changes to unmanaged code using function pointers.
	/// <summary>
	template<typename TARGET_TYPE>
	public ref class UnmanagedParameterTarget : public IParameterTarget
	{
	protected:
		// A datatype for a single parameter in the collection
		template<typename T>
		ref class UmParameterImpl : public Parameter<T>
		{
		private:
			T value;

			TARGET_TYPE* pInstance;						// A pointer to the targetted object
			void (TARGET_TYPE::*ptrToSetter)(void*);	// A pointer to the parameter setter method

		protected:
			virtual property T PropertyValue
			{
				T get() override { return value; }
				void set(T val) override 
				{ 
					value = val; 

					// As well as updating the cache, propagate the changed to the unmanaged object
					pin_ptr<T> valPtr = &value;
					(pInstance->*ptrToSetter)(valPtr);
				}
			}

		public:
			UmParameterImpl(TARGET_TYPE* pInst, void (TARGET_TYPE::*pSetter)(void*), 
				T initialValue, ParameterRange^ range, 
				String^ theName, String^ theDescription)
				: Parameter<T>(range, theName, theDescription), value(initialValue), pInstance(pInst), ptrToSetter(pSetter) 
			{
				// Set the initial value
				pin_ptr<T> valPtr = &value;
				(pInstance->*ptrToSetter)(valPtr);
			}
		};

	protected:
		List<Parameter^>^ parameters;
		String^ name;

	public:
		UnmanagedParameterTarget(String^ theName) : parameters(gcnew List<Parameter^>()), name(theName) { }

		// Add a new parameter to the collection, and initialize the value as specified
		template<typename T>
		void AddNewParameter(TARGET_TYPE* pInst, void (TARGET_TYPE::*pSetter)(void*), T initialValue, ParameterRange^ range, String^ name, String^ description)
		{
			UmParameterImpl<T>^ param = gcnew UmParameterImpl<T>(pInst, pSetter, initialValue, range, name, description);
			parameters->Add(param);
		}

		virtual ICollection<Parameter^>^ GetParameters() { return parameters; }
		virtual property String^ Name { String^ get() { return name; } }
	};

} }