// $Id: ManagedMaximizers.cpp 65 2010-03-18 17:06:22Z cr333 $
#include "UnmanagedMaximizers.h"
#include "ManagedMaximizers.h"

using namespace Stereo::GpGpuLib;

void ManagedMaximizers::RunMaxKernel(CostSpace^ costSpace, float scaleFactor, DepthMap^ result, const ExecutionStream^ stream)
{
	GpuCostSpace* gpuCost = costSpace->Get();
	GpuDepthMap* gpuMap = result->Get();

	gpuMap->Create(DEPTH_MAP_TYPE_FLOAT, gpuCost->GetWidth(), gpuCost->GetHeight());

	RunWtaKernel(gpuCost->Get(), gpuCost->GetDepth(), scaleFactor, gpuMap->Get(), gpuMap->GetPitch() / sizeof(float));
}

void ManagedMaximizers::RunSubpixelMaxKernel(CostSpace^ costSpace, float scaleFactor, float threshold, DepthMap^ result, const ExecutionStream^ stream)
{
	GpuCostSpace* gpuCost = costSpace->Get();
	GpuDepthMap* gpuMap = result->Get();

	gpuMap->Create(DEPTH_MAP_TYPE_FLOAT, gpuCost->GetWidth(), gpuCost->GetHeight());

	RunSubPixWtaKernel(gpuCost->Get(), gpuCost->GetDepth(), scaleFactor, threshold, gpuMap->Get(), gpuMap->GetPitch() / sizeof(float));
}