%**********************************************************************
% RGB2lab.m
% Mapping from RGB to lab colour space using Reinhard et al. 2001
%**********************************************************************
function [ result ] = RGB2lab( array )

result = zeros(size(array));
R = double(array(:,1));
G = double(array(:,2));
B = double(array(:,3));
l = R*0.3811 + G*0.5783 + B*0.0402;
m = R*0.1967 + G*0.7244 + B*0.0782;
s = R*0.0241 + G*0.1288 + B*0.8444;
logl = log10(l);
logm2 = log10(m);
logs = log10(s);
l = logl*0.5774 + logm2*0.5774 + logs*0.5774;
a = logl*0.4082 + logm2*0.4082 - logs*0.8165;
b = logl*0.7071 - logm2*0.7071;
result(:,1) = l;
result(:,2) = a;
result(:,3) = b;

end