#!/usr/bin/perl -w

use strict;

my $line;
my $date;
my $speaker;
my $title;
my $link;

print <<__END_OF_HEADER;
YEAR-GOES-HERE
SECTION\&Logic and Semantics Seminar
COMMENTS\&<A href=\"mailto:David.Richerby\@cl.cam.ac.uk\">David.Richerby\@cl.cam.ac.uk</A>
BREADCRUMB\&Research\&http://www.cl.cam.ac.uk/UoCCL/research/
BREADCRUMB\&TSG\&http://www.cl.cam.ac.uk/Research/TSG/
BREADCRUMB\&Logic and Semantics Seminar\&http://www.cl.cam.ac.uk/Research/LS/

__END_OF_HEADER

$line = 0;

while (<>)
{
    chomp;

    if (/(Michaelmas|Lent|Easter) Term/)
    {
	if ($1 ne "Michaelmas")
	{
	    print "</TABLE>\n</DIV>\n\n\n";
	}
	print "<H2>$1 Term</H2>\n\n";
	print "<DIV align=\"center\">\n";
	print "<TABLE border =\"0\" cellpadding=\"10\" cellspacing=\"5\" ".
	      "width=\"95%\">\n\n";
    }

    elsif (/^<td>$/)
    {
	$line++;
    }

    elsif (/^<td>(.*)/)
    { 
	if    ($line == 1) { $date    = $1;$date=~s/ /\&nbsp;/g;}
	elsif ($line == 2) { $speaker = $1;                }
	elsif ($line == 3) { $title   = $1;                }
	$line++;
    }

    elsif (/^<a href=\"(.*)\">Abstract/)
    {
	$link = $1;
    }

    elsif (/<\/tr>/ && $line > 0)
    {
	print "<TR valign=\"top\" bgcolor=\"#ffffcc\">\n";
	print "  <TD align=\"right\">$date<BR>14:00</TD>\n";
	print "  <TD>$speaker,<BR>\n";
	print "      <A href=\"$link\">$title</A></TD>\n";
	print "</TR>\n\n";

	$line = 0;
	$date = $speaker = $title = $link = "";
    }
}

print "</TABLE>\n</DIV>\n"
