import numpy as np
from matplotlib import pyplot

def plotdata(filename): #plot all of the fields against time
	"Plots the all columns in a .csv file against the last"
	#Create a List of the header fields
	header = open(filename).readline().split(',')
	#first import the data into an ndarray, skipping the header line
	data = np.loadtxt(open(filename, "r"), delimiter=',', skiprows = 1)
	fields = len(data[1,:])
	#Create a title, x and y labels
	pyplot.figure()
	if fields > 2:
		pyplot.suptitle('Graphs of Wiimote Accelerometer Data')
	else:
		pyplot.suptitle('A Graph of Wiimote Accelerometer Data')
	#intialise axis variables
	subaxis = []
	newaxis = [0,0,0,0]
	Lines = ['r-','g-','b-']
	
	for field in range(fields-1):
		#Draw subplot in one of fields-1 rows ( 3 for X,Y&Z)
		# Draw the plot in subplot no. field.
		# Draw the subplot in figure 1
		pyplot.subplot( fields-1,1,field+1)
		pyplot.plot( data[:,fields-1], data[:,field], Lines[field], label = header[field])
		pyplot.legend( loc = 'lower right')
		pyplot.ylabel ('{} Acc(ms^-2)'.format(header[field]))
		#In order To make all axis the same, store the axis after each iteration
		subaxis.append(pyplot.axis())
		
	#iterate through all of the subaxis and create newaxis, with the greatest
	#axis values
	for field in range(fields-1):
		for axis in range(len(newaxis)):
			if axis % 2:
				newaxis[axis] = max(newaxis[axis], subaxis[field][axis])
			else:
				newaxis[axis] = min(newaxis[axis], subaxis[field][axis])
	
	#Update all of the axis of each subplot			
	for field in range(fields-1):
		pyplot.subplot( fields-1,1,field+1)
		pyplot.axis(newaxis)
		
	
	pyplot.xlabel (header[fields-1])