#ifndef __STM0_H_
#define __STM0_H_

#if defined(ENV_SPARC_JVM)
#include "env_sparc_jvm.h"
#elif defined(ENV_SPARC)
#include "env_sparc.h"
#elif defined(ENV_SPARC_V9)
#include "env_sparc_v9.h"
#elif defined(ENV_IA32)
#include "env_ia32.h"
#elif defined(ENV_IA64)
#include "env_ia64.h"
#else
#error "A valid environment has not been defined"
#endif

typedef enum { STM_ACTIVE,
               STM_COMMITTED,
	       STM_ABORTED,
	       STM_READ_PHASE,        /* Only if OPT_SHARABLE_READS */
	       STM_WAITING_1,         /* Wake by state update */
	       STM_WAITING_2,         /* Wake by condvar notify */
	       STM_DEALLOCATED_COMMITTED,
	       STM_DEALLOCATED_ABORTED,
	       BEYOND_LAST_STATUS     /* Internal use */
} STMResult_t;

#include "stm.h"

/*
 * Entry points for the GC.  These are used by some of the memory
 * managment algorithms to clear free lists of objects that the GC
 * will have freed or to release owned locations so that the GC
 * need not be aware of them.
 *
 * We assume that external mechanisms will prevent GC (including the
 * invocation of these hook functions) while any thread is invoking 
 * any of the preceding functions in this interface.
 */

void STMPreGCHook ();
void STMPostGCHook ();

#endif /* __STM0_H_ */
