/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.io.File;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.PropertyPermission;
import opera.AppContextAdapter;
import opera.AppContextCreator;
import opera.CertificateHandler;
import opera.PluginPanel;

public class PluginClassLoader
extends URLClassLoader {
    private static RuntimePermission usePolicyPermission = new RuntimePermission("usePolicy");
    private static PropertyPermission browserReadPerm = new PropertyPermission("browser", "read");
    private static PropertyPermission browserVerReadPerm = new PropertyPermission("browser.version", "read");
    private URL codeBase;
    String key;
    private AppContextAdapter appContext = null;
    private ThreadGroup threadGroup = null;
    private int usageCount = 0;
    private Object usageCountSync = new Object();

    String getKey() {
        return this.key;
    }

    public PluginClassLoader(URL uRL, String string) {
        super(new URL[0], ClassLoader.getSystemClassLoader());
        this.codeBase = uRL;
        this.key = string;
    }

    public void addJar(URL uRL) {
        this.addURL(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadGroup getThreadGroup() {
        block7: {
            try {
                if (this.threadGroup != null && !this.threadGroup.isDestroyed()) break block7;
                this.threadGroup = new ThreadGroup(this.codeBase + "-threadGroup");
                this.threadGroup.setMaxPriority(4);
                AppContextCreator appContextCreator = new AppContextCreator(this.threadGroup);
                appContextCreator.setContextClassLoader(this);
                Object object = appContextCreator.syncObject;
                synchronized (object) {
                    appContextCreator.start();
                    try {
                        appContextCreator.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.appContext = appContextCreator.appContext;
                }
                appContextCreator = null;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return this.threadGroup;
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grab() {
        Object object = this.usageCountSync;
        synchronized (object) {
            ++this.usageCount;
            this.getThreadGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.usageCountSync;
        synchronized (object) {
            if (this.usageCount > 1) {
                --this.usageCount;
            } else {
                if (this.appContext != null) {
                    try {
                        this.appContext.dispose();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        illegalThreadStateException.printStackTrace(System.err);
                    }
                }
                this.usageCount = 0;
                this.appContext = null;
                this.threadGroup = null;
                PluginPanel.cacheClassLoader(this);
            }
        }
    }

    public AppContextAdapter getAppContext() {
        return this.appContext;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        final PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        if (uRL.getProtocol().equals("file")) {
            int n;
            String string = uRL.getFile().replace('/', File.separatorChar);
            if (!string.endsWith(File.separator) && (n = string.lastIndexOf(File.separatorChar)) != -1) {
                string = string.substring(0, n + 1) + "-";
                permissionCollection.add(new FilePermission(string, "read"));
            }
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            if (this.codeBase.getProtocol().equals("file")) {
                String string2 = this.codeBase.getFile().replace('/', File.separatorChar);
                if (string2.endsWith(File.separator)) {
                    string2 = string2 + "-";
                }
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        }
        permissionCollection.add(browserReadPerm);
        permissionCollection.add(browserVerReadPerm);
        if (codeSource.getCertificates() != null && !permissionCollection.implies(usePolicyPermission) && this.allPermissionsGranted(codeSource)) {
            permissionCollection.add(new AllPermission());
        }
        return permissionCollection;
    }

    boolean allPermissionsGranted(CodeSource codeSource) {
        if (System.getProperty("browser.opera.useCertificateHandler").equals("true")) {
            return CertificateHandler.checkCertificates(codeSource);
        }
        return false;
    }
}

