/*
 *	msnl_proto.c
 *	------------
 *
 * $Id: msnl_proto.c,v 1.2 1993/03/19 16:22:52 rjb17 Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

#include "../h/param.h"
#include "../h/socket.h"
#include "../h/protosw.h"
#include "../h/domain.h"
#include "../h/mbuf.h"

#include "msnl.h"

extern int msnl_usrreq_control();
extern int msnl_usrreq(), msnl_init();
extern int edl_ifinput();

extern struct domain msnldomain;

struct protosw msnlsw[] = {
{ 
    SOCK_STREAM,	&msnldomain,	MSNLPROTO_MSNL,	PR_CONNREQUIRED | PR_ATOMIC,
    0,			0,		0,		0,
    msnl_usrreq,	msnl_init,	0,		0,
#ifndef __arm
    0,			0,		edl_ifinput,	0,
#endif
},
{
    SOCK_RAW,		&msnldomain,	MSNLPROTO_RAW,	PR_ATOMIC,
    0,			0,		0,		0,
    msnl_usrreq_control,0,		0,		0,
#ifndef __arm
    0,			0,		0,		0,
#endif
}
};

struct domain msnldomain = {
    AF_MSNL, "msnl", 0, 0, 0,
    msnlsw, &msnlsw[sizeof(msnlsw)/sizeof(msnlsw[0])]
};
