/*
 *	msnl_assoc.h
 *	------------
 *
 * $Id: msnl_assoc.h,v 1.6 1993/05/20 13:56:16 rjb17 Exp $
 *
 * Copyright (c) 1993 Cambridge University Computer Laboratory.
 *
 */

typedef struct {
    int				as_id;
    struct mbuf			*as_m_start, *as_m_current;
    SAR				as_rxsar;
    void			(* as_rx_proc)();
    struct ifnet		*as_ifp;
    caddr_t			as_pcb;
    SAR				as_txsar;
    int				as_idle;
    struct sockaddr		as_txadr;
} ASSOC;

#define ASSOC_MAX	(1023)
#define ASSOC_EDL	(1023)
#define ASSOC_FDL	(1)

extern ASSOC *assocTable[];

extern void assoc_got_bogus(int associd, struct ifnet *ifp);

#define assoc_check(x) (((x < 1) || (x>ASSOC_MAX)) ? \
			(ASSOC *)0 : assocTable[x])

/*
 * ---------------------------------------------------------------------
 */

extern int edl_tx();
extern int edl_tx_prepare();
