local open Obj Lexing in


open Parser

(* For nesting comments *)

val comment_depth = ref 0;

(* The table of keywords *)
val keyword_table =
    (Polyhash.mkPolyTable(53, Subscript) : (string,token) Polyhash.hash_table);

val () =
    List.app (Polyhash.insert keyword_table)
    [
     ("abstype",    NULL),
     ("and",        NULL),
     ("andalso",    NULL),
     ("as",         NULL),
     ("case",       NULL),
     ("datatype",   NULL),
     ("do",         NULL),
     ("else",       NULL),
     ("eqtype",     NULL),
     ("end",        NULL),
     ("exception",  NULL),
     ("fn",         NULL),
     ("fun",        NULL),
     ("handle",     NULL),
     ("if",         NULL),
     ("in",         NULL),
     ("infix",      NULL),
     ("infixr",     NULL),
     ("let",        NULL),
     ("local",      NULL),
     ("nonfix",     NULL),
     ("of",         NULL),
     ("op",         NULL),
     ("open",       OPEN),
     ("orelse",     NULL),
     ("prim_eqtype",  NULL),
     ("prim_EQtype",  NULL),
     ("prim_type",    NULL),
     ("prim_val",     NULL),
     ("raise",      NULL),
     ("rec",        NULL),
     ("then",       NULL),
     ("type",       NULL),
     ("val",        NULL),
     ("while",      NULL),
     ("with",       NULL),
     ("withtype",   NULL),
     ("#",          NULL),
     ("->",         NULL),
     ("|",          NULL),
     (":",          NULL),
     ("=>",         NULL),
     ("=",          NULL),
     ("*",          NULL)
     ];

fun mkKeyword lexbuf =
  let val s = getLexeme lexbuf in
    Polyhash.find keyword_table s
    handle Subscript => ID s
  end
;

val savedLexemeStart = ref 0;
exception LexicalError of string * int * int (* (message, loc1, loc2) *)

fun getQual s =
  let open CharVector
      val len' = size s - 1
      fun parse n =
        if sub(s, n) = #"." then
	    extract(s, 0, SOME n)
        else
	    parse (n+1)
  in parse 0 end;

fun mkQualId lexbuf =
  QUAL_ID (getQual(getLexeme lexbuf));

fun lexError msg lexbuf =
  raise LexicalError (msg, getLexemeStart lexbuf, getLexemeEnd lexbuf)


fun incr r = (r := !r + 1);
fun decr r = (r := !r - 1);


fun action_50 lexbuf = (
TokenN lexbuf)
and action_49 lexbuf = (
 lexError "this will be never called!" lexbuf )
and action_48 lexbuf = (
 TokenId lexbuf )
and action_47 lexbuf = (
 Quotation lexbuf )
and action_46 lexbuf = (
 DQuotation lexbuf )
and action_45 lexbuf = (
 EOF )
and action_44 lexbuf = (
 NULL )
and action_43 lexbuf = (
 NULL )
and action_42 lexbuf = (
 NULL )
and action_41 lexbuf = (
 NULL )
and action_40 lexbuf = (
 NULL )
and action_39 lexbuf = (
 NULL )
and action_38 lexbuf = (
 NULL )
and action_37 lexbuf = (
 NULL )
and action_36 lexbuf = (
 NULL )
and action_35 lexbuf = (
 NULL )
and action_34 lexbuf = (
 NULL )
and action_33 lexbuf = (
 String lexbuf )
and action_32 lexbuf = (
 String lexbuf )
and action_31 lexbuf = (
 NULL )
and action_30 lexbuf = (
 NULL )
and action_29 lexbuf = (
 lexError "unmatched comment bracket" lexbuf )
and action_28 lexbuf = (
 savedLexemeStart := getLexemeStart lexbuf;
        comment_depth := 1; Comment lexbuf; TokenN lexbuf
      )
and action_27 lexbuf = (
 TokenN lexbuf )
and action_26 lexbuf = (
 lexError "ill-formed token" lexbuf )
and action_25 lexbuf = (
 mkQualId lexbuf )
and action_24 lexbuf = (
 mkKeyword lexbuf )
and action_23 lexbuf = (
 Comment lexbuf )
and action_22 lexbuf = (
 EOF )
and action_21 lexbuf = (
 (decr comment_depth;
         if !comment_depth > 0 then Comment lexbuf else NULL) )
and action_20 lexbuf = (
 (incr comment_depth; Comment lexbuf) )
and action_19 lexbuf = (
 String lexbuf )
and action_18 lexbuf = (
 SkipString lexbuf )
and action_17 lexbuf = (
 EOF )
and action_16 lexbuf = (
 SkipString lexbuf )
and action_15 lexbuf = (
 String lexbuf )
and action_14 lexbuf = (
 String lexbuf )
and action_13 lexbuf = (
 String lexbuf )
and action_12 lexbuf = (
 String lexbuf )
and action_11 lexbuf = (
 NULL )
and action_10 lexbuf = (
 SkipString lexbuf )
and action_9 lexbuf = (
 EOF )
and action_8 lexbuf = (
 SkipString lexbuf )
and action_7 lexbuf = (
 SkipString lexbuf )
and action_6 lexbuf = (
 NULL )
and action_5 lexbuf = (
 Quotation lexbuf )
and action_4 lexbuf = (
 EOF )
and action_3 lexbuf = (
 NULL )
and action_2 lexbuf = (
DQuotation lexbuf )
and action_1 lexbuf = (
 EOF )
and action_0 lexbuf = (
 NULL )
and state_0 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"`" => state_84 lexbuf
 |  #"\^Z" => action_1 lexbuf
 |  #"\^@" => action_1 lexbuf
 |  _ => action_2 lexbuf
 end)
and state_1 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"`" => action_3 lexbuf
 |  #"\^Z" => action_4 lexbuf
 |  #"\^@" => action_4 lexbuf
 |  _ => action_5 lexbuf
 end)
and state_2 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_73 lexbuf
 |  #"\"" => action_6 lexbuf
 |  #"\^Z" => action_9 lexbuf
 |  #"\^@" => action_9 lexbuf
 |  _ => action_10 lexbuf
 end)
and state_3 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"\^A" andalso currChar <= #"\^Y" then  action_18 lexbuf
 else case currChar of
    #"\127" => action_18 lexbuf
 |  #"\255" => action_18 lexbuf
 |  #"\\" => state_60 lexbuf
 |  #"\"" => action_11 lexbuf
 |  #"\^Z" => action_17 lexbuf
 |  #"\^@" => action_17 lexbuf
 |  _ => action_19 lexbuf
 end)
and state_4 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => state_52 lexbuf
 |  #"(" => state_51 lexbuf
 |  #"\^Z" => action_22 lexbuf
 |  #"\^@" => action_22 lexbuf
 |  _ => action_23 lexbuf
 end)
and state_5 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"A" andalso currChar <= #"Z" then  state_42 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_42 lexbuf
 else case currChar of
    #"!" => state_41 lexbuf
 |  #"&" => state_41 lexbuf
 |  #"%" => state_41 lexbuf
 |  #"$" => state_41 lexbuf
 |  #"#" => state_41 lexbuf
 |  #"+" => state_41 lexbuf
 |  #"*" => state_41 lexbuf
 |  #"-" => state_41 lexbuf
 |  #"/" => state_41 lexbuf
 |  #":" => state_41 lexbuf
 |  #"@" => state_41 lexbuf
 |  #"?" => state_41 lexbuf
 |  #">" => state_41 lexbuf
 |  #"=" => state_41 lexbuf
 |  #"<" => state_41 lexbuf
 |  #"\\" => state_41 lexbuf
 |  #"^" => state_41 lexbuf
 |  #"|" => state_41 lexbuf
 |  #"~" => state_41 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => action_26 lexbuf
 end)
and state_6 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_48);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_18 lexbuf
 else case currChar of
    #"\n" => action_27 lexbuf
 |  #"\t" => action_27 lexbuf
 |  #"\r" => action_27 lexbuf
 |  #" " => action_27 lexbuf
 |  #"\^@" => action_45 lexbuf
 |  #"\^Z" => action_45 lexbuf
 |  #"~" => state_26 lexbuf
 |  #"}" => action_38 lexbuf
 |  #"{" => action_37 lexbuf
 |  #"`" => state_23 lexbuf
 |  #"_" => action_34 lexbuf
 |  #"]" => action_41 lexbuf
 |  #"[" => action_39 lexbuf
 |  #";" => action_44 lexbuf
 |  #"." => state_17 lexbuf
 |  #"," => action_35 lexbuf
 |  #"*" => state_15 lexbuf
 |  #")" => action_43 lexbuf
 |  #"(" => state_13 lexbuf
 |  #"'" => state_12 lexbuf
 |  #"#" => state_11 lexbuf
 |  #"\"" => action_32 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_7 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_50);
 let val currChar = getNextChar lexbuf in
 case currChar of
    _ => backtrack lexbuf
 end)
and state_11 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"[" => action_40 lexbuf
 |  #"\"" => action_33 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_12 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_37 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_37 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_37 lexbuf
 else case currChar of
    #"'" => state_37 lexbuf
 |  #"_" => state_37 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_13 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_42);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_28 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_15 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #")" => action_29 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_17 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"." => state_33 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_18 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_18 lexbuf
 else case currChar of
    #"E" => state_29 lexbuf
 |  #"." => state_28 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_23 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_47);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"`" => action_46 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_26 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_18 lexbuf
 else backtrack lexbuf
 end)
and state_28 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_32 lexbuf
 else backtrack lexbuf
 end)
and state_29 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else case currChar of
    #"~" => state_31 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_30 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else backtrack lexbuf
 end)
and state_31 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else backtrack lexbuf
 end)
and state_32 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_32 lexbuf
 else case currChar of
    #"E" => state_29 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_33 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"." => action_36 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_37 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_30);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_37 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_37 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_37 lexbuf
 else case currChar of
    #"'" => state_37 lexbuf
 |  #"_" => state_37 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_41 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_24);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"!" => state_47 lexbuf
 |  #"&" => state_47 lexbuf
 |  #"%" => state_47 lexbuf
 |  #"$" => state_47 lexbuf
 |  #"#" => state_47 lexbuf
 |  #"+" => state_47 lexbuf
 |  #"*" => state_47 lexbuf
 |  #"-" => state_47 lexbuf
 |  #"/" => state_47 lexbuf
 |  #":" => state_47 lexbuf
 |  #"@" => state_47 lexbuf
 |  #"?" => state_47 lexbuf
 |  #">" => state_47 lexbuf
 |  #"=" => state_47 lexbuf
 |  #"<" => state_47 lexbuf
 |  #"\\" => state_47 lexbuf
 |  #"^" => state_47 lexbuf
 |  #"|" => state_47 lexbuf
 |  #"~" => state_47 lexbuf
 |  #"." => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_42 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_24);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_43 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_43 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_43 lexbuf
 else case currChar of
    #"'" => state_43 lexbuf
 |  #"_" => state_43 lexbuf
 |  #"." => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_43 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_24);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_43 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_43 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_43 lexbuf
 else case currChar of
    #"'" => state_43 lexbuf
 |  #"_" => state_43 lexbuf
 |  #"." => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_44 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"A" andalso currChar <= #"Z" then  state_46 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_46 lexbuf
 else case currChar of
    #"!" => state_45 lexbuf
 |  #"&" => state_45 lexbuf
 |  #"%" => state_45 lexbuf
 |  #"$" => state_45 lexbuf
 |  #"#" => state_45 lexbuf
 |  #"+" => state_45 lexbuf
 |  #"*" => state_45 lexbuf
 |  #"/" => state_45 lexbuf
 |  #"." => state_45 lexbuf
 |  #"-" => state_45 lexbuf
 |  #":" => state_45 lexbuf
 |  #"@" => state_45 lexbuf
 |  #"?" => state_45 lexbuf
 |  #">" => state_45 lexbuf
 |  #"=" => state_45 lexbuf
 |  #"<" => state_45 lexbuf
 |  #"\\" => state_45 lexbuf
 |  #"^" => state_45 lexbuf
 |  #"|" => state_45 lexbuf
 |  #"~" => state_45 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_45 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_25);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"!" => state_45 lexbuf
 |  #"&" => state_45 lexbuf
 |  #"%" => state_45 lexbuf
 |  #"$" => state_45 lexbuf
 |  #"#" => state_45 lexbuf
 |  #"+" => state_45 lexbuf
 |  #"*" => state_45 lexbuf
 |  #"/" => state_45 lexbuf
 |  #"." => state_45 lexbuf
 |  #"-" => state_45 lexbuf
 |  #":" => state_45 lexbuf
 |  #"@" => state_45 lexbuf
 |  #"?" => state_45 lexbuf
 |  #">" => state_45 lexbuf
 |  #"=" => state_45 lexbuf
 |  #"<" => state_45 lexbuf
 |  #"\\" => state_45 lexbuf
 |  #"^" => state_45 lexbuf
 |  #"|" => state_45 lexbuf
 |  #"~" => state_45 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_46 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_25);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_46 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_46 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_46 lexbuf
 else case currChar of
    #"'" => state_46 lexbuf
 |  #"." => state_46 lexbuf
 |  #"_" => state_46 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_47 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_24);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"!" => state_47 lexbuf
 |  #"&" => state_47 lexbuf
 |  #"%" => state_47 lexbuf
 |  #"$" => state_47 lexbuf
 |  #"#" => state_47 lexbuf
 |  #"+" => state_47 lexbuf
 |  #"*" => state_47 lexbuf
 |  #"-" => state_47 lexbuf
 |  #"/" => state_47 lexbuf
 |  #":" => state_47 lexbuf
 |  #"@" => state_47 lexbuf
 |  #"?" => state_47 lexbuf
 |  #">" => state_47 lexbuf
 |  #"=" => state_47 lexbuf
 |  #"<" => state_47 lexbuf
 |  #"\\" => state_47 lexbuf
 |  #"^" => state_47 lexbuf
 |  #"|" => state_47 lexbuf
 |  #"~" => state_47 lexbuf
 |  #"." => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_51 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_23);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_20 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_52 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_23);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #")" => action_21 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_60 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_16);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_63 lexbuf
 else case currChar of
    #"\"" => action_12 lexbuf
 |  #"\\" => action_12 lexbuf
 |  #"n" => action_12 lexbuf
 |  #"t" => action_12 lexbuf
 |  #"\n" => state_61 lexbuf
 |  #"\t" => state_61 lexbuf
 |  #"\r" => state_61 lexbuf
 |  #" " => state_61 lexbuf
 |  #"^" => state_64 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_61 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\n" => state_61 lexbuf
 |  #"\t" => state_61 lexbuf
 |  #"\r" => state_61 lexbuf
 |  #" " => state_61 lexbuf
 |  #"\\" => action_13 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_63 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_66 lexbuf
 else backtrack lexbuf
 end)
and state_64 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"@" andalso currChar <= #"_" then  action_14 lexbuf
 else backtrack lexbuf
 end)
and state_66 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  action_15 lexbuf
 else backtrack lexbuf
 end)
and state_73 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_10);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\"" => action_7 lexbuf
 |  #"\\" => action_7 lexbuf
 |  #"n" => action_7 lexbuf
 |  #"t" => action_7 lexbuf
 |  #"\n" => state_74 lexbuf
 |  #"\t" => state_74 lexbuf
 |  #"\r" => state_74 lexbuf
 |  #" " => state_74 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_74 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\n" => state_74 lexbuf
 |  #"\t" => state_74 lexbuf
 |  #"\r" => state_74 lexbuf
 |  #" " => state_74 lexbuf
 |  #"\\" => action_8 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_84 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_2);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"`" => action_0 lexbuf
 |  _ => backtrack lexbuf
 end)
and Token lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_7 lexbuf)

and TokenN lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_6 lexbuf)

and TokenId lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_5 lexbuf)

and Comment lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_4 lexbuf)

and String lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_3 lexbuf)

and SkipString lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_2 lexbuf)

and Quotation lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_1 lexbuf)

and DQuotation lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_0 lexbuf)

(* The following checks type consistency of actions *)
val _ = fn _ => [action_50, action_49];
val _ = fn _ => [action_48, action_47, action_46, action_45, action_44, action_43, action_42, action_41, action_40, action_39, action_38, action_37, action_36, action_35, action_34, action_33, action_32, action_31, action_30, action_29, action_28, action_27];
val _ = fn _ => [action_26, action_25, action_24];
val _ = fn _ => [action_23, action_22, action_21, action_20];
val _ = fn _ => [action_19, action_18, action_17, action_16, action_15, action_14, action_13, action_12, action_11];
val _ = fn _ => [action_10, action_9, action_8, action_7, action_6];
val _ = fn _ => [action_5, action_4, action_3];
val _ = fn _ => [action_2, action_1, action_0];

end
