signature opsemTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val EVAL : thm
    val If : thm
    val SPEC_DEF : thm
    val Skip : thm
    val While : thm
    val assign_def : thm
    val comm_TY_DEF : thm
    val comm_case_def : thm
    val comm_repfns : thm
    val comm_size_def : thm
    val ii_internalopsem0_def : thm
    val ii_internalopsem1_def : thm
    val ii_internalopsem2_def : thm
    val ii_internalopsem3_def : thm
    val ii_internalopsem4_def : thm
    val seq_def : thm
  
  (*  Theorems  *)
    val ASSIGN_THM : thm
    val DETERMINISTIC : thm
    val IF_F_THM : thm
    val IF_T_THM : thm
    val SEQ_THM : thm
    val SKIP_THM : thm
    val WHILE : thm
    val WHILE_F_THM : thm
    val WHILE_T_THM : thm
    val comm_11 : thm
    val comm_Axiom : thm
    val comm_case_cong : thm
    val comm_distinct : thm
    val comm_induction : thm
    val comm_nchotomy : thm
  
  val opsem_grammars : parse_type.grammar * term_grammar.grammar
(*
   [list] Parent theory of "opsem"
   
   [option] Parent theory of "opsem"
   
   [string] Parent theory of "opsem"
   
   [EVAL]
   Definition
   [oracles: ] [axioms: ] []
   |- EVAL =
      (\a0 a1 a2.
         !EVAL'.
           (!a0 a1 a2.
              (a0 = Skip) /\ (a2 = a1) \/
              (?V E.
                 (a0 = V ::= E) /\
                 (a2 = (\v. (if v = V then E a1 else a1 v)))) \/
              (?C1 C2.
                 (a0 = C1 ;; C2) /\
                 ?s2. EVAL' C1 a1 s2 /\ EVAL' C2 s2 a2) \/
              (?C1 C2 B. (a0 = If B C1 C2) /\ EVAL' C1 a1 a2 /\ B a1) \/
              (?C1 C2 B. (a0 = If B C1 C2) /\ EVAL' C2 a1 a2 /\ ~B a1) \/
              (?C B. (a0 = While B C) /\ (a2 = a1) /\ ~B a1) \/
              (?C B.
                 (a0 = While B C) /\
                 ?s2. EVAL' C a1 s2 /\ EVAL' (While B C) s2 a2 /\ B a1) ==>
              EVAL' a0 a1 a2) ==>
           EVAL' a0 a1 a2)
   
   [If]  Definition  [oracles: ] [axioms: ] [] |- If = ii_internalopsem3
   
   [SPEC_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- !P C Q. SPEC P C Q = !s1 s2. P s1 /\ EVAL C s1 s2 ==> Q s2
   
   [Skip]
   Definition
   [oracles: ] [axioms: ] [] |- Skip = ii_internalopsem0
   
   [While]
   Definition
   [oracles: ] [axioms: ] [] |- While = ii_internalopsem4
   
   [assign_def]
   Definition
   [oracles: ] [axioms: ] [] |- $::= = ii_internalopsem1
   
   [comm_TY_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- ?rep.
        TYPE_DEFINITION
          (\a0'.
             !'comm'.
               (!a0'.
                  (a0' = CONSTR 0 ((@v. T),(@v. T),@v. T) (\n. BOTTOM)) \/
                  (?a0 a1.
                     a0' =
                     (\a0 a1. CONSTR (SUC 0) (a0,a1,@v. T) (\n. BOTTOM)) a0
                       a1) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC (SUC 0)) ((@v. T),(@v. T),@v. T)
                           (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                     'comm' a0 /\ 'comm' a1) \/
                  (?a0 a1 a2.
                     (a0' =
                      (\a0 a1 a2.
                         CONSTR (SUC (SUC (SUC 0))) ((@v. T),(@v. T),a0)
                           (FCONS a1 (FCONS a2 (\n. BOTTOM)))) a0 a1 a2) /\
                     'comm' a1 /\ 'comm' a2) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC (SUC (SUC (SUC 0))))
                           ((@v. T),(@v. T),a0) (FCONS a1 (\n. BOTTOM))) a0
                        a1) /\ 'comm' a1) ==>
                  'comm' a0') ==>
               'comm' a0') rep
   
   [comm_case_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!v f f1 f2 f3. comm_case v f f1 f2 f3 Skip = v) /\
      (!v f f1 f2 f3 a0 a1.
         comm_case v f f1 f2 f3 (a0 ::= a1) = f a0 a1) /\
      (!v f f1 f2 f3 a0 a1.
         comm_case v f f1 f2 f3 (a0 ;; a1) = f1 a0 a1) /\
      (!v f f1 f2 f3 a0 a1 a2.
         comm_case v f f1 f2 f3 (If a0 a1 a2) = f2 a0 a1 a2) /\
      !v f f1 f2 f3 a0 a1. comm_case v f f1 f2 f3 (While a0 a1) = f3 a0 a1
   
   [comm_repfns]
   Definition
   [oracles: ] [axioms: ] []
   |- (!a. ii_internal_mk_comm (ii_internal_dest_comm a) = a) /\
      !r.
        (\a0'.
           !'comm'.
             (!a0'.
                (a0' = CONSTR 0 ((@v. T),(@v. T),@v. T) (\n. BOTTOM)) \/
                (?a0 a1.
                   a0' =
                   (\a0 a1. CONSTR (SUC 0) (a0,a1,@v. T) (\n. BOTTOM)) a0
                     a1) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC (SUC 0)) ((@v. T),(@v. T),@v. T)
                         (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                   'comm' a0 /\ 'comm' a1) \/
                (?a0 a1 a2.
                   (a0' =
                    (\a0 a1 a2.
                       CONSTR (SUC (SUC (SUC 0))) ((@v. T),(@v. T),a0)
                         (FCONS a1 (FCONS a2 (\n. BOTTOM)))) a0 a1 a2) /\
                   'comm' a1 /\ 'comm' a2) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC (SUC (SUC (SUC 0))))
                         ((@v. T),(@v. T),a0) (FCONS a1 (\n. BOTTOM))) a0
                      a1) /\ 'comm' a1) ==>
                'comm' a0') ==>
             'comm' a0') r =
        (ii_internal_dest_comm (ii_internal_mk_comm r) = r)
   
   [comm_size_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (comm_size Skip = 0) /\
      (!a0 a1. comm_size (a0 ::= a1) = 1 + string_size a0) /\
      (!a0 a1. comm_size (a0 ;; a1) = 1 + (comm_size a0 + comm_size a1)) /\
      (!a0 a1 a2.
         comm_size (If a0 a1 a2) = 1 + (comm_size a1 + comm_size a2)) /\
      !a0 a1. comm_size (While a0 a1) = 1 + comm_size a1
   
   [ii_internalopsem0_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalopsem0 =
      ii_internal_mk_comm (CONSTR 0 ((@v. T),(@v. T),@v. T) (\n. BOTTOM))
   
   [ii_internalopsem1_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalopsem1 =
      (\a0 a1.
         ii_internal_mk_comm
           ((\a0 a1. CONSTR (SUC 0) (a0,a1,@v. T) (\n. BOTTOM)) a0 a1))
   
   [ii_internalopsem2_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalopsem2 =
      (\a0 a1.
         ii_internal_mk_comm
           ((\a0 a1.
               CONSTR (SUC (SUC 0)) ((@v. T),(@v. T),@v. T)
                 (FCONS a0 (FCONS a1 (\n. BOTTOM))))
              (ii_internal_dest_comm a0) (ii_internal_dest_comm a1)))
   
   [ii_internalopsem3_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalopsem3 =
      (\a0 a1 a2.
         ii_internal_mk_comm
           ((\a0 a1 a2.
               CONSTR (SUC (SUC (SUC 0))) ((@v. T),(@v. T),a0)
                 (FCONS a1 (FCONS a2 (\n. BOTTOM)))) a0
              (ii_internal_dest_comm a1) (ii_internal_dest_comm a2)))
   
   [ii_internalopsem4_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalopsem4 =
      (\a0 a1.
         ii_internal_mk_comm
           ((\a0 a1.
               CONSTR (SUC (SUC (SUC (SUC 0)))) ((@v. T),(@v. T),a0)
                 (FCONS a1 (\n. BOTTOM))) a0 (ii_internal_dest_comm a1)))
   
   [seq_def]
   Definition
   [oracles: ] [axioms: ] [] |- $;; = ii_internalopsem2
   
   [ASSIGN_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 V E.
        EVAL (V ::= E) s1 s2 = ((\v. (if v = V then E s1 else s1 v)) = s2)
   
   [DETERMINISTIC]
   Theorem
   [oracles: ] [axioms: ] []
   |- !C st1 st2. EVAL C st1 st2 ==> !st3. EVAL C st1 st3 ==> (st2 = st3)
   
   [IF_F_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 B C1 C2. ~B s1 ==> (EVAL (If B C1 C2) s1 s2 = EVAL C2 s1 s2)
   
   [IF_T_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 B C1 C2. B s1 ==> (EVAL (If B C1 C2) s1 s2 = EVAL C1 s1 s2)
   
   [SEQ_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 C1 C2.
        EVAL (C1 ;; C2) s1 s2 = ?s3. EVAL C1 s1 s3 /\ EVAL C2 s3 s2
   
   [SKIP_THM]
   Theorem
   [oracles: ] [axioms: ] [] |- !s1 s2. EVAL Skip s1 s2 = (s1 = s2)
   
   [WHILE]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P C.
        SPEC (\s. P s /\ B s) C P ==> SPEC P (While B C) (\s. P s /\ ~B s)
   
   [WHILE_F_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 B C'. ~B s1 ==> (EVAL (While B C') s1 s2 = (s1 = s2))
   
   [WHILE_T_THM]
   Theorem
   [oracles: ] [axioms: ] []
   |- !s1 s2 B C'.
        B s1 ==>
        (EVAL (While B C') s1 s2 =
         ?s3. EVAL C' s1 s3 /\ EVAL (While B C') s3 s2)
   
   [comm_11]
   Theorem
   [oracles: ] [axioms: ] []
   |- (!a0 a1 a0' a1'.
         (a0 ::= a1 = a0' ::= a1') = (a0 = a0') /\ (a1 = a1')) /\
      (!a0 a1 a0' a1'.
         (a0 ;; a1 = a0' ;; a1') = (a0 = a0') /\ (a1 = a1')) /\
      (!a0 a1 a2 a0' a1' a2'.
         (If a0 a1 a2 = If a0' a1' a2') =
         (a0 = a0') /\ (a1 = a1') /\ (a2 = a2')) /\
      !a0 a1 a0' a1'.
        (While a0 a1 = While a0' a1') = (a0 = a0') /\ (a1 = a1')
   
   [comm_Axiom]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f0 f1 f2 f3 f4.
        ?fn.
          (fn Skip = f0) /\ (!a0 a1. fn (a0 ::= a1) = f1 a0 a1) /\
          (!a0 a1. fn (a0 ;; a1) = f2 a0 a1 (fn a0) (fn a1)) /\
          (!a0 a1 a2. fn (If a0 a1 a2) = f3 a0 a1 a2 (fn a1) (fn a2)) /\
          !a0 a1. fn (While a0 a1) = f4 a0 a1 (fn a1)
   
   [comm_case_cong]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f3' f3 f2' f2 f1' f1 f' f v' v M' M.
        (M = M') /\ ((M' = Skip) ==> (v = v')) /\
        (!a0 a1. (M' = a0 ::= a1) ==> (f a0 a1 = f' a0 a1)) /\
        (!a0 a1. (M' = a0 ;; a1) ==> (f1 a0 a1 = f1' a0 a1)) /\
        (!a0 a1 a2. (M' = If a0 a1 a2) ==> (f2 a0 a1 a2 = f2' a0 a1 a2)) /\
        (!a0 a1. (M' = While a0 a1) ==> (f3 a0 a1 = f3' a0 a1)) ==>
        (comm_case v f f1 f2 f3 M = comm_case v' f' f1' f2' f3' M')
   
   [comm_distinct]
   Theorem
   [oracles: ] [axioms: ] []
   |- (!a1 a0. ~(Skip = a0 ::= a1)) /\ (!a1 a0. ~(Skip = a0 ;; a1)) /\
      (!a2 a1 a0. ~(Skip = If a0 a1 a2)) /\
      (!a1 a0. ~(Skip = While a0 a1)) /\
      (!a1' a0' a1 a0. ~(a0 ::= a1 = a0' ;; a1')) /\
      (!a2 a1' a0' a1 a0. ~(a0 ::= a1 = If a0' a1' a2)) /\
      (!a1' a0' a1 a0. ~(a0 ::= a1 = While a0' a1')) /\
      (!a2 a1' a0' a1 a0. ~(a0 ;; a1 = If a0' a1' a2)) /\
      (!a1' a0' a1 a0. ~(a0 ;; a1 = While a0' a1')) /\
      !a1' a0' a2 a1 a0. ~(If a0 a1 a2 = While a0' a1')
   
   [comm_induction]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P.
        P Skip /\ (!s f. P (s ::= f)) /\
        (!c c0. P c /\ P c0 ==> P (c ;; c0)) /\
        (!c c0. P c /\ P c0 ==> !f. P (If f c c0)) /\
        (!c. P c ==> !f. P (While f c)) ==>
        !c. P c
   
   [comm_nchotomy]
   Theorem
   [oracles: ] [axioms: ] []
   |- !c.
        (c = Skip) \/ (?s f. c = s ::= f) \/ (?c' c0. c = c' ;; c0) \/
        (?f c' c0. c = If f c' c0) \/ ?f c'. c = While f c'
   
   
*)
end
