signature algebraTheory =
sig
  type thm = Thm.thm
  
  (*  Definitions  *)
    val BEQUIV_DEF : thm
    val MEQUIV_DEF : thm
    val MTRACE : thm
    val Nil : thm
    val Pre : thm
    val Prod : thm
    val SIM_DEF : thm
    val Sum : thm
    val TERMINAL_DEF : thm
    val TRANS : thm
    val TRANSIT : thm
    val agent_TY_DEF : thm
    val agent_case_def : thm
    val agent_repfns : thm
    val agent_size_def : thm
    val ii_internalalgebra0_def : thm
    val ii_internalalgebra1_def : thm
    val ii_internalalgebra2_def : thm
    val ii_internalalgebra3_def : thm
  
  (*  Theorems  *)
    val Corollary1 : thm
    val Theorem1 : thm
    val Theorem2 : thm
    val Theorem3 : thm
    val agent_11 : thm
    val agent_Axiom : thm
    val agent_case_cong : thm
    val agent_distinct : thm
    val agent_induction : thm
    val agent_nchotomy : thm
  
  val algebra_grammars : parse_type.grammar * term_grammar.grammar
(*
   [list] Parent theory of "algebra"
   
   [option] Parent theory of "algebra"
   
   [string] Parent theory of "algebra"
   
   [BEQUIV_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- !P Q. P BEQUIV Q = ?s. SIM s /\ s P Q /\ SIM (\x y. s y x)
   
   [MEQUIV_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- !P Q. P MEQUIV Q = !A. MTRACE P A = MTRACE Q A
   
   [MTRACE]
   Definition
   [oracles: ] [axioms: ] []
   |- MTRACE =
      (\a0 a1.
         !MTRACE'.
           (!a0 a1.
              (a0 = Nil) /\ (a1 = []) \/
              (?P A a. (a0 = Pre a P) /\ (a1 = a::A) /\ MTRACE' P A) \/
              (?P Q. (a0 = Sum P Q) /\ MTRACE' P a1) \/
              (?P Q. (a0 = Sum P Q) /\ MTRACE' Q a1) \/
              (?P Q. (a0 = Prod P Q) /\ MTRACE' P a1 /\ MTRACE' Q a1) ==>
              MTRACE' a0 a1) ==>
           MTRACE' a0 a1)
   
   [Nil]
   Definition
   [oracles: ] [axioms: ] [] |- Nil = ii_internalalgebra0
   
   [Pre]
   Definition
   [oracles: ] [axioms: ] [] |- Pre = ii_internalalgebra1
   
   [Prod]
   Definition
   [oracles: ] [axioms: ] [] |- Prod = ii_internalalgebra3
   
   [SIM_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- !s.
        SIM s =
        !P Q.
          s P Q ==> !a P'. TRANS P a P' ==> ?Q'. TRANS Q a Q' /\ s P' Q'
   
   [Sum]
   Definition
   [oracles: ] [axioms: ] [] |- Sum = ii_internalalgebra2
   
   [TERMINAL_DEF]
   Definition
   [oracles: ] [axioms: ] [] |- !P. TERMINAL P = MTRACE P []
   
   [TRANS]
   Definition
   [oracles: ] [axioms: ] []
   |- TRANS =
      (\a0 a1 a2.
         !TRANS'.
           (!a0 a1 a2.
              (a0 = Pre a1 a2) \/
              (?P Q. (a0 = Sum P Q) /\ TRANS' P a1 a2) \/
              (?P Q. (a0 = Sum P Q) /\ TRANS' Q a1 a2) \/
              (?P P' Q Q'.
                 (a0 = Prod P Q) /\ (a2 = Prod P' Q') /\ TRANS' P a1 P' /\
                 TRANS' Q a1 Q') ==>
              TRANS' a0 a1 a2) ==>
           TRANS' a0 a1 a2)
   
   [TRANSIT]
   Definition
   [oracles: ] [axioms: ] []
   |- TRANSIT =
      (\a0 a1 a2.
         !TRANSIT'.
           (!a0 a1 a2.
              (a1 = []) /\ (a2 = a0) \/
              (?B a.
                 (a1 = a::B) /\ ?Q. TRANS a0 a Q /\ TRANSIT' Q B a2) ==>
              TRANSIT' a0 a1 a2) ==>
           TRANSIT' a0 a1 a2)
   
   [agent_TY_DEF]
   Definition
   [oracles: ] [axioms: ] []
   |- ?rep.
        TYPE_DEFINITION
          (\a0'.
             !'agent'.
               (!a0'.
                  (a0' = CONSTR 0 (@v. T) (\n. BOTTOM)) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1. CONSTR (SUC 0) a0 (FCONS a1 (\n. BOTTOM)))
                        a0 a1) /\ 'agent' a1) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC (SUC 0)) (@v. T)
                           (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                     'agent' a0 /\ 'agent' a1) \/
                  (?a0 a1.
                     (a0' =
                      (\a0 a1.
                         CONSTR (SUC (SUC (SUC 0))) (@v. T)
                           (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                     'agent' a0 /\ 'agent' a1) ==>
                  'agent' a0') ==>
               'agent' a0') rep
   
   [agent_case_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (!v f f1 f2. agent_case v f f1 f2 Nil = v) /\
      (!v f f1 f2 a0 a1. agent_case v f f1 f2 (Pre a0 a1) = f a0 a1) /\
      (!v f f1 f2 a0 a1. agent_case v f f1 f2 (Sum a0 a1) = f1 a0 a1) /\
      !v f f1 f2 a0 a1. agent_case v f f1 f2 (Prod a0 a1) = f2 a0 a1
   
   [agent_repfns]
   Definition
   [oracles: ] [axioms: ] []
   |- (!a. ii_internal_mk_agent (ii_internal_dest_agent a) = a) /\
      !r.
        (\a0'.
           !'agent'.
             (!a0'.
                (a0' = CONSTR 0 (@v. T) (\n. BOTTOM)) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1. CONSTR (SUC 0) a0 (FCONS a1 (\n. BOTTOM))) a0
                      a1) /\ 'agent' a1) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC (SUC 0)) (@v. T)
                         (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                   'agent' a0 /\ 'agent' a1) \/
                (?a0 a1.
                   (a0' =
                    (\a0 a1.
                       CONSTR (SUC (SUC (SUC 0))) (@v. T)
                         (FCONS a0 (FCONS a1 (\n. BOTTOM)))) a0 a1) /\
                   'agent' a0 /\ 'agent' a1) ==>
                'agent' a0') ==>
             'agent' a0') r =
        (ii_internal_dest_agent (ii_internal_mk_agent r) = r)
   
   [agent_size_def]
   Definition
   [oracles: ] [axioms: ] []
   |- (agent_size Nil = 0) /\
      (!a0 a1.
         agent_size (Pre a0 a1) = 1 + (string_size a0 + agent_size a1)) /\
      (!a0 a1.
         agent_size (Sum a0 a1) = 1 + (agent_size a0 + agent_size a1)) /\
      !a0 a1. agent_size (Prod a0 a1) = 1 + (agent_size a0 + agent_size a1)
   
   [ii_internalalgebra0_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalalgebra0 =
      ii_internal_mk_agent (CONSTR 0 (@v. T) (\n. BOTTOM))
   
   [ii_internalalgebra1_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalalgebra1 =
      (\a0 a1.
         ii_internal_mk_agent
           ((\a0 a1. CONSTR (SUC 0) a0 (FCONS a1 (\n. BOTTOM))) a0
              (ii_internal_dest_agent a1)))
   
   [ii_internalalgebra2_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalalgebra2 =
      (\a0 a1.
         ii_internal_mk_agent
           ((\a0 a1.
               CONSTR (SUC (SUC 0)) (@v. T)
                 (FCONS a0 (FCONS a1 (\n. BOTTOM))))
              (ii_internal_dest_agent a0) (ii_internal_dest_agent a1)))
   
   [ii_internalalgebra3_def]
   Definition
   [oracles: ] [axioms: ] []
   |- ii_internalalgebra3 =
      (\a0 a1.
         ii_internal_mk_agent
           ((\a0 a1.
               CONSTR (SUC (SUC (SUC 0))) (@v. T)
                 (FCONS a0 (FCONS a1 (\n. BOTTOM))))
              (ii_internal_dest_agent a0) (ii_internal_dest_agent a1)))
   
   [Corollary1]
   Theorem
   [oracles: ] [axioms: ] [] |- !P A. TRANSIT P A Nil ==> MTRACE P A
   
   [Theorem1]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P A Q. TRANSIT P A Q ==> TERMINAL Q ==> MTRACE P A
   
   [Theorem2]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P A. MTRACE P A ==> ?Q. TRANSIT P A Q /\ TERMINAL Q
   
   [Theorem3]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P A. MTRACE P A = ?Q. TRANSIT P A Q /\ TERMINAL Q
   
   [agent_11]
   Theorem
   [oracles: ] [axioms: ] []
   |- (!a0 a1 a0' a1'.
         (Pre a0 a1 = Pre a0' a1') = (a0 = a0') /\ (a1 = a1')) /\
      (!a0 a1 a0' a1'.
         (Sum a0 a1 = Sum a0' a1') = (a0 = a0') /\ (a1 = a1')) /\
      !a0 a1 a0' a1'.
        (Prod a0 a1 = Prod a0' a1') = (a0 = a0') /\ (a1 = a1')
   
   [agent_Axiom]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f0 f1 f2 f3.
        ?fn.
          (fn Nil = f0) /\ (!a0 a1. fn (Pre a0 a1) = f1 a0 a1 (fn a1)) /\
          (!a0 a1. fn (Sum a0 a1) = f2 a0 a1 (fn a0) (fn a1)) /\
          !a0 a1. fn (Prod a0 a1) = f3 a0 a1 (fn a0) (fn a1)
   
   [agent_case_cong]
   Theorem
   [oracles: ] [axioms: ] []
   |- !f2' f2 f1' f1 f' f v' v M' M.
        (M = M') /\ ((M' = Nil) ==> (v = v')) /\
        (!a0 a1. (M' = Pre a0 a1) ==> (f a0 a1 = f' a0 a1)) /\
        (!a0 a1. (M' = Sum a0 a1) ==> (f1 a0 a1 = f1' a0 a1)) /\
        (!a0 a1. (M' = Prod a0 a1) ==> (f2 a0 a1 = f2' a0 a1)) ==>
        (agent_case v f f1 f2 M = agent_case v' f' f1' f2' M')
   
   [agent_distinct]
   Theorem
   [oracles: ] [axioms: ] []
   |- (!a1 a0. ~(Nil = Pre a0 a1)) /\ (!a1 a0. ~(Nil = Sum a0 a1)) /\
      (!a1 a0. ~(Nil = Prod a0 a1)) /\
      (!a1' a0' a1 a0. ~(Pre a0 a1 = Sum a0' a1')) /\
      (!a1' a0' a1 a0. ~(Pre a0 a1 = Prod a0' a1')) /\
      !a1' a0' a1 a0. ~(Sum a0 a1 = Prod a0' a1')
   
   [agent_induction]
   Theorem
   [oracles: ] [axioms: ] []
   |- !P.
        P Nil /\ (!a. P a ==> !s. P (Pre s a)) /\
        (!a a0. P a /\ P a0 ==> P (Sum a a0)) /\
        (!a a0. P a /\ P a0 ==> P (Prod a a0)) ==>
        !a. P a
   
   [agent_nchotomy]
   Theorem
   [oracles: ] [axioms: ] []
   |- !a.
        (a = Nil) \/ (?s a'. a = Pre s a') \/ (?a' a0. a = Sum a' a0) \/
        ?a' a0. a = Prod a' a0
   
   
*)
end
