(*---------------------------------------------------------------------------

     Tautologies. The examples were originally collected by John
     Harrison to exercise his implementation of Stalmarck's algorithm.

     Some of these can take a great deal of time and memory to complete.

     Note: the robdd package can be very slow to respond to interrupts: 
           the longer it runs, the longer it seems to take to respond.

 ---------------------------------------------------------------------------*)

load "muddyLib";

fun bdd_oracle q =
  let val tm = Parse.Term q
      val V = free_vars tm
  in 
    Lib.say (String.concat [int_to_string (length V), " variables.\n"]);
    time muddyLib.mk_bdd_thm tm
  end;

show_tags := true;


val syn323_1 = bdd_oracle 
`~((v0 \/ v1) /\ (~v0 \/ v1) /\ (~v1 \/ v0) /\ (~v0 \/ ~v1))`;

val syn029_1 = bdd_oracle 
`~((~v2 \/ ~v1) /\ v0 /\ (~v0 \/ ~v1 \/ v2) /\ (~v2 \/ v1) /\ (v1 \/ v2))`;

val syn052_1 = bdd_oracle 
`~((~v1 \/ v0) /\ (~v0 \/ v1) /\ (v1 \/ v0) /\ (~v1 \/ v1) /\ (~v0 \/ ~v1))`;

val syn051_1 = bdd_oracle 
`~((v1 \/ v0) /\
  (v1 \/ v2) /\
  (~v0 \/ ~v1) /\
  (~v2 \/ ~v1) /\
  (~v0 \/ v1) /\
  (~v1 \/ v2))`;

val syn044_1 = bdd_oracle 
`~((v0 \/ v1) /\
  (~v0 \/ ~v1) /\
  (~v0 \/ v1 \/ v2) /\
  (~v2 \/ v1) /\
  (~v2 \/ v0) /\
  (~v1 \/ v2))`;

val syn011_1 = bdd_oracle
`~(v6 /\
  (~v0 \/ ~v2) /\
  (v0 \/ v1 \/ v5) /\
  (~v2 \/ ~v1) /\
  (~v4 \/ v2) /\
  (~v3 \/ v2) /\
  (v3 \/ v4 \/ v5) /\
  (~v5 \/ ~v6))`;

val syn032_1 = bdd_oracle
`~((~v5 \/ ~v1) /\
  (~v4 \/ ~v0) /\
  (~v4 \/ v0) /\
  (~v5 \/ v1) /\
  (~v2 \/ v4 \/ v3) /\
  (v4 \/ v2 \/ v3) /\
  (~v3 \/ v4 \/ v5))`;

val ex2_be  = bdd_oracle
 `~((a /\ b /\ ~c) \/ (~a /\ b /\ c /\ ~d)) 
    ==>
    (s1 = ~a \/ d) /\ (oh = b /\ s1) /\ (s2 = ~c \/ d) ==> (oh = b /\ s2)`;

val syn030_1 = bdd_oracle
`~((~v4 \/ ~v0 \/ ~v1) /\
  (~v3 \/ ~v4 \/ v0) /\
  (~v1 \/ v0) /\
  (v0 \/ v1) /\
  (~v0 \/ v1) /\
  (~v1 \/ ~v0 \/ v2) /\
  (~v2 \/ v1) /\
  (~v1 \/ v3) /\
  (~v2 \/ ~v3 \/ v4))`;

val transp_be = bdd_oracle
 `(sub1x = ~(a \/ b)) /\
  (sub1y = ~(c \/ d)) /\
  (o2 = ~(sub1x \/ sub1y)) /\
  (o1 = sub1x /\ sub1y)
  ==> (o1 = ~a /\ ~b /\ ~c /\ ~d) /\ (o2 = (a \/ b) /\ (c \/ d))`;


val syn054_1 = bdd_oracle
`~((~v1 \/ ~v7) /\
  (~v2 \/ ~v0) /\
  (~v3 \/ v7 \/ v4) /\
  (~v6 \/ v0 \/ v5) /\
  (~v7 \/ v1) /\
  (~v0 \/ v2) /\
  (~v4 \/ v1) /\
  (~v5 \/ v2) /\
  (~v3 \/ ~v4) /\
  (~v6 \/ ~v5) /\
  (v6 \/ v7))`;

val gra001_1 = bdd_oracle
`~((~v1 \/ v0) /\
  (~v0 \/ v1) /\
  (~v4 \/ ~v2 \/ ~v0) /\
  (~v4 \/ v2 \/ v0) /\
  (~v2 \/ v4 \/ v0) /\
  (~v0 \/ v4 \/ v2) /\
  (~v3 \/ ~v2 \/ ~v1) /\
  (~v3 \/ v2 \/ v1) /\
  (~v2 \/ v3 \/ v1) /\
  (~v1 \/ v3 \/ v2) /\
  (~v3 \/ ~v4) /\
  (v3 \/ v4))` ;

val syn321_1 = bdd_oracle
`~((~v0 \/ v9) /\
  (~v0 \/ v6) /\
  (~v0 \/ v7) /\
  (~v8 \/ v9) /\
  (~v8 \/ v6) /\
  (~v8 \/ v7) /\
  (~v1 \/ v9) /\
  (~v1 \/ v6) /\
  (~v1 \/ v7) /\
  (~v2 \/ v3) /\
  (~v4 \/ v5) /\
  (~v7 \/ v8) /\
  (v8 \/ v9) /\
  (v8 \/ v6) /\
  (v8 \/ v7) /\
  (~v8 \/ ~v9))` ;

val rip02_be  = bdd_oracle
 `(car1 = a1 /\ b1) /\
  (cout = (a2 \/ b2) /\ car1 \/ a2 /\ b2) /\
  (som2 = ~(a2 = ~(b2 = car1))) /\
  (som1 = ~(a1 = b1)) /\
  (cout1 = b1 /\ a1)
  ==> (som1 = ~(~a1 /\ ~b1 \/ a1 /\ b1)) /\
      (som2 =
       ~((~a2 /\ ~b2 \/ a2 /\ b2) /\ ~cout1 \/
         cout1 /\ ~(~a2 /\ ~b2 \/ a2 /\ b2))) /\
      (cout = a2 /\ cout1 \/ b2 /\ cout1 \/ a2 /\ b2)`;

val puz014_1 = bdd_oracle
`~(v3 /\
  v0 /\
  v10 /\
  (v4 \/ v5) /\
  (v9 \/ v2) /\
  (v8 \/ v1) /\
  (v7 \/ v0) /\
  (v3 \/ v12) /\
  (v11 \/ v10) /\
  (~v12 \/ ~v6 \/ v7) /\
  (~v10 \/ ~v3 \/ v1) /\
  (~v10 \/ ~v0 \/ ~v4 \/ v11) /\
  (~v5 \/ ~v2 \/ ~v8) /\
  (~v12 \/ ~v9 \/ ~v7) /\
  (~v0 \/ ~v1 \/ v4) /\
  (~v4 \/ v7 \/ v2) /\
  (~v12 \/ ~v3 \/ v8) /\
  (~v4 \/ v5 \/ v6) /\
  (~v7 \/ ~v8 \/ v9) /\
  (~v10 \/ ~v11 \/ v12))` ;

val mjcg_yes = bdd_oracle 
`((adder1____carry__1__1 = ~a__0 /\ b__0) /\
  (adder1____carry__1__2 =
   b__1 /\ adder1____carry__1__1 \/
   ~a__1 /\ ~(b__1 = adder1____carry__1__1)) /\
  (adder1____carry__2__1 = a__0 /\ b__0) /\
  (adder1____carry__2__2 =
   b__1 /\ adder1____carry__2__1 \/
   a__1 /\ ~(b__1 = adder1____carry__2__1))) /\
 (adder2____carry__1__1 = cnt__0 /\ a__0) /\
 (adder2____carry__1__2 = a__1 /\ adder2____carry__1__1) /\
 (adder2____carry__1__3 = a__2 /\ adder2____carry__1__2) /\
 (adder2____carry__2__1 = ~(cnt__0 = a__0) /\ ~(cnt__0 = b__0)) /\
 (adder2____carry__2__2 =
  ~(cnt__0 = b__1) /\ adder2____carry__2__1 \/
  ~(a__1 = adder2____carry__1__1) /\
  ~(~(cnt__0 = b__1) = adder2____carry__2__1)) /\
 (adder2____carry__2__3 =
  ~(cnt__0 = b__2) /\ adder2____carry__2__2 \/
  ~(a__2 = adder2____carry__1__2) /\
  ~(~(cnt__0 = b__2) = adder2____carry__2__2)) ==>
 ((out__2 =
   ~(~(a__2 = b__2) = adder1____carry__1__2) /\ cnt__0 \/
   ~(~(a__2 = b__2) = adder1____carry__2__2) /\ ~cnt__0) /\
  (out__1 =
   ~(~(a__1 = b__1) = adder1____carry__1__1) /\ cnt__0 \/
   ~(~(a__1 = b__1) = adder1____carry__2__1) /\ ~cnt__0) /\
  (out__0 = ~(a__0 = b__0) /\ cnt__0 \/ ~(a__0 = b__0) /\ ~cnt__0) =
  (out__2 =
   ~(~(~(a__2 = adder2____carry__1__2) = ~(cnt__0 = b__2)) =
     adder2____carry__2__2)) /\
  (out__1 =
   ~(~(~(a__1 = adder2____carry__1__1) = ~(cnt__0 = b__1)) =
     adder2____carry__2__1)) /\
  (out__0 = ~(~(cnt__0 = a__0) = ~(cnt__0 = b__0))))`;

val mul03_be  = bdd_oracle
 `(p_00_00 = x1 /\ y1) /\
  (p_00_01 = x1 /\ y2) /\
  (p_00_02 = x1 /\ y3) /\
  (p_01_00 = x2 /\ y1) /\
  (p_01_01 = x2 /\ y2) /\
  (p_01_02 = x2 /\ y3) /\
  (p_02_00 = x3 /\ y1) /\
  (p_02_01 = x3 /\ y2) /\
  (p_02_02 = x3 /\ y3) /\
  (s_01_01 = ~(p_01_02 = p_02_01)) /\
  (c_01_01 = p_01_02 /\ p_02_01) /\
  (s_01_02 = ~(p_00_02 = p_02_00)) /\
  (c_01_02 = p_00_02 /\ p_02_00) /\
  (s_02_01 = ~(c_01_01 = ~(s_01_02 = p_01_01))) /\
  (s_02_02 = ~(c_01_02 = ~(p_01_00 = p_00_01))) /\
  (c_02_01 = c_01_01 /\ s_01_02 \/ c_01_01 /\ p_01_01 \/ s_01_02 /\ p_01_01) /\
  (c_02_02 = c_01_02 /\ p_01_00 \/ c_01_02 /\ p_00_01 \/ p_01_00 /\ p_00_01) /\
  (s_03_01 = ~(c_02_01 = s_02_02)) /\
  (c_03_01 = c_02_01 /\ s_02_02) /\
  (s_03_02 = ~(c_02_02 = ~(p_00_00 = c_03_01))) /\
  (c_03_02 = c_02_02 /\ p_00_00 \/ c_02_02 /\ c_03_01 \/ p_00_00 /\ c_03_01) /\
  (z05 = p_02_02) /\
  (z04 = s_01_01) /\
  (z03 = s_02_01) /\
  (z02 = s_03_01) /\
  (z01 = s_03_02) /\
  (z00 = c_03_02) /\
  (p_00_00' = y1 /\ x1) /\
  (p_00_01' = y1 /\ x2) /\
  (p_00_02' = y1 /\ x3) /\
  (p_01_00' = y2 /\ x1) /\
  (p_01_01' = y2 /\ x2) /\
  (p_01_02' = y2 /\ x3) /\
  (p_02_00' = y3 /\ x1) /\
  (p_02_01' = y3 /\ x2) /\
  (p_02_02' = y3 /\ x3) /\
  (s_01_01' = ~(p_01_02' = p_02_01')) /\
  (c_01_01' = p_01_02' /\ p_02_01') /\
  (s_01_02' = ~(p_00_02' = p_02_00')) /\
  (c_01_02' = p_00_02' /\ p_02_00') /\
  (s_02_01' = ~(c_01_01' = ~(s_01_02' = p_01_01'))) /\
  (s_02_02' = ~(c_01_02' = ~(p_01_00' = p_00_01'))) /\
  (c_02_01' =
   c_01_01' /\ s_01_02' \/ c_01_01' /\ p_01_01' \/ s_01_02' /\ p_01_01') /\
  (c_02_02' =
   c_01_02' /\ p_01_00' \/ c_01_02' /\ p_00_01' \/ p_01_00' /\ p_00_01') /\
  (s_03_01' = ~(c_02_01' = s_02_02')) /\
  (c_03_01' = c_02_01' /\ s_02_02') /\
  (s_03_02' = ~(c_02_02' = ~(p_00_00' = c_03_01'))) /\
  (c_03_02' =
   c_02_02' /\ p_00_00' \/ c_02_02' /\ c_03_01' \/ p_00_00' /\ c_03_01')
  ==> (z00 = c_03_02') /\
      (z01 = s_03_02') /\
      (z02 = s_03_01') /\
      (z03 = s_02_01') /\
      (z04 = s_01_01') /\
      (z05 = p_02_02')` ;

val puz030_2 = bdd_oracle
`~((~v8 \/ ~v5 \/ ~v7 \/ ~v9 \/ v6 \/ v2 \/ v3 \/ v0 \/ v1 \/ v4) /\
  (v0 \/ v1 \/ v8) /\
  (v7 \/ v4 \/ v2) /\
  (v5 \/ v8 \/ v0) /\
  (v6 \/ v9 \/ v1) /\
  (v7 \/ v4 \/ v1) /\
  (v2 \/ v3 \/ v9) /\
  (v7 \/ v4 \/ v9) /\
  (~v5 \/ ~v3 \/ ~v2 \/ v6 \/ v9) /\
  (~v5 \/ ~v3 \/ ~v2 \/ ~v9 \/ ~v6) /\
  (~v6 \/ ~v1 \/ ~v0 \/ v5 \/ v8) /\
  (~v6 \/ ~v8 \/ ~v5 \/ v0 \/ v1) /\
  (~v6 \/ ~v8 \/ ~v5 \/ ~v1 \/ ~v0) /\
  (~v4 \/ v2 \/ v3 \/ v0 \/ v1) /\
  (~v4 \/ ~v3 \/ ~v2 \/ ~v1 \/ ~v0) /\
  (~v2 \/ ~v7 \/ v5 \/ v8) /\
  (~v2 \/ ~v4 \/ v5 \/ v8) /\
  (~v2 \/ ~v8 \/ ~v5 \/ ~v7) /\
  (~v2 \/ ~v8 \/ ~v5 \/ ~v4) /\
  (~v2 \/ v3 \/ v5) /\
  (~v3 \/ v2 \/ v5) /\
  (~v6 \/ v9 \/ v5) /\
  (~v9 \/ v6 \/ v5) /\
  (~v7 \/ ~v4 \/ v8) /\
  (~v5 \/ v8 \/ v2) /\
  (~v8 \/ v5 \/ v2) /\
  (~v0 \/ ~v1 \/ v3) /\
  (~v6 \/ ~v9 \/ v3) /\
  (~v2 \/ ~v3 \/ v0) /\
  (~v5 \/ v8 \/ v6) /\
  (~v8 \/ v5 \/ v6) /\
  (~v0 \/ v1 \/ v6) /\
  (~v1 \/ v0 \/ v6) /\
  (~v5 \/ ~v8 \/ v7) /\
  (~v6 \/ ~v9 \/ v7) /\
  (~v2 \/ v3 \/ v4) /\
  (~v3 \/ v2 \/ v4) /\
  (~v0 \/ v1 \/ v4) /\
  (~v1 \/ v0 \/ v4) /\
  (~v8 \/ ~v0 \/ v7) /\
  (~v8 \/ ~v0 \/ v4) /\
  (~v8 \/ ~v1 \/ v7) /\
  (~v8 \/ ~v1 \/ v4) /\
  (~v3 \/ v0 \/ v6) /\
  (~v3 \/ v0 \/ v9) /\
  (~v3 \/ v1 \/ v6) /\
  (~v3 \/ v1 \/ v9) /\
  (~v0 \/ ~v5 \/ v2) /\
  (~v0 \/ ~v5 \/ v3) /\
  (~v0 \/ ~v8 \/ v2) /\
  (~v0 \/ ~v8 \/ v3) /\
  (~v1 \/ ~v6 \/ ~v7) /\
  (~v1 \/ ~v6 \/ ~v4) /\
  (~v1 \/ ~v9 \/ ~v7) /\
  (~v1 \/ ~v9 \/ ~v4) /\
  (~v9 \/ ~v2 \/ ~v7) /\
  (~v9 \/ ~v2 \/ ~v4) /\
  (~v9 \/ ~v3 \/ ~v7) /\
  (~v9 \/ ~v3 \/ ~v4) /\
  (~v7 \/ v5 \/ v6) /\
  (~v7 \/ v5 \/ v9) /\
  (~v7 \/ v8 \/ v6) /\
  (~v7 \/ v8 \/ v9))` ;

val puz030_1 = bdd_oracle
`~((~v21 \/ v2) /\
  (~v14 \/ v10) /\
  (~v15 \/ v6) /\
  (~v12 \/ v16) /\
  (~v3 \/ v22) /\
  (~v21 \/ v1) /\
  (~v14 \/ v8) /\
  (~v15 \/ v4) /\
  (~v12 \/ v13) /\
  (~v3 \/ v19) /\
  (~v2 \/ ~v1 \/ v21) /\
  (~v10 \/ ~v8 \/ v14) /\
  (~v6 \/ ~v4 \/ v15) /\
  (~v16 \/ ~v13 \/ v12) /\
  (~v22 \/ ~v19 \/ v3) /\
  (~v0 \/ v2 \/ v1) /\
  (~v7 \/ v10 \/ v8) /\
  (~v24 \/ v6 \/ v4) /\
  (~v23 \/ v16 \/ v13) /\
  (~v17 \/ v22 \/ v19) /\
  (~v0 \/ ~v21) /\
  (~v7 \/ ~v14) /\
  (~v24 \/ ~v15) /\
  (~v23 \/ ~v12) /\
  (~v17 \/ ~v3) /\
  (~v0 \/ ~v18) /\
  (~v7 \/ ~v20) /\
  (~v24 \/ ~v9) /\
  (~v23 \/ ~v5) /\
  (~v17 \/ ~v11) /\
  (v21 \/ v18 \/ v0) /\
  (v14 \/ v20 \/ v7) /\
  (v15 \/ v9 \/ v24) /\
  (v12 \/ v5 \/ v23) /\
  (v3 \/ v11 \/ v17) /\
  (~v0 \/ ~v2 \/ ~v1) /\
  (~v7 \/ ~v10 \/ ~v8) /\
  (~v24 \/ ~v6 \/ ~v4) /\
  (~v23 \/ ~v16 \/ ~v13) /\
  (~v17 \/ ~v22 \/ ~v19) /\
  (~v21 \/ ~v18) /\
  (~v14 \/ ~v20) /\
  (~v15 \/ ~v9) /\
  (~v12 \/ ~v5) /\
  (~v3 \/ ~v11) /\
  (~v18 \/ ~v2) /\
  (~v20 \/ ~v10) /\
  (~v9 \/ ~v6) /\
  (~v5 \/ ~v16) /\
  (~v11 \/ ~v22) /\
  (~v18 \/ ~v1) /\
  (~v20 \/ ~v8) /\
  (~v9 \/ ~v4) /\
  (~v5 \/ ~v13) /\
  (~v11 \/ ~v19) /\
  (v2 \/ v1 \/ v18) /\
  (v10 \/ v8 \/ v20) /\
  (v6 \/ v4 \/ v9) /\
  (v16 \/ v13 \/ v5) /\
  (v22 \/ v19 \/ v11) /\
  (~v5 \/ ~v20 \/ ~v3 \/ ~v24 \/ ~v2 \/ ~v4 \/ ~v0) /\
  (~v7 \/ v1) /\
  (~v23 \/ v1) /\
  (~v1 \/ v23 \/ v7) /\
  (~v15 \/ v1) /\
  (~v3 \/ v2) /\
  (~v2 \/ v3 \/ v15) /\
  (~v18 \/ v4) /\
  (~v5 \/ v4) /\
  (~v4 \/ v5 \/ v18) /\
  (~v7 \/ v6) /\
  (~v17 \/ v6) /\
  (~v6 \/ v17 \/ v7) /\
  (~v18 \/ v8) /\
  (~v9 \/ v8) /\
  (~v8 \/ v9 \/ v18) /\
  (~v12 \/ v10) /\
  (~v11 \/ v10) /\
  (~v10 \/ v11 \/ v12) /\
  (~v15 \/ v13) /\
  (~v14 \/ v13) /\
  (~v13 \/ v14 \/ v15) /\
  (~v18 \/ v16) /\
  (~v17 \/ v16) /\
  (~v16 \/ v17 \/ v18) /\
  (~v21 \/ v19) /\
  (~v20 \/ v19) /\
  (~v19 \/ v20 \/ v21) /\
  (~v24 \/ v22) /\
  (~v23 \/ v22) /\
  (~v22 \/ v23 \/ v24))` ;


val dk27_be  = bdd_oracle
 `(ge2 = ~in4 /\ ~in3 /\ ~in2 /\ ~in0) /\
  (ge7 = ge2 /\ ~in1) /\
  (ge0 = ~in6 /\ ~in5 /\ ~in1 /\ ~in0) /\
  (ge4 = in8 /\ ~in7 /\ ~in5) /\
  (ge11 = ge7 /\ in6) /\
  (ge20 = ~in3 /\ ~in2 /\ ~in1 /\ in0) /\
  (ge21 = ~in6 /\ ~in4) /\
  (ge1 = ~in8 /\ in7 \/ in8 /\ ~in7) /\
  (ge8 = ge0 /\ ~in3) /\
  (ge9 = ge0 /\ ~in4 /\ in3 /\ ~in2) /\
  (ge10 = in8 /\ ~in7) /\
  (ge16 = ge11 /\ ge4) /\
  (ge5 = ge21 /\ ge20) /\
  (ge6 = ~in8 /\ in7 /\ ~in5) /\
  (ge14 = ge8 /\ ge1) /\
  (ge19 = ge10 /\ ge9 \/ ge16) /\
  (ge12 = ge7 /\ ~in6 /\ in5) /\
  (ge13 = ge2 /\ ~in6 /\ in1) /\
  (ge17 = ~in8 /\ in7) /\
  (ge18 = ge16 \/ ge6 /\ ge5) /\
  (ge15 = ge8 /\ in4 /\ ~in2 \/ ge8 /\ ~in4 /\ in2) /\
  (out0 = ge17 /\ ge15) /\
  (out1 = ge15 /\ ge10) /\
  (out2 = ge9 /\ ge1 \/ ge18) /\
  (out3 = ge5 /\ ge4) /\
  (out4 = ge11 /\ ge6 \/ ge13 /\ ge6 \/ ge17 /\ ge12) /\
  (out5 = ge13 /\ ge4) /\
  (out6 = ge12 /\ ge10) /\
  (out7 = ge14 /\ in4 /\ ~in2 \/ ge19) /\
  (out8 = ge14 /\ ~in4 /\ in2) /\
  (wres2 = ~in4 /\ ~in3 /\ ~in2 /\ ~in0) /\
  (wres0 = ~in6 /\ ~in5 /\ ~in1 /\ ~in0) /\
  (wres7 = wres2 /\ ~in1) /\
  (wres1 = ~in8 /\ in7 \/ in8 /\ ~in7) /\
  (wres8 = wres0 /\ ~in3) /\
  (wres4 = in8 /\ ~in7 /\ ~in5) /\
  (wres11 = wres7 /\ in6) /\
  (wres14 = wres8 /\ wres1) /\
  (wres9 = wres0 /\ ~in4 /\ in3 /\ ~in2) /\
  (wres10 = in8 /\ ~in7) /\
  (wres16 = wres11 /\ wres4) /\
  (wres12 = wres7 /\ ~in6 /\ in5) /\
  (wres13 = wres2 /\ ~in6 /\ in1) /\
  (wres6 = ~in8 /\ in7 /\ ~in5) /\
  (wres17 = ~in8 /\ in7) /\
  (wres5 = ~in6 /\ ~in4 /\ ~in3 /\ ~in2 /\ ~in1 /\ in0) /\
  (wres15 = wres8 /\ in4 /\ ~in2 \/ wres8 /\ ~in4 /\ in2)
  ==> (out8 = wres14 /\ ~in4 /\ in2) /\
      (out7 = wres10 /\ wres9 \/ wres14 /\ in4 /\ ~in2 \/ wres16) /\
      (out6 = wres12 /\ wres10) /\
      (out5 = wres13 /\ wres4) /\
      (out4 = wres11 /\ wres6 \/ wres13 /\ wres6 \/ wres17 /\ wres12) /\
      (out3 = wres5 /\ wres4) /\
      (out2 = wres9 /\ wres1 \/ wres6 /\ wres5 \/ wres16) /\
      (out1 = wres15 /\ wres10) /\
      (out0 = wres17 /\ wres15)` ;

val syn071_1 = bdd_oracle
`~(v8 /\
  v3 /\
  v1 /\
  v0 /\
  (~v9 \/ v11) /\
  (~v5 \/ v12) /\
  (~v2 \/ v14) /\
  (~v0 \/ v0) /\
  (~v7 \/ v13) /\
  (~v4 \/ v10) /\
  (~v1 \/ v1) /\
  (~v14 \/ v2) /\
  (~v6 \/ v15) /\
  (~v3 \/ v3) /\
  (~v10 \/ v4) /\
  (~v12 \/ v5) /\
  (~v8 \/ v8) /\
  (~v15 \/ v6) /\
  (~v13 \/ v7) /\
  (~v11 \/ v9) /\
  (~v0 \/ ~v11 \/ v11) /\
  (~v0 \/ ~v12 \/ v12) /\
  (~v0 \/ ~v14 \/ v14) /\
  (~v0 \/ ~v0 \/ v0) /\
  (~v2 \/ ~v11 \/ v13) /\
  (~v2 \/ ~v12 \/ v10) /\
  (~v2 \/ ~v14 \/ v1) /\
  (~v2 \/ ~v0 \/ v2) /\
  (~v5 \/ ~v11 \/ v15) /\
  (~v5 \/ ~v12 \/ v3) /\
  (~v5 \/ ~v14 \/ v4) /\
  (~v5 \/ ~v0 \/ v5) /\
  (~v9 \/ ~v11 \/ v8) /\
  (~v9 \/ ~v12 \/ v6) /\
  (~v9 \/ ~v14 \/ v7) /\
  (~v9 \/ ~v0 \/ v9) /\
  (~v14 \/ ~v13 \/ v11) /\
  (~v14 \/ ~v10 \/ v12) /\
  (~v14 \/ ~v1 \/ v14) /\
  (~v14 \/ ~v2 \/ v0) /\
  (~v1 \/ ~v13 \/ v13) /\
  (~v1 \/ ~v10 \/ v10) /\
  (~v1 \/ ~v1 \/ v1) /\
  (~v1 \/ ~v2 \/ v2) /\
  (~v4 \/ ~v13 \/ v15) /\
  (~v4 \/ ~v10 \/ v3) /\
  (~v4 \/ ~v1 \/ v4) /\
  (~v4 \/ ~v2 \/ v5) /\
  (~v7 \/ ~v13 \/ v8) /\
  (~v7 \/ ~v10 \/ v6) /\
  (~v7 \/ ~v1 \/ v7) /\
  (~v7 \/ ~v2 \/ v9) /\
  (~v12 \/ ~v15 \/ v11) /\
  (~v12 \/ ~v3 \/ v12) /\
  (~v12 \/ ~v4 \/ v14) /\
  (~v12 \/ ~v5 \/ v0) /\
  (~v10 \/ ~v15 \/ v13) /\
  (~v10 \/ ~v3 \/ v10) /\
  (~v10 \/ ~v4 \/ v1) /\
  (~v10 \/ ~v5 \/ v2) /\
  (~v3 \/ ~v15 \/ v15) /\
  (~v3 \/ ~v3 \/ v3) /\
  (~v3 \/ ~v4 \/ v4) /\
  (~v3 \/ ~v5 \/ v5) /\
  (~v6 \/ ~v15 \/ v8) /\
  (~v6 \/ ~v3 \/ v6) /\
  (~v6 \/ ~v4 \/ v7) /\
  (~v6 \/ ~v5 \/ v9) /\
  (~v11 \/ ~v8 \/ v11) /\
  (~v11 \/ ~v6 \/ v12) /\
  (~v11 \/ ~v7 \/ v14) /\
  (~v11 \/ ~v9 \/ v0) /\
  (~v13 \/ ~v8 \/ v13) /\
  (~v13 \/ ~v6 \/ v10) /\
  (~v13 \/ ~v7 \/ v1) /\
  (~v13 \/ ~v9 \/ v2) /\
  (~v15 \/ ~v8 \/ v15) /\
  (~v15 \/ ~v6 \/ v3) /\
  (~v15 \/ ~v7 \/ v4) /\
  (~v15 \/ ~v9 \/ v5) /\
  (~v8 \/ ~v8 \/ v8) /\
  (~v8 \/ ~v6 \/ v6) /\
  (~v8 \/ ~v7 \/ v7) /\
  (~v8 \/ ~v9 \/ v9) /\
  ~v10 /\
  ~v11 /\
  (v12 \/ v13) /\
  (v14 \/ v15))` ;

(* Hard : takes buddy17 73 secs. on sole *)
val aim_50_1_6_no_3 = bdd_oracle
`~
((v15 \/ v20 \/ v41) /\
 (~v15 \/ v20 \/ v41) /\
 (v7 \/ v8 \/ ~v41) /\
 (v7 \/ ~v8 \/ ~v41) /\
 (~v7 \/ v42 \/ v50) /\
 (~v7 \/ ~v42 \/ v50) /\
 (v22 \/ v35 \/ ~v50) /\
 (v22 \/ ~v35 \/ v45) /\
 (v18 \/ ~v22 \/ v45) /\
 (~v18 \/ ~v22 \/ v45) /\
 (v33 \/ ~v45 \/ ~v50) /\
 (~v7 \/ ~v33 \/ ~v50) /\
 (v19 \/ ~v20 \/ v21) /\
 (~v20 \/ v21 \/ ~v41) /\
 (v19 \/ ~v20 \/ ~v21) /\
 (v1 \/ v14 \/ v36) /\
 (~v1 \/ v14 \/ v36) /\
 (v13 \/ ~v14 \/ v36) /\
 (v3 \/ v13 \/ ~v36) /\
 (~v3 \/ v5 \/ ~v36) /\
 (~v3 \/ ~v5 \/ v13) /\
 (v4 \/ v44 \/ v49) /\
 (~v4 \/ v17 \/ v49) /\
 (~v4 \/ ~v17 \/ v44) /\
 (~v13 \/ v31 \/ ~v44) /\
 (~v13 \/ ~v31 \/ ~v44) /\
 (v23 \/ v33 \/ ~v49) /\
 (v23 \/ ~v33 \/ ~v49) /\
 (~v19 \/ v37 \/ v42) /\
 (~v19 \/ v37 \/ ~v42) /\
 (~v23 \/ v29 \/ ~v37) /\
 (~v23 \/ ~v29 \/ ~v37) /\
 (~v24 \/ ~v26 \/ v32) /\
 (v2 \/ ~v12 \/ ~v31) /\
 (v17 \/ v28 \/ v40) /\
 (~v15 \/ ~v17 \/ v40) /\
 (v2 \/ v28 \/ v47) /\
 (v26 \/ ~v28 \/ ~v39) /\
 (v21 \/ ~v26 \/ ~v28) /\
 (v16 \/ v24 \/ v29) /\
 (v12 \/ ~v34 \/ ~v39) /\
 (v10 \/ v31 \/ v40) /\
 (~v6 \/ ~v32 \/ v35) /\
 (v16 \/ ~v24 \/ v34) /\
 (~v24 \/ ~v31 \/ v38) /\
 (~v16 \/ ~v24 \/ ~v38) /\
 (~v2 \/ ~v10 \/ ~v47) /\
 (v4 \/ ~v16 \/ v27) /\
 (~v1 \/ v24 \/ ~v30) /\
 (~v18 \/ v26 \/ ~v46) /\
 (v27 \/ v30 \/ ~v45) /\
 (v4 \/ ~v14 \/ ~v44) /\
 (~v29 \/ v43 \/ v47) /\
 (~v8 \/ ~v10 \/ ~v46) /\
 (~v11 \/ v39 \/ ~v43) /\
 (~v11 \/ ~v40 \/ ~v43) /\
 (v6 \/ ~v21 \/ v26) /\
 (v8 \/ ~v25 \/ v46) /\
 (~v25 \/ ~v38 \/ v46) /\
 (v10 \/ ~v46 \/ ~v47) /\
 (v25 \/ ~v32 \/ ~v40) /\
 (v5 \/ v6 \/ ~v40) /\
 (v11 \/ v15 \/ v16) /\
 (v12 \/ v39 \/ v43) /\
 (v5 \/ v11 \/ v32) /\
 (~v5 \/ v17 \/ v32) /\
 (~v12 \/ ~v40 \/ ~v48) /\
 (~v2 \/ v18 \/ ~v30) /\
 (v3 \/ v10 \/ ~v34) /\
 (~v2 \/ ~v9 \/ v30) /\
 (~v3 \/ ~v5 \/ ~v28) /\
 (~v9 \/ v26 \/ v48) /\
 (v22 \/ ~v27 \/ ~v48) /\
 (v1 \/ v9 \/ v38) /\
 (v3 \/ ~v6 \/ v48) /\
 (v1 \/ ~v6 \/ v34) /\
 (v15 \/ ~v35 \/ v48) /\
 (v15 \/ v26 \/ ~v27) /\
 (~v9 \/ ~v9 \/ ~v27) /\
 (v1 \/ v9 \/ v25))` ;

(* Harder: runtime: 526.970s,    gctime: 21.640s,     systime: 0.650s. *)

val aim_50_1_6_no_4 = bdd_oracle
`~
((v1 \/ v32 \/ v34) /\
 (v4 \/ v5 \/ v32) /\
 (~v4 \/ v5 \/ ~v34) /\
 (~v5 \/ v32 \/ ~v34) /\
 (v29 \/ ~v32 \/ v43) /\
 (v29 \/ v36 \/ ~v43) /\
 (v29 \/ ~v32 \/ ~v36) /\
 (v1 \/ v3 \/ ~v29) /\
 (~v3 \/ ~v29 \/ ~v32) /\
 (~v1 \/ v24 \/ v39) /\
 (~v1 \/ v24 \/ ~v39) /\
 (v7 \/ v18 \/ ~v24) /\
 (~v7 \/ v18 \/ v28) /\
 (~v7 \/ ~v21 \/ v28) /\
 (~v7 \/ v17 \/ ~v28) /\
 (v18 \/ ~v24 \/ ~v28) /\
 (v2 \/ v17 \/ v40) /\
 (~v17 \/ ~v18 \/ v40) /\
 (v2 \/ v39 \/ ~v40) /\
 (v2 \/ ~v39 \/ ~v40) /\
 (~v2 \/ ~v18 \/ v35) /\
 (~v2 \/ ~v18 \/ ~v35) /\
 (v9 \/ ~v32 \/ v41) /\
 (~v9 \/ v41 \/ v45) /\
 (~v1 \/ ~v9 \/ ~v45) /\
 (~v5 \/ v27 \/ v43) /\
 (v14 \/ v16 \/ v26) /\
 (v14 \/ ~v16 \/ v49) /\
 (v12 \/ ~v14 \/ v26) /\
 (~v12 \/ v26 \/ v35) /\
 (v26 \/ v30 \/ ~v35) /\
 (~v26 \/ v30 \/ v49) /\
 (v9 \/ v13 \/ v25) /\
 (v5 \/ ~v17 \/ v25) /\
 (v15 \/ v30 \/ v47) /\
 (~v20 \/ v27 \/ ~v49) /\
 (v13 \/ ~v20 \/ ~v27) /\
 (~v13 \/ ~v30 \/ ~v49) /\
 (v3 \/ v8 \/ v37) /\
 (v8 \/ v23 \/ ~v43) /\
 (v10 \/ v19 \/ v22) /\
 (v10 \/ ~v19 \/ v22) /\
 (~v10 \/ ~v19 \/ v36) /\
 (v4 \/ v21 \/ v38) /\
 (~v4 \/ v38 \/ v46) /\
 (v21 \/ ~v38 \/ ~v47) /\
 (~v21 \/ v45 \/ v46) /\
 (~v14 \/ ~v33 \/ ~v38) /\
 (~v10 \/ v11 \/ ~v26) /\
 (~v14 \/ v16 \/ ~v50) /\
 (~v14 \/ ~v16 \/ ~v23) /\
 (~v2 \/ ~v23 \/ ~v50) /\
 (v12 \/ ~v47 \/ v50) /\
 (v7 \/ v10 \/ v48) /\
 (~v6 \/ ~v13 \/ ~v41) /\
 (v11 \/ ~v41 \/ ~v48) /\
 (v23 \/ ~v41 \/ ~v48) /\
 (~v15 \/ v42 \/ v48) /\
 (~v15 \/ ~v21 \/ ~v42) /\
 (v11 \/ v34 \/ v44) /\
 (~v27 \/ ~v34 \/ ~v46) /\
 (v19 \/ v28 \/ v50) /\
 (~v3 \/ v6 \/ ~v35) /\
 (~v22 \/ ~v40 \/ ~v44) /\
 (~v25 \/ ~v37 \/ ~v42) /\
 (~v26 \/ ~v30 \/ ~v37) /\
 (v6 \/ ~v31 \/ v42) /\
 (v6 \/ ~v31 \/ ~v33) /\
 (~v44 \/ ~v45 \/ v47) /\
 (v4 \/ v20 \/ v47) /\
 (~v6 \/ v44 \/ ~v46) /\
 (~v11 \/ v12 \/ v20) /\
 (~v8 \/ v10 \/ v28) /\
 (~v22 \/ v31 \/ ~v36) /\
 (v7 \/ ~v25 \/ v37) /\
 (~v11 \/ v31 \/ v47) /\
 (~v4 \/ v10 \/ ~v12) /\
 (~v30 \/ ~v31 \/ v44) /\
 (v7 \/ v15 \/ v33) /\
 (~v8 \/ ~v11 \/ v33))` ;

val hostint1_be  = bdd_oracle
 `(wnpls =
   ~eos /\ ~s1 /\ ~s2 \/
   eof /\ eos /\ s1 /\ ~s2 \/
   eof /\ eos /\ ~mof /\ s1 /\ s2 \/
   eos /\ ~s1 /\ s2 \/
   ~eos /\ s1 /\ s2 \/
   eof /\ eos /\ mof /\ s1 /\ s2 \/
   ~eof /\ eos /\ ~mof /\ s1 /\ s2) /\
  (rnp =
   ~eos /\ s1 /\ ~s2 \/
   ~eof /\ eos /\ s1 /\ ~s2 \/
   ~eof /\ eos /\ mof /\ s1 /\ s2) /\
  (wnp =
   eos /\ ~s1 /\ s2 \/
   ~eos /\ s1 /\ s2 \/
   eof /\ eos /\ mof /\ s1 /\ s2 \/
   ~eof /\ eos /\ ~mof /\ s1 /\ s2) /\
  (fs = ~eos /\ ~s1 /\ s2 \/ eos /\ ~s1 /\ ~s2) /\
  (ls =
   ~eos /\ ~s1 /\ ~s2 \/
   eof /\ eos /\ s1 /\ ~s2 \/
   eof /\ eos /\ ~mof /\ s1 /\ s2) /\
  (s1 =
   ~eof /\ eos /\ mof /\ s1 /\ s2 \/
   ~eos /\ s1 /\ ~s2 \/
   ~eof /\ eos /\ s1 /\ ~s2 \/
   ~eos /\ s1 /\ s2 \/
   eof /\ eos /\ mof /\ s1 /\ s2 \/
   ~eof /\ eos /\ ~mof /\ s1 /\ s2 \/
   eos /\ ~s1 /\ s2) /\
  (s2 =
   ~eos /\ s1 /\ s2 \/
   eof /\ eos /\ mof /\ s1 /\ s2 \/
   ~eof /\ eos /\ ~mof /\ s1 /\ s2 \/
   eos /\ ~s1 /\ s2 \/
   ~eos /\ ~s1 /\ s2 \/
   eos /\ ~s1 /\ ~s2)
  ==> (s2 =
       eof /\ mof /\ s1 /\ s2 \/
       ~eof /\ ~mof /\ s1 /\ s2 \/
       ~eos /\ s1 /\ s2 \/
       eos /\ ~s1 /\ s2 \/
       ~eos /\ ~s1 /\ s2 \/
       eos /\ ~s1 /\ ~s2) /\
      (s1 =
       eof /\ mof /\ s1 /\ s2 \/
       ~eof /\ eos /\ mof /\ s1 \/
       ~eof /\ ~mof /\ s1 /\ s2 \/
       ~eos /\ s1 /\ s2 \/
       eos /\ ~s1 /\ s2 \/
       ~eof /\ s1 /\ ~s2 \/
       ~eos /\ s1 /\ ~s2) /\
      (ls =
       eof /\ eos /\ ~mof /\ s1 \/
       eof /\ eos /\ s1 /\ ~s2 \/
       ~eos /\ ~s1 /\ ~s2) /\
      (fs = ~eos /\ ~s1 /\ s2 \/ eos /\ ~s1 /\ ~s2) /\
      (wnp =
       eof /\ mof /\ s1 /\ s2 \/
       ~eof /\ ~mof /\ s1 /\ s2 \/
       ~eos /\ s1 /\ s2 \/
       eos /\ ~s1 /\ s2) /\
      (rnp =
       ~eof /\ eos /\ mof /\ s1 \/ ~eof /\ s1 /\ ~s2 \/ ~eos /\ s1 /\ ~s2) /\
      (wnpls =
       eof /\ mof /\ s1 /\ s2 \/
       eof /\ eos /\ ~mof /\ s1 \/
       ~eof /\ ~mof /\ s1 /\ s2 \/
       ~eos /\ s1 /\ s2 \/
       eos /\ ~s1 /\ s2 \/
       eof /\ eos /\ s1 /\ ~s2 \/
       ~eos /\ ~s1 /\ ~s2)` ;

(* Hard : runtime: 73.140s,    gctime: 0.640s,     systime: 0.020s. *)
val aim_50_2_0_no_4 = bdd_oracle
`~
((v2 \/ v26 \/ v32) /\
 (v2 \/ ~v21 \/ v32) /\
 (v2 \/ v3 \/ ~v26) /\
 (~v2 \/ v22 \/ v44) /\
 (~v2 \/ ~v22 \/ v44) /\
 (~v2 \/ v23 \/ ~v44) /\
 (v3 \/ ~v23 \/ v41) /\
 (v3 \/ ~v41 \/ ~v44) /\
 (~v3 \/ v9 \/ v20) /\
 (~v3 \/ ~v20 \/ v32) /\
 (v7 \/ v9 \/ ~v32) /\
 (~v7 \/ v16 \/ ~v32) /\
 (v9 \/ ~v16 \/ ~v32) /\
 (v1 \/ v16 \/ v37) /\
 (~v1 \/ v16 \/ v26) /\
 (~v16 \/ v26 \/ v37) /\
 (~v9 \/ ~v26 \/ v37) /\
 (v5 \/ ~v9 \/ v46) /\
 (v11 \/ v21 \/ ~v46) /\
 (v5 \/ v21 \/ ~v46) /\
 (~v5 \/ v21 \/ v39) /\
 (~v5 \/ ~v37 \/ ~v39) /\
 (~v9 \/ ~v21 \/ ~v37) /\
 (v10 \/ ~v19 \/ ~v48) /\
 (v10 \/ ~v13 \/ ~v19) /\
 (v5 \/ ~v36 \/ v47) /\
 (~v5 \/ ~v36 \/ v47) /\
 (~v16 \/ v42 \/ ~v43) /\
 (~v1 \/ v13 \/ ~v39) /\
 (v8 \/ ~v27 \/ v30) /\
 (v13 \/ v18 \/ ~v30) /\
 (v8 \/ v13 \/ ~v18) /\
 (~v13 \/ v15 \/ ~v17) /\
 (~v13 \/ ~v15 \/ ~v30) /\
 (~v17 \/ ~v27 \/ ~v45) /\
 (~v12 \/ ~v27 \/ ~v45) /\
 (~v18 \/ v25 \/ v40) /\
 (~v18 \/ v34 \/ ~v40) /\
 (v25 \/ ~v34 \/ v48) /\
 (~v19 \/ ~v25 \/ v48) /\
 (~v1 \/ ~v12 \/ ~v34) /\
 (v20 \/ ~v25 \/ ~v43) /\
 (v8 \/ v19 \/ ~v45) /\
 (v17 \/ v29 \/ v34) /\
 (~v17 \/ v29 \/ v41) /\
 (v15 \/ ~v31 \/ ~v35) /\
 (~v15 \/ ~v31 \/ ~v35) /\
 (v34 \/ v39 \/ ~v43) /\
 (~v11 \/ ~v14 \/ v45) /\
 (~v11 \/ ~v12 \/ ~v14) /\
 (~v24 \/ v28 \/ ~v39) /\
 (~v8 \/ ~v24 \/ ~v30) /\
 (v7 \/ ~v25 \/ v45) /\
 (~v7 \/ ~v44 \/ v45) /\
 (~v20 \/ v36 \/ v50) /\
 (~v8 \/ v36 \/ v50) /\
 (~v8 \/ ~v20 \/ ~v50) /\
 (v20 \/ ~v41 \/ v44) /\
 (v28 \/ ~v33 \/ v39) /\
 (v28 \/ ~v33 \/ v47) /\
 (v10 \/ v27 \/ v38) /\
 (~v10 \/ v27 \/ v30) /\
 (v4 \/ ~v10 \/ v38) /\
 (~v6 \/ ~v35 \/ v41) /\
 (v12 \/ v18 \/ v22) /\
 (v17 \/ v22 \/ v30) /\
 (v12 \/ v29 \/ v42) /\
 (~v4 \/ v23 \/ v31) /\
 (v1 \/ ~v4 \/ ~v31) /\
 (~v4 \/ ~v6 \/ ~v22) /\
 (~v22 \/ v40 \/ v50) /\
 (v4 \/ ~v33 \/ v43) /\
 (~v6 \/ ~v21 \/ v42) /\
 (v7 \/ ~v24 \/ ~v47) /\
 (~v3 \/ v31 \/ ~v46) /\
 (v4 \/ v12 \/ ~v36) /\
 (~v11 \/ ~v29 \/ v36) /\
 (~v14 \/ ~v23 \/ ~v48) /\
 (~v23 \/ ~v37 \/ ~v48) /\
 (v15 \/ ~v42 \/ v43) /\
 (~v7 \/ v24 \/ ~v50) /\
 (~v10 \/ v33 \/ v46) /\
 (v40 \/ ~v42 \/ v46) /\
 (v14 \/ v24 \/ ~v49) /\
 (v11 \/ v17 \/ ~v38) /\
 (v19 \/ ~v28 \/ ~v47) /\
 (v14 \/ v24 \/ v27) /\
 (v6 \/ ~v15 \/ v43) /\
 (v11 \/ v18 \/ ~v41) /\
 (v1 \/ v6 \/ v49) /\
 (~v29 \/ ~v47 \/ ~v50) /\
 (v25 \/ ~v34 \/ ~v38) /\
 (v6 \/ v31 \/ ~v49) /\
 (v33 \/ v35 \/ v35) /\
 (v33 \/ v35 \/ v48) /\
 (v49 \/ v49 \/ ~v49) /\
 (v23 \/ ~v29 \/ ~v40) /\
 (v19 \/ ~v26 \/ ~v42) /\
 (v14 \/ v38 \/ ~v38) /\
 (~v28 \/ ~v28 \/ ~v40))` ;

(* Hard runtime: 170.440s,    gctime: 1.940s,     systime: 0.050s. *)
val aim_50_2_0_no_1 = bdd_oracle
`~
((v7 \/ v11 \/ v19) /\
 (v7 \/ ~v11 \/ v27) /\
 (v7 \/ v16 \/ ~v27) /\
 (~v11 \/ v25 \/ v48) /\
 (~v16 \/ v17 \/ ~v48) /\
 (~v17 \/ v25 \/ ~v48) /\
 (~v16 \/ ~v25 \/ ~v27) /\
 (v19 \/ v36 \/ v49) /\
 (~v7 \/ ~v36 \/ v49) /\
 (~v7 \/ v19 \/ ~v49) /\
 (v4 \/ v12 \/ v44) /\
 (v4 \/ ~v12 \/ v44) /\
 (v1 \/ ~v44 \/ v47) /\
 (~v1 \/ v4 \/ v47) /\
 (v20 \/ v34 \/ v48) /\
 (~v19 \/ v20 \/ v34) /\
 (v24 \/ ~v34 \/ ~v44) /\
 (~v24 \/ ~v34 \/ ~v44) /\
 (~v24 \/ ~v32 \/ v41) /\
 (~v34 \/ ~v41 \/ ~v47) /\
 (~v4 \/ ~v19 \/ v20) /\
 (v30 \/ v39 \/ v41) /\
 (~v30 \/ v39 \/ v50) /\
 (~v20 \/ ~v30 \/ ~v50) /\
 (~v20 \/ ~v39 \/ v41) /\
 (~v19 \/ v32 \/ ~v41) /\
 (~v20 \/ ~v32 \/ ~v41) /\
 (v1 \/ v18 \/ ~v35) /\
 (~v14 \/ v18 \/ ~v35) /\
 (~v14 \/ ~v18 \/ v27) /\
 (~v1 \/ v25 \/ ~v46) /\
 (~v4 \/ v16 \/ ~v47) /\
 (v11 \/ v16 \/ ~v25) /\
 (~v4 \/ v11 \/ ~v25) /\
 (~v27 \/ ~v35 \/ ~v47) /\
 (v15 \/ v31 \/ v40) /\
 (v10 \/ v39 \/ ~v49) /\
 (~v8 \/ ~v10 \/ v21) /\
 (~v21 \/ ~v26 \/ v30) /\
 (v6 \/ ~v11 \/ v29) /\
 (v6 \/ v31 \/ v50) /\
 (v45 \/ v49 \/ ~v50) /\
 (v31 \/ ~v45 \/ ~v50) /\
 (v21 \/ v30 \/ v33) /\
 (v2 \/ v37 \/ ~v49) /\
 (~v2 \/ v17 \/ v37) /\
 (~v8 \/ v14 \/ v32) /\
 (~v14 \/ ~v15 \/ v32) /\
 (~v1 \/ v37 \/ v47) /\
 (v6 \/ ~v38 \/ v45) /\
 (~v21 \/ ~v38 \/ v45) /\
 (~v13 \/ ~v18 \/ ~v42) /\
 (v2 \/ ~v6 \/ v22) /\
 (~v2 \/ ~v6 \/ v22) /\
 (v9 \/ ~v28 \/ ~v36) /\
 (v8 \/ v29 \/ ~v39) /\
 (~v8 \/ ~v38 \/ ~v39) /\
 (~v12 \/ v17 \/ v38) /\
 (v1 \/ ~v15 \/ ~v26) /\
 (~v7 \/ ~v15 \/ ~v26) /\
 (~v9 \/ v36 \/ v42) /\
 (v12 \/ ~v16 \/ v21) /\
 (~v10 \/ ~v23 \/ ~v46) /\
 (~v9 \/ ~v29 \/ v34) /\
 (~v9 \/ ~v21 \/ v42) /\
 (~v12 \/ ~v23 \/ v38) /\
 (~v30 \/ v38 \/ v40) /\
 (v18 \/ v23 \/ v33) /\
 (~v6 \/ v15 \/ v33) /\
 (v9 \/ v27 \/ ~v43) /\
 (v22 \/ v40 \/ ~v48) /\
 (v8 \/ ~v22 \/ v26) /\
 (~v5 \/ ~v33 \/ ~v36) /\
 (v2 \/ ~v33 \/ v46) /\
 (v5 \/ v10 \/ ~v42) /\
 (v14 \/ ~v29 \/ ~v31) /\
 (v12 \/ ~v23 \/ v26) /\
 (v8 \/ v35 \/ v36) /\
 (~v10 \/ ~v17 \/ ~v18) /\
 (v10 \/ ~v22 \/ ~v28) /\
 (v15 \/ ~v17 \/ ~v43) /\
 (v23 \/ ~v29 \/ ~v37) /\
 (v13 \/ ~v33 \/ v35) /\
 (~v2 \/ v23 \/ v42) /\
 (v9 \/ v43 \/ v46) /\
 (v5 \/ ~v24 \/ ~v45) /\
 (~v5 \/ v43 \/ v46) /\
 (~v3 \/ ~v13 \/ ~v40) /\
 (v3 \/ ~v28 \/ ~v42) /\
 (v24 \/ ~v31 \/ v43) /\
 (v14 \/ ~v22 \/ ~v32) /\
 (v3 \/ v24 \/ v26) /\
 (~v13 \/ ~v43 \/ v44) /\
 (~v3 \/ ~v31 \/ ~v40) /\
 (~v5 \/ ~v40 \/ v50) /\
 (v35 \/ ~v37 \/ ~v45) /\
 (~v3 \/ v5 \/ v28) /\
 (v13 \/ v28 \/ ~v46) /\
 (v3 \/ v28 \/ ~v37) /\
 (v13 \/ v29 \/ v48))` ;

(* Hard *)
val aim_50_2_0_no_2 = bdd_oracle
`~
((v4 \/ v21 \/ v34) /\
 (v21 \/ ~v34 \/ v40) /\
 (v1 \/ ~v21 \/ v40) /\
 (~v21 \/ v39 \/ v40) /\
 (v20 \/ v29 \/ v41) /\
 (~v20 \/ v39 \/ v41) /\
 (v39 \/ ~v40 \/ v41) /\
 (~v40 \/ ~v41 \/ v42) /\
 (~v40 \/ ~v41 \/ ~v42) /\
 (v1 \/ v25 \/ ~v39) /\
 (v2 \/ ~v25 \/ ~v39) /\
 (~v2 \/ v5 \/ ~v39) /\
 (~v1 \/ v4 \/ v5) /\
 (v15 \/ v26 \/ v33) /\
 (v15 \/ v26 \/ ~v33) /\
 (~v5 \/ ~v15 \/ v26) /\
 (~v5 \/ ~v26 \/ v31) /\
 (~v5 \/ ~v26 \/ ~v31) /\
 (v6 \/ v9 \/ v47) /\
 (v9 \/ v37 \/ v38) /\
 (v9 \/ v14 \/ ~v38) /\
 (~v14 \/ ~v38 \/ ~v47) /\
 (~v9 \/ v11 \/ v37) /\
 (~v9 \/ ~v11 \/ v37) /\
 (v24 \/ ~v37 \/ v48) /\
 (v24 \/ v46 \/ ~v48) /\
 (~v24 \/ ~v37 \/ v46) /\
 (v16 \/ v18 \/ ~v46) /\
 (~v16 \/ v18 \/ ~v46) /\
 (~v18 \/ ~v37 \/ ~v46) /\
 (~v4 \/ ~v6 \/ v15) /\
 (~v4 \/ v13 \/ ~v15) /\
 (~v4 \/ ~v13 \/ ~v15) /\
 (~v1 \/ ~v6 \/ v38) /\
 (v3 \/ ~v9 \/ v35) /\
 (v7 \/ v43 \/ v44) /\
 (v7 \/ v29 \/ v43) /\
 (~v8 \/ ~v29 \/ v44) /\
 (~v29 \/ ~v32 \/ v48) /\
 (~v14 \/ v30 \/ v46) /\
 (~v1 \/ ~v14 \/ ~v30) /\
 (~v11 \/ v20 \/ v49) /\
 (v20 \/ ~v44 \/ ~v49) /\
 (v16 \/ v22 \/ ~v27) /\
 (v13 \/ ~v19 \/ ~v35) /\
 (v2 \/ v19 \/ ~v33) /\
 (v2 \/ v19 \/ ~v28) /\
 (v33 \/ ~v34 \/ ~v44) /\
 (~v33 \/ ~v44 \/ v50) /\
 (v5 \/ v30 \/ ~v48) /\
 (v10 \/ v22 \/ ~v50) /\
 (~v10 \/ v22 \/ ~v34) /\
 (v1 \/ v10 \/ ~v47) /\
 (~v10 \/ ~v25 \/ ~v47) /\
 (~v25 \/ ~v27 \/ v50) /\
 (v11 \/ v21 \/ v23) /\
 (~v3 \/ v11 \/ v23) /\
 (~v3 \/ v6 \/ ~v50) /\
 (~v6 \/ v23 \/ ~v50) /\
 (~v31 \/ ~v43 \/ v44) /\
 (~v7 \/ v16 \/ ~v26) /\
 (~v23 \/ v28 \/ ~v38) /\
 (v19 \/ v28 \/ v50) /\
 (~v18 \/ v45 \/ v49) /\
 (~v2 \/ ~v16 \/ ~v48) /\
 (v7 \/ v14 \/ ~v42) /\
 (v12 \/ v25 \/ ~v36) /\
 (v10 \/ ~v24 \/ ~v45) /\
 (~v21 \/ v32 \/ ~v42) /\
 (v12 \/ ~v18 \/ ~v27) /\
 (~v13 \/ ~v23 \/ ~v24) /\
 (v25 \/ v29 \/ v38) /\
 (~v8 \/ v43 \/ ~v45) /\
 (~v2 \/ ~v12 \/ v13) /\
 (~v7 \/ v14 \/ v30) /\
 (~v8 \/ ~v17 \/ ~v19) /\
 (v8 \/ ~v22 \/ v49) /\
 (~v12 \/ ~v17 \/ v33) /\
 (v27 \/ ~v29 \/ v32) /\
 (v8 \/ ~v12 \/ ~v13) /\
 (v24 \/ ~v31 \/ v47) /\
 (~v3 \/ v36 \/ v47) /\
 (v3 \/ v12 \/ v34) /\
 (~v7 \/ ~v16 \/ v36) /\
 (~v22 \/ v31 \/ v48) /\
 (v17 \/ ~v22 \/ ~v49) /\
 (~v17 \/ ~v19 \/ v32) /\
 (~v20 \/ v27 \/ v36) /\
 (v18 \/ ~v32 \/ ~v35) /\
 (v3 \/ ~v28 \/ ~v30) /\
 (v17 \/ v34 \/ v42) /\
 (~v32 \/ ~v43 \/ ~v49) /\
 (v17 \/ ~v28 \/ ~v43) /\
 (~v23 \/ v35 \/ ~v45) /\
 (~v10 \/ v31 \/ ~v36) /\
 (v27 \/ ~v41 \/ v42) /\
 (v35 \/ ~v36 \/ v45) /\
 (v8 \/ ~v30 \/ v45) /\
 (v4 \/ v28 \/ ~v35) /\
 (v6 \/ ~v11 \/ ~v20))` ;

(* Hard *)
val aim_50_2_0_no_3 = bdd_oracle
`~
((v33 \/ v37 \/ v43) /\
 (v21 \/ ~v37 \/ v43) /\
 (~v21 \/ ~v37 \/ v39) /\
 (v23 \/ v39 \/ ~v43) /\
 (v13 \/ ~v23 \/ v31) /\
 (~v13 \/ ~v23 \/ v31) /\
 (~v23 \/ ~v31 \/ ~v43) /\
 (v6 \/ v9 \/ v25) /\
 (~v6 \/ v9 \/ v25) /\
 (v9 \/ v33 \/ ~v38) /\
 (~v9 \/ v25 \/ ~v39) /\
 (v24 \/ ~v25 \/ ~v39) /\
 (~v24 \/ ~v25 \/ v33) /\
 (v6 \/ v27 \/ v41) /\
 (~v6 \/ v14 \/ v41) /\
 (v14 \/ ~v41 \/ v43) /\
 (v14 \/ ~v41 \/ ~v43) /\
 (v1 \/ v20 \/ v27) /\
 (v1 \/ v12 \/ ~v20) /\
 (v1 \/ ~v12 \/ ~v14) /\
 (~v1 \/ v27 \/ v28) /\
 (~v1 \/ ~v14 \/ ~v28) /\
 (~v1 \/ ~v11 \/ ~v14) /\
 (~v27 \/ ~v33 \/ v39) /\
 (v5 \/ v20 \/ v28) /\
 (v19 \/ v29 \/ ~v33) /\
 (~v19 \/ ~v20 \/ v29) /\
 (~v20 \/ v28 \/ ~v29) /\
 (v5 \/ ~v28 \/ v37) /\
 (v5 \/ ~v28 \/ ~v37) /\
 (~v5 \/ ~v33 \/ ~v39) /\
 (v7 \/ v17 \/ v22) /\
 (~v5 \/ v7 \/ v17) /\
 (~v7 \/ v18 \/ v22) /\
 (v22 \/ ~v24 \/ v41) /\
 (~v7 \/ v12 \/ v18) /\
 (~v12 \/ v18 \/ v34) /\
 (~v12 \/ v34 \/ ~v42) /\
 (~v7 \/ ~v34 \/ ~v41) /\
 (~v16 \/ ~v29 \/ v35) /\
 (~v3 \/ v13 \/ ~v29) /\
 (~v21 \/ ~v30 \/ v37) /\
 (~v15 \/ ~v21 \/ v47) /\
 (~v8 \/ v24 \/ v40) /\
 (~v3 \/ ~v8 \/ v42) /\
 (~v3 \/ ~v8 \/ ~v42) /\
 (~v2 \/ v30 \/ v36) /\
 (~v2 \/ ~v30 \/ v36) /\
 (~v4 \/ ~v35 \/ v44) /\
 (v42 \/ ~v45 \/ ~v50) /\
 (~v42 \/ ~v45 \/ ~v50) /\
 (~v11 \/ v15 \/ ~v40) /\
 (v3 \/ v46 \/ v48) /\
 (v3 \/ ~v46 \/ v48) /\
 (~v11 \/ v30 \/ v50) /\
 (~v16 \/ v30 \/ v50) /\
 (v4 \/ ~v36 \/ ~v40) /\
 (v8 \/ v46 \/ v47) /\
 (v24 \/ ~v40 \/ v44) /\
 (v12 \/ v16 \/ ~v46) /\
 (v2 \/ v6 \/ ~v36) /\
 (~v6 \/ ~v44 \/ v46) /\
 (~v22 \/ v32 \/ ~v36) /\
 (v3 \/ v32 \/ v38) /\
 (~v27 \/ ~v35 \/ v38) /\
 (v11 \/ v16 \/ ~v47) /\
 (v31 \/ ~v45 \/ ~v46) /\
 (v19 \/ ~v24 \/ v32) /\
 (~v15 \/ v23 \/ ~v31) /\
 (v4 \/ ~v34 \/ ~v49) /\
 (v11 \/ ~v22 \/ ~v49) /\
 (v23 \/ ~v26 \/ v50) /\
 (~v9 \/ ~v31 \/ ~v32) /\
 (~v2 \/ ~v27 \/ v35) /\
 (v26 \/ v34 \/ v45) /\
 (v7 \/ v36 \/ v47) /\
 (~v4 \/ ~v30 \/ v49) /\
 (~v26 \/ ~v44 \/ ~v50) /\
 (v2 \/ v40 \/ v48) /\
 (v26 \/ ~v44 \/ ~v47) /\
 (~v18 \/ v19 \/ ~v25) /\
 (~v38 \/ v42 \/ v49) /\
 (v13 \/ ~v22 \/ v49) /\
 (~v10 \/ ~v32 \/ ~v48) /\
 (v2 \/ ~v19 \/ v29) /\
 (~v13 \/ ~v15 \/ v26) /\
 (~v10 \/ ~v17 \/ v20) /\
 (~v17 \/ v21 \/ v45) /\
 (~v4 \/ ~v13 \/ ~v26) /\
 (~v9 \/ v21 \/ ~v48) /\
 (~v10 \/ v35 \/ v44) /\
 (~v32 \/ ~v48 \/ ~v49) /\
 (v4 \/ ~v16 \/ ~v19) /\
 (~v5 \/ v8 \/ v40) /\
 (v15 \/ ~v18 \/ ~v35) /\
 (v8 \/ v10 \/ ~v47) /\
 (v10 \/ v15 \/ v45) /\
 (v10 \/ ~v18 \/ ~v34) /\
 (v16 \/ v17 \/ v38) /\
 (v11 \/ ~v17 \/ ~v38))` ;

val mul_be  = bdd_oracle
 `(ba0 =
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl) /\
  (ba1 =
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~c17 /\ ~repl) /\
  (ba2 =
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~c17 /\ ~repl) /\
  (by0 =
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl) /\
  (by1 =
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ c1 \/
   c0 \/
   repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ ~c16 /\ ~c17) /\
  (bx0 =
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl) /\
  (bx1 =
   ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl \/
   ~c0 /\ c1 \/
   c0 \/
   repl \/
   ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ ~c16 /\ ~c17)
  ==> (bx1 =
       repl \/
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl \/
       ~c14 /\ ~c15 /\ ~c16 /\ ~c17 \/
       c1 \/
       c0) /\
      (bx0 =
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ ~c16 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~repl) /\
      (by1 =
       repl \/
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
       ~c14 /\ ~c15 /\ ~c16 /\ ~c17 \/
       c1 \/
       c0) /\
      (by0 =
       ~c0 /\ ~c1 /\ ~c14 /\ ~c16 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~repl) /\
      (ba2 = ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ ~c16 /\ ~repl) /\
      (ba1 = ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c16 /\ ~repl) /\
      (ba0 =
       ~c0 /\ ~c1 /\ ~c14 /\ ~c15 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ ~c16 /\ c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ ~c14 /\ c15 /\ c16 /\ ~c17 /\ ~repl \/
       ~c0 /\ ~c1 /\ c14 /\ ~c15 /\ ~c16 /\ ~c17 /\ ~repl)` ;

val dk17_be  = bdd_oracle
 `(ge17 = ~in4 /\ ~in3 /\ ~in2 /\ ~in1) /\
  (ge0 = ge17 /\ ~in5) /\
  (ge22 = ~in9 /\ ~in7 /\ ~in6 /\ in0) /\
  (ge19 = ~in5 /\ ~in4 /\ ~in3 /\ ~in0) /\
  (ge20 = ~in7 /\ ~in6) /\
  (ge18 = ~in6 /\ ~in2 /\ ~in1 /\ ~in0) /\
  (ge21 = in9 /\ ~in7 /\ in6 /\ ~in0) /\
  (ge23 = ge22 /\ ge0) /\
  (ge25 = ~in9 /\ ~in7 /\ in6 /\ ~in0) /\
  (ge26 = in9 /\ ~in7 /\ ~in6 /\ in0) /\
  (ge2 = ge20 /\ ge19) /\
  (ge1 = ge18 /\ ~in7) /\
  (ge24 = ge23 \/ ge21 /\ ge0) /\
  (ge5 = ~in5 /\ in4 \/ in5 /\ ~in4) /\
  (ge6 = ge0 /\ in7 /\ ~in6 /\ ~in0) /\
  (ge12 = ge26 /\ ge0 \/ ge25 /\ ge0) /\
  (ge14 = ge2 /\ in8 /\ ~in2 /\ in1) /\
  (ge27 = ~in8 /\ in5 /\ ~in4 /\ ~in3) /\
  (ge9 = ge1 /\ ~in5 /\ ~in4 /\ in3) /\
  (ge7 = ge24 \/ ge2 /\ in2 /\ ~in1) /\
  (ge10 = ge6 \/ ge5 /\ ge1 /\ ~in3) /\
  (ge15 = ~in8 \/ in9) /\
  (ge16 = ge12 \/ ge14 /\ ~in9) /\
  (ge4 =
   ge5 /\ ge1 /\ in8 /\ ~in3 \/
   ge0 /\ ~in7 /\ in6 /\ ~in0 \/
   ge2 /\ in2 /\ ~in1) /\
  (ge13 = ge27 /\ ge1) /\
  (ge11 = ge9 \/ ge6 /\ ~in8) /\
  (ge8 = ge1 /\ ~in5 /\ in4 /\ ~in3 \/ ge2 /\ ~in2 /\ in1) /\
  (out0 = ge7 /\ ~in8) /\
  (out1 = ge7 /\ in8) /\
  (out2 = ge8 /\ ~in9 \/ ge10 /\ in8) /\
  (out3 = ge8 /\ in9 /\ ~in8 \/ ge11 /\ ~in9 \/ ge12 /\ ~in8) /\
  (out4 = ge11 /\ in9 \/ ge12 /\ in8) /\
  (out5 = ge14 /\ in9) /\
  (out6 = ge13 /\ ~in9) /\
  (out7 = ge13 /\ in9) /\
  (out8 = ge9 /\ ~in8 \/ ge15 /\ ge6 \/ ge4 /\ in9) /\
  (out9 = ge9 /\ in8 \/ ~ge15 /\ ge10 \/ ge16) /\
  (out10 = ge7) /\
  (wres0 = ~in5 /\ ~in4 /\ ~in3 /\ ~in2 /\ ~in1) /\
  (wres1 = ~in7 /\ ~in6 /\ ~in2 /\ ~in1 /\ ~in0) /\
  (wres2 = ~in7 /\ ~in6 /\ ~in5 /\ ~in4 /\ ~in3 /\ ~in0) /\
  (wres5 = ~in5 /\ in4 \/ in5 /\ ~in4) /\
  (wres6 = wres0 /\ in7 /\ ~in6 /\ ~in0) /\
  (wres9 = wres1 /\ ~in5 /\ ~in4 /\ in3) /\
  (wres7 =
   wres0 /\ ~in9 /\ ~in7 /\ ~in6 /\ in0 \/
   wres0 /\ in9 /\ ~in7 /\ in6 /\ ~in0 \/
   wres2 /\ in2 /\ ~in1) /\
  (wres10 = wres6 \/ wres5 /\ wres1 /\ ~in3) /\
  (wres12 = wres0 /\ in9 /\ ~in7 /\ ~in6 /\ in0 \/
            wres0 /\ ~in9 /\ ~in7 /\ in6 /\ ~in0) /\
  (wres14 = wres2 /\ in8 /\ ~in2 /\ in1) /\
  (wres15 = ~in8 \/ in9) /\
  (wres4 = wres5 /\ wres1 /\ in8 /\ ~in3 \/
           wres2 /\ in2 /\ ~in1 \/
           wres0 /\ ~in7 /\ in6 /\ ~in0) /\
  (wres13 = wres1 /\ ~in8 /\ in5 /\ ~in4 /\ ~in3) /\
  (wres11 = wres9 \/ wres6 /\ ~in8) /\
  (wres8 = wres1 /\ ~in5 /\ in4 /\ ~in3 \/ wres2 /\ ~in2 /\ in1)
  ==> (out10 = wres7) /\
      (out9 = wres9 /\ in8 \/ wres12 \/ wres14 /\ ~in9 \/ ~wres15 /\ wres10) /\
      (out8 = wres9 /\ ~in8 \/ wres15 /\ wres6 \/ wres4 /\ in9) /\
      (out7 = wres13 /\ in9) /\
      (out6 = wres13 /\ ~in9) /\
      (out5 = wres14 /\ in9) /\
      (out4 = wres11 /\ in9 \/ wres12 /\ in8) /\
      (out3 = wres8 /\ in9 /\ ~in8 \/ wres11 /\ ~in9 \/ wres12 /\ ~in8) /\
      (out2 = wres8 /\ ~in9 \/ wres10 /\ in8) /\
      (out1 = wres7 /\ in8) /\
      (out0 = wres7 /\ ~in8)` ;

(* Hard *)
val risc_be  = bdd_oracle
 `(ge1 = ~in4 /\ ~in2 /\ ~in1 /\ in0) /\
  (ge2 = in2 /\ ~in1 /\ ~in0) /\
  (ge3 = in2 /\ ~in1 /\ in0) /\
  (ge8 = in2 /\ in1) /\
  (ge16 = ~in2 /\ in1) /\
  (ge5 = ~in3 /\ ~in2 /\ in1 /\ in0) /\
  (ge11 = ge1 /\ in3) /\
  (ge0 = ~in3 /\ ~in2 /\ in1 /\ ~in0) /\
  (ge9 = ge2 /\ in3) /\
  (ge10 = ge3 /\ ~in3) /\
  (ge17 = ~in4 /\ in3) /\
  (ge20 = ge2 /\ ~in3) /\
  (ge15 = ge8 /\ in0) /\
  (ge19 = ge1 /\ in5) /\
  (ge6 = ge16 \/ in4 /\ ~in2) /\
  (ge13 = ge11 \/ ge5) /\
  (ge4 = in2 \/ in1 \/ in0) /\
  (ge7 = ~in6 /\ in5 \/ in4) /\
  (ge12 = ge0 /\ ~in6 /\ ~in4 \/ ge0 /\ ~in5 /\ ~in4) /\
  (ge14 = ge8 /\ ~in0) /\
  (ge18 = ge9 /\ in4) /\
  (out0 = ge12 \/ ge18) /\
  (out1 = ge9 /\ in5 /\ ~in4) /\
  (out2 = ge17 /\ in5 /\ in2 /\ ~in0 \/ ge5 \/ ge14) /\
  (out3 = ge1 /\ in7 \/ ge13) /\
  (out4 = ge3 \/ ~ge4) /\
  (out5 = ge9) /\
  (out6 = ge20) /\
  (out7 = ge2 /\ ~in5 \/ ge18) /\
  (out8 = ge14) /\
  (out9 = ge12) /\
  (out10 = ge0) /\
  (out11 = ~ge7 /\ ge0) /\
  (out12 = ge7 /\ ge0) /\
  (out13 = ge16 /\ ~in0) /\
  (out14 = ~ge4) /\
  (out15 = ge4) /\
  (out16 = ge10 /\ in5) /\
  (out17 = ge10 /\ ~in5) /\
  (out18 = ~ge4 /\ ~in4 /\ ~in3) /\
  (out19 = ~ge4 /\ in3) /\
  (out20 = ge15) /\
  (out21 = ge13) /\
  (out22 = ge11) /\
  (out23 = ge1 /\ ~in3) /\
  (out24 = ge19) /\
  (out25 = ge6 /\ in3 /\ in0) /\
  (out26 = ge19 \/ ge15) /\
  (out27 = in1 /\ ~in0) /\
  (out28 = ge20 /\ in5) /\
  (out29 = ge17 /\ ge3) /\
  (out30 = ge10 /\ ~in4) /\
  (wres1 = ~in4 /\ ~in2 /\ ~in1 /\ in0) /\
  (wres2 = in2 /\ ~in1 /\ ~in0) /\
  (wres3 = in2 /\ ~in1 /\ in0) /\
  (wres8 = in2 /\ in1) /\
  (wres16 = ~in2 /\ in1) /\
  (wres5 = ~in3 /\ ~in2 /\ in1 /\ in0) /\
  (wres11 = wres1 /\ in3) /\
  (wres0 = ~in3 /\ ~in2 /\ in1 /\ ~in0) /\
  (wres9 = wres2 /\ in3) /\
  (wres10 = wres3 /\ ~in3) /\
  (wres17 = ~in4 /\ in3) /\
  (wres20 = wres2 /\ ~in3) /\
  (wres15 = wres8 /\ in0) /\
  (wres19 = wres1 /\ in5) /\
  (wres6 = wres16 \/ in4 /\ ~in2) /\
  (wres13 = wres11 \/ wres5) /\
  (wres4 = in2 \/ in1 \/ in0) /\
  (wres7 = ~in6 /\ in5 \/ in4) /\
  (wres12 = wres0 /\ ~in6 /\ ~in4 \/ wres0 /\ ~in5 /\ ~in4) /\
  (wres14 = wres8 /\ ~in0) /\
  (wres18 = wres9 /\ in4)
  ==> (out30 = wres10 /\ ~in4) /\
      (out29 = wres17 /\ wres3) /\
      (out28 = wres20 /\ in5) /\
      (out27 = in1 /\ ~in0) /\
      (out26 = wres19 \/ wres15) /\
      (out25 = wres6 /\ in3 /\ in0) /\
      (out24 = wres19) /\
      (out23 = wres1 /\ ~in3) /\
      (out22 = wres11) /\
      (out21 = wres13) /\
      (out20 = wres15) /\
      (out19 = ~wres4 /\ in3) /\
      (out18 = ~wres4 /\ ~in4 /\ ~in3) /\
      (out17 = wres10 /\ ~in5) /\
      (out16 = wres10 /\ in5) /\
      (out15 = wres4) /\
      (out14 = ~wres4) /\
      (out13 = wres16 /\ ~in0) /\
      (out12 = wres7 /\ wres0) /\
      (out11 = ~wres7 /\ wres0) /\
      (out10 = wres0) /\
      (out9 = wres12) /\
      (out8 = wres14) /\
      (out7 = wres2 /\ ~in5 \/ wres18) /\
      (out6 = wres20) /\
      (out5 = wres9) /\
      (out4 = wres3 \/ ~wres4) /\
      (out3 = wres1 /\ in7 \/ wres13) /\
      (out2 = wres5 \/ wres14 \/ wres17 /\ in5 /\ in2 /\ ~in0) /\
      (out1 = wres9 /\ in5 /\ ~in4) /\
      (out0 = wres12 \/ wres18)` ;

val msc006_1 = bdd_oracle
`~((~v5 \/ ~v0 \/ v0) /\
  (~v5 \/ ~v2 \/ v2) /\
  (~v5 \/ ~v31 \/ v31) /\
  (~v5 \/ ~v5 \/ v5) /\
  (~v13 \/ ~v0 \/ v7) /\
  (~v13 \/ ~v2 \/ v9) /\
  (~v13 \/ ~v31 \/ v11) /\
  (~v13 \/ ~v5 \/ v13) /\
  (~v20 \/ ~v0 \/ v15) /\
  (~v20 \/ ~v2 \/ v16) /\
  (~v20 \/ ~v31 \/ v18) /\
  (~v20 \/ ~v5 \/ v20) /\
  (~v28 \/ ~v0 \/ v22) /\
  (~v28 \/ ~v2 \/ v24) /\
  (~v28 \/ ~v31 \/ v26) /\
  (~v28 \/ ~v5 \/ v28) /\
  (~v31 \/ ~v7 \/ v0) /\
  (~v31 \/ ~v9 \/ v2) /\
  (~v31 \/ ~v11 \/ v31) /\
  (~v31 \/ ~v13 \/ v5) /\
  (~v11 \/ ~v7 \/ v7) /\
  (~v11 \/ ~v9 \/ v9) /\
  (~v11 \/ ~v11 \/ v11) /\
  (~v11 \/ ~v13 \/ v13) /\
  (~v18 \/ ~v7 \/ v15) /\
  (~v18 \/ ~v9 \/ v16) /\
  (~v18 \/ ~v11 \/ v18) /\
  (~v18 \/ ~v13 \/ v20) /\
  (~v26 \/ ~v7 \/ v22) /\
  (~v26 \/ ~v9 \/ v24) /\
  (~v26 \/ ~v11 \/ v26) /\
  (~v26 \/ ~v13 \/ v28) /\
  (~v2 \/ ~v15 \/ v0) /\
  (~v2 \/ ~v16 \/ v2) /\
  (~v2 \/ ~v18 \/ v31) /\
  (~v2 \/ ~v20 \/ v5) /\
  (~v9 \/ ~v15 \/ v7) /\
  (~v9 \/ ~v16 \/ v9) /\
  (~v9 \/ ~v18 \/ v11) /\
  (~v9 \/ ~v20 \/ v13) /\
  (~v16 \/ ~v15 \/ v15) /\
  (~v16 \/ ~v16 \/ v16) /\
  (~v16 \/ ~v18 \/ v18) /\
  (~v16 \/ ~v20 \/ v20) /\
  (~v24 \/ ~v15 \/ v22) /\
  (~v24 \/ ~v16 \/ v24) /\
  (~v24 \/ ~v18 \/ v26) /\
  (~v24 \/ ~v20 \/ v28) /\
  (~v0 \/ ~v22 \/ v0) /\
  (~v0 \/ ~v24 \/ v2) /\
  (~v0 \/ ~v26 \/ v31) /\
  (~v0 \/ ~v28 \/ v5) /\
  (~v7 \/ ~v22 \/ v7) /\
  (~v7 \/ ~v24 \/ v9) /\
  (~v7 \/ ~v26 \/ v11) /\
  (~v7 \/ ~v28 \/ v13) /\
  (~v15 \/ ~v22 \/ v15) /\
  (~v15 \/ ~v24 \/ v16) /\
  (~v15 \/ ~v26 \/ v18) /\
  (~v15 \/ ~v28 \/ v20) /\
  (~v22 \/ ~v22 \/ v22) /\
  (~v22 \/ ~v24 \/ v24) /\
  (~v22 \/ ~v26 \/ v26) /\
  (~v22 \/ ~v28 \/ v28) /\
  (~v6 \/ ~v1 \/ v1) /\
  (~v6 \/ ~v3 \/ v3) /\
  (~v6 \/ ~v4 \/ v4) /\
  (~v6 \/ ~v6 \/ v6) /\
  (~v14 \/ ~v1 \/ v8) /\
  (~v14 \/ ~v3 \/ v10) /\
  (~v14 \/ ~v4 \/ v12) /\
  (~v14 \/ ~v6 \/ v14) /\
  (~v21 \/ ~v1 \/ v30) /\
  (~v21 \/ ~v3 \/ v17) /\
  (~v21 \/ ~v4 \/ v19) /\
  (~v21 \/ ~v6 \/ v21) /\
  (~v29 \/ ~v1 \/ v23) /\
  (~v29 \/ ~v3 \/ v25) /\
  (~v29 \/ ~v4 \/ v27) /\
  (~v29 \/ ~v6 \/ v29) /\
  (~v4 \/ ~v8 \/ v1) /\
  (~v4 \/ ~v10 \/ v3) /\
  (~v4 \/ ~v12 \/ v4) /\
  (~v4 \/ ~v14 \/ v6) /\
  (~v12 \/ ~v8 \/ v8) /\
  (~v12 \/ ~v10 \/ v10) /\
  (~v12 \/ ~v12 \/ v12) /\
  (~v12 \/ ~v14 \/ v14) /\
  (~v19 \/ ~v8 \/ v30) /\
  (~v19 \/ ~v10 \/ v17) /\
  (~v19 \/ ~v12 \/ v19) /\
  (~v19 \/ ~v14 \/ v21) /\
  (~v27 \/ ~v8 \/ v23) /\
  (~v27 \/ ~v10 \/ v25) /\
  (~v27 \/ ~v12 \/ v27) /\
  (~v27 \/ ~v14 \/ v29) /\
  (~v3 \/ ~v30 \/ v1) /\
  (~v3 \/ ~v17 \/ v3) /\
  (~v3 \/ ~v19 \/ v4) /\
  (~v3 \/ ~v21 \/ v6) /\
  (~v10 \/ ~v30 \/ v8) /\
  (~v10 \/ ~v17 \/ v10) /\
  (~v10 \/ ~v19 \/ v12) /\
  (~v10 \/ ~v21 \/ v14) /\
  (~v17 \/ ~v30 \/ v30) /\
  (~v17 \/ ~v17 \/ v17) /\
  (~v17 \/ ~v19 \/ v19) /\
  (~v17 \/ ~v21 \/ v21) /\
  (~v25 \/ ~v30 \/ v23) /\
  (~v25 \/ ~v17 \/ v25) /\
  (~v25 \/ ~v19 \/ v27) /\
  (~v25 \/ ~v21 \/ v29) /\
  (~v1 \/ ~v23 \/ v1) /\
  (~v1 \/ ~v25 \/ v3) /\
  (~v1 \/ ~v27 \/ v4) /\
  (~v1 \/ ~v29 \/ v6) /\
  (~v8 \/ ~v23 \/ v8) /\
  (~v8 \/ ~v25 \/ v10) /\
  (~v8 \/ ~v27 \/ v12) /\
  (~v8 \/ ~v29 \/ v14) /\
  (~v30 \/ ~v23 \/ v30) /\
  (~v30 \/ ~v25 \/ v17) /\
  (~v30 \/ ~v27 \/ v19) /\
  (~v30 \/ ~v29 \/ v21) /\
  (~v23 \/ ~v23 \/ v23) /\
  (~v23 \/ ~v25 \/ v25) /\
  (~v23 \/ ~v27 \/ v27) /\
  (~v23 \/ ~v29 \/ v29) /\
  (~v29 \/ v1) /\
  (~v21 \/ v3) /\
  (~v14 \/ v4) /\
  (~v6 \/ v6) /\
  (~v27 \/ v8) /\
  (~v19 \/ v10) /\
  (~v12 \/ v12) /\
  (~v4 \/ v14) /\
  (~v25 \/ v30) /\
  (~v17 \/ v17) /\
  (~v10 \/ v19) /\
  (~v3 \/ v21) /\
  (~v23 \/ v23) /\
  (~v30 \/ v25) /\
  (~v8 \/ v27) /\
  (~v1 \/ v29) /\
  (v0 \/ v1) /\
  (v2 \/ v3) /\
  (v31 \/ v4) /\
  (v5 \/ v6) /\
  (v7 \/ v8) /\
  (v9 \/ v10) /\
  (v11 \/ v12) /\
  (v13 \/ v14) /\
  (v15 \/ v30) /\
  (v16 \/ v17) /\
  (v18 \/ v19) /\
  (v20 \/ v21) /\
  (v22 \/ v23) /\
  (v24 \/ v25) /\
  (v26 \/ v27) /\
  (v28 \/ v29) /\
  ~v30 /\
  ~v31)` ;

val syn072_1 = bdd_oracle
`~(v11 /\
  v9 /\
  v7 /\
  v23 /\
  v24 /\
  (~v16 \/ v0) /\
  (~v18 \/ v1) /\
  (~v20 \/ v2) /\
  (~v22 \/ v25) /\
  (~v24 \/ v24) /\
  (~v17 \/ v3) /\
  (~v19 \/ v4) /\
  (~v21 \/ v5) /\
  (~v23 \/ v23) /\
  (~v25 \/ v22) /\
  (~v13 \/ v6) /\
  (~v10 \/ v27) /\
  (~v7 \/ v7) /\
  (~v5 \/ v21) /\
  (~v2 \/ v20) /\
  (~v12 \/ v8) /\
  (~v9 \/ v9) /\
  (~v27 \/ v10) /\
  (~v4 \/ v19) /\
  (~v1 \/ v18) /\
  (~v11 \/ v11) /\
  (~v8 \/ v12) /\
  (~v6 \/ v13) /\
  (~v3 \/ v17) /\
  (~v0 \/ v16) /\
  (~v24 \/ ~v0 \/ v0) /\
  (~v24 \/ ~v1 \/ v1) /\
  (~v24 \/ ~v2 \/ v2) /\
  (~v24 \/ ~v25 \/ v25) /\
  (~v24 \/ ~v24 \/ v24) /\
  (~v22 \/ ~v0 \/ v3) /\
  (~v22 \/ ~v1 \/ v4) /\
  (~v22 \/ ~v2 \/ v5) /\
  (~v22 \/ ~v25 \/ v23) /\
  (~v22 \/ ~v24 \/ v22) /\
  (~v20 \/ ~v0 \/ v6) /\
  (~v20 \/ ~v1 \/ v27) /\
  (~v20 \/ ~v2 \/ v7) /\
  (~v20 \/ ~v25 \/ v21) /\
  (~v20 \/ ~v24 \/ v20) /\
  (~v18 \/ ~v0 \/ v8) /\
  (~v18 \/ ~v1 \/ v9) /\
  (~v18 \/ ~v2 \/ v10) /\
  (~v18 \/ ~v25 \/ v19) /\
  (~v18 \/ ~v24 \/ v18) /\
  (~v16 \/ ~v0 \/ v11) /\
  (~v16 \/ ~v1 \/ v12) /\
  (~v16 \/ ~v2 \/ v13) /\
  (~v16 \/ ~v25 \/ v17) /\
  (~v16 \/ ~v24 \/ v16) /\
  (~v25 \/ ~v3 \/ v0) /\
  (~v25 \/ ~v4 \/ v1) /\
  (~v25 \/ ~v5 \/ v2) /\
  (~v25 \/ ~v23 \/ v25) /\
  (~v25 \/ ~v22 \/ v24) /\
  (~v23 \/ ~v3 \/ v3) /\
  (~v23 \/ ~v4 \/ v4) /\
  (~v23 \/ ~v5 \/ v5) /\
  (~v23 \/ ~v23 \/ v23) /\
  (~v23 \/ ~v22 \/ v22) /\
  (~v21 \/ ~v3 \/ v6) /\
  (~v21 \/ ~v4 \/ v27) /\
  (~v21 \/ ~v5 \/ v7) /\
  (~v21 \/ ~v23 \/ v21) /\
  (~v21 \/ ~v22 \/ v20) /\
  (~v19 \/ ~v3 \/ v8) /\
  (~v19 \/ ~v4 \/ v9) /\
  (~v19 \/ ~v5 \/ v10) /\
  (~v19 \/ ~v23 \/ v19) /\
  (~v19 \/ ~v22 \/ v18) /\
  (~v17 \/ ~v3 \/ v11) /\
  (~v17 \/ ~v4 \/ v12) /\
  (~v17 \/ ~v5 \/ v13) /\
  (~v17 \/ ~v23 \/ v17) /\
  (~v17 \/ ~v22 \/ v16) /\
  (~v2 \/ ~v6 \/ v0) /\
  (~v2 \/ ~v27 \/ v1) /\
  (~v2 \/ ~v7 \/ v2) /\
  (~v2 \/ ~v21 \/ v25) /\
  (~v2 \/ ~v20 \/ v24) /\
  (~v5 \/ ~v6 \/ v3) /\
  (~v5 \/ ~v27 \/ v4) /\
  (~v5 \/ ~v7 \/ v5) /\
  (~v5 \/ ~v21 \/ v23) /\
  (~v5 \/ ~v20 \/ v22) /\
  (~v7 \/ ~v6 \/ v6) /\
  (~v7 \/ ~v27 \/ v27) /\
  (~v7 \/ ~v7 \/ v7) /\
  (~v7 \/ ~v21 \/ v21) /\
  (~v7 \/ ~v20 \/ v20) /\
  (~v10 \/ ~v6 \/ v8) /\
  (~v10 \/ ~v27 \/ v9) /\
  (~v10 \/ ~v7 \/ v10) /\
  (~v10 \/ ~v21 \/ v19) /\
  (~v10 \/ ~v20 \/ v18) /\
  (~v13 \/ ~v6 \/ v11) /\
  (~v13 \/ ~v27 \/ v12) /\
  (~v13 \/ ~v7 \/ v13) /\
  (~v13 \/ ~v21 \/ v17) /\
  (~v13 \/ ~v20 \/ v16) /\
  (~v1 \/ ~v8 \/ v0) /\
  (~v1 \/ ~v9 \/ v1) /\
  (~v1 \/ ~v10 \/ v2) /\
  (~v1 \/ ~v19 \/ v25) /\
  (~v1 \/ ~v18 \/ v24) /\
  (~v4 \/ ~v8 \/ v3) /\
  (~v4 \/ ~v9 \/ v4) /\
  (~v4 \/ ~v10 \/ v5) /\
  (~v4 \/ ~v19 \/ v23) /\
  (~v4 \/ ~v18 \/ v22) /\
  (~v27 \/ ~v8 \/ v6) /\
  (~v27 \/ ~v9 \/ v27) /\
  (~v27 \/ ~v10 \/ v7) /\
  (~v27 \/ ~v19 \/ v21) /\
  (~v27 \/ ~v18 \/ v20) /\
  (~v9 \/ ~v8 \/ v8) /\
  (~v9 \/ ~v9 \/ v9) /\
  (~v9 \/ ~v10 \/ v10) /\
  (~v9 \/ ~v19 \/ v19) /\
  (~v9 \/ ~v18 \/ v18) /\
  (~v12 \/ ~v8 \/ v11) /\
  (~v12 \/ ~v9 \/ v12) /\
  (~v12 \/ ~v10 \/ v13) /\
  (~v12 \/ ~v19 \/ v17) /\
  (~v12 \/ ~v18 \/ v16) /\
  (~v0 \/ ~v11 \/ v0) /\
  (~v0 \/ ~v12 \/ v1) /\
  (~v0 \/ ~v13 \/ v2) /\
  (~v0 \/ ~v17 \/ v25) /\
  (~v0 \/ ~v16 \/ v24) /\
  (~v3 \/ ~v11 \/ v3) /\
  (~v3 \/ ~v12 \/ v4) /\
  (~v3 \/ ~v13 \/ v5) /\
  (~v3 \/ ~v17 \/ v23) /\
  (~v3 \/ ~v16 \/ v22) /\
  (~v6 \/ ~v11 \/ v6) /\
  (~v6 \/ ~v12 \/ v27) /\
  (~v6 \/ ~v13 \/ v7) /\
  (~v6 \/ ~v17 \/ v21) /\
  (~v6 \/ ~v16 \/ v20) /\
  (~v8 \/ ~v11 \/ v8) /\
  (~v8 \/ ~v12 \/ v9) /\
  (~v8 \/ ~v13 \/ v10) /\
  (~v8 \/ ~v17 \/ v19) /\
  (~v8 \/ ~v16 \/ v18) /\
  (~v11 \/ ~v11 \/ v11) /\
  (~v11 \/ ~v12 \/ v12) /\
  (~v11 \/ ~v13 \/ v13) /\
  (~v11 \/ ~v17 \/ v17) /\
  (~v11 \/ ~v16 \/ v16) /\
  (~v0 \/ ~v15 \/ v26) /\
  (~v1 \/ ~v15 \/ v28) /\
  (~v2 \/ ~v15 \/ v29) /\
  (~v25 \/ ~v15 \/ v14) /\
  (~v24 \/ ~v15 \/ v15) /\
  (~v3 \/ ~v14 \/ v26) /\
  (~v4 \/ ~v14 \/ v28) /\
  (~v5 \/ ~v14 \/ v29) /\
  (~v23 \/ ~v14 \/ v14) /\
  (~v22 \/ ~v14 \/ v15) /\
  (~v6 \/ ~v29 \/ v26) /\
  (~v27 \/ ~v29 \/ v28) /\
  (~v7 \/ ~v29 \/ v29) /\
  (~v21 \/ ~v29 \/ v14) /\
  (~v20 \/ ~v29 \/ v15) /\
  (~v8 \/ ~v28 \/ v26) /\
  (~v9 \/ ~v28 \/ v28) /\
  (~v10 \/ ~v28 \/ v29) /\
  (~v19 \/ ~v28 \/ v14) /\
  (~v18 \/ ~v28 \/ v15) /\
  (~v11 \/ ~v26 \/ v26) /\
  (~v12 \/ ~v26 \/ v28) /\
  (~v13 \/ ~v26 \/ v29) /\
  (~v17 \/ ~v26 \/ v14) /\
  (~v16 \/ ~v26 \/ v15) /\
  (v16 \/ v17) /\
  (v18 \/ v19) /\
  (v20 \/ v21) /\
  (v22 \/ v23) /\
  (v24 \/ v25) /\
  ~v26 /\
  ~v27 /\
  v28 /\
  v29)` ;

(* Hard *)
val aim_100_2_0_no_1 = bdd_oracle
`~
((v6 \/ v55 \/ v66) /\
 (v6 \/ v62 \/ ~v66) /\
 (~v62 \/ ~v66 \/ v68) /\
 (v6 \/ v8 \/ ~v55) /\
 (v8 \/ v58 \/ v70) /\
 (~v6 \/ v58 \/ ~v70) /\
 (~v6 \/ v33 \/ ~v58) /\
 (~v6 \/ v8 \/ ~v33) /\
 (~v8 \/ v61 \/ v68) /\
 (~v8 \/ ~v61 \/ v68) /\
 (v35 \/ v42 \/ v51) /\
 (v30 \/ ~v42 \/ v51) /\
 (v30 \/ ~v51 \/ v75) /\
 (v20 \/ ~v51 \/ ~v75) /\
 (~v20 \/ ~v51 \/ ~v75) /\
 (~v30 \/ v35 \/ ~v68) /\
 (v34 \/ ~v35 \/ v46) /\
 (~v35 \/ v46 \/ v86) /\
 (~v34 \/ v46 \/ ~v68) /\
 (~v35 \/ ~v46 \/ ~v68) /\
 (~v31 \/ v42 \/ v91) /\
 (~v7 \/ v20 \/ v85) /\
 (~v20 \/ ~v24 \/ ~v42) /\
 (v18 \/ ~v85 \/ v91) /\
 (~v18 \/ ~v24 \/ ~v31) /\
 (~v24 \/ ~v31 \/ ~v91) /\
 (~v17 \/ v32 \/ v60) /\
 (~v17 \/ v39 \/ ~v60) /\
 (v36 \/ v50 \/ v56) /\
 (~v50 \/ v56 \/ v91) /\
 (~v44 \/ v52 \/ ~v54) /\
 (~v52 \/ v53 \/ ~v54) /\
 (v71 \/ v79 \/ ~v97) /\
 (v9 \/ v71 \/ ~v79) /\
 (~v8 \/ v34 \/ ~v71) /\
 (v34 \/ ~v71 \/ v95) /\
 (~v56 \/ v85 \/ ~v95) /\
 (~v71 \/ ~v85 \/ ~v95) /\
 (~v18 \/ ~v56 \/ v87) /\
 (~v52 \/ ~v56 \/ v87) /\
 (~v7 \/ ~v76 \/ ~v93) /\
 (v3 \/ v9 \/ v86) /\
 (v3 \/ ~v86 \/ ~v96) /\
 (v3 \/ v12 \/ v67) /\
 (~v9 \/ ~v40 \/ v67) /\
 (~v9 \/ v13 \/ ~v67) /\
 (~v9 \/ ~v67 \/ ~v88) /\
 (~v3 \/ v13 \/ ~v96) /\
 (v2 \/ v12 \/ v27) /\
 (~v33 \/ v36 \/ ~v74) /\
 (~v13 \/ ~v29 \/ ~v41) /\
 (v11 \/ v52 \/ ~v98) /\
 (~v50 \/ v90 \/ v92) /\
 (~v26 \/ ~v47 \/ ~v77) /\
 (v5 \/ v42 \/ ~v93) /\
 (v28 \/ v36 \/ ~v42) /\
 (v5 \/ v28 \/ ~v36) /\
 (~v28 \/ v45 \/ ~v73) /\
 (v5 \/ ~v45 \/ ~v73) /\
 (v7 \/ v25 \/ ~v86) /\
 (~v25 \/ v37 \/ ~v86) /\
 (v19 \/ ~v25 \/ ~v37) /\
 (v7 \/ ~v19 \/ v41) /\
 (v12 \/ ~v34 \/ ~v47) /\
 (~v12 \/ ~v34 \/ ~v47) /\
 (~v13 \/ ~v60 \/ v93) /\
 (v19 \/ ~v94 \/ v98) /\
 (v92 \/ ~v94 \/ ~v98) /\
 (v67 \/ ~v92 \/ ~v98) /\
 (v1 \/ v26 \/ v55) /\
 (v26 \/ ~v53 \/ v55) /\
 (v18 \/ ~v29 \/ v31) /\
 (~v1 \/ v69 \/ v94) /\
 (v23 \/ v69 \/ ~v93) /\
 (~v1 \/ ~v23 \/ v69) /\
 (~v19 \/ v29 \/ v43) /\
 (v33 \/ v37 \/ v62) /\
 (~v20 \/ ~v33 \/ v62) /\
 (~v18 \/ v39 \/ v65) /\
 (v45 \/ v51 \/ ~v53) /\
 (~v1 \/ v11 \/ ~v28) /\
 (v18 \/ v33 \/ v84) /\
 (~v14 \/ ~v52 \/ v84) /\
 (v7 \/ ~v40 \/ ~v53) /\
 (~v7 \/ ~v17 \/ ~v40) /\
 (~v19 \/ v65 \/ v72) /\
 (~v63 \/ v77 \/ ~v85) /\
 (v27 \/ ~v63 \/ ~v77) /\
 (~v4 \/ v64 \/ v94) /\
 (v22 \/ ~v82 \/ v99) /\
 (~v11 \/ v41 \/ ~v99) /\
 (~v11 \/ v85 \/ ~v99) /\
 (v4 \/ ~v65 \/ ~v87) /\
 (v17 \/ v37 \/ v100) /\
 (v25 \/ ~v37 \/ v100) /\
 (v17 \/ ~v25 \/ ~v37) /\
 (v83 \/ ~v89 \/ ~v100) /\
 (v15 \/ v17 \/ ~v89) /\
 (~v15 \/ ~v83 \/ ~v100) /\
 (~v39 \/ ~v74 \/ ~v90) /\
 (v19 \/ ~v26 \/ v40) /\
 (v41 \/ ~v70 \/ ~v99) /\
 (~v26 \/ ~v41 \/ ~v70) /\
 (~v28 \/ v59 \/ ~v62) /\
 (v4 \/ v78 \/ v90) /\
 (v4 \/ v21 \/ v78) /\
 (v39 \/ ~v49 \/ v63) /\
 (~v39 \/ ~v49 \/ ~v95) /\
 (v48 \/ ~v54 \/ v65) /\
 (v60 \/ v82 \/ v98) /\
 (v49 \/ ~v74 \/ v97) /\
 (~v21 \/ v49 \/ ~v97) /\
 (~v79 \/ v87 \/ ~v88) /\
 (v21 \/ v45 \/ ~v75) /\
 (v16 \/ ~v84 \/ ~v89) /\
 (~v21 \/ ~v46 \/ v63) /\
 (v14 \/ v16 \/ ~v81) /\
 (~v14 \/ ~v81 \/ ~v87) /\
 (~v66 \/ ~v67 \/ ~v83) /\
 (~v80 \/ v81 \/ v100) /\
 (v2 \/ ~v29 \/ v99) /\
 (~v2 \/ ~v39 \/ v99) /\
 (~v44 \/ ~v64 \/ ~v90) /\
 (~v13 \/ v14 \/ v23) /\
 (~v10 \/ ~v45 \/ ~v91) /\
 (v10 \/ v40 \/ v73) /\
 (v40 \/ ~v73 \/ ~v76) /\
 (v22 \/ ~v76 \/ v78) /\
 (v21 \/ ~v32 \/ ~v57) /\
 (~v38 \/ ~v64 \/ v86) /\
 (~v12 \/ ~v15 \/ v54) /\
 (~v12 \/ v47 \/ ~v69) /\
 (v47 \/ ~v69 \/ ~v82) /\
 (~v22 \/ ~v23 \/ v32) /\
 (~v22 \/ ~v23 \/ ~v78) /\
 (~v10 \/ v20 \/ ~v50) /\
 (~v5 \/ v10 \/ v84) /\
 (v23 \/ ~v92 \/ v97) /\
 (~v69 \/ v72 \/ ~v78) /\
 (v1 \/ v11 \/ ~v80) /\
 (~v2 \/ v27 \/ v50) /\
 (~v57 \/ ~v61 \/ ~v79) /\
 (v43 \/ v76 \/ ~v90) /\
 (~v22 \/ ~v49 \/ ~v92) /\
 (v26 \/ v43 \/ ~v60) /\
 (~v10 \/ v50 \/ v98) /\
 (v10 \/ ~v30 \/ v59) /\
 (~v55 \/ ~v72 \/ ~v100) /\
 (~v41 \/ v53 \/ ~v78) /\
 (v38 \/ ~v65 \/ v94) /\
 (v38 \/ ~v65 \/ ~v94) /\
 (v29 \/ ~v55 \/ v61) /\
 (~v46 \/ ~v48 \/ v59) /\
 (v53 \/ v73 \/ v90) /\
 (v1 \/ ~v11 \/ v74) /\
 (v15 \/ v76 \/ v82) /\
 (~v27 \/ ~v82 \/ ~v97) /\
 (~v3 \/ ~v36 \/ ~v48) /\
 (v28 \/ ~v32 \/ v80) /\
 (v9 \/ ~v63 \/ v80) /\
 (v70 \/ v73 \/ v89) /\
 (~v80 \/ ~v91 \/ v93) /\
 (v22 \/ ~v64 \/ v77) /\
 (v66 \/ v72 \/ ~v87) /\
 (~v36 \/ v83 \/ v88) /\
 (v24 \/ ~v38 \/ v52) /\
 (~v43 \/ v81 \/ ~v96) /\
 (~v59 \/ ~v62 \/ v81) /\
 (v48 \/ v66 \/ v71) /\
 (~v2 \/ v48 \/ v63) /\
 (v29 \/ ~v83 \/ v93) /\
 (~v16 \/ v25 \/ ~v72) /\
 (~v27 \/ v57 \/ ~v84) /\
 (~v5 \/ v77 \/ v88) /\
 (~v5 \/ ~v59 \/ v88) /\
 (v15 \/ v44 \/ ~v45) /\
 (v13 \/ ~v84 \/ v89) /\
 (v47 \/ ~v48 \/ v83) /\
 (~v14 \/ ~v44 \/ v54) /\
 (~v30 \/ v31 \/ v64) /\
 (v24 \/ v70 \/ v75) /\
 (~v15 \/ ~v32 \/ v92) /\
 (~v16 \/ ~v58 \/ v74) /\
 (~v4 \/ v54 \/ ~v77) /\
 (~v43 \/ v57 \/ v60) /\
 (~v16 \/ v61 \/ v64) /\
 (~v59 \/ v79 \/ v95) /\
 (~v4 \/ ~v61 \/ ~v88) /\
 (v58 \/ v74 \/ v80) /\
 (v49 \/ ~v58 \/ v82) /\
 (v16 \/ v44 \/ ~v57) /\
 (v2 \/ v89 \/ v95) /\
 (~v3 \/ ~v27 \/ ~v81) /\
 (v24 \/ v75 \/ v79) /\
 (v44 \/ v96 \/ v97) /\
 (v31 \/ ~v38 \/ v57) /\
 (v14 \/ ~v43 \/ ~v72) /\
 (v38 \/ v76 \/ v96) /\
 (v30 \/ v32 \/ v96) /\
 (~v21 \/ v35 \/ v56))` ;


val aim_100_2_0_no_2 = bdd_oracle
`~
((v40 \/ v54 \/ v75) /\
 (~v40 \/ v54 \/ v58) /\
 (~v40 \/ ~v58 \/ v69) /\
 (~v40 \/ ~v69 \/ v95) /\
 (~v51 \/ ~v69 \/ v95) /\
 (v64 \/ v75 \/ v89) /\
 (v26 \/ ~v64 \/ v89) /\
 (v26 \/ ~v69 \/ ~v95) /\
 (~v26 \/ v75 \/ ~v95) /\
 (v11 \/ v28 \/ v82) /\
 (~v11 \/ v23 \/ v82) /\
 (v14 \/ ~v23 \/ v28) /\
 (~v11 \/ ~v14 \/ v28) /\
 (~v28 \/ ~v75 \/ v88) /\
 (~v28 \/ v84 \/ ~v88) /\
 (v62 \/ ~v75 \/ ~v84) /\
 (v12 \/ v51 \/ ~v62) /\
 (v12 \/ ~v51 \/ ~v62) /\
 (~v12 \/ v43 \/ v65) /\
 (~v12 \/ ~v65 \/ v82) /\
 (~v12 \/ ~v28 \/ ~v43) /\
 (v54 \/ ~v75 \/ ~v82) /\
 (~v54 \/ v77 \/ v86) /\
 (v8 \/ ~v86 \/ v94) /\
 (~v8 \/ v36 \/ ~v86) /\
 (~v8 \/ ~v36 \/ ~v86) /\
 (v24 \/ v77 \/ ~v94) /\
 (v4 \/ v7 \/ v78) /\
 (v4 \/ ~v78 \/ v84) /\
 (v4 \/ v7 \/ ~v84) /\
 (~v4 \/ v7 \/ ~v77) /\
 (~v7 \/ v63 \/ v76) /\
 (~v7 \/ v24 \/ ~v63) /\
 (~v7 \/ ~v55 \/ ~v63) /\
 (v24 \/ ~v76 \/ v93) /\
 (~v76 \/ ~v77 \/ ~v93) /\
 (v6 \/ ~v24 \/ v98) /\
 (v6 \/ v94 \/ ~v98) /\
 (~v6 \/ ~v54 \/ v94) /\
 (v62 \/ ~v94 \/ v96) /\
 (~v62 \/ ~v94 \/ v96) /\
 (~v54 \/ ~v88 \/ v96) /\
 (v20 \/ ~v24 \/ ~v96) /\
 (~v20 \/ ~v24 \/ ~v96) /\
 (v20 \/ v27 \/ v32) /\
 (~v20 \/ v27 \/ v32) /\
 (~v15 \/ ~v53 \/ v78) /\
 (v26 \/ v44 \/ ~v46) /\
 (~v26 \/ v44 \/ ~v89) /\
 (v12 \/ v35 \/ ~v39) /\
 (v1 \/ ~v51 \/ ~v80) /\
 (~v3 \/ v21 \/ v60) /\
 (~v3 \/ ~v48 \/ v60) /\
 (~v48 \/ ~v60 \/ v100) /\
 (~v48 \/ ~v60 \/ v61) /\
 (~v60 \/ ~v61 \/ ~v100) /\
 (v9 \/ ~v22 \/ ~v93) /\
 (~v21 \/ v44 \/ v93) /\
 (~v44 \/ v46 \/ v69) /\
 (~v46 \/ v69 \/ v93) /\
 (v13 \/ ~v46 \/ ~v85) /\
 (~v13 \/ ~v44 \/ ~v85) /\
 (v41 \/ v43 \/ v84) /\
 (~v41 \/ v43 \/ v87) /\
 (~v37 \/ v49 \/ v74) /\
 (~v29 \/ ~v37 \/ ~v70) /\
 (~v37 \/ v49 \/ ~v74) /\
 (v33 \/ v35 \/ v41) /\
 (~v15 \/ v33 \/ v41) /\
 (~v5 \/ ~v43 \/ ~v85) /\
 (~v92 \/ ~v93 \/ ~v98) /\
 (v15 \/ v50 \/ v63) /\
 (~v21 \/ ~v58 \/ v87) /\
 (v25 \/ ~v39 \/ ~v97) /\
 (~v25 \/ v51 \/ ~v97) /\
 (~v25 \/ ~v39 \/ ~v97) /\
 (~v4 \/ ~v38 \/ ~v52) /\
 (v59 \/ v79 \/ v95) /\
 (v14 \/ v59 \/ ~v79) /\
 (v76 \/ ~v89 \/ v99) /\
 (v40 \/ v76 \/ ~v99) /\
 (v40 \/ ~v76 \/ ~v89) /\
 (~v5 \/ ~v22 \/ v46) /\
 (~v31 \/ v86 \/ v100) /\
 (v10 \/ v31 \/ v62) /\
 (v14 \/ v31 \/ v58) /\
 (v10 \/ v31 \/ ~v58) /\
 (~v30 \/ v42 \/ ~v67) /\
 (~v21 \/ ~v30 \/ v42) /\
 (~v30 \/ v42 \/ ~v77) /\
 (v5 \/ ~v11 \/ v13) /\
 (v11 \/ ~v26 \/ v92) /\
 (v15 \/ v38 \/ v83) /\
 (~v13 \/ v56 \/ ~v100) /\
 (~v16 \/ v47 \/ v87) /\
 (v47 \/ v83 \/ ~v87) /\
 (v6 \/ ~v35 \/ v92) /\
 (~v6 \/ ~v65 \/ v92) /\
 (v61 \/ v66 \/ ~v82) /\
 (~v1 \/ ~v18 \/ v68) /\
 (~v18 \/ v52 \/ ~v68) /\
 (v32 \/ v64 \/ ~v96) /\
 (~v8 \/ v35 \/ ~v67) /\
 (v10 \/ ~v83 \/ ~v90) /\
 (~v10 \/ ~v32 \/ ~v91) /\
 (v20 \/ v68 \/ v72) /\
 (v16 \/ v85 \/ ~v95) /\
 (v9 \/ v29 \/ v30) /\
 (~v1 \/ ~v29 \/ v30) /\
 (v39 \/ v45 \/ v51) /\
 (v39 \/ v45 \/ ~v82) /\
 (v19 \/ v70 \/ v88) /\
 (~v19 \/ ~v45 \/ v88) /\
 (~v36 \/ ~v45 \/ ~v70) /\
 (~v59 \/ ~v70 \/ ~v81) /\
 (~v1 \/ ~v52 \/ v81) /\
 (v15 \/ ~v35 \/ v55) /\
 (~v18 \/ ~v45 \/ v48) /\
 (~v35 \/ ~v53 \/ ~v68) /\
 (v16 \/ ~v38 \/ ~v64) /\
 (v27 \/ v46 \/ v57) /\
 (v9 \/ ~v27 \/ v57) /\
 (~v32 \/ ~v43 \/ v70) /\
 (~v23 \/ v34 \/ ~v67) /\
 (v55 \/ v85 \/ ~v92) /\
 (v18 \/ ~v25 \/ v48) /\
 (~v36 \/ v67 \/ ~v78) /\
 (~v59 \/ v66 \/ v86) /\
 (~v4 \/ ~v44 \/ v60) /\
 (~v20 \/ ~v31 \/ ~v78) /\
 (~v61 \/ ~v80 \/ v97) /\
 (v21 \/ ~v84 \/ v91) /\
 (v22 \/ v52 \/ ~v90) /\
 (v73 \/ ~v83 \/ ~v98) /\
 (v13 \/ v80 \/ ~v91) /\
 (v1 \/ ~v15 \/ v19) /\
 (v64 \/ v83 \/ v90) /\
 (v16 \/ v33 \/ v99) /\
 (~v16 \/ ~v65 \/ v99) /\
 (~v16 \/ v53 \/ ~v74) /\
 (v53 \/ ~v63 \/ v85) /\
 (v17 \/ v61 \/ ~v80) /\
 (v3 \/ v17 \/ ~v61) /\
 (~v41 \/ v74 \/ ~v83) /\
 (v47 \/ ~v72 \/ ~v73) /\
 (v8 \/ v30 \/ v72) /\
 (~v27 \/ ~v34 \/ v53) /\
 (v1 \/ v56 \/ v97) /\
 (v29 \/ ~v68 \/ v79) /\
 (v67 \/ ~v73 \/ ~v92) /\
 (v18 \/ ~v57 \/ v89) /\
 (v22 \/ v36 \/ v91) /\
 (~v14 \/ ~v23 \/ v56) /\
 (~v52 \/ v68 \/ v100) /\
 (v37 \/ ~v38 \/ ~v50) /\
 (~v13 \/ ~v33 \/ v57) /\
 (v55 \/ v58 \/ v59) /\
 (v19 \/ v36 \/ v37) /\
 (~v19 \/ v78 \/ v97) /\
 (v3 \/ ~v14 \/ v37) /\
 (~v5 \/ ~v57 \/ v98) /\
 (~v9 \/ v72 \/ ~v87) /\
 (v48 \/ ~v90 \/ ~v99) /\
 (v23 \/ ~v55 \/ ~v99) /\
 (v39 \/ ~v64 \/ ~v81) /\
 (v66 \/ v81 \/ ~v87) /\
 (~v17 \/ ~v41 \/ v90) /\
 (~v17 \/ ~v53 \/ ~v57) /\
 (~v47 \/ ~v79 \/ v80) /\
 (~v3 \/ ~v42 \/ ~v56) /\
 (v3 \/ ~v27 \/ ~v33) /\
 (~v6 \/ v22 \/ ~v34) /\
 (~v22 \/ ~v34 \/ v81) /\
 (~v2 \/ v23 \/ v73) /\
 (v29 \/ ~v55 \/ ~v59) /\
 (~v10 \/ v65 \/ ~v79) /\
 (v34 \/ v63 \/ v79) /\
 (v67 \/ ~v71 \/ ~v88) /\
 (v38 \/ ~v50 \/ v90) /\
 (~v10 \/ v25 \/ v98) /\
 (v52 \/ v73 \/ ~v91) /\
 (v45 \/ ~v73 \/ v91) /\
 (v25 \/ v34 \/ v38) /\
 (~v9 \/ ~v47 \/ ~v72) /\
 (v5 \/ v8 \/ ~v17) /\
 (v2 \/ ~v32 \/ v71) /\
 (~v9 \/ v65 \/ v80) /\
 (~v47 \/ ~v49 \/ ~v66) /\
 (~v19 \/ ~v33 \/ ~v50) /\
 (~v42 \/ ~v56 \/ ~v66) /\
 (v17 \/ ~v56 \/ ~v74) /\
 (v5 \/ ~v31 \/ v77) /\
 (v2 \/ v11 \/ ~v100) /\
 (v18 \/ ~v49 \/ v71) /\
 (v2 \/ ~v2 \/ v49) /\
 (v50 \/ v70 \/ ~v72) /\
 (v21 \/ ~v42 \/ v74) /\
 (~v49 \/ ~v71 \/ ~v81) /\
 (~v29 \/ ~v66 \/ v71) /\
 (~v2 \/ v50 \/ ~v71))` ;

val prv001_1 = bdd_oracle
`~((~v0 \/ ~v111 \/ v47) /\
  (~v1 \/ ~v111 \/ v37) /\
  (~v2 \/ ~v111 \/ v28) /\
  (~v114 \/ ~v113 \/ v46) /\
  (~v3 \/ ~v113 \/ v36) /\
  (~v4 \/ ~v113 \/ v27) /\
  (~v5 \/ ~v105 \/ v44) /\
  (~v6 \/ ~v105 \/ v35) /\
  (~v7 \/ ~v105 \/ v26) /\
  (~v8 \/ ~v112 \/ v51) /\
  (~v9 \/ ~v112 \/ v40) /\
  (~v10 \/ ~v112 \/ v31) /\
  (~v11 \/ ~v109 \/ v50) /\
  (~v12 \/ ~v109 \/ v39) /\
  (~v13 \/ ~v109 \/ v30) /\
  (~v14 \/ ~v106 \/ v48) /\
  (~v15 \/ ~v106 \/ v38) /\
  (~v16 \/ ~v106 \/ v29) /\
  (~v17 \/ ~v103 \/ v56) /\
  (~v18 \/ ~v103 \/ v43) /\
  (~v19 \/ ~v103 \/ v34) /\
  (~v20 \/ ~v107 \/ v54) /\
  (~v21 \/ ~v107 \/ v42) /\
  (~v22 \/ ~v107 \/ v33) /\
  (~v23 \/ ~v102 \/ v53) /\
  (~v24 \/ ~v102 \/ v41) /\
  (~v25 \/ ~v102 \/ v32) /\
  (~v0 \/ v111 \/ v80) /\
  (~v1 \/ v111 \/ v69) /\
  (~v2 \/ v111 \/ v60) /\
  (~v114 \/ v113 \/ v86) /\
  (~v3 \/ v113 \/ v72) /\
  (~v4 \/ v113 \/ v63) /\
  (~v5 \/ v105 \/ v91) /\
  (~v6 \/ v105 \/ v75) /\
  (~v7 \/ v105 \/ v66) /\
  (~v8 \/ v112 \/ v78) /\
  (~v9 \/ v112 \/ v68) /\
  (~v10 \/ v112 \/ v59) /\
  (~v11 \/ v109 \/ v84) /\
  (~v12 \/ v109 \/ v71) /\
  (~v13 \/ v109 \/ v62) /\
  (~v14 \/ v106 \/ v89) /\
  (~v15 \/ v106 \/ v74) /\
  (~v16 \/ v106 \/ v65) /\
  (~v17 \/ v103 \/ v76) /\
  (~v18 \/ v103 \/ v67) /\
  (~v19 \/ v103 \/ v58) /\
  (~v20 \/ v107 \/ v82) /\
  (~v21 \/ v107 \/ v70) /\
  (~v22 \/ v107 \/ v61) /\
  (~v23 \/ v102 \/ v87) /\
  (~v24 \/ v102 \/ v73) /\
  (~v25 \/ v102 \/ v64) /\
  (~v26 \/ v45) /\
  (~v27 \/ v108) /\
  (~v28 \/ v81) /\
  (~v29 \/ v49) /\
  (~v30 \/ v85) /\
  (~v31 \/ v52) /\
  (~v32 \/ v88) /\
  (~v33 \/ v55) /\
  (~v34 \/ v57) /\
  (~v35 \/ v45) /\
  (~v36 \/ v108) /\
  (~v37 \/ v81) /\
  (~v38 \/ v49) /\
  (~v39 \/ v85) /\
  (~v40 \/ v52) /\
  (~v41 \/ v88) /\
  (~v42 \/ v55) /\
  (~v43 \/ v57) /\
  (~v44 \/ v45) /\
  (~v46 \/ v108) /\
  (~v47 \/ v81) /\
  (~v48 \/ v49) /\
  (~v50 \/ v85) /\
  (~v51 \/ v52) /\
  (~v53 \/ v88) /\
  (~v54 \/ v55) /\
  (~v56 \/ v57) /\
  (~v58 \/ v77) /\
  (~v59 \/ v79) /\
  (~v60 \/ v81) /\
  (~v61 \/ v83) /\
  (~v62 \/ v85) /\
  (~v63 \/ v110) /\
  (~v64 \/ v88) /\
  (~v65 \/ v90) /\
  (~v66 \/ v92) /\
  (~v67 \/ v77) /\
  (~v68 \/ v79) /\
  (~v69 \/ v81) /\
  (~v70 \/ v83) /\
  (~v71 \/ v85) /\
  (~v72 \/ v110) /\
  (~v73 \/ v88) /\
  (~v74 \/ v90) /\
  (~v75 \/ v92) /\
  (~v76 \/ v77) /\
  (~v78 \/ v79) /\
  (~v80 \/ v81) /\
  (~v82 \/ v83) /\
  (~v84 \/ v85) /\
  (~v86 \/ v110) /\
  (~v87 \/ v88) /\
  (~v89 \/ v90) /\
  (~v91 \/ v92) /\
  v102 /\
  v109 /\
  v111 /\
  (~v105 \/ ~v103 \/ v93) /\
  (~v113 \/ ~v112 \/ v94) /\
  (~v111 \/ ~v111 \/ v95) /\
  (~v106 \/ ~v107 \/ v96) /\
  (~v109 \/ ~v109 \/ v97) /\
  (~v112 \/ ~v113 \/ v98) /\
  (~v102 \/ ~v102 \/ v99) /\
  (~v107 \/ ~v106 \/ v100) /\
  (~v103 \/ ~v105 \/ v101) /\
  (~v111 \/ ~v105 \/ v105) /\
  (~v111 \/ ~v113 \/ v113) /\
  (~v111 \/ ~v111 \/ v111) /\
  (~v112 \/ ~v105 \/ v106) /\
  (~v112 \/ ~v113 \/ v109) /\
  (~v112 \/ ~v111 \/ v112) /\
  (~v103 \/ ~v105 \/ v102) /\
  (~v103 \/ ~v113 \/ v107) /\
  (~v103 \/ ~v111 \/ v103) /\
  (~v113 \/ ~v106 \/ v105) /\
  (~v113 \/ ~v109 \/ v113) /\
  (~v113 \/ ~v112 \/ v111) /\
  (~v109 \/ ~v106 \/ v106) /\
  (~v109 \/ ~v109 \/ v109) /\
  (~v109 \/ ~v112 \/ v112) /\
  (~v107 \/ ~v106 \/ v102) /\
  (~v107 \/ ~v109 \/ v107) /\
  (~v107 \/ ~v112 \/ v103) /\
  (~v105 \/ ~v102 \/ v105) /\
  (~v105 \/ ~v107 \/ v113) /\
  (~v105 \/ ~v103 \/ v111) /\
  (~v106 \/ ~v102 \/ v106) /\
  (~v106 \/ ~v107 \/ v109) /\
  (~v106 \/ ~v103 \/ v112) /\
  (~v102 \/ ~v102 \/ v102) /\
  (~v102 \/ ~v107 \/ v107) /\
  (~v102 \/ ~v103 \/ v103) /\
  (v103 \/ v105) /\
  (v112 \/ v113) /\
  (v111 \/ v111) /\
  (v107 \/ v106) /\
  (v109 \/ v109) /\
  (v113 \/ v112) /\
  (v102 \/ v102) /\
  (v106 \/ v107) /\
  (v105 \/ v103) /\
  (~v93 \/ v105) /\
  (~v94 \/ v113) /\
  (~v95 \/ v111) /\
  (~v96 \/ v106) /\
  (~v97 \/ v109) /\
  (~v98 \/ v112) /\
  (~v99 \/ v102) /\
  (~v100 \/ v107) /\
  (~v101 \/ v103) /\
  (~v95 \/ ~v105 \/ v105) /\
  (~v95 \/ ~v113 \/ v113) /\
  (~v95 \/ ~v111 \/ v111) /\
  (~v94 \/ ~v105 \/ v106) /\
  (~v94 \/ ~v113 \/ v109) /\
  (~v94 \/ ~v111 \/ v112) /\
  (~v93 \/ ~v105 \/ v102) /\
  (~v93 \/ ~v113 \/ v107) /\
  (~v93 \/ ~v111 \/ v103) /\
  (~v98 \/ ~v106 \/ v105) /\
  (~v98 \/ ~v109 \/ v113) /\
  (~v98 \/ ~v112 \/ v111) /\
  (~v97 \/ ~v106 \/ v106) /\
  (~v97 \/ ~v109 \/ v109) /\
  (~v97 \/ ~v112 \/ v112) /\
  (~v96 \/ ~v106 \/ v102) /\
  (~v96 \/ ~v109 \/ v107) /\
  (~v96 \/ ~v112 \/ v103) /\
  (~v101 \/ ~v102 \/ v105) /\
  (~v101 \/ ~v107 \/ v113) /\
  (~v101 \/ ~v103 \/ v111) /\
  (~v100 \/ ~v102 \/ v106) /\
  (~v100 \/ ~v107 \/ v109) /\
  (~v100 \/ ~v103 \/ v112) /\
  (~v99 \/ ~v102 \/ v102) /\
  (~v99 \/ ~v107 \/ v107) /\
  (~v99 \/ ~v103 \/ v103) /\
  (~v93 \/ ~v111 \/ v105) /\
  (~v94 \/ ~v111 \/ v113) /\
  (~v95 \/ ~v111 \/ v111) /\
  (~v93 \/ ~v112 \/ v106) /\
  (~v94 \/ ~v112 \/ v109) /\
  (~v95 \/ ~v112 \/ v112) /\
  (~v93 \/ ~v103 \/ v102) /\
  (~v94 \/ ~v103 \/ v107) /\
  (~v95 \/ ~v103 \/ v103) /\
  (~v96 \/ ~v113 \/ v105) /\
  (~v97 \/ ~v113 \/ v113) /\
  (~v98 \/ ~v113 \/ v111) /\
  (~v96 \/ ~v109 \/ v106) /\
  (~v97 \/ ~v109 \/ v109) /\
  (~v98 \/ ~v109 \/ v112) /\
  (~v96 \/ ~v107 \/ v102) /\
  (~v97 \/ ~v107 \/ v107) /\
  (~v98 \/ ~v107 \/ v103) /\
  (~v99 \/ ~v105 \/ v105) /\
  (~v100 \/ ~v105 \/ v113) /\
  (~v101 \/ ~v105 \/ v111) /\
  (~v99 \/ ~v106 \/ v106) /\
  (~v100 \/ ~v106 \/ v109) /\
  (~v101 \/ ~v106 \/ v112) /\
  (~v99 \/ ~v102 \/ v102) /\
  (~v100 \/ ~v102 \/ v107) /\
  (~v101 \/ ~v102 \/ v103) /\
  (~v104 \/ ~v105 \/ ~v106 \/ ~v103) /\
  (~v108 \/ ~v113 \/ ~v109 \/ ~v112) /\
  (~v110 \/ ~v111 \/ ~v112 \/ ~v111) /\
  (~v104 \/ ~v105 \/ ~v106 \/ ~v107) /\
  (~v108 \/ ~v113 \/ ~v109 \/ ~v109) /\
  (~v110 \/ ~v111 \/ ~v112 \/ ~v113) /\
  v114)` ;

val ssa0432_003 = bdd_oracle
`~
((v435) /\
 (v174) /\
 (~v175) /\
 (v173) /\
 (~v39 \/ ~v433) /\
 (v37 \/ ~v433) /\
 (v39 \/ ~v434) /\
 (~v37 \/ ~v434) /\
 (~v434 \/ v432) /\
 (~v433 \/ v432) /\
 (~v79 \/ ~v37) /\
 (~v67 \/ ~v37) /\
 (~v68 \/ v38) /\
 (~v68 \/ ~v79) /\
 (~v79 \/ ~v39) /\
 (~v69 \/ ~v39) /\
 (~v76 \/ ~v67) /\
 (~v71 \/ ~v67) /\
 (~v74 \/ ~v67) /\
 (~v138 \/ ~v67) /\
 (~v72 \/ v68) /\
 (~v72 \/ ~v138) /\
 (~v72 \/ ~v74) /\
 (~v72 \/ ~v76) /\
 (~v76 \/ ~v69) /\
 (~v73 \/ ~v69) /\
 (~v74 \/ ~v69) /\
 (~v138 \/ ~v69) /\
 (v75 \/ ~v138) /\
 (~v75 \/ v138) /\
 (v75 \/ ~v139) /\
 (~v75 \/ v139) /\
 (v75 \/ ~v147) /\
 (~v75 \/ v147) /\
 (~v311 \/ ~v75) /\
 (~v307 \/ ~v75) /\
 (v312 \/ v307) /\
 (~v312 \/ ~v307) /\
 (v15 \/ ~v315) /\
 (~v15 \/ v315) /\
 (v15 \/ ~v316) /\
 (~v15 \/ v316) /\
 (v53 \/ ~v93) /\
 (~v53 \/ v93) /\
 (v53 \/ ~v94) /\
 (~v53 \/ v94) /\
 (v53 \/ ~v98) /\
 (~v53 \/ v98) /\
 (v53 \/ ~v102) /\
 (~v53 \/ v102) /\
 (v53 \/ ~v105) /\
 (~v53 \/ v105) /\
 (v53 \/ ~v119) /\
 (~v53 \/ v119) /\
 (v53 \/ ~v121) /\
 (~v53 \/ v121) /\
 (v53 \/ ~v124) /\
 (~v53 \/ v124) /\
 (v53 \/ ~v129) /\
 (~v53 \/ v129) /\
 (v53 \/ ~v169) /\
 (~v53 \/ v169) /\
 (v53 \/ ~v207) /\
 (~v53 \/ v207) /\
 (v53 \/ ~v221) /\
 (~v53 \/ v221) /\
 (v53 \/ ~v244) /\
 (~v53 \/ v244) /\
 (v53 \/ ~v250) /\
 (~v53 \/ v250) /\
 (v53 \/ ~v304) /\
 (~v53 \/ v304) /\
 (v53 \/ ~v314) /\
 (~v53 \/ v314) /\
 (v53 \/ ~v330) /\
 (~v53 \/ v330) /\
 (v53 \/ ~v343) /\
 (~v53 \/ v343) /\
 (v53 \/ ~v345) /\
 (~v53 \/ v345) /\
 (v53 \/ ~v360) /\
 (~v53 \/ v360) /\
 (v53 \/ ~v378) /\
 (~v53 \/ v378) /\
 (v60 \/ v53) /\
 (v263 \/ v53) /\
 (v176 \/ v53) /\
 (v182 \/ v53) /\
 (v188 \/ v182) /\
 (~v188 \/ ~v182) /\
 (v104 \/ ~v187) /\
 (~v104 \/ v187) /\
 (v104 \/ ~v188) /\
 (~v104 \/ v188) /\
 (~v196 \/ ~v104) /\
 (~v191 \/ ~v104) /\
 (~v193 \/ ~v104) /\
 (v184 \/ ~v192) /\
 (~v184 \/ v192) /\
 (v184 \/ ~v193) /\
 (~v184 \/ v193) /\
 (v184 \/ ~v200) /\
 (~v184 \/ v200) /\
 (v184 \/ ~v203) /\
 (~v184 \/ v203) /\
 (v34 \/ v184) /\
 (~v34 \/ ~v184) /\
 (v12 \/ ~v190) /\
 (~v12 \/ v190) /\
 (v12 \/ ~v191) /\
 (~v12 \/ v191) /\
 (v189 \/ ~v196) /\
 (~v189 \/ v196) /\
 (v189 \/ ~v197) /\
 (~v189 \/ v197) /\
 (~v271 \/ ~v422) /\
 (v195 \/ ~v422) /\
 (v271 \/ ~v423) /\
 (~v195 \/ ~v423) /\
 (~v423 \/ v189) /\
 (~v422 \/ v189) /\
 (v42 \/ ~v80) /\
 (~v42 \/ v80) /\
 (v42 \/ ~v81) /\
 (~v42 \/ v81) /\
 (v42 \/ ~v84) /\
 (~v42 \/ v84) /\
 (v42 \/ ~v101) /\
 (~v42 \/ v101) /\
 (v42 \/ ~v112) /\
 (~v42 \/ v112) /\
 (v42 \/ ~v166) /\
 (~v42 \/ v166) /\
 (v42 \/ ~v195) /\
 (~v42 \/ v195) /\
 (v42 \/ ~v218) /\
 (~v42 \/ v218) /\
 (v42 \/ ~v241) /\
 (~v42 \/ v241) /\
 (v42 \/ ~v259) /\
 (~v42 \/ v259) /\
 (v42 \/ ~v291) /\
 (~v42 \/ v291) /\
 (v42 \/ ~v303) /\
 (~v42 \/ v303) /\
 (v42 \/ ~v313) /\
 (~v42 \/ v313) /\
 (v42 \/ ~v323) /\
 (~v42 \/ v323) /\
 (v42 \/ ~v344) /\
 (~v42 \/ v344) /\
 (v42 \/ ~v349) /\
 (~v42 \/ v349) /\
 (v42 \/ ~v357) /\
 (~v42 \/ v357) /\
 (v42 \/ ~v385) /\
 (~v42 \/ v385) /\
 (v42 \/ ~v404) /\
 (~v42 \/ v404) /\
 (v286 \/ v42) /\
 (v267 \/ v42) /\
 (v43 \/ v42) /\
 (v278 \/ v42) /\
 (v347 \/ v278) /\
 (~v347 \/ ~v278) /\
 (v279 \/ ~v347) /\
 (~v279 \/ v347) /\
 (v279 \/ ~v348) /\
 (~v279 \/ v348) /\
 (~v369 \/ ~v279) /\
 (~v370 \/ ~v279) /\
 (v281 \/ ~v284) /\
 (~v281 \/ v284) /\
 (v281 \/ ~v285) /\
 (~v281 \/ v285) /\
 (v281 \/ ~v301) /\
 (~v281 \/ v301) /\
 (v281 \/ ~v370) /\
 (~v281 \/ v370) /\
 (v26 \/ v281) /\
 (~v26 \/ ~v281) /\
 (v7 \/ ~v368) /\
 (~v7 \/ v368) /\
 (v7 \/ ~v369) /\
 (~v7 \/ v369) /\
 (~v110 \/ ~v43) /\
 (~v46 \/ ~v43) /\
 (v41 \/ ~v45) /\
 (~v41 \/ v45) /\
 (v41 \/ ~v46) /\
 (~v41 \/ v46) /\
 (~v219 \/ ~v41) /\
 (~v211 \/ ~v41) /\
 (v204 \/ ~v211) /\
 (~v204 \/ v211) /\
 (v204 \/ ~v212) /\
 (~v204 \/ v212) /\
 (v214 \/ v204) /\
 (~v214 \/ ~v204) /\
 (v32 \/ ~v214) /\
 (~v32 \/ v214) /\
 (v32 \/ ~v215) /\
 (~v32 \/ v215) /\
 (v32 \/ ~v228) /\
 (~v32 \/ v228) /\
 (v5 \/ ~v219) /\
 (~v5 \/ v219) /\
 (v5 \/ ~v220) /\
 (~v5 \/ v220) /\
 (v44 \/ ~v110) /\
 (~v44 \/ v110) /\
 (v44 \/ ~v111) /\
 (~v44 \/ v111) /\
 (~v358 \/ ~v44) /\
 (~v355 \/ ~v44) /\
 (v350 \/ ~v353) /\
 (~v350 \/ v353) /\
 (v350 \/ ~v354) /\
 (~v350 \/ v354) /\
 (v350 \/ ~v355) /\
 (~v350 \/ v355) /\
 (v350 \/ ~v367) /\
 (~v350 \/ v367) /\
 (v9 \/ v350) /\
 (~v9 \/ ~v350) /\
 (v21 \/ ~v358) /\
 (~v21 \/ v358) /\
 (v21 \/ ~v359) /\
 (~v21 \/ v359) /\
 (~v270 \/ ~v267) /\
 (~v268 \/ ~v267) /\
 (~v272 \/ ~v267) /\
 (v194 \/ ~v271) /\
 (~v194 \/ v271) /\
 (v194 \/ ~v272) /\
 (~v194 \/ v272) /\
 (~v202 \/ ~v194) /\
 (~v203 \/ ~v194) /\
 (v25 \/ ~v201) /\
 (~v25 \/ v201) /\
 (v25 \/ ~v202) /\
 (~v25 \/ v202) /\
 (v331 \/ v268) /\
 (v324 \/ v268) /\
 (v332 \/ v268) /\
 (v402 \/ v332) /\
 (~v402 \/ ~v332) /\
 (v391 \/ ~v402) /\
 (~v391 \/ v402) /\
 (v391 \/ ~v403) /\
 (~v391 \/ v403) /\
 (~v400 \/ ~v391) /\
 (~v401 \/ ~v391) /\
 (v392 \/ ~v397) /\
 (~v392 \/ v397) /\
 (v392 \/ ~v398) /\
 (~v392 \/ v398) /\
 (v392 \/ ~v401) /\
 (~v392 \/ v401) /\
 (v392 \/ ~v409) /\
 (~v392 \/ v409) /\
 (v19 \/ v392) /\
 (~v19 \/ ~v392) /\
 (v17 \/ ~v399) /\
 (~v17 \/ v399) /\
 (v17 \/ ~v400) /\
 (~v17 \/ v400) /\
 (v326 \/ v324) /\
 (~v326 \/ ~v324) /\
 (v322 \/ ~v325) /\
 (~v322 \/ v325) /\
 (v322 \/ ~v326) /\
 (~v322 \/ v326) /\
 (~v389 \/ ~v322) /\
 (~v390 \/ ~v322) /\
 (v235 \/ ~v386) /\
 (~v235 \/ v386) /\
 (v235 \/ ~v387) /\
 (~v235 \/ v387) /\
 (v235 \/ ~v390) /\
 (~v235 \/ v390) /\
 (v383 \/ v235) /\
 (~v383 \/ ~v235) /\
 (v35 \/ ~v382) /\
 (~v35 \/ v382) /\
 (v35 \/ ~v383) /\
 (~v35 \/ v383) /\
 (v30 \/ ~v388) /\
 (~v30 \/ v388) /\
 (v30 \/ ~v389) /\
 (~v30 \/ v389) /\
 (v334 \/ v331) /\
 (~v334 \/ ~v331) /\
 (v83 \/ ~v333) /\
 (~v83 \/ v333) /\
 (v83 \/ ~v334) /\
 (~v83 \/ v334) /\
 (~v320 \/ ~v83) /\
 (~v321 \/ ~v83) /\
 (v86 \/ ~v91) /\
 (~v86 \/ v91) /\
 (v86 \/ ~v92) /\
 (~v86 \/ v92) /\
 (v86 \/ ~v158) /\
 (~v86 \/ v158) /\
 (v86 \/ ~v321) /\
 (~v86 \/ v321) /\
 (v28 \/ v86) /\
 (~v28 \/ ~v86) /\
 (v4 \/ ~v317) /\
 (~v4 \/ v317) /\
 (v4 \/ ~v320) /\
 (~v4 \/ v320) /\
 (v237 \/ ~v269) /\
 (~v237 \/ v269) /\
 (v237 \/ ~v270) /\
 (~v237 \/ v270) /\
 (~v242 \/ ~v237) /\
 (~v239 \/ ~v237) /\
 (v232 \/ ~v238) /\
 (~v232 \/ v238) /\
 (v232 \/ ~v239) /\
 (~v232 \/ v239) /\
 (v253 \/ v232) /\
 (~v253 \/ ~v232) /\
 (v6 \/ ~v253) /\
 (~v6 \/ v253) /\
 (v6 \/ ~v254) /\
 (~v6 \/ v254) /\
 (v6 \/ ~v258) /\
 (~v6 \/ v258) /\
 (v10 \/ ~v242) /\
 (~v10 \/ v242) /\
 (v10 \/ ~v243) /\
 (~v10 \/ v243) /\
 (v289 \/ v286) /\
 (~v289 \/ ~v286) /\
 (v287 \/ ~v289) /\
 (~v287 \/ v289) /\
 (v287 \/ ~v290) /\
 (~v287 \/ v290) /\
 (~v372 \/ ~v287) /\
 (~v373 \/ ~v287) /\
 (v292 \/ ~v295) /\
 (~v292 \/ v295) /\
 (v292 \/ ~v296) /\
 (~v292 \/ v296) /\
 (v292 \/ ~v311) /\
 (~v292 \/ v311) /\
 (v292 \/ ~v373) /\
 (~v292 \/ v373) /\
 (v27 \/ v292) /\
 (~v27 \/ ~v292) /\
 (v11 \/ ~v371) /\
 (~v11 \/ v371) /\
 (v11 \/ ~v372) /\
 (~v11 \/ v372) /\
 (~v180 \/ ~v176) /\
 (~v328 \/ ~v176) /\
 (~v276 \/ ~v176) /\
 (v178 \/ ~v276) /\
 (~v178 \/ v276) /\
 (v178 \/ ~v277) /\
 (~v178 \/ v277) /\
 (v178 \/ ~v342) /\
 (~v178 \/ v342) /\
 (~v405 \/ ~v178) /\
 (~v396 \/ ~v178) /\
 (~v398 \/ ~v178) /\
 (v18 \/ ~v395) /\
 (~v18 \/ v395) /\
 (v18 \/ ~v396) /\
 (~v18 \/ v396) /\
 (v394 \/ ~v405) /\
 (~v394 \/ v405) /\
 (v394 \/ ~v406) /\
 (~v394 \/ v406) /\
 (~v403 \/ ~v410) /\
 (v404 \/ ~v410) /\
 (v403 \/ ~v411) /\
 (~v404 \/ ~v411) /\
 (~v411 \/ v394) /\
 (~v410 \/ v394) /\
 (v177 \/ ~v328) /\
 (~v177 \/ v328) /\
 (v177 \/ ~v329) /\
 (~v177 \/ v329) /\
 (~v337 \/ ~v177) /\
 (~v376 \/ ~v177) /\
 (~v386 \/ ~v177) /\
 (v22 \/ ~v376) /\
 (~v22 \/ v376) /\
 (v22 \/ ~v377) /\
 (~v22 \/ v377) /\
 (v234 \/ ~v337) /\
 (~v234 \/ v337) /\
 (v234 \/ ~v338) /\
 (~v234 \/ v338) /\
 (~v325 \/ ~v416) /\
 (v323 \/ ~v416) /\
 (v325 \/ ~v417) /\
 (~v323 \/ ~v417) /\
 (~v417 \/ v234) /\
 (~v416 \/ v234) /\
 (v85 \/ ~v179) /\
 (~v85 \/ v179) /\
 (v85 \/ ~v180) /\
 (~v85 \/ v180) /\
 (~v89 \/ ~v85) /\
 (~v172 \/ ~v85) /\
 (~v91 \/ ~v85) /\
 (v23 \/ ~v172) /\
 (~v23 \/ v172) /\
 (v23 \/ ~v173) /\
 (~v23 \/ v173) /\
 (v82 \/ ~v89) /\
 (~v82 \/ v89) /\
 (v82 \/ ~v90) /\
 (~v82 \/ v90) /\
 (~v333 \/ ~v428) /\
 (v84 \/ ~v428) /\
 (v333 \/ ~v429) /\
 (~v84 \/ ~v429) /\
 (~v429 \/ v82) /\
 (~v428 \/ v82) /\
 (v181 \/ ~v263) /\
 (~v181 \/ v263) /\
 (v181 \/ ~v264) /\
 (~v181 \/ v264) /\
 (v248 \/ v181) /\
 (~v248 \/ ~v181) /\
 (v233 \/ ~v248) /\
 (~v233 \/ v248) /\
 (v233 \/ ~v249) /\
 (~v233 \/ v249) /\
 (~v261 \/ ~v233) /\
 (~v245 \/ ~v233) /\
 (~v238 \/ ~v233) /\
 (v33 \/ ~v245) /\
 (~v33 \/ v245) /\
 (v33 \/ ~v246) /\
 (~v33 \/ v246) /\
 (v236 \/ ~v261) /\
 (~v236 \/ v261) /\
 (v236 \/ ~v262) /\
 (~v236 \/ v262) /\
 (~v269 \/ ~v420) /\
 (v259 \/ ~v420) /\
 (v269 \/ ~v421) /\
 (~v259 \/ ~v421) /\
 (~v421 \/ v236) /\
 (~v420 \/ v236) /\
 (~v65 \/ ~v60) /\
 (~v122 \/ ~v60) /\
 (~v117 \/ ~v60) /\
 (~v127 \/ ~v60) /\
 (v63 \/ ~v127) /\
 (~v63 \/ v127) /\
 (v63 \/ ~v128) /\
 (~v63 \/ v128) /\
 (v63 \/ ~v206) /\
 (~v63 \/ v206) /\
 (~v210 \/ ~v63) /\
 (~v222 \/ ~v63) /\
 (~v212 \/ ~v63) /\
 (v29 \/ ~v222) /\
 (~v29 \/ v222) /\
 (v29 \/ ~v223) /\
 (~v29 \/ v223) /\
 (v40 \/ ~v209) /\
 (~v40 \/ v209) /\
 (v40 \/ ~v210) /\
 (~v40 \/ v210) /\
 (~v45 \/ ~v430) /\
 (v80 \/ ~v430) /\
 (v45 \/ ~v431) /\
 (~v80 \/ ~v431) /\
 (~v431 \/ v40) /\
 (~v430 \/ v40) /\
 (v62 \/ ~v117) /\
 (~v62 \/ v117) /\
 (v62 \/ ~v118) /\
 (~v62 \/ v118) /\
 (v62 \/ ~v120) /\
 (~v62 \/ v120) /\
 (~v283 \/ ~v62) /\
 (~v305 \/ ~v62) /\
 (~v285 \/ ~v62) /\
 (v31 \/ ~v305) /\
 (~v31 \/ v305) /\
 (v31 \/ ~v306) /\
 (~v31 \/ v306) /\
 (v280 \/ ~v282) /\
 (~v280 \/ v282) /\
 (v280 \/ ~v283) /\
 (~v280 \/ v283) /\
 (~v348 \/ ~v412) /\
 (v349 \/ ~v412) /\
 (v348 \/ ~v413) /\
 (~v349 \/ ~v413) /\
 (~v413 \/ v280) /\
 (~v412 \/ v280) /\
 (v61 \/ ~v122) /\
 (~v61 \/ v122) /\
 (v61 \/ ~v123) /\
 (~v61 \/ v123) /\
 (~v351 \/ ~v61) /\
 (~v361 \/ ~v61) /\
 (~v353 \/ ~v61) /\
 (v20 \/ ~v361) /\
 (~v20 \/ v361) /\
 (v20 \/ ~v362) /\
 (~v20 \/ v362) /\
 (v109 \/ ~v351) /\
 (~v109 \/ v351) /\
 (v109 \/ ~v352) /\
 (~v109 \/ v352) /\
 (~v111 \/ ~v424) /\
 (v112 \/ ~v424) /\
 (v111 \/ ~v425) /\
 (~v112 \/ ~v425) /\
 (~v425 \/ v109) /\
 (~v424 \/ v109) /\
 (v52 \/ ~v64) /\
 (~v52 \/ v64) /\
 (v52 \/ ~v65) /\
 (~v52 \/ v65) /\
 (~v293 \/ ~v52) /\
 (~v315 \/ ~v52) /\
 (~v295 \/ ~v52) /\
 (v288 \/ ~v293) /\
 (~v288 \/ v293) /\
 (v288 \/ ~v294) /\
 (~v288 \/ v294) /\
 (~v290 \/ ~v418) /\
 (v291 \/ ~v418) /\
 (v290 \/ ~v419) /\
 (~v291 \/ ~v419) /\
 (~v419 \/ v288) /\
 (~v418 \/ v288) /\
 (v2 \/ ~v309) /\
 (~v2 \/ v309) /\
 (v2 \/ ~v310) /\
 (~v2 \/ v310) /\
 (v58 \/ ~v185) /\
 (~v58 \/ v185) /\
 (v58 \/ ~v186) /\
 (~v58 \/ v186) /\
 (v58 \/ ~v231) /\
 (~v58 \/ v231) /\
 (v58 \/ ~v298) /\
 (~v58 \/ v298) /\
 (v58 \/ ~v308) /\
 (~v58 \/ v308) /\
 (v58 \/ ~v364) /\
 (~v58 \/ v364) /\
 (v58 \/ ~v375) /\
 (~v58 \/ v375) /\
 (v58 \/ ~v393) /\
 (~v58 \/ v393) /\
 (v49 \/ v58) /\
 (v59 \/ v58) /\
 (v54 \/ v58) /\
 (~v57 \/ ~v54) /\
 (~v209 \/ ~v57) /\
 (~v208 \/ ~v57) /\
 (v226 \/ v208) /\
 (v215 \/ v208) /\
 (v213 \/ ~v226) /\
 (~v213 \/ v226) /\
 (v213 \/ ~v227) /\
 (~v213 \/ v227) /\
 (v14 \/ v213) /\
 (~v14 \/ ~v213) /\
 (v126 \/ v125) /\
 (~v126 \/ ~v125) /\
 (~v128 \/ ~v126) /\
 (~v129 \/ ~v126) /\
 (v206 \/ v205) /\
 (v207 \/ v205) /\
 (~v352 \/ ~v56) /\
 (~v365 \/ ~v56) /\
 (~v354 \/ ~v56) /\
 (v8 \/ ~v365) /\
 (~v8 \/ v365) /\
 (v8 \/ ~v366) /\
 (~v8 \/ v366) /\
 (~v95 \/ ~v59) /\
 (~v87 \/ ~v59) /\
 (~v96 \/ ~v59) /\
 (v336 \/ v96) /\
 (v346 \/ v336) /\
 (~v406 \/ ~v346) /\
 (~v408 \/ ~v346) /\
 (~v409 \/ ~v346) /\
 (v3 \/ ~v407) /\
 (~v3 \/ v407) /\
 (v3 \/ ~v408) /\
 (~v3 \/ v408) /\
 (~v342 \/ ~v341) /\
 (~v343 \/ ~v341) /\
 (~v274 \/ ~v273) /\
 (~v275 \/ ~v273) /\
 (v78 \/ ~v265) /\
 (~v78 \/ v265) /\
 (v78 \/ ~v266) /\
 (~v78 \/ v266) /\
 (v78 \/ ~v275) /\
 (~v78 \/ v275) /\
 (v98 \/ v78) /\
 (~v98 \/ ~v78) /\
 (v277 \/ v274) /\
 (~v277 \/ ~v274) /\
 (v379 \/ v335) /\
 (v382 \/ v335) /\
 (v381 \/ v379) /\
 (~v381 \/ ~v379) /\
 (v1 \/ ~v380) /\
 (~v1 \/ v380) /\
 (v1 \/ ~v381) /\
 (~v1 \/ v381) /\
 (~v329 \/ ~v414) /\
 (v330 \/ ~v414) /\
 (v329 \/ ~v415) /\
 (~v330 \/ ~v415) /\
 (~v415 \/ v327) /\
 (~v414 \/ v327) /\
 (~v88 \/ ~v87) /\
 (~v90 \/ ~v87) /\
 (~v156 \/ ~v87) /\
 (~v92 \/ ~v87) /\
 (v16 \/ ~v156) /\
 (~v16 \/ v156) /\
 (v16 \/ ~v157) /\
 (~v16 \/ v157) /\
 (~v179 \/ ~v426) /\
 (v94 \/ ~v426) /\
 (v179 \/ ~v427) /\
 (~v94 \/ ~v427) /\
 (~v427 \/ v88) /\
 (~v426 \/ v88) /\
 (v106 \/ v95) /\
 (~v106 \/ ~v95) /\
 (~v108 \/ ~v106) /\
 (~v262 \/ ~v108) /\
 (~v255 \/ ~v108) /\
 (v257 \/ v255) /\
 (v258 \/ v255) /\
 (v251 \/ ~v256) /\
 (~v251 \/ v256) /\
 (v251 \/ ~v257) /\
 (~v251 \/ v257) /\
 (v13 \/ v251) /\
 (~v13 \/ ~v251) /\
 (v264 \/ v260) /\
 (v266 \/ v260) /\
 (v249 \/ v247) /\
 (v250 \/ v247) /\
 (~v197 \/ ~v107) /\
 (~v199 \/ ~v107) /\
 (~v200 \/ ~v107) /\
 (v36 \/ ~v198) /\
 (~v36 \/ v198) /\
 (v36 \/ ~v199) /\
 (~v36 \/ v199) /\
 (~v47 \/ ~v49) /\
 (v48 \/ v47) /\
 (~v48 \/ ~v47) /\
 (v115 \/ v48) /\
 (~v282 \/ ~v115) /\
 (~v299 \/ ~v115) /\
 (~v284 \/ ~v115) /\
 (v24 \/ ~v299) /\
 (~v24 \/ v299) /\
 (v24 \/ ~v300) /\
 (~v24 \/ v300) /\
 (~v120 \/ ~v114) /\
 (~v121 \/ ~v114) /\
 (v116 \/ v113) /\
 (~v116 \/ ~v113) /\
 (v118 \/ v116) /\
 (v119 \/ v116) /\
 (~v294 \/ ~v51) /\
 (~v309 \/ ~v51) /\
 (~v296 \/ ~v51) /\
 (v229 \/ v74) /\
 (v230 \/ v74) /\
 (v66 \/ ~v132) /\
 (~v66 \/ v132) /\
 (v66 \/ ~v133) /\
 (~v66 \/ v133) /\
 (v66 \/ ~v135) /\
 (~v66 \/ v135) /\
 (v66 \/ ~v230) /\
 (~v66 \/ v230) /\
 (v216 \/ v66) /\
 (~v216 \/ ~v66) /\
 (~v356 \/ ~v216) /\
 (v363 \/ v356) /\
 (~v363 \/ ~v356) /\
 (~v367 \/ ~v363) /\
 (v131 \/ ~v136) /\
 (~v131 \/ v136) /\
 (v131 \/ ~v137) /\
 (~v131 \/ v137) /\
 (v131 \/ ~v140) /\
 (~v131 \/ v140) /\
 (v131 \/ ~v148) /\
 (~v131 \/ v148) /\
 (v131 \/ ~v229) /\
 (~v131 \/ v229) /\
 (v302 \/ v131) /\
 (v297 \/ v131) /\
 (~v301 \/ ~v297) /\
 (v146 \/ v71) /\
 (v141 \/ v71) /\
 (v149 \/ v71) /\
 (~v142 \/ v72) /\
 (~v142 \/ v149) /\
 (~v142 \/ v146) /\
 (v146 \/ v73) /\
 (v143 \/ v73) /\
 (v149 \/ v73) /\
 (v144 \/ ~v149) /\
 (~v144 \/ v149) /\
 (v144 \/ ~v150) /\
 (~v144 \/ v150) /\
 (v152 \/ v144) /\
 (~v152 \/ ~v144) /\
 (v134 \/ ~v151) /\
 (~v134 \/ v151) /\
 (v134 \/ ~v152) /\
 (~v134 \/ v152) /\
 (~v240 \/ ~v134) /\
 (v254 \/ v240) /\
 (v97 \/ ~v224) /\
 (~v97 \/ v224) /\
 (v97 \/ ~v225) /\
 (~v97 \/ v225) /\
 (v97 \/ ~v252) /\
 (~v97 \/ v252) /\
 (v231 \/ v97) /\
 (~v231 \/ ~v97) /\
 (~v163 \/ ~v141) /\
 (~v160 \/ v142) /\
 (~v160 \/ v153) /\
 (~v154 \/ ~v163) /\
 (~v160 \/ ~v163) /\
 (~v163 \/ ~v143) /\
 (v99 \/ ~v162) /\
 (~v99 \/ v162) /\
 (v99 \/ ~v163) /\
 (~v99 \/ v163) /\
 (~v100 \/ ~v99) /\
 (v183 \/ v100) /\
 (~v183 \/ ~v100) /\
 (~v192 \/ ~v183) /\
 (~v158 \/ ~v153) /\
 (~v174 \/ v160) /\
 (~v174 \/ v169) /\
 (~v318 \/ v166) /\
 (~v167 \/ v317) /\
 (v130 \/ ~v145) /\
 (~v130 \/ v145) /\
 (v130 \/ ~v146) /\
 (~v130 \/ v146) /\
 (v228 \/ v130) /\
 (v217 \/ v130) /\
 (v70 \/ ~v76) /\
 (~v70 \/ v76) /\
 (v70 \/ ~v77) /\
 (~v70 \/ v77) /\
 (~v339 \/ ~v70) /\
 (v340 \/ v339) /\
 (~v340 \/ ~v339) /\
 (~v397 \/ ~v340) /\
 (~v384 \/ ~v79) /\
 (~v387 \/ ~v79) /\
 (v374 \/ v384) /\
 (~v374 \/ ~v384) /\
 (~v432 \/ v435) /\
 (~v435 \/ v432) /\
 (v433 \/ v39 \/ ~v37) /\
 (v434 \/ ~v39 \/ v37) /\
 (~v432 \/ v434 \/ v433) /\
 (v37 \/ v79 \/ v67) /\
 (~v38 \/ v37 \/ v39) /\
 (~v38 \/ ~v37 \/ ~v39) /\
 (v39 \/ v79 \/ v69) /\
 (~v68 \/ v67 \/ v69) /\
 (~v68 \/ ~v67 \/ ~v69) /\
 (~v310 \/ ~v308 \/ ~v75) /\
 (~v371 \/ ~v313 \/ ~v312) /\
 (~v316 \/ ~v314 \/ ~v312) /\
 (v314 \/ v313 \/ v312) /\
 (v316 \/ v313 \/ v312) /\
 (v314 \/ v371 \/ v312) /\
 (v316 \/ v371 \/ v312) /\
 (v422 \/ v271 \/ ~v195) /\
 (v423 \/ ~v271 \/ v195) /\
 (~v189 \/ v423 \/ v422) /\
 (v279 \/ v369 \/ v370) /\
 (v43 \/ v110 \/ v46) /\
 (v41 \/ v219 \/ v211) /\
 (v44 \/ v358 \/ v355) /\
 (v194 \/ v202 \/ v203) /\
 (v391 \/ v400 \/ v401) /\
 (v322 \/ v389 \/ v390) /\
 (v83 \/ v320 \/ v321) /\
 (v237 \/ v242 \/ v239) /\
 (v287 \/ v372 \/ v373) /\
 (v410 \/ v403 \/ ~v404) /\
 (v411 \/ ~v403 \/ v404) /\
 (~v394 \/ v411 \/ v410) /\
 (v416 \/ v325 \/ ~v323) /\
 (v417 \/ ~v325 \/ v323) /\
 (~v234 \/ v417 \/ v416) /\
 (v428 \/ v333 \/ ~v84) /\
 (v429 \/ ~v333 \/ v84) /\
 (~v82 \/ v429 \/ v428) /\
 (v420 \/ v269 \/ ~v259) /\
 (v421 \/ ~v269 \/ v259) /\
 (~v236 \/ v421 \/ v420) /\
 (v430 \/ v45 \/ ~v80) /\
 (v431 \/ ~v45 \/ v80) /\
 (~v40 \/ v431 \/ v430) /\
 (v412 \/ v348 \/ ~v349) /\
 (v413 \/ ~v348 \/ v349) /\
 (~v280 \/ v413 \/ v412) /\
 (v424 \/ v111 \/ ~v112) /\
 (v425 \/ ~v111 \/ v112) /\
 (~v109 \/ v425 \/ v424) /\
 (v418 \/ v290 \/ ~v291) /\
 (v419 \/ ~v290 \/ v291) /\
 (~v288 \/ v419 \/ v418) /\
 (~v56 \/ ~v55 \/ ~v54) /\
 (v57 \/ v55 \/ v54) /\
 (v57 \/ v56 \/ v54) /\
 (~v125 \/ ~v205 \/ ~v57) /\
 (~v208 \/ ~v226 \/ ~v215) /\
 (v126 \/ v128 \/ v129) /\
 (~v205 \/ ~v206 \/ ~v207) /\
 (v124 \/ v123 \/ v55) /\
 (~v124 \/ ~v123 \/ v55) /\
 (~v124 \/ v123 \/ ~v55) /\
 (v124 \/ ~v123 \/ ~v55) /\
 (~v336 \/ ~v327 \/ ~v96) /\
 (~v336 \/ ~v338 \/ ~v96) /\
 (~v336 \/ ~v335 \/ ~v96) /\
 (v341 \/ v273 \/ v336) /\
 (~v346 \/ ~v273 \/ ~v336) /\
 (~v346 \/ ~v341 \/ ~v336) /\
 (v341 \/ v342 \/ v343) /\
 (v273 \/ v274 \/ v275) /\
 (~v335 \/ ~v379 \/ ~v382) /\
 (v414 \/ v329 \/ ~v330) /\
 (v415 \/ ~v329 \/ v330) /\
 (~v327 \/ v415 \/ v414) /\
 (v426 \/ v179 \/ ~v94) /\
 (v427 \/ ~v179 \/ v94) /\
 (~v88 \/ v427 \/ v426) /\
 (~v107 \/ ~v103 \/ ~v106) /\
 (v108 \/ v103 \/ v106) /\
 (v108 \/ v107 \/ v106) /\
 (~v260 \/ ~v247 \/ ~v108) /\
 (~v255 \/ ~v257 \/ ~v258) /\
 (~v260 \/ ~v264 \/ ~v266) /\
 (~v247 \/ ~v249 \/ ~v250) /\
 (v105 \/ v187 \/ v103) /\
 (~v105 \/ ~v187 \/ v103) /\
 (~v105 \/ v187 \/ ~v103) /\
 (v105 \/ ~v187 \/ ~v103) /\
 (~v51 \/ ~v50 \/ ~v49) /\
 (v47 \/ v50 \/ v49) /\
 (v47 \/ v51 \/ v49) /\
 (v114 \/ v113 \/ v48) /\
 (~v115 \/ ~v113 \/ ~v48) /\
 (~v115 \/ ~v114 \/ ~v48) /\
 (v114 \/ v120 \/ v121) /\
 (~v116 \/ ~v118 \/ ~v119) /\
 (v93 \/ v64 \/ v50) /\
 (~v93 \/ ~v64 \/ v50) /\
 (~v93 \/ v64 \/ ~v50) /\
 (v93 \/ ~v64 \/ ~v50) /\
 (~v74 \/ ~v229 \/ ~v230) /\
 (~v359 \/ ~v357 \/ ~v216) /\
 (~v362 \/ ~v360 \/ ~v216) /\
 (~v366 \/ ~v364 \/ ~v363) /\
 (v367 \/ v364 \/ v363) /\
 (v367 \/ v366 \/ v363) /\
 (~v131 \/ ~v302 \/ ~v297) /\
 (~v300 \/ ~v298 \/ ~v297) /\
 (v301 \/ v298 \/ v297) /\
 (v301 \/ v300 \/ v297) /\
 (~v368 \/ ~v303 \/ ~v302) /\
 (~v306 \/ ~v304 \/ ~v302) /\
 (v304 \/ v303 \/ v302) /\
 (v306 \/ v303 \/ v302) /\
 (v304 \/ v368 \/ v302) /\
 (v306 \/ v368 \/ v302) /\
 (~v72 \/ v71 \/ v73) /\
 (~v72 \/ ~v71 \/ ~v73) /\
 (~v243 \/ ~v241 \/ ~v134) /\
 (~v246 \/ ~v244 \/ ~v134) /\
 (v256 \/ v252 \/ v240) /\
 (~v254 \/ ~v252 \/ ~v240) /\
 (~v254 \/ ~v256 \/ ~v240) /\
 (~v153 \/ ~v159 \/ ~v141) /\
 (v163 \/ v159 \/ v141) /\
 (v163 \/ v153 \/ v141) /\
 (~v154 \/ ~v155 \/ v161) /\
 (~v154 \/ ~v153 \/ v159) /\
 (~v154 \/ v159 \/ v161) /\
 (~v142 \/ v141 \/ v143) /\
 (~v142 \/ ~v141 \/ ~v143) /\
 (~v153 \/ ~v161 \/ ~v143) /\
 (v163 \/ v161 \/ v143) /\
 (v163 \/ v153 \/ v143) /\
 (~v201 \/ ~v101 \/ ~v99) /\
 (~v190 \/ ~v102 \/ ~v99) /\
 (~v198 \/ ~v186 \/ ~v183) /\
 (v192 \/ v186 \/ v183) /\
 (v192 \/ v198 \/ v183) /\
 (~v157 \/ ~v185 \/ ~v153) /\
 (v158 \/ v185 \/ v153) /\
 (v158 \/ v157 \/ v153) /\
 (~v317 \/ ~v166 \/ ~v159) /\
 (~v173 \/ ~v169 \/ ~v159) /\
 (v169 \/ v166 \/ v159) /\
 (v173 \/ v166 \/ v159) /\
 (v169 \/ v317 \/ v159) /\
 (v173 \/ v317 \/ v159) /\
 (~v170 \/ ~v171 \/ v175) /\
 (~v170 \/ ~v169 \/ v173) /\
 (~v170 \/ v173 \/ v175) /\
 (~v174 \/ ~v317 \/ ~v166) /\
 (~v170 \/ ~v317 \/ ~v166) /\
 (~v160 \/ v159 \/ v161) /\
 (~v160 \/ ~v159 \/ ~v161) /\
 (~v317 \/ ~v166 \/ ~v161) /\
 (~v175 \/ ~v169 \/ ~v161) /\
 (v169 \/ v166 \/ v161) /\
 (v175 \/ v166 \/ v161) /\
 (v169 \/ v317 \/ v161) /\
 (v175 \/ v317 \/ v161) /\
 (v227 \/ v225 \/ v130) /\
 (~v220 \/ ~v218 \/ ~v217) /\
 (~v223 \/ ~v221 \/ ~v217) /\
 (v221 \/ v218 \/ v217) /\
 (v223 \/ v218 \/ v217) /\
 (v221 \/ v220 \/ v217) /\
 (v223 \/ v220 \/ v217) /\
 (~v399 \/ ~v344 \/ ~v70) /\
 (~v395 \/ ~v345 \/ ~v70) /\
 (~v407 \/ ~v393 \/ ~v340) /\
 (v397 \/ v393 \/ v340) /\
 (v397 \/ v407 \/ v340) /\
 (~v385 \/ ~v388 \/ ~v79) /\
 (~v375 \/ ~v380 \/ ~v374) /\
 (~v378 \/ ~v377 \/ ~v374) /\
 (v377 \/ v380 \/ v374) /\
 (v378 \/ v380 \/ v374) /\
 (v377 \/ v375 \/ v374) /\
 (v378 \/ v375 \/ v374) /\
 (v307 \/ v311 \/ v308 \/ v75) /\
 (v307 \/ v311 \/ v310 \/ v75) /\
 (v104 \/ v196 \/ v191 \/ v193) /\
 (v267 \/ v270 \/ v268 \/ v272) /\
 (~v268 \/ ~v331 \/ ~v324 \/ ~v332) /\
 (v176 \/ v180 \/ v328 \/ v276) /\
 (v178 \/ v405 \/ v396 \/ v398) /\
 (v177 \/ v337 \/ v376 \/ v386) /\
 (v85 \/ v89 \/ v172 \/ v91) /\
 (v233 \/ v261 \/ v245 \/ v238) /\
 (v63 \/ v210 \/ v222 \/ v212) /\
 (v62 \/ v283 \/ v305 \/ v285) /\
 (v61 \/ v351 \/ v361 \/ v353) /\
 (v52 \/ v293 \/ v315 \/ v295) /\
 (~v58 \/ ~v49 \/ ~v59 \/ ~v54) /\
 (v208 \/ v209 \/ v205 \/ v57) /\
 (v208 \/ v209 \/ v125 \/ v57) /\
 (v56 \/ v352 \/ v365 \/ v354) /\
 (v59 \/ v95 \/ v87 \/ v96) /\
 (v335 \/ v338 \/ v327 \/ v96) /\
 (v346 \/ v406 \/ v408 \/ v409) /\
 (v255 \/ v262 \/ v247 \/ v108) /\
 (v255 \/ v262 \/ v260 \/ v108) /\
 (v107 \/ v197 \/ v199 \/ v200) /\
 (v115 \/ v282 \/ v299 \/ v284) /\
 (v51 \/ v294 \/ v309 \/ v296) /\
 (v356 \/ v360 \/ v357 \/ v216) /\
 (v356 \/ v362 \/ v357 \/ v216) /\
 (v356 \/ v360 \/ v359 \/ v216) /\
 (v356 \/ v362 \/ v359 \/ v216) /\
 (~v71 \/ ~v146 \/ ~v141 \/ ~v149) /\
 (~v73 \/ ~v146 \/ ~v143 \/ ~v149) /\
 (v240 \/ v244 \/ v241 \/ v134) /\
 (v240 \/ v246 \/ v241 \/ v134) /\
 (v240 \/ v244 \/ v243 \/ v134) /\
 (v240 \/ v246 \/ v243 \/ v134) /\
 (~v164 \/ ~v153 \/ ~v165 \/ ~v159) /\
 (~v164 \/ ~v153 \/ ~v163 \/ ~v161) /\
 (~v164 \/ ~v153 \/ ~v159 \/ ~v161) /\
 (v100 \/ v102 \/ v101 \/ v99) /\
 (v100 \/ v190 \/ v101 \/ v99) /\
 (v100 \/ v102 \/ v201 \/ v99) /\
 (v100 \/ v190 \/ v201 \/ v99) /\
 (~v318 \/ ~v169 \/ ~v319 \/ ~v173) /\
 (~v318 \/ ~v169 \/ ~v317 \/ ~v175) /\
 (~v318 \/ ~v169 \/ ~v173 \/ ~v175) /\
 (~v167 \/ ~v169 \/ ~v168 \/ ~v173) /\
 (~v167 \/ ~v169 \/ ~v166 \/ ~v175) /\
 (~v167 \/ ~v169 \/ ~v173 \/ ~v175) /\
 (~v217 \/ ~v228 \/ ~v225 \/ ~v130) /\
 (~v217 \/ ~v228 \/ ~v227 \/ ~v130) /\
 (v339 \/ v345 \/ v344 \/ v70) /\
 (v339 \/ v395 \/ v344 \/ v70) /\
 (v339 \/ v345 \/ v399 \/ v70) /\
 (v339 \/ v395 \/ v399 \/ v70) /\
 (v387 \/ v384 \/ v388 \/ v79) /\
 (v387 \/ v384 \/ v385 \/ v79) /\
 (v67 \/ v76 \/ v71 \/ v74 \/ v138) /\
 (v69 \/ v76 \/ v73 \/ v74 \/ v138) /\
 (~v53 \/ ~v60 \/ ~v263 \/ ~v176 \/ ~v182) /\
 (~v42 \/ ~v286 \/ ~v267 \/ ~v43 \/ ~v278) /\
 (v60 \/ v65 \/ v122 \/ v117 \/ v127) /\
 (v87 \/ v88 \/ v90 \/ v156 \/ v92))`
;

val jnh211 = bdd_oracle
`~
((v7 \/ ~v9 \/ ~v29) /\
 (v13 \/ ~v35 \/ v44 \/ ~v45 \/ ~v48) /\
 (~v50 \/ v60) /\
 (v1 \/ v2 \/ v13 \/ v21 \/ ~v29 \/ ~v36 \/ ~v75) /\
 (v1 \/ ~v9 \/ v12 \/ ~v13 \/ v47 \/ v59 \/ v83 \/ ~v84) /\
 (~v13 \/ v29 \/ v47 \/ ~v53 \/ ~v97) /\
 (v32 \/ ~v54 \/ ~v58 \/ ~v70) /\
 (~v7 \/ v24 \/ v48) /\
 (v31 \/ v94) /\
 (~v3 \/ ~v5 \/ v11 \/ v59 \/ ~v90 \/ ~v99) /\
 (~v6 \/ v41) /\
 (~v2 \/ v17 \/ ~v28 \/ v67 \/ v68 \/ ~v77 \/ ~v100) /\
 (v37 \/ v61 \/ v78 \/ v88 \/ v89 \/ ~v92) /\
 (v31 \/ ~v70 \/ v73 \/ ~v79 \/ v82) /\
 (~v4 \/ v28 \/ v37 \/ ~v75 \/ v91) /\
 (v81 \/ ~v88 \/ v97) /\
 (~v2 \/ v23 \/ ~v31 \/ ~v48 \/ v66) /\
 (~v20 \/ v57 \/ ~v61 \/ ~v83 \/ v86 \/ v92 \/ ~v99) /\
 (~v35 \/ v38 \/ ~v50 \/ v63 \/ ~v68 \/ ~v84 \/ v87 \/ ~v90) /\
 (v22 \/ v34 \/ ~v56 \/ ~v65 \/ v76 \/ ~v77 \/ ~v95) /\
 (v14 \/ ~v42 \/ v44 \/ v83) /\
 (v32 \/ v87) /\
 (~v22 \/ ~v51 \/ ~v77) /\
 (~v70 \/ v85) /\
 (~v3 \/ ~v15 \/ v44 \/ ~v50 \/ ~v92) /\
 (v3 \/ v10 \/ v37 \/ ~v41 \/ ~v60 \/ ~v69 \/ v89) /\
 (~v37 \/ v45 \/ ~v83 \/ ~v97) /\
 (~v31 \/ v44 \/ v69) /\
 (v13 \/ ~v19 \/ ~v29 \/ v36) /\
 (v8 \/ v44 \/ v54 \/ ~v82 \/ v98) /\
 (v61 \/ ~v62 \/ ~v84) /\
 (~v23 \/ ~v74 \/ ~v85 \/ ~v90) /\
 (v12 \/ v64 \/ ~v77 \/ ~v92) /\
 (v17 \/ v22 \/ v38 \/ v40 \/ ~v48 \/ ~v66 \/ v69 \/ ~v79 \/ v94) /\
 (v19 \/ v24 \/ v39 \/ ~v76 \/ ~v88 \/ ~v94) /\
 (v37 \/ ~v57 \/ v71 \/ ~v73 \/ ~v93) /\
 (v79 \/ ~v80 \/ v92) /\
 (v1 \/ v12 \/ ~v14 \/ ~v18 \/ v45 \/ v61 \/ v63 \/ ~v85 \/ v88 \/ v90) /\
 (~v6 \/ v19 \/ v68 \/ ~v73) /\
 (~v11 \/ ~v46 \/ ~v85 \/ v89) /\
 (~v31 \/ ~v43 \/ v63 \/ ~v73) /\
 (v26 \/ ~v62 \/ ~v71 \/ v77) /\
 (~v14 \/ ~v23 \/ ~v30 \/ v34 \/ ~v47 \/ v71 \/ v73) /\
 (~v13 \/ v16 \/ ~v31 \/ v81 \/ v94) /\
 (~v6 \/ ~v56 \/ ~v85 \/ ~v96) /\
 (~v7 \/ v27 \/ ~v32 \/ v35 \/ ~v74) /\
 (v3 \/ v6 \/ ~v8 \/ ~v17 \/ ~v43 \/ ~v54 \/ v65) /\
 (v4 \/ ~v53 \/ v58 \/ ~v71 \/ v89 \/ ~v99) /\
 (v36 \/ v92 \/ v97) /\
 (~v1 \/ v11 \/ v29 \/ v36 \/ v37 \/ v98) /\
 (~v31 \/ v34 \/ ~v47 \/ ~v64) /\
 (~v26 \/ v80 \/ v88 \/ v91 \/ v98) /\
 (v10 \/ ~v21 \/ v43 \/ v62 \/ ~v68 \/ ~v85 \/ ~v87) /\
 (v71 \/ ~v88 \/ ~v93 \/ v96) /\
 (~v4 \/ ~v63) /\
 (~v21 \/ v36 \/ ~v61 \/ v79 \/ v82 \/ v88) /\
 (v21 \/ v32 \/ ~v66 \/ ~v95) /\
 (v37 \/ ~v51 \/ v86 \/ ~v88) /\
 (v3 \/ v25 \/ v34 \/ v74 \/ v95 \/ v96) /\
 (v35 \/ v76 \/ v91) /\
 (~v24 \/ v90 \/ ~v93) /\
 (~v19 \/ ~v23) /\
 (v27 \/ v58 \/ ~v75) /\
 (~v9 \/ v31 \/ ~v54 \/ ~v58 \/ ~v70) /\
 (v2 \/ ~v5 \/ ~v49 \/ v51 \/ ~v52 \/ v62 \/ ~v66 \/ ~v69 \/ v73) /\
 (v11 \/ ~v22 \/ ~v33 \/ v72 \/ v96 \/ v99) /\
 (v12 \/ v30 \/ ~v35) /\
 (~v39 \/ v44 \/ v48 \/ ~v60 \/ v62 \/ v66) /\
 (~v3 \/ v20 \/ ~v45 \/ v67 \/ v71 \/ v83 \/ ~v100) /\
 (v13 \/ v23 \/ ~v32 \/ ~v84) /\
 (v9 \/ v13 \/ ~v16 \/ ~v64) /\
 (v13 \/ ~v28 \/ v39 \/ v45 \/ v48 \/ v50 \/ ~v64 \/ ~v80) /\
 (~v18 \/ ~v42 \/ ~v47 \/ ~v60) /\
 (v24 \/ v29 \/ ~v32 \/ ~v45 \/ ~v87 \/ ~v92 \/ ~v99) /\
 (v13 \/ ~v15 \/ ~v18 \/ ~v39 \/ ~v62) /\
 (~v4 \/ v51) /\
 (v6 \/ v70 \/ v94) /\
 (v44 \/ v45 \/ ~v60 \/ v98) /\
 (v12 \/ ~v21 \/ v42 \/ v58) /\
 (v3 \/ ~v15 \/ v19 \/ v21 \/ ~v24 \/ v32) /\
 (v13 \/ v19 \/ ~v56) /\
 (~v4 \/ ~v78) /\
 (v3 \/ v4 \/ ~v45 \/ ~v49 \/ ~v53 \/ v80) /\
 (~v4 \/ v17 \/ ~v82 \/ ~v92) /\
 (v34 \/ ~v39 \/ ~v56 \/ v63 \/ v68 \/ ~v73 \/ v83) /\
 (v20 \/ ~v22 \/ ~v27 \/ v31 \/ v37 \/ v48 \/ v57 \/ v100) /\
 (~v9 \/ ~v22 \/ v26 \/ v38 \/ ~v41 \/ v47 \/ ~v53 \/ v73) /\
 (v74 \/ v91) /\
 (~v5 \/ ~v59 \/ ~v79 \/ ~v82 \/ ~v98) /\
 (~v2 \/ ~v46 \/ ~v76 \/ ~v85) /\
 (~v19 \/ ~v23 \/ v64 \/ v75 \/ ~v76 \/ ~v86 \/ ~v89 \/ v92 \/ ~v100) /\
 (~v12 \/ v25 \/ ~v59 \/ v74 \/ v96) /\
 (~v3 \/ ~v5 \/ v29 \/ v57 \/ ~v67 \/ ~v75 \/ ~v80) /\
 (~v14 \/ ~v17 \/ ~v42 \/ v55) /\
 (v18 \/ ~v58 \/ v62) /\
 (~v6 \/ v31 \/ v54 \/ v59) /\
 (v12 \/ ~v66) /\
 (v12 \/ ~v26 \/ ~v41 \/ v46) /\
 (v36 \/ v78) /\
 (~v1 \/ ~v13 \/ v30) /\
 (v30 \/ ~v36 \/ v58 \/ v59 \/ ~v71) /\
 (v2 \/ ~v22 \/ v26 \/ ~v41 \/ v55 \/ v58 \/ v60 \/ v92) /\
 (~v24 \/ v44 \/ v64 \/ v67 \/ v68 \/ ~v100) /\
 (v18 \/ ~v32 \/ v54) /\
 (~v9 \/ v41 \/ v52 \/ ~v98) /\
 (~v25 \/ ~v57 \/ v60) /\
 (v20 \/ v21 \/ v73) /\
 (v30 \/ v49 \/ v51 \/ v53 \/ v88 \/ ~v97 \/ v100) /\
 (v47 \/ v52 \/ ~v94) /\
 (~v25 \/ ~v38 \/ ~v48) /\
 (v8 \/ v19 \/ v76 \/ ~v85 \/ ~v97) /\
 (~v7 \/ v13 \/ ~v49) /\
 (v3 \/ v22 \/ v23 \/ ~v58 \/ v67 \/ v77) /\
 (v10 \/ ~v15 \/ ~v34 \/ v36 \/ v41 \/ ~v47) /\
 (v44 \/ ~v46 \/ ~v79 \/ ~v99) /\
 (v26 \/ v28 \/ ~v43 \/ v45 \/ v81) /\
 (~v51 \/ ~v73 \/ ~v83) /\
 (v2 \/ ~v46 \/ ~v69 \/ ~v84) /\
 (~v28 \/ ~v41 \/ v63) /\
 (v4 \/ ~v5 \/ ~v19 \/ v29 \/ ~v60 \/ ~v62 \/ ~v85 \/ v87 \/ ~v88) /\
 (v5 \/ v14 \/ ~v26 \/ ~v30 \/ v66) /\
 (~v2 \/ ~v47 \/ v78) /\
 (v11 \/ v14 \/ v43 \/ v99) /\
 (~v2 \/ v89 \/ v100) /\
 (v68 \/ ~v82 \/ v86 \/ ~v97) /\
 (v7 \/ v8 \/ ~v24 \/ v28 \/ v30 \/ v51 \/ ~v58 \/ ~v67 \/ ~v84 \/ ~v89) /\
 (v36 \/ v51) /\
 (~v17 \/ ~v42 \/ v53 \/ v54 \/ ~v69 \/ ~v72 \/ v99) /\
 (v31 \/ v34 \/ v56 \/ ~v71 \/ ~v80) /\
 (v31 \/ ~v52 \/ v64 \/ ~v65) /\
 (v17 \/ ~v23 \/ ~v35 \/ ~v56 \/ v58 \/ v59 \/ ~v61 \/ v63 \/ v64 \/ ~v66 \/ ~v71) /\
 (~v9 \/ v30 \/ ~v51) /\
 (v2 \/ v3 \/ v22 \/ v37 \/ ~v60 \/ ~v69 \/ v81 \/ v92) /\
 (v8 \/ ~v44 \/ ~v94) /\
 (v9 \/ ~v37 \/ v55 \/ ~v73) /\
 (v30 \/ v47 \/ ~v87 \/ v92) /\
 (v12 \/ v26 \/ ~v41 \/ ~v57 \/ ~v65 \/ v93) /\
 (v41 \/ ~v45 \/ ~v84 \/ v90) /\
 (~v6 \/ ~v13) /\
 (v31 \/ v45 \/ ~v56 \/ v67) /\
 (v1 \/ v33 \/ ~v79 \/ ~v84) /\
 (v14 \/ v21 \/ v30 \/ v32 \/ v37 \/ v48 \/ ~v62 \/ ~v65 \/ v75) /\
 (~v6 \/ ~v33 \/ v41 \/ v50) /\
 (~v12 \/ v17 \/ ~v37 \/ ~v68 \/ ~v77 \/ v88 \/ v89 \/ v96) /\
 (~v28 \/ ~v60 \/ v79 \/ ~v84 \/ v95) /\
 (~v12 \/ v37 \/ ~v54 \/ v95 \/ v99) /\
 (v2 \/ v35 \/ ~v68 \/ ~v81 \/ v100) /\
 (v4 \/ ~v10 \/ v13 \/ v31 \/ ~v33 \/ ~v83) /\
 (v18 \/ v80 \/ v90) /\
 (~v31 \/ ~v69 \/ v89) /\
 (v51 \/ v52 \/ ~v57 \/ ~v71 \/ v79 \/ ~v81) /\
 (v35 \/ v63) /\
 (~v13 \/ v17 \/ ~v39 \/ v43 \/ ~v75 \/ v86) /\
 (~v35 \/ v58 \/ ~v73 \/ ~v78 \/ ~v82 \/ v95 \/ v100) /\
 (~v36 \/ v60 \/ ~v67) /\
 (v33 \/ ~v36 \/ v43 \/ v78 \/ ~v88 \/ ~v99) /\
 (v77 \/ v79 \/ v97) /\
 (v2 \/ v5 \/ ~v32 \/ v38 \/ v63 \/ ~v94) /\
 (~v1 \/ v52) /\
 (v7 \/ ~v88 \/ v91) /\
 (v10 \/ v17 \/ ~v22 \/ v75 \/ v76) /\
 (~v34 \/ v74 \/ v80 \/ v95) /\
 (~v33 \/ v36 \/ ~v57 \/ ~v74) /\
 (~v47 \/ v66 \/ v71 \/ v80 \/ ~v92) /\
 (v2 \/ ~v17 \/ ~v43 \/ v54 \/ v56 \/ ~v77 \/ ~v79 \/ v88 \/ ~v94 \/ ~v98) /\
 (~v17 \/ ~v46 \/ v97) /\
 (v27 \/ v55 \/ v82) /\
 (~v4 \/ ~v27 \/ v34 \/ ~v40 \/ v71) /\
 (v28 \/ ~v32 \/ ~v94) /\
 (~v29 \/ v60 \/ v63 \/ ~v70 \/ v76) /\
 (v1 \/ v2 \/ ~v9 \/ ~v14 \/ ~v20 \/ v79 \/ v93 \/ v94) /\
 (~v33 \/ v42 \/ ~v45 \/ ~v69 \/ ~v73) /\
 (~v10 \/ ~v16 \/ ~v29 \/ v56 \/ v58 \/ v75 \/ ~v88 \/ v95 \/ ~v96) /\
 (v2 \/ ~v3 \/ v41 \/ ~v51 \/ v67 \/ ~v78) /\
 (~v11 \/ ~v15 \/ ~v20 \/ ~v50 \/ v95) /\
 (~v13 \/ ~v27 \/ ~v31 \/ ~v35 \/ v45 \/ ~v64 \/ ~v84 \/ v89 \/ ~v96) /\
 (v5 \/ ~v16 \/ ~v45 \/ v47 \/ v87) /\
 (~v15 \/ ~v18 \/ v31 \/ v98) /\
 (v27 \/ ~v32 \/ v39 \/ v40 \/ v75 \/ ~v88) /\
 (v14 \/ v16 \/ v29 \/ v30 \/ v46 \/ v50 \/ ~v56 \/ ~v80) /\
 (v9 \/ v22 \/ v25 \/ v27 \/ ~v41 \/ ~v58 \/ v84 \/ ~v94) /\
 (~v21 \/ ~v27) /\
 (v10 \/ v11 \/ ~v17 \/ v38 \/ ~v57 \/ ~v98) /\
 (v7 \/ v33 \/ ~v46 \/ ~v56 \/ ~v67) /\
 (v20 \/ v26 \/ v69) /\
 (~v35 \/ ~v42 \/ v69 \/ ~v90 \/ v98) /\
 (v26 \/ ~v39 \/ ~v62 \/ ~v81 \/ v94) /\
 (v24 \/ v25 \/ ~v36) /\
 (~v3 \/ v10 \/ v37 \/ ~v38 \/ ~v49 \/ ~v64 \/ ~v67 \/ ~v88 \/ ~v100) /\
 (~v26 \/ ~v31 \/ v37 \/ v38 \/ v66 \/ v98) /\
 (v46 \/ ~v75 \/ v78 \/ ~v87 \/ ~v90) /\
 (~v35 \/ v40 \/ v69 \/ ~v84 \/ v88) /\
 (v22 \/ ~v44 \/ v53 \/ ~v54 \/ ~v57) /\
 (~v59 \/ v69) /\
 (v10 \/ v11 \/ v22 \/ v30 \/ ~v38 \/ ~v45 \/ ~v84) /\
 (~v6 \/ v10 \/ ~v18 \/ v21 \/ ~v22 \/ v56 \/ v68 \/ v92 \/ ~v93) /\
 (~v22 \/ v38 \/ v56 \/ ~v62) /\
 (v41 \/ ~v63 \/ ~v67 \/ ~v79) /\
 (v3 \/ ~v16 \/ v33 \/ v57) /\
 (~v8 \/ v40) /\
 (~v12 \/ ~v14 \/ v20 \/ v68 \/ ~v99) /\
 (~v9 \/ ~v15 \/ v50) /\
 (~v1 \/ ~v11 \/ v26 \/ ~v37 \/ v76 \/ v77 \/ ~v86) /\
 (v46 \/ v70 \/ v87 \/ v97 \/ v98) /\
 (v40 \/ ~v79 \/ v82 \/ ~v88 \/ v91) /\
 (v6 \/ ~v13 \/ v37 \/ v46 \/ ~v84 \/ v100) /\
 (v90 \/ ~v97) /\
 (v1 \/ ~v8 \/ ~v11 \/ v32 \/ ~v40 \/ ~v57 \/ v75) /\
 (~v29 \/ v66 \/ ~v70 \/ ~v92 \/ v95) /\
 (~v4 \/ ~v44 \/ v47 \/ ~v59 \/ v72 \/ ~v77 \/ ~v93 \/ v96 \/ ~v99) /\
 (v31 \/ v43 \/ ~v65 \/ ~v74 \/ v85 \/ ~v86) /\
 (v23 \/ ~v51 \/ v53 \/ v92) /\
 (v41 \/ v96) /\
 (~v31 \/ ~v60 \/ ~v86) /\
 (~v1 \/ ~v79 \/ v94) /\
 (~v12 \/ ~v24 \/ v53 \/ ~v59) /\
 (~v6 \/ v12 \/ v19 \/ v46 \/ ~v50 \/ ~v69 \/ ~v78 \/ v98) /\
 (~v46 \/ v54 \/ ~v92) /\
 (~v40 \/ v53 \/ v78) /\
 (v7 \/ v22 \/ ~v28 \/ ~v38 \/ v45) /\
 (v17 \/ v53 \/ v63 \/ ~v91) /\
 (v70 \/ ~v71 \/ ~v93) /\
 (~v32 \/ ~v83 \/ ~v94 \/ ~v99) /\
 (~v1 \/ ~v77) /\
 (v3 \/ v21 \/ v73 \/ ~v86) /\
 (~v3 \/ v26 \/ v31 \/ v47 \/ v49 \/ ~v57 \/ ~v75 \/ v78 \/ ~v88) /\
 (v28 \/ v33 \/ v48 \/ ~v85 \/ ~v97) /\
 (~v2 \/ v88) /\
 (v1 \/ v46 \/ ~v66 \/ v80 \/ ~v82) /\
 (v88 \/ ~v89) /\
 (v10 \/ v21 \/ ~v23 \/ ~v27 \/ v54 \/ v70 \/ v72 \/ ~v94 \/ v97 \/ v99) /\
 (~v15 \/ v28 \/ v77 \/ ~v82) /\
 (~v20 \/ ~v55 \/ ~v94 \/ v98) /\
 (~v40 \/ ~v52 \/ v72 \/ ~v82) /\
 (v35 \/ ~v71 \/ ~v80 \/ v86) /\
 (v3 \/ ~v23 \/ ~v32 \/ ~v39 \/ v43 \/ ~v56 \/ v80 \/ v82) /\
 (~v5 \/ ~v22 \/ v25 \/ ~v40 \/ v90) /\
 (~v15 \/ ~v65 \/ ~v94) /\
 (~v16 \/ v36 \/ ~v41 \/ v44 \/ ~v83) /\
 (~v8 \/ v12 \/ v15 \/ ~v17 \/ ~v26 \/ ~v52 \/ ~v63 \/ v74) /\
 (v1 \/ v6 \/ v13 \/ ~v62 \/ v67 \/ ~v80 \/ v98) /\
 (v7 \/ v45) /\
 (~v10 \/ v20 \/ v38 \/ v45 \/ v46) /\
 (v7 \/ ~v40 \/ v43 \/ ~v56 \/ ~v73) /\
 (~v35 \/ v89 \/ v97 \/ v100) /\
 (~v2 \/ v5 \/ v19 \/ ~v30 \/ v52 \/ v71 \/ ~v77 \/ ~v94 \/ ~v96) /\
 (v80 \/ ~v97) /\
 (~v13 \/ ~v72) /\
 (~v4 \/ ~v30 \/ v45 \/ ~v70 \/ v88 \/ v91 \/ v97) /\
 (v30 \/ v41 \/ ~v75) /\
 (v4 \/ v5 \/ v46 \/ ~v60 \/ v95 \/ ~v97) /\
 (v12 \/ v34 \/ v43 \/ v83) /\
 (~v2 \/ v44 \/ v85 \/ v100) /\
 (~v33 \/ v99) /\
 (~v28 \/ ~v32) /\
 (v36 \/ v67 \/ ~v84) /\
 (~v18 \/ v40 \/ ~v63 \/ ~v67 \/ ~v79) /\
 (v5 \/ v8 \/ v11 \/ ~v14 \/ ~v58 \/ v60 \/ ~v61 \/ v71 \/ ~v75 \/ ~v78 \/ v82) /\
 (v20 \/ ~v31 \/ ~v42 \/ v81) /\
 (v21 \/ v39 \/ ~v44) /\
 (~v9 \/ ~v48 \/ v53 \/ v57 \/ ~v69 \/ v71 \/ v75) /\
 (~v12 \/ v29 \/ ~v54 \/ v76 \/ v80 \/ v92) /\
 (v22 \/ v32 \/ ~v41 \/ ~v93) /\
 (v18 \/ v22 \/ ~v25 \/ ~v73) /\
 (v22 \/ ~v37 \/ v48 \/ v54 \/ v57 \/ v59 \/ ~v73 \/ ~v89) /\
 (~v1 \/ ~v8 \/ ~v27 \/ ~v51 \/ ~v56 \/ ~v69) /\
 (v33 \/ v38 \/ ~v41 \/ ~v54 \/ ~v96) /\
 (v22 \/ ~v24 \/ ~v27 \/ ~v48 \/ ~v71) /\
 (v3 \/ ~v13 \/ v60) /\
 (v7 \/ v15 \/ v79) /\
 (v53 \/ v54 \/ ~v69) /\
 (v21 \/ ~v30 \/ v51 \/ v67) /\
 (v12 \/ ~v24 \/ v28 \/ v30 \/ ~v33 \/ v41) /\
 (v22 \/ v28 \/ ~v65) /\
 (~v13 \/ ~v87) /\
 (~v1 \/ v12 \/ v13 \/ ~v54 \/ ~v58 \/ ~v62 \/ v89) /\
 (~v13 \/ v26 \/ ~v91) /\
 (v9 \/ v43 \/ ~v48 \/ ~v65 \/ v72 \/ v77 \/ ~v82 \/ v92) /\
 (v29 \/ ~v31 \/ ~v36 \/ v40 \/ v46 \/ v57 \/ v66) /\
 (~v18 \/ ~v31 \/ v35 \/ v47 \/ ~v50 \/ v56 \/ ~v62 \/ v82) /\
 (~v7 \/ v83 \/ v100) /\
 (~v14 \/ ~v68 \/ ~v88 \/ ~v91) /\
 (v1 \/ ~v9 \/ ~v11 \/ ~v55 \/ ~v85 \/ ~v94) /\
 (v5 \/ ~v28 \/ ~v32 \/ v73 \/ v84 \/ ~v85 \/ ~v95 \/ ~v98) /\
 (~v21 \/ v34 \/ ~v68 \/ v83) /\
 (~v12 \/ ~v14 \/ v38 \/ v66 \/ ~v76 \/ ~v84 \/ ~v89) /\
 (~v23 \/ ~v26 \/ ~v51 \/ v64) /\
 (v27 \/ ~v67 \/ v71) /\
 (~v15 \/ v40 \/ v63 \/ v68) /\
 (v21 \/ ~v75) /\
 (v21 \/ ~v35 \/ ~v50 \/ v55) /\
 (v45 \/ v87) /\
 (~v10 \/ ~v22 \/ v39) /\
 (v1 \/ v39 \/ ~v45 \/ v67 \/ v68 \/ ~v80) /\
 (~v9 \/ v11 \/ ~v31 \/ v35 \/ ~v50 \/ v64 \/ v67 \/ v69) /\
 (~v33 \/ v53 \/ v73 \/ v76 \/ v77) /\
 (~v7 \/ v27 \/ ~v41 \/ v63) /\
 (~v18 \/ v50 \/ v61) /\
 (~v34 \/ ~v66 \/ v69) /\
 (~v6 \/ v9 \/ v29 \/ v30 \/ v82) /\
 (~v3 \/ v39 \/ v58 \/ v60 \/ v62 \/ v97) /\
 (v56 \/ v61) /\
 (~v6 \/ ~v34 \/ ~v47 \/ ~v57) /\
 (v17 \/ v28 \/ v85 \/ ~v94) /\
 (~v16 \/ v22 \/ ~v58) /\
 (v12 \/ v31 \/ v32 \/ ~v67 \/ v76 \/ v86) /\
 (~v8 \/ v19 \/ ~v24 \/ ~v43 \/ v45 \/ v50 \/ ~v56) /\
 (v53 \/ ~v55 \/ ~v88) /\
 (v35 \/ v37 \/ ~v52 \/ v54 \/ v90) /\
 (~v60 \/ ~v82 \/ ~v92) /\
 (v11 \/ ~v55 \/ ~v78 \/ ~v93) /\
 (~v37 \/ ~v50 \/ v72) /\
 (v13 \/ ~v14 \/ ~v28 \/ v38 \/ ~v69 \/ ~v71 \/ ~v94 \/ v96 \/ ~v97) /\
 (v14 \/ v23 \/ ~v35 \/ ~v39 \/ v75) /\
 (v8 \/ ~v11 \/ ~v56 \/ v87) /\
 (v9 \/ v20 \/ v23 \/ v52) /\
 (~v6 \/ ~v11 \/ v98) /\
 (v77 \/ ~v91 \/ v95) /\
 (v16 \/ v17 \/ ~v33 \/ v37 \/ v39 \/ v60 \/ ~v67 \/ ~v76 \/ ~v93 \/ ~v98) /\
 (v8 \/ v45 \/ v60) /\
 (~v26 \/ ~v51 \/ v62 \/ v63 \/ ~v78 \/ ~v81) /\
 (v40 \/ v43 \/ v65 \/ ~v80 \/ ~v89) /\
 (v40 \/ ~v61 \/ v73 \/ ~v74) /\
 (v26 \/ ~v32 \/ ~v44 \/ ~v65 \/ v67 \/ v68 \/ ~v70 \/ v72 \/ v73 \/ ~v75 \/ ~v80) /\
 (~v18 \/ v39 \/ ~v60) /\
 (v1 \/ ~v19) /\
 (~v3 \/ v11 \/ v12 \/ v31 \/ v46 \/ ~v69 \/ ~v78 \/ v90) /\
 (v17 \/ ~v53) /\
 (v1 \/ v18 \/ ~v46 \/ v64 \/ ~v82) /\
 (v2 \/ v39 \/ v56 \/ ~v96) /\
 (v21 \/ v35 \/ ~v50 \/ ~v66 \/ ~v74) /\
 (v50 \/ ~v54 \/ ~v93 \/ v99) /\
 (~v15 \/ ~v22) /\
 (v40 \/ v54 \/ ~v65 \/ v76) /\
 (v10 \/ v42 \/ ~v88 \/ ~v93) /\
 (v23 \/ v30 \/ v39 \/ v41 \/ v46 \/ v57 \/ ~v71 \/ ~v74 \/ v84) /\
 (v5 \/ ~v15 \/ ~v42 \/ v50 \/ v59) /\
 (v4 \/ ~v21 \/ v26 \/ ~v46 \/ ~v77 \/ ~v86 \/ v97 \/ v98) /\
 (v4 \/ v8 \/ ~v37 \/ ~v69 \/ v88 \/ ~v93) /\
 (v9 \/ ~v21 \/ v46 \/ ~v63) /\
 (v11 \/ v44 \/ ~v77 \/ ~v90) /\
 (v13 \/ ~v19 \/ v22 \/ v40 \/ ~v42 \/ ~v92) /\
 (v27 \/ v89 \/ v99) /\
 (~v40 \/ ~v78 \/ v98) /\
 (v60 \/ v61 \/ ~v66 \/ ~v80 \/ v88 \/ ~v90) /\
 (v2 \/ v44 \/ v72) /\
 (v4 \/ v9 \/ ~v22 \/ v26 \/ ~v48 \/ v52 \/ ~v84 \/ v95) /\
 (~v44 \/ v67 \/ ~v82 \/ ~v87 \/ ~v91) /\
 (~v8 \/ ~v45 \/ v69 \/ ~v76) /\
 (v6 \/ v42 \/ ~v45 \/ v52 \/ v87 \/ ~v97) /\
 (~v3 \/ v86 \/ v88) /\
 (v11 \/ v14 \/ ~v41 \/ v47 \/ v72) /\
 (~v10 \/ v61) /\
 (v16 \/ ~v97 \/ v100) /\
 (v4 \/ v19 \/ v26 \/ ~v31 \/ v84 \/ v85) /\
 (~v43 \/ v83 \/ v89) /\
 (~v1 \/ ~v42 \/ v45 \/ ~v66 \/ ~v83) /\
 (~v3 \/ ~v7 \/ ~v56 \/ v75 \/ v80 \/ v89) /\
 (v6 \/ v11 \/ ~v26 \/ ~v52 \/ v63 \/ v65 \/ ~v86 \/ ~v88 \/ v97) /\
 (~v26 \/ ~v55) /\
 (v36 \/ v64 \/ v91) /\
 (~v3 \/ ~v13 \/ ~v36 \/ v43 \/ ~v49 \/ v80) /\
 (v37 \/ ~v41) /\
 (v2 \/ v3 \/ ~v38 \/ v69 \/ v72 \/ ~v79 \/ v85) /\
 (v10 \/ v11 \/ ~v18 \/ ~v23 \/ ~v29 \/ v88) /\
 (v4 \/ ~v5 \/ ~v42 \/ v51 \/ ~v54 \/ ~v78 \/ ~v82) /\
 (~v19 \/ ~v25 \/ ~v38 \/ v65 \/ v67 \/ v84 \/ ~v97) /\
 (v4 \/ v11 \/ ~v12 \/ v50 \/ ~v60 \/ v76 \/ ~v87) /\
 (~v5 \/ ~v20 \/ ~v24 \/ ~v29 \/ ~v59) /\
 (~v22 \/ ~v36 \/ ~v40 \/ ~v44 \/ v54 \/ ~v73 \/ ~v93 \/ v98) /\
 (v7 \/ v14 \/ ~v25 \/ ~v54 \/ v56 \/ v96) /\
 (~v24 \/ ~v27 \/ v40) /\
 (v36 \/ ~v41 \/ v48 \/ v49 \/ v84 \/ ~v97) /\
 (~v3 \/ v23 \/ v25 \/ v38 \/ v39 \/ v55 \/ v59 \/ ~v65 \/ ~v89) /\
 (v18 \/ v31 \/ v34 \/ v36 \/ ~v50 \/ ~v67 \/ v93) /\
 (~v7 \/ ~v30 \/ ~v36) /\
 (v19 \/ v20 \/ ~v26 \/ v47 \/ ~v66) /\
 (v16 \/ v42 \/ ~v55 \/ ~v65 \/ ~v76) /\
 (v7 \/ v29 \/ v35 \/ v78) /\
 (v3 \/ ~v44 \/ ~v51 \/ v78 \/ ~v99) /\
 (v35 \/ ~v48 \/ ~v71 \/ ~v90) /\
 (~v9 \/ v33 \/ v34 \/ ~v45) /\
 (v7 \/ ~v12 \/ v19 \/ v46 \/ ~v47 \/ ~v58 \/ ~v73 \/ ~v76 \/ ~v97) /\
 (~v35 \/ ~v40 \/ v46 \/ v47 \/ v75) /\
 (v55 \/ ~v84 \/ v87 \/ ~v96 \/ ~v99) /\
 (~v44 \/ v49 \/ v78 \/ ~v93 \/ v97) /\
 (v31 \/ ~v53 \/ v62 \/ ~v63 \/ ~v66) /\
 (~v68 \/ v78) /\
 (v1 \/ ~v2 \/ v19 \/ v20 \/ v31 \/ v39 \/ ~v47 \/ ~v54 \/ ~v93) /\
 (~v15 \/ v19 \/ ~v27 \/ v30 \/ ~v31 \/ v65 \/ v77) /\
 (~v31 \/ v47 \/ v65 \/ ~v71) /\
 (v50 \/ ~v72 \/ ~v76 \/ ~v88) /\
 (v12 \/ ~v25 \/ v42 \/ v66) /\
 (~v8 \/ ~v17 \/ v49) /\
 (~v21 \/ ~v23 \/ v29 \/ v77) /\
 (~v18 \/ ~v24 \/ v59) /\
 (v6 \/ v7 \/ ~v10 \/ ~v20 \/ v35 \/ ~v46 \/ v85 \/ v86 \/ ~v95) /\
 (v55 \/ v79 \/ v96) /\
 (v9 \/ v49 \/ ~v88 \/ v91 \/ ~v97 \/ v100) /\
 (~v6 \/ v15 \/ ~v22 \/ v46 \/ v55 \/ ~v93) /\
 (~v1 \/ v4 \/ v10 \/ ~v17 \/ ~v20 \/ v41 \/ ~v49 \/ ~v66 \/ v84) /\
 (~v2 \/ v5 \/ ~v8 \/ ~v38 \/ v75 \/ ~v79) /\
 (~v13 \/ ~v53 \/ v56 \/ ~v68 \/ v81 \/ ~v86) /\
 (v1 \/ v40 \/ v52 \/ ~v74 \/ ~v83 \/ v94 \/ ~v95) /\
 (v5 \/ v32 \/ ~v60 \/ v62) /\
 (v3 \/ ~v40 \/ ~v69 \/ ~v95) /\
 (~v10 \/ ~v88) /\
 (v7 \/ ~v21 \/ ~v33 \/ v62 \/ ~v68) /\
 (~v1 \/ ~v15 \/ v21 \/ v28 \/ v55 \/ ~v59 \/ ~v78 \/ ~v87) /\
 (~v55 \/ v63) /\
 (~v49 \/ v62 \/ v87) /\
 (v16 \/ v31 \/ ~v37 \/ ~v47 \/ v54) /\
 (~v2 \/ v26 \/ v62 \/ v72 \/ ~v100) /\
 (~v3 \/ ~v8 \/ v79 \/ ~v80) /\
 (~v41 \/ ~v92) /\
 (~v10 \/ ~v86) /\
 (v12 \/ v30 \/ v82 \/ ~v95) /\
 (~v6 \/ ~v12 \/ v35 \/ v40 \/ v56 \/ v58 \/ ~v66 \/ ~v84 \/ v87 \/ ~v97) /\
 (v37 \/ v42 \/ v57 \/ ~v94) /\
 (~v11 \/ v97) /\
 (v10 \/ v55 \/ ~v75 \/ v89 \/ ~v91) /\
 (v97 \/ ~v98) /\
 (~v3 \/ v6 \/ v8 \/ ~v29) /\
 (v19 \/ v30 \/ ~v32 \/ ~v36 \/ v63 \/ v79 \/ v81) /\
 (~v3 \/ v7 \/ ~v24 \/ v37 \/ v86 \/ ~v91) /\
 (~v29 \/ ~v64) /\
 (~v49 \/ ~v61 \/ v81 \/ ~v91) /\
 (v44 \/ ~v80 \/ ~v89 \/ v95) /\
 (v12 \/ ~v32 \/ ~v41 \/ ~v48 \/ v52 \/ ~v65 \/ v89 \/ v91) /\
 (~v3 \/ ~v14 \/ ~v31 \/ v34 \/ ~v49 \/ v99) /\
 (~v24 \/ ~v74) /\
 (~v25 \/ v45 \/ ~v50 \/ v53 \/ ~v92) /\
 (v7 \/ ~v17 \/ v21 \/ v24 \/ ~v26 \/ ~v35 \/ ~v61 \/ ~v72 \/ v83) /\
 (v10 \/ v15 \/ v22 \/ ~v71 \/ v76 \/ ~v89) /\
 (v16 \/ v54) /\
 (~v19 \/ v29 \/ v47 \/ v54 \/ v55) /\
 (v6 \/ v9 \/ v16 \/ ~v49 \/ v52 \/ ~v65 \/ ~v82) /\
 (~v3 \/ ~v5 \/ ~v44 \/ v98) /\
 (~v6 \/ ~v11 \/ v14 \/ v28 \/ ~v39 \/ v61 \/ v80 \/ ~v86) /\
 (v6 \/ ~v22 \/ ~v81) /\
 (~v13 \/ ~v39 \/ v54 \/ ~v79 \/ v97 \/ v100) /\
 (v4 \/ ~v6 \/ v39 \/ v50 \/ ~v84) /\
 (v13 \/ v14 \/ v55 \/ ~v69) /\
 (v9 \/ v21 \/ v43 \/ v52 \/ v92) /\
 (v8 \/ ~v11 \/ v53 \/ v94) /\
 (~v37 \/ ~v41) /\
 (v45 \/ v76 \/ ~v93) /\
 (~v27 \/ v49 \/ ~v72 \/ ~v76 \/ ~v88) /\
 (v14 \/ v17 \/ v20 \/ ~v23 \/ ~v67 \/ v69 \/ ~v70 \/ v80 \/ ~v84 \/ ~v87 \/ v91) /\
 (v29 \/ ~v40 \/ ~v51 \/ v90) /\
 (v30 \/ v48 \/ ~v53) /\
 (v1 \/ ~v18 \/ ~v57 \/ v62 \/ v66 \/ ~v78 \/ v80 \/ v84) /\
 (~v2 \/ ~v21 \/ v38 \/ ~v63 \/ v85 \/ v89) /\
 (v31 \/ v41 \/ ~v50) /\
 (v27 \/ v31 \/ ~v34 \/ ~v82) /\
 (v31 \/ ~v46 \/ v57 \/ v63 \/ v66 \/ v68 \/ ~v82 \/ ~v98) /\
 (~v5 \/ ~v10 \/ ~v17 \/ ~v36 \/ ~v60 \/ ~v65 \/ ~v78) /\
 (v42 \/ v47 \/ ~v50 \/ ~v63) /\
 (v31 \/ ~v33 \/ ~v36 \/ ~v57 \/ ~v80) /\
 (v12 \/ ~v22 \/ v69) /\
 (v16 \/ v24 \/ v88) /\
 (v62 \/ v63 \/ ~v78) /\
 (v30 \/ ~v39 \/ v60 \/ v76) /\
 (v21 \/ ~v33 \/ v37 \/ v39 \/ ~v42 \/ v50) /\
 (v31 \/ v37 \/ ~v74) /\
 (~v22 \/ ~v96) /\
 (~v10 \/ v21 \/ v22 \/ ~v63 \/ ~v67 \/ ~v71 \/ v98) /\
 (v1 \/ ~v22 \/ v35 \/ ~v100) /\
 (v18 \/ v52 \/ ~v57 \/ ~v74 \/ v81 \/ v86 \/ ~v91) /\
 (v38 \/ ~v40 \/ ~v45 \/ v49 \/ v55 \/ v66 \/ v75) /\
 (v9 \/ ~v27 \/ ~v40 \/ v44 \/ v56 \/ ~v59 \/ v65 \/ ~v71 \/ v91) /\
 (~v16 \/ v92) /\
 (~v3 \/ ~v23 \/ ~v77 \/ ~v97 \/ ~v100) /\
 (~v4 \/ ~v7 \/ v10 \/ ~v18 \/ ~v20 \/ ~v64 \/ ~v94) /\
 (v14 \/ ~v37 \/ ~v41 \/ v82 \/ v93 \/ ~v94) /\
 (~v30 \/ v43 \/ ~v77 \/ v92) /\
 (~v21 \/ ~v23 \/ v47 \/ v75 \/ ~v85 \/ ~v93 \/ ~v98) /\
 (~v32 \/ ~v35 \/ ~v60 \/ v73) /\
 (v36 \/ ~v76 \/ v80) /\
 (~v24 \/ v49 \/ v72 \/ v77) /\
 (v30 \/ ~v84) /\
 (v30 \/ ~v44 \/ ~v59 \/ v64) /\
 (v54 \/ v96) /\
 (~v19 \/ ~v31 \/ v48) /\
 (v10 \/ v48 \/ ~v54 \/ v76 \/ v77 \/ ~v89) /\
 (~v18 \/ v20 \/ ~v40 \/ v44 \/ ~v59 \/ v73 \/ v76 \/ v78) /\
 (~v42 \/ v62 \/ v82 \/ v85 \/ v86) /\
 (~v16 \/ v36 \/ ~v50 \/ v72) /\
 (~v27 \/ v59 \/ v70) /\
 (~v43 \/ ~v75 \/ v78) /\
 (v6 \/ ~v15 \/ v18 \/ v38 \/ v39 \/ v91) /\
 (~v12 \/ v48 \/ v67 \/ v69 \/ v71) /\
 (v65 \/ v70) /\
 (~v3 \/ ~v15 \/ ~v43 \/ ~v56 \/ ~v66) /\
 (v26 \/ v37 \/ v94) /\
 (~v25 \/ v31 \/ ~v67) /\
 (v21 \/ v40 \/ v41 \/ ~v76 \/ v85 \/ v95) /\
 (~v17 \/ v28 \/ ~v33 \/ ~v52 \/ v54 \/ v59 \/ ~v65) /\
 (v62 \/ ~v64 \/ ~v97) /\
 (~v1 \/ v44 \/ v46 \/ ~v61 \/ v63 \/ v99) /\
 (~v2 \/ ~v69 \/ ~v91) /\
 (v20 \/ ~v64 \/ ~v87) /\
 (~v46 \/ ~v59 \/ v81) /\
 (~v3 \/ v5 \/ ~v6) /\
 (v22 \/ ~v23 \/ ~v37 \/ v47 \/ ~v78 \/ ~v80) /\
 (v23 \/ v32 \/ ~v44 \/ ~v48 \/ v84) /\
 (v17 \/ ~v20 \/ ~v65 \/ v96) /\
 (v7 \/ v18 \/ v29 \/ v32 \/ v61) /\
 (v4 \/ ~v15 \/ ~v20) /\
 (~v2 \/ ~v7 \/ v86 \/ ~v100) /\
 (v25 \/ v26 \/ ~v42 \/ v46 \/ v48 \/ v69 \/ ~v76 \/ ~v85) /\
 (v17 \/ v54 \/ v69) /\
 (~v35 \/ ~v60 \/ v71 \/ v72 \/ ~v87 \/ ~v90) /\
 (v49 \/ v52 \/ v74 \/ ~v89 \/ ~v98) /\
 (v49 \/ ~v70 \/ v82 \/ ~v83) /\
 (v35 \/ ~v41 \/ ~v53 \/ ~v74 \/ v76 \/ v77 \/ ~v79 \/ v81 \/ v82 \/ ~v84 \/ ~v89) /\
 (~v27 \/ v48 \/ ~v69) /\
 (v10 \/ ~v28) /\
 (~v12 \/ v20 \/ v21 \/ v40 \/ v55 \/ ~v78 \/ ~v87 \/ v99) /\
 (v26 \/ ~v62) /\
 (~v5 \/ v10 \/ v27 \/ ~v55 \/ v73 \/ ~v91) /\
 (v11 \/ v48 \/ v65) /\
 (~v2 \/ v8 \/ v30 \/ v44 \/ ~v59 \/ ~v75 \/ ~v83) /\
 (v59 \/ ~v63) /\
 (~v24 \/ ~v31) /\
 (~v2 \/ v49 \/ v63 \/ ~v74 \/ v85) /\
 (v19 \/ v51 \/ ~v97) /\
 (v32 \/ v39 \/ v48 \/ v50 \/ v55 \/ v66 \/ ~v80 \/ ~v83 \/ v93) /\
 (v6 \/ v7 \/ v14 \/ ~v24 \/ ~v51 \/ v59 \/ v68) /\
 (~v2 \/ v13 \/ ~v30 \/ v35 \/ ~v55 \/ ~v86 \/ ~v95) /\
 (v13 \/ v17 \/ ~v46 \/ ~v78 \/ v97) /\
 (v18 \/ ~v30 \/ v55 \/ ~v72) /\
 (~v1 \/ v20 \/ v53 \/ ~v86 \/ ~v99) /\
 (v8 \/ v22 \/ ~v28 \/ v31 \/ v49 \/ ~v51) /\
 (v7 \/ v36 \/ v98) /\
 (~v49 \/ ~v87) /\
 (v69 \/ v70 \/ ~v75 \/ ~v89 \/ v97 \/ ~v99) /\
 (v11 \/ v53 \/ v81) /\
 (v13 \/ v18 \/ ~v31 \/ v35 \/ ~v57 \/ v61 \/ ~v93) /\
 (~v53 \/ v76 \/ ~v91 \/ ~v96 \/ ~v100) /\
 (~v6 \/ ~v17 \/ ~v54 \/ v78 \/ ~v85) /\
 (v15 \/ v51 \/ ~v54 \/ v61 \/ v96) /\
 (~v12 \/ v95 \/ v97) /\
 (v20 \/ v23 \/ ~v50 \/ v56 \/ v81) /\
 (~v6 \/ v9 \/ ~v19 \/ v70) /\
 (v13 \/ v28 \/ v35 \/ ~v40 \/ v93 \/ v94) /\
 (~v52 \/ v92 \/ v98) /\
 (~v10 \/ ~v51 \/ v54 \/ ~v75 \/ ~v92) /\
 (v6 \/ ~v12 \/ ~v16 \/ ~v65 \/ v84 \/ v89 \/ v98) /\
 (v15 \/ v20 \/ ~v35 \/ ~v61 \/ v72 \/ v74 \/ ~v95 \/ ~v97) /\
 (~v35 \/ ~v64) /\
 (v45 \/ v73 \/ v100) /\
 (~v12 \/ ~v22 \/ ~v45 \/ v52 \/ ~v58 \/ v89) /\
 (v46 \/ ~v50) /\
 (v11 \/ v12 \/ ~v47 \/ v78 \/ v81 \/ ~v88 \/ v94) /\
 (v19 \/ v20 \/ ~v27 \/ ~v32 \/ ~v38 \/ v97) /\
 (~v6 \/ v13 \/ ~v14 \/ ~v51 \/ v60 \/ ~v63 \/ ~v87 \/ ~v91) /\
 (~v28 \/ ~v34 \/ ~v47 \/ v74 \/ v76 \/ v93) /\
 (v13 \/ v20 \/ ~v21 \/ v59 \/ ~v69 \/ v85 \/ ~v96) /\
 (~v2 \/ v7 \/ ~v14 \/ ~v29 \/ ~v33 \/ ~v38 \/ ~v68) /\
 (v5 \/ ~v31 \/ ~v45 \/ ~v49 \/ ~v53 \/ v63 \/ ~v82) /\
 (v16 \/ v23 \/ ~v34 \/ ~v63 \/ v65) /\
 (~v6 \/ ~v33 \/ ~v36 \/ v49) /\
 (v45 \/ ~v50 \/ v57 \/ v58 \/ v93) /\
 (v2 \/ ~v12 \/ v32 \/ v34 \/ v47 \/ v48 \/ v64 \/ v68 \/ ~v74 \/ ~v98) /\
 (v27 \/ v40 \/ v43 \/ v45 \/ ~v59 \/ ~v76) /\
 (~v16 \/ ~v39 \/ ~v45) /\
 (v28 \/ v29 \/ ~v35 \/ v56 \/ ~v75) /\
 (v25 \/ v51 \/ ~v64 \/ ~v74 \/ ~v85) /\
 (~v8 \/ v16 \/ v38 \/ v44 \/ v87) /\
 (v12 \/ ~v53 \/ ~v60 \/ v87) /\
 (v44 \/ ~v57 \/ ~v80 \/ ~v99) /\
 (~v6 \/ ~v18 \/ v42 \/ v43 \/ ~v54) /\
 (v16 \/ ~v21 \/ v28 \/ v55 \/ ~v56 \/ ~v67 \/ ~v82 \/ ~v85) /\
 (~v5 \/ ~v8 \/ ~v44 \/ ~v49 \/ v55 \/ v56 \/ v84) /\
 (~v2 \/ v6 \/ v64 \/ ~v93 \/ v96) /\
 (~v53 \/ v58 \/ v87) /\
 (v40 \/ ~v62 \/ v71 \/ ~v72 \/ ~v75) /\
 (~v2 \/ ~v77 \/ v87) /\
 (v10 \/ ~v11 \/ v28 \/ v29 \/ v40 \/ v48 \/ ~v56 \/ ~v63) /\
 (~v24 \/ v28 \/ ~v36 \/ v39 \/ ~v40 \/ v74 \/ v86) /\
 (~v40 \/ v56 \/ v74 \/ ~v80) /\
 (v59 \/ ~v81 \/ ~v85 \/ ~v97) /\
 (v21 \/ ~v34 \/ v51 \/ v75) /\
 (~v17 \/ ~v26 \/ v58) /\
 (~v30 \/ ~v32 \/ v38 \/ v86) /\
 (~v4 \/ ~v27 \/ ~v33 \/ v68) /\
 (v5 \/ v15 \/ v16 \/ ~v19 \/ ~v29 \/ v44 \/ ~v55 \/ v94 \/ v95) /\
 (~v6 \/ v9 \/ v64 \/ v88) /\
 (~v2 \/ v18 \/ v58 \/ ~v97 \/ v100) /\
 (v8 \/ ~v15 \/ v24 \/ ~v31 \/ v55 \/ v64) /\
 (~v10 \/ v13 \/ v19 \/ ~v26 \/ ~v29 \/ v50 \/ ~v58 \/ ~v75 \/ v93) /\
 (~v11 \/ v14 \/ ~v17 \/ ~v47 \/ v84 \/ ~v88) /\
 (v3 \/ ~v4 \/ ~v22 \/ ~v62 \/ v65 \/ ~v77 \/ v90 \/ ~v95) /\
 (v10 \/ v49 \/ v61 \/ ~v83 \/ ~v92) /\
 (v14 \/ v41 \/ ~v69 \/ v71) /\
 (~v4 \/ v59) /\
 (v12 \/ ~v49 \/ ~v78) /\
 (~v19 \/ ~v97) /\
 (v16 \/ ~v30 \/ ~v42 \/ v71 \/ ~v77) /\
 (~v10 \/ ~v24 \/ v30 \/ v37 \/ v64 \/ ~v68 \/ ~v87 \/ ~v96) /\
 (~v64 \/ v72) /\
 (~v58 \/ v71 \/ v96) /\
 (~v9 \/ v25 \/ v40 \/ ~v46 \/ ~v56 \/ v63) /\
 (~v11 \/ v35 \/ v71 \/ v81) /\
 (~v1 \/ ~v12 \/ ~v17 \/ v88 \/ ~v89) /\
 (~v4 \/ ~v19 \/ ~v95) /\
 (~v6 \/ v21 \/ v39 \/ v91) /\
 (~v3 \/ ~v15 \/ ~v21 \/ v44 \/ v49 \/ v65 \/ v67 \/ ~v75 \/ ~v93 \/ v96) /\
 (v6 \/ v46 \/ v51 \/ v66) /\
 (v6 \/ ~v7 \/ v19 \/ v64 \/ ~v84 \/ v98 \/ ~v100) /\
 (~v12 \/ v15 \/ v17 \/ ~v38) /\
 (v28 \/ v39 \/ ~v41 \/ ~v45 \/ v72 \/ v88 \/ v90) /\
 (~v12 \/ v16 \/ ~v33 \/ v46 \/ v95 \/ ~v100) /\
 (~v38 \/ ~v73) /\
 (v4 \/ ~v58 \/ ~v70 \/ v90 \/ ~v100) /\
 (v53 \/ ~v89 \/ ~v98) /\
 (v8 \/ v21 \/ ~v41 \/ ~v50 \/ ~v57 \/ v61 \/ ~v74 \/ v98 \/ v100) /\
 (~v12 \/ ~v23 \/ ~v40 \/ v43 \/ ~v58) /\
 (~v1 \/ ~v33 \/ ~v83) /\
 (~v34 \/ v54 \/ ~v59 \/ v62) /\
 (v16 \/ ~v26 \/ v30 \/ v33 \/ ~v35 \/ ~v44 \/ ~v70 \/ ~v81 \/ v92) /\
 (v19 \/ v24 \/ v31 \/ ~v80 \/ v85 \/ ~v98) /\
 (v25 \/ v63) /\
 (~v28 \/ v38 \/ v56 \/ v63 \/ v64) /\
 (v7 \/ v15 \/ v18 \/ v25 \/ ~v58 \/ v61 \/ ~v74 \/ ~v91) /\
 (~v12 \/ ~v14 \/ ~v53) /\
 (~v15 \/ ~v20 \/ v23 \/ v37 \/ ~v48 \/ v70 \/ v89 \/ ~v95) /\
 (v6 \/ v9 \/ v15 \/ ~v31 \/ ~v90) /\
 (~v22 \/ ~v48 \/ v63 \/ ~v88) /\
 (v13 \/ ~v15 \/ v48 \/ v59 \/ ~v93) /\
 (v1 \/ v22 \/ v23 \/ v64 \/ ~v78) /\
 (v3 \/ v18 \/ v30 \/ v52 \/ v61) /\
 (v17 \/ ~v20 \/ v62) /\
 (~v2 \/ ~v46 \/ ~v50) /\
 (v54 \/ v85) /\
 (~v36 \/ v58 \/ ~v81 \/ ~v85 \/ ~v97) /\
 (v23 \/ v26 \/ v29 \/ ~v32 \/ ~v76 \/ v78 \/ ~v79 \/ v89 \/ ~v93 \/ ~v96 \/ v100) /\
 (v38 \/ ~v49 \/ ~v60 \/ v99) /\
 (v39 \/ v57 \/ ~v62) /\
 (v10 \/ ~v27 \/ ~v66 \/ v71 \/ v75 \/ ~v87 \/ v89 \/ v93) /\
 (~v11 \/ ~v30 \/ v47 \/ ~v72 \/ v94 \/ v98) /\
 (v40 \/ v50 \/ ~v59) /\
 (v36 \/ v40 \/ ~v43 \/ ~v91) /\
 (~v7 \/ v75) /\
 (v40 \/ ~v55 \/ v66 \/ v72 \/ v75 \/ v77 \/ ~v91) /\
 (~v14 \/ ~v19 \/ ~v26 \/ ~v45 \/ ~v69 \/ ~v74 \/ ~v87) /\
 (v51 \/ v56 \/ ~v59 \/ ~v72) /\
 (v40 \/ ~v42 \/ ~v45 \/ ~v66 \/ ~v89) /\
 (v21 \/ ~v31 \/ v78) /\
 (v25 \/ v33 \/ v97) /\
 (v71 \/ v72 \/ ~v87) /\
 (v39 \/ ~v48 \/ v69 \/ v85) /\
 (v30 \/ ~v42 \/ v46 \/ v48 \/ ~v51 \/ v59) /\
 (~v5 \/ v40 \/ v46 \/ ~v83) /\
 (v7 \/ ~v31) /\
 (~v9 \/ ~v19 \/ v30 \/ v31 \/ ~v72 \/ ~v76 \/ ~v80) /\
 (v10 \/ ~v31 \/ v44) /\
 (v27 \/ v61 \/ ~v66 \/ ~v83 \/ v90 \/ v95 \/ ~v100) /\
 (v47 \/ ~v49 \/ ~v54 \/ v58 \/ v64 \/ v75 \/ v84) /\
 (v1 \/ v18 \/ ~v36 \/ ~v49 \/ v53 \/ v65 \/ ~v68 \/ v74 \/ ~v80 \/ v100) /\
 (~v6 \/ ~v9 \/ ~v25) /\
 (~v3 \/ ~v12 \/ ~v32 \/ ~v86) /\
 (v2 \/ ~v3 \/ ~v13 \/ ~v16 \/ v19 \/ ~v27 \/ ~v29 \/ ~v73) /\
 (v1 \/ v23 \/ ~v46 \/ ~v50 \/ v91) /\
 (~v2 \/ ~v7 \/ ~v39 \/ v52 \/ ~v86) /\
 (~v30 \/ ~v32 \/ v56 \/ v84 \/ ~v94) /\
 (~v41 \/ ~v44 \/ ~v69 \/ v82) /\
 (v45 \/ ~v85 \/ v89) /\
 (~v33 \/ v58 \/ v81 \/ v86) /\
 (v39 \/ ~v93) /\
 (v5 \/ v39 \/ ~v53 \/ ~v68 \/ v73) /\
 (~v28 \/ ~v40 \/ v57) /\
 (v19 \/ v57 \/ ~v63 \/ v85 \/ v86 \/ ~v98) /\
 (~v27 \/ v29 \/ ~v49 \/ v53 \/ ~v68 \/ v82 \/ v85 \/ v87) /\
 (~v51 \/ v71 \/ v91 \/ v94 \/ v95) /\
 (~v25 \/ v45 \/ ~v59 \/ v81) /\
 (~v36 \/ v68 \/ v79) /\
 (~v52 \/ ~v84 \/ v87) /\
 (v15 \/ ~v24 \/ v27 \/ v47 \/ v48 \/ v100) /\
 (~v21 \/ v57 \/ v76 \/ v78 \/ v80) /\
 (v74 \/ v79) /\
 (v3 \/ ~v12 \/ ~v24 \/ ~v52 \/ ~v65 \/ ~v75) /\
 (v35 \/ v46) /\
 (v4 \/ ~v34 \/ v40 \/ ~v76) /\
 (v30 \/ v49 \/ v50 \/ ~v85 \/ v94) /\
 (~v6 \/ ~v26 \/ v37 \/ ~v42 \/ ~v61 \/ v63 \/ v68 \/ ~v74) /\
 (v8 \/ v71 \/ ~v73) /\
 (~v10 \/ v53 \/ v55 \/ ~v70 \/ v72) /\
 (~v11 \/ ~v78 \/ ~v100) /\
 (v29 \/ ~v73 \/ ~v96) /\
 (~v55 \/ ~v68 \/ v90) /\
 (~v12 \/ v14 \/ ~v15) /\
 (v31 \/ ~v32 \/ ~v46 \/ v56 \/ ~v87 \/ ~v89) /\
 (v5 \/ v32 \/ v41 \/ ~v53 \/ ~v57 \/ v93) /\
 (v26 \/ ~v29 \/ ~v74) /\
 (v16 \/ v27 \/ v38 \/ v41 \/ v70) /\
 (~v9 \/ v13 \/ ~v24 \/ ~v29) /\
 (~v11 \/ ~v16 \/ v95) /\
 (v34 \/ v35 \/ ~v51 \/ v55 \/ v57 \/ v78 \/ ~v85 \/ ~v94) /\
 (v26 \/ v63 \/ v78) /\
 (~v7 \/ ~v44 \/ ~v69 \/ v80 \/ v81 \/ ~v96 \/ ~v99) /\
 (v58 \/ v61 \/ v83 \/ ~v98) /\
 (v58 \/ ~v79 \/ v91 \/ ~v92) /\
 (v44 \/ ~v50 \/ ~v62 \/ ~v83 \/ v85 \/ v86 \/ ~v88 \/ v90 \/ v91 \/ ~v93 \/ ~v98) /\
 (~v36 \/ v57 \/ ~v78) /\
 (v8 \/ v19 \/ ~v37) /\
 (~v21 \/ v29 \/ v30 \/ v49 \/ v64 \/ ~v87 \/ ~v96) /\
 (v35 \/ ~v71) /\
 (~v14 \/ v19 \/ v36 \/ ~v64 \/ v82 \/ ~v100) /\
 (v20 \/ v57 \/ v74) /\
 (~v11 \/ v17 \/ v39 \/ v53 \/ ~v68 \/ ~v84 \/ ~v92) /\
 (v68 \/ ~v72) /\
 (~v33 \/ ~v40) /\
 (~v6 \/ ~v11 \/ v58 \/ v72 \/ ~v83 \/ v94) /\
 (v2 \/ v28 \/ v60) /\
 (v41 \/ v48 \/ v57 \/ v59 \/ v64 \/ v75 \/ ~v89 \/ ~v92) /\
 (~v4 \/ v15 \/ v16 \/ v23 \/ ~v33 \/ ~v60 \/ v68 \/ v77) /\
 (v6 \/ ~v11 \/ v22 \/ ~v39 \/ v44 \/ ~v64 \/ ~v95) /\
 (v22 \/ v26 \/ ~v55 \/ ~v87) /\
 (~v8 \/ v27 \/ ~v39 \/ v64 \/ ~v81) /\
 (~v10 \/ v29 \/ v62 \/ ~v95) /\
 (v7 \/ v17 \/ v31 \/ ~v37 \/ v40 \/ v58 \/ ~v60) /\
 (v16 \/ v45) /\
 (v6 \/ ~v8 \/ ~v58 \/ ~v96) /\
 (v78 \/ v79 \/ ~v84 \/ ~v98) /\
 (v20 \/ v62 \/ v90) /\
 (~v2 \/ v13) /\
 (~v5 \/ ~v9 \/ v22 \/ v27 \/ ~v40 \/ v44 \/ ~v66 \/ v70) /\
 (~v62 \/ v85 \/ ~v100) /\
 (v5 \/ ~v15 \/ ~v26 \/ ~v63 \/ v87 \/ ~v94) /\
 (v4 \/ v6 \/ v24 \/ v60 \/ ~v63 \/ v70) /\
 (v29 \/ v32 \/ ~v59 \/ v65 \/ v90) /\
 (~v15 \/ v18 \/ ~v28 \/ v79) /\
 (v2 \/ v3 \/ v34) /\
 (v1 \/ v7 \/ v22 \/ v37 \/ v44 \/ ~v49) /\
 (~v1 \/ ~v61) /\
 (v7 \/ ~v19 \/ ~v60 \/ v63 \/ ~v84) /\
 (~v4 \/ ~v6 \/ v15 \/ ~v21 \/ ~v25 \/ ~v74 \/ v93 \/ v98) /\
 (v24 \/ v29 \/ ~v44 \/ ~v70 \/ v81 \/ v83) /\
 (v9 \/ ~v44 \/ ~v73) /\
 (v54 \/ v82) /\
 (~v21 \/ ~v31 \/ ~v54 \/ v61 \/ ~v67 \/ v98) /\
 (v3 \/ v55 \/ ~v59) /\
 (v6 \/ v20 \/ v21 \/ ~v56 \/ v87 \/ v90 \/ ~v97) /\
 (v28 \/ v29 \/ ~v36 \/ ~v41 \/ ~v47) /\
 (v2 \/ ~v15 \/ v22 \/ ~v23 \/ ~v60 \/ v69 \/ ~v72 \/ ~v96 \/ ~v100) /\
 (~v5 \/ ~v37 \/ ~v43 \/ ~v56 \/ v83 \/ v85) /\
 (v22 \/ v29 \/ ~v30 \/ v68 \/ ~v78 \/ v94) /\
 (~v11 \/ v16 \/ ~v23 \/ ~v38 \/ ~v42 \/ ~v47 \/ ~v77) /\
 (v14 \/ ~v40 \/ ~v54 \/ ~v58 \/ ~v62 \/ v72 \/ ~v91) /\
 (v25 \/ v32 \/ ~v43 \/ ~v72 \/ v74) /\
 (v2 \/ ~v15 \/ ~v42 \/ ~v45 \/ v58) /\
 (~v7 \/ v54 \/ ~v59 \/ v66 \/ v67) /\
 (v11 \/ ~v21 \/ v41 \/ v43 \/ v56 \/ v57 \/ v73 \/ v77 \/ ~v83) /\
 (v36 \/ v49 \/ v52 \/ v54 \/ ~v68 \/ ~v85) /\
 (~v25 \/ ~v48 \/ ~v54) /\
 (v37 \/ v38 \/ ~v44 \/ v65 \/ ~v84) /\
 (v34 \/ v60 \/ ~v73 \/ ~v83 \/ ~v94) /\
 (~v17 \/ v25 \/ v47 \/ v53 \/ v96) /\
 (~v8 \/ v21 \/ ~v62 \/ ~v69 \/ v96) /\
 (v53 \/ ~v66 \/ ~v89) /\
 (~v15 \/ ~v27 \/ v51 \/ v52 \/ ~v63) /\
 (v25 \/ ~v30 \/ v37 \/ v64 \/ ~v65 \/ ~v76 \/ ~v91 \/ ~v94) /\
 (~v2 \/ v5 \/ ~v14 \/ ~v17 \/ ~v53 \/ ~v58 \/ v64 \/ v65 \/ v93) /\
 (~v11 \/ v15 \/ v73) /\
 (~v62 \/ v67 \/ v96) /\
 (v49 \/ ~v71 \/ v80 \/ ~v81 \/ ~v84) /\
 (~v11 \/ ~v86 \/ v96) /\
 (v19 \/ ~v20 \/ v37 \/ v38 \/ v49 \/ v57 \/ ~v65 \/ ~v72) /\
 (~v33 \/ v37 \/ ~v45 \/ v48 \/ ~v49 \/ v83 \/ v95) /\
 (~v6 \/ ~v49 \/ v65 \/ v83 \/ ~v89) /\
 (v68 \/ ~v90 \/ ~v94) /\
 (v30 \/ ~v43 \/ v60 \/ v84) /\
 (~v26 \/ ~v35 \/ v67) /\
 (~v39 \/ ~v41 \/ v47 \/ v95) /\
 (v3 \/ v4 \/ ~v13 \/ ~v36 \/ ~v42 \/ v77) /\
 (v14 \/ v24 \/ v25 \/ ~v28 \/ ~v38 \/ v53 \/ ~v64) /\
 (~v6 \/ v9 \/ ~v15 \/ v18 \/ v73 \/ v97) /\
 (~v11 \/ v27 \/ v67) /\
 (v17 \/ ~v24 \/ v33 \/ ~v40 \/ v64 \/ v73) /\
 (~v19 \/ v22 \/ v28 \/ ~v35 \/ ~v38 \/ v59 \/ ~v67 \/ ~v84) /\
 (~v4 \/ ~v20 \/ v23 \/ ~v26 \/ ~v56 \/ v93 \/ ~v97) /\
 (~v1 \/ v12 \/ ~v13 \/ ~v31 \/ ~v71 \/ v74 \/ ~v86 \/ v99) /\
 (v19 \/ v58 \/ v70 \/ ~v92) /\
 (v23 \/ v50 \/ ~v78 \/ v80) /\
 (~v13 \/ v68) /\
 (~v6 \/ v21 \/ ~v58 \/ ~v87) /\
 (~v5 \/ v25 \/ ~v39 \/ ~v51 \/ v80 \/ ~v86) /\
 (~v19 \/ ~v33 \/ v39 \/ v46 \/ v73 \/ ~v77 \/ ~v96) /\
 (v5 \/ ~v73 \/ v81) /\
 (~v67 \/ v80) /\
 (~v18 \/ v34 \/ v49 \/ ~v55 \/ ~v65 \/ v72) /\
 (~v20 \/ v44 \/ v80 \/ v90) /\
 (~v10 \/ ~v21 \/ ~v26 \/ v97 \/ ~v98) /\
 (~v4 \/ ~v59) /\
 (~v13 \/ ~v28) /\
 (~v2 \/ v5 \/ ~v15 \/ v30 \/ v48 \/ v100) /\
 (~v12 \/ ~v24 \/ ~v30 \/ v53 \/ v58 \/ v74 \/ v76 \/ ~v84) /\
 (v15 \/ v55 \/ v60 \/ v75))` ;

val rip04_be  = bdd_oracle
 `(car1 = a1 /\ b1) /\
  (car2 = (a2 \/ b2) /\ car1 \/ a2 /\ b2) /\
  (car3 = (a3 \/ b3) /\ car2 \/ a3 /\ b3) /\
  (cout = (a4 \/ b4) /\ car3 \/ a4 /\ b4) /\
  (som4 = ~(a4 = ~(b4 = car3))) /\
  (som3 = ~(a3 = ~(b3 = car2))) /\
  (som2 = ~(a2 = ~(b2 = car1))) /\
  (som1 = ~(a1 = b1)) /\
  (cout1 = b1 /\ a1) /\
  (cout2 = cout1 /\ b2 \/ cout1 /\ a2 \/ b2 /\ a2) /\
  (cout3 = cout2 /\ b3 \/ cout2 /\ a3 \/ b3 /\ a3)
  ==> (som1 = ~(~a1 /\ ~b1 \/ a1 /\ b1)) /\
      (som2 =
       ~((~a2 /\ ~b2 \/ a2 /\ b2) /\ ~cout1 \/
         cout1 /\ ~(~a2 /\ ~b2 \/ a2 /\ b2))) /\
      (som3 =
       ~((~a3 /\ ~b3 \/ a3 /\ b3) /\ ~cout2 \/
         cout2 /\ ~(~a3 /\ ~b3 \/ a3 /\ b3))) /\
      (som4 =
       ~((~a4 /\ ~b4 \/ a4 /\ b4) /\ ~cout3 \/
         cout3 /\ ~(~a4 /\ ~b4 \/ a4 /\ b4))) /\
      (cout = a4 /\ cout3 \/ b4 /\ cout3 \/ a4 /\ b4)`
;

val ztwaalf2_be  = bdd_oracle
 `(out =
   ~(a1 /\ a2 \/ ~a3 /\ (a4 = a5) = a6 /\ b6) \/
   (b1 /\ (b2 \/ b3 /\ (b4 = b5)) = b6 /\ a1))
  ==> (out =
       a1 /\ a2 /\ ~a6 \/
       ~a3 /\ ~a4 /\ ~a5 /\ ~a6 \/
       ~a3 /\ a4 /\ a5 /\ ~a6 \/
       ~a1 /\ ~b1 \/
       ~a1 /\ ~b2 /\ ~b3 \/
       ~a1 /\ ~b2 /\ b4 /\ ~b5 \/
       ~a1 /\ ~b2 /\ ~b4 /\ b5 \/
       a1 /\ a2 /\ ~b6 \/
       ~a3 /\ ~a4 /\ ~a5 /\ ~b6 \/
       ~a3 /\ a4 /\ a5 /\ ~b6 \/
       ~b1 /\ ~b6 \/
       ~b2 /\ ~b3 /\ ~b6 \/
       ~b2 /\ b4 /\ ~b5 /\ ~b6 \/
       ~b2 /\ ~b4 /\ b5 /\ ~b6 \/
       ~a1 /\ a3 /\ a6 /\ b6 \/
       ~a2 /\ a3 /\ a6 /\ b6 \/
       ~a1 /\ a4 /\ ~a5 /\ a6 /\ b6 \/
       ~a2 /\ a4 /\ ~a5 /\ a6 /\ b6 \/
       ~a1 /\ ~a4 /\ a5 /\ a6 /\ b6 \/
       ~a2 /\ ~a4 /\ a5 /\ a6 /\ b6 \/
       a1 /\ b1 /\ b2 /\ b6 \/
       a1 /\ b1 /\ b3 /\ ~b4 /\ ~b5 /\ b6 \/
       a1 /\ b1 /\ b3 /\ b4 /\ b5 /\ b6)`
;

val ztwaalf1_be  = bdd_oracle
 `(out =
   a1 /\ a2 /\ ~a6 \/
   ~a3 /\ ~a4 /\ ~a5 /\ ~a6 \/
   ~a3 /\ a4 /\ a5 /\ ~a6 \/
   ~a1 /\ ~b1 \/
   ~a1 /\ ~b2 /\ ~b3 \/
   ~a1 /\ ~b2 /\ b4 /\ ~b5 \/
   ~a1 /\ ~b2 /\ ~b4 /\ b5 \/
   a1 /\ a2 /\ ~b6 \/
   ~a3 /\ ~a4 /\ ~a5 /\ ~b6 \/
   ~a3 /\ a4 /\ a5 /\ ~b6 \/
   ~b1 /\ ~b6 \/
   ~b2 /\ ~b3 /\ ~b6 \/
   ~b2 /\ b4 /\ ~b5 /\ ~b6 \/
   ~b2 /\ ~b4 /\ b5 /\ ~b6 \/
   ~a1 /\ a3 /\ a6 /\ b6 \/
   ~a2 /\ a3 /\ a6 /\ b6 \/
   ~a1 /\ a4 /\ ~a5 /\ a6 /\ b6 \/
   ~a2 /\ a4 /\ ~a5 /\ a6 /\ b6 \/
   ~a1 /\ ~a4 /\ a5 /\ a6 /\ b6 \/
   ~a2 /\ ~a4 /\ a5 /\ a6 /\ b6 \/
   a1 /\ b1 /\ b2 /\ b6 \/
   a1 /\ b1 /\ b3 /\ ~b4 /\ ~b5 /\ b6 \/
   a1 /\ b1 /\ b3 /\ b4 /\ b5 /\ b6) /\
  (s1 = ~(a1 /\ a2 \/ ~a3 /\ (a4 = a5) = a6 /\ b6)) /\
  (s2 = ~(b1 /\ (b2 \/ b3 /\ (b4 = b5)) = b6 /\ a1))
  ==> (out = s1 \/ ~s2)` ;

val z4_be  = bdd_oracle
 `(ge2 = in3 \/ in0) /\
  (ge4 = ~in3 \/ ~in0) /\
  (ge1 = in5 \/ in2) /\
  (ge3 = ge2 /\ in6 \/ in3 /\ in0) /\
  (ge5 = ~ge2 \/ ge4 /\ ~in6) /\
  (ge7 = ~in5 \/ ~in2) /\
  (ge0 = in4 \/ in1) /\
  (ge6 = ge3 /\ ge1 \/ in5 /\ in2) /\
  (ge8 = in4 /\ in1) /\
  (ge9 = ~in4 /\ in1 \/ in4 /\ ~in1) /\
  (out0 = ge6 /\ ge0 \/ ge8) /\
  (out1 = ge9 /\ ge7 /\ ge5 \/ ge6 /\ ~ge0 \/ ge9 /\ ~ge1 \/ ge8 /\ ge6) /\
  (out2 =
   ge5 /\ in5 /\ ~in2 \/ ge5 /\ ~in5 /\ in2 \/ ge3 /\ ~ge1 \/ ~ge7 /\ ge3) /\
  (out3 =
   ~in6 /\ in3 /\ ~in0 \/ ~in6 /\ ~in3 /\ in0 \/ ~ge2 /\ in6 \/ ~ge4 /\ in6) /\
  (wres2 = in3 \/ in0) /\
  (wres4 = ~in3 \/ ~in0) /\
  (wres1 = in5 \/ in2) /\
  (wres3 = wres2 /\ in6 \/ in3 /\ in0) /\
  (wres5 = ~wres2 \/ wres4 /\ ~in6) /\
  (wres7 = ~in5 \/ ~in2) /\
  (wres0 = in4 \/ in1) /\
  (wres6 = wres3 /\ wres1 \/ in5 /\ in2) /\
  (wres8 = in4 /\ in1) /\
  (wres9 = ~in4 /\ in1 \/ in4 /\ ~in1)
  ==> (out3 =
       ~in6 /\ in3 /\ ~in0 \/
       ~in6 /\ ~in3 /\ in0 \/
       ~wres2 /\ in6 \/
       ~wres4 /\ in6) /\
      (out2 =
       wres3 /\ ~wres1 \/
       wres5 /\ ~in5 /\ in2 \/
       wres5 /\ in5 /\ ~in2 \/
       ~wres7 /\ wres3) /\
      (out1 =
       wres6 /\ ~wres0 \/
       wres8 /\ wres6 \/
       wres9 /\ ~wres1 \/
       wres9 /\ wres7 /\ wres5) /\
      (out0 = wres6 /\ wres0 \/ wres8)` ;

val rip06_be  = bdd_oracle
 `(car1 = a1 /\ b1) /\
  (car2 = (a2 \/ b2) /\ car1 \/ a2 /\ b2) /\
  (car3 = (a3 \/ b3) /\ car2 \/ a3 /\ b3) /\
  (car4 = (a4 \/ b4) /\ car3 \/ a4 /\ b4) /\
  (car5 = (a5 \/ b5) /\ car4 \/ a5 /\ b5) /\
  (cout = (a6 \/ b6) /\ car5 \/ a6 /\ b6) /\
  (som6 = ~(a6 = ~(b6 = car5))) /\
  (som5 = ~(a5 = ~(b5 = car4))) /\
  (som4 = ~(a4 = ~(b4 = car3))) /\
  (som3 = ~(a3 = ~(b3 = car2))) /\
  (som2 = ~(a2 = ~(b2 = car1))) /\
  (som1 = ~(a1 = b1)) /\
  (cout1 = b1 /\ a1) /\
  (cout2 = cout1 /\ b2 \/ cout1 /\ a2 \/ b2 /\ a2) /\
  (cout3 = cout2 /\ b3 \/ cout2 /\ a3 \/ b3 /\ a3) /\
  (cout4 = cout3 /\ b4 \/ cout3 /\ a4 \/ b4 /\ a4) /\
  (cout5 = cout4 /\ b5 \/ cout4 /\ a5 \/ b5 /\ a5)
  ==> (som1 = ~(~a1 /\ ~b1 \/ a1 /\ b1)) /\
      (som2 =
       ~((~a2 /\ ~b2 \/ a2 /\ b2) /\ ~cout1 \/
         cout1 /\ ~(~a2 /\ ~b2 \/ a2 /\ b2))) /\
      (som3 =
       ~((~a3 /\ ~b3 \/ a3 /\ b3) /\ ~cout2 \/
         cout2 /\ ~(~a3 /\ ~b3 \/ a3 /\ b3))) /\
      (som4 =
       ~((~a4 /\ ~b4 \/ a4 /\ b4) /\ ~cout3 \/
         cout3 /\ ~(~a4 /\ ~b4 \/ a4 /\ b4))) /\
      (som5 =
       ~((~a5 /\ ~b5 \/ a5 /\ b5) /\ ~cout4 \/
         cout4 /\ ~(~a5 /\ ~b5 \/ a5 /\ b5))) /\
      (som6 =
       ~((~a6 /\ ~b6 \/ a6 /\ b6) /\ ~cout5 \/
         cout5 /\ ~(~a6 /\ ~b6 \/ a6 /\ b6))) /\
      (cout = a6 /\ cout5 \/ b6 /\ cout5 \/ a6 /\ b6)` ;

val add1_be  = bdd_oracle
 `(n3 = a_1_) /\
  (n4 = a_3_) /\
  (n5 = a_2_) /\
  (n6 = a_4_) /\
  (n7 = ~carryin) /\
  (n8 = b_3_) /\
  (n9 = b_1_) /\
  (n10 = b_2_) /\
  (n11 = b_4_) /\
  (n17 = ~n3) /\
  (n31 = ~n4) /\
  (n29 = ~n5) /\
  (n19 = ~n7) /\
  (n43 = ~n6) /\
  (n20 = ~n19) /\
  (n18 = ~(n9 /\ ~n3 \/ ~n9 /\ n3)) /\
  (n28 = ~(n10 /\ ~n5 \/ ~n10 /\ n5)) /\
  (n32 = ~(n8 /\ ~n4 \/ ~n8 /\ n4)) /\
  (n16 = ~n18) /\
  (n24 = ~n28) /\
  (n22 = ~n16) /\
  (n42 = ~(n11 /\ ~n6 \/ ~n11 /\ n6)) /\
  (n38 = ~n42) /\
  (n27 = ~n24) /\
  (n21 = ~(n20 /\ n16 \/ ~n20 /\ ~n16)) /\
  (n23 = ~n16 /\ ~n3 \/ ~n22 /\ ~n19) /\
  (n25 = ~n23) /\
  (n26 = ~(n25 /\ ~n24 \/ ~n25 /\ n24)) /\
  (n13 = ~n26) /\
  (n30 = ~n32) /\
  (n33 = ~n27 /\ ~n23 \/ ~n29 /\ ~n24) /\
  (n36 = ~n30) /\
  (n15 = ~n21) /\
  (n34 = ~n33) /\
  (n41 = ~n38) /\
  (n37 = ~n30 /\ ~n4 \/ ~n36 /\ ~n33) /\
  (n39 = ~n37) /\
  (n40 = ~(n39 /\ ~n38 \/ ~n39 /\ n38)) /\
  (n12 = ~n40) /\
  (n35 = ~(n34 /\ n30 \/ ~n34 /\ ~n30)) /\
  (n14 = ~n35) /\
  (n44 = ~n41 /\ ~n37 \/ ~n43 /\ ~n38) /\
  (cout = n44) /\
  (o_4_ = n12) /\
  (o_3_ = n14) /\
  (o_2_ = n13) /\
  (o_1_ = n15) /\
  (cout1 = carryin /\ b_1_ \/ carryin /\ a_1_ \/ b_1_ /\ a_1_) /\
  (cout2 = cout1 /\ b_2_ \/ cout1 /\ a_2_ \/ b_2_ /\ a_2_) /\
  (cout3 = cout2 /\ b_3_ \/ cout2 /\ a_3_ \/ b_3_ /\ a_3_)
  ==> (o_1_ = ~(a_1_ = ~(b_1_ = carryin))) /\
      (o_2_ = ~(a_2_ = ~(b_2_ = cout1))) /\
      (o_3_ = ~(a_3_ = ~(b_3_ = cout2))) /\
      (o_4_ = ~(a_4_ = ~(b_4_ = cout3))) /\
      (cout = cout3 /\ b_4_ \/ cout3 /\ a_4_ \/ b_4_ /\ a_4_)` ;

val rip08_be  = bdd_oracle
 `(car1 = a1 /\ b1) /\
  (car2 = (a2 \/ b2) /\ car1 \/ a2 /\ b2) /\
  (car3 = (a3 \/ b3) /\ car2 \/ a3 /\ b3) /\
  (car4 = (a4 \/ b4) /\ car3 \/ a4 /\ b4) /\
  (car5 = (a5 \/ b5) /\ car4 \/ a5 /\ b5) /\
  (car6 = (a6 \/ b6) /\ car5 \/ a6 /\ b6) /\
  (car7 = (a7 \/ b7) /\ car6 \/ a7 /\ b7) /\
  (cout = (a8 \/ b8) /\ car7 \/ a8 /\ b8) /\
  (som8 = ~(a8 = ~(b8 = car7))) /\
  (som7 = ~(a7 = ~(b7 = car6))) /\
  (som6 = ~(a6 = ~(b6 = car5))) /\
  (som5 = ~(a5 = ~(b5 = car4))) /\
  (som4 = ~(a4 = ~(b4 = car3))) /\
  (som3 = ~(a3 = ~(b3 = car2))) /\
  (som2 = ~(a2 = ~(b2 = car1))) /\
  (som1 = ~(a1 = b1)) /\
  (cout1 = b1 /\ a1) /\
  (cout2 = cout1 /\ b2 \/ cout1 /\ a2 \/ b2 /\ a2) /\
  (cout3 = cout2 /\ b3 \/ cout2 /\ a3 \/ b3 /\ a3) /\
  (cout4 = cout3 /\ b4 \/ cout3 /\ a4 \/ b4 /\ a4) /\
  (cout5 = cout4 /\ b5 \/ cout4 /\ a5 \/ b5 /\ a5) /\
  (cout6 = cout5 /\ b6 \/ cout5 /\ a6 \/ b6 /\ a6) /\
  (cout7 = cout6 /\ b7 \/ cout6 /\ a7 \/ b7 /\ a7)
  ==> (som1 = ~(~a1 /\ ~b1 \/ a1 /\ b1)) /\
      (som2 =
       ~((~a2 /\ ~b2 \/ a2 /\ b2) /\ ~cout1 \/
         cout1 /\ ~(~a2 /\ ~b2 \/ a2 /\ b2))) /\
      (som3 =
       ~((~a3 /\ ~b3 \/ a3 /\ b3) /\ ~cout2 \/
         cout2 /\ ~(~a3 /\ ~b3 \/ a3 /\ b3))) /\
      (som4 =
       ~((~a4 /\ ~b4 \/ a4 /\ b4) /\ ~cout3 \/
         cout3 /\ ~(~a4 /\ ~b4 \/ a4 /\ b4))) /\
      (som5 =
       ~((~a5 /\ ~b5 \/ a5 /\ b5) /\ ~cout4 \/
         cout4 /\ ~(~a5 /\ ~b5 \/ a5 /\ b5))) /\
      (som6 =
       ~((~a6 /\ ~b6 \/ a6 /\ b6) /\ ~cout5 \/
         cout5 /\ ~(~a6 /\ ~b6 \/ a6 /\ b6))) /\
      (som7 =
       ~((~a7 /\ ~b7 \/ a7 /\ b7) /\ ~cout6 \/
         cout6 /\ ~(~a7 /\ ~b7 \/ a7 /\ b7))) /\
      (som8 =
       ~((~a8 /\ ~b8 \/ a8 /\ b8) /\ ~cout7 \/
         cout7 /\ ~(~a8 /\ ~b8 \/ a8 /\ b8))) /\
      (cout = a8 /\ cout7 \/ b8 /\ cout7 \/ a8 /\ b8)` ;

val aim_50_1_6_no_1 = bdd_oracle
`~
((v16 \/ v23 \/ v42) /\
 (~v16 \/ v23 \/ v42) /\
 (v26 \/ v41 \/ ~v42) /\
 (~v26 \/ v41 \/ ~v42) /\
 (v32 \/ ~v41 \/ ~v42) /\
 (v6 \/ v15 \/ ~v41) /\
 (~v6 \/ v15 \/ ~v32) /\
 (v1 \/ ~v32 \/ v46) /\
 (~v1 \/ ~v32 \/ v46) /\
 (~v15 \/ ~v41 \/ ~v46) /\
 (~v15 \/ ~v21 \/ ~v46) /\
 (~v23 \/ v33 \/ v38) /\
 (~v23 \/ ~v33 \/ v38) /\
 (v8 \/ v22 \/ v33) /\
 (v8 \/ v22 \/ ~v33) /\
 (~v22 \/ v37 \/ ~v38) /\
 (v13 \/ v36 \/ ~v37) /\
 (v13 \/ ~v22 \/ ~v36) /\
 (~v13 \/ ~v22 \/ ~v37) /\
 (v11 \/ ~v23 \/ v47) /\
 (~v8 \/ v11 \/ ~v47) /\
 (~v8 \/ ~v11 \/ v39) /\
 (~v11 \/ v27 \/ ~v39) /\
 (~v8 \/ ~v11 \/ ~v39) /\
 (~v7 \/ v26 \/ v29) /\
 (~v7 \/ ~v26 \/ v29) /\
 (~v13 \/ v20 \/ v36) /\
 (~v13 \/ v17 \/ v20) /\
 (v5 \/ ~v17 \/ v20) /\
 (v5 \/ ~v19 \/ ~v45) /\
 (~v5 \/ ~v10 \/ ~v45) /\
 (v6 \/ v25 \/ v47) /\
 (~v6 \/ ~v10 \/ v25) /\
 (~v2 \/ ~v27 \/ v37) /\
 (~v27 \/ ~v36 \/ v40) /\
 (v18 \/ v39 \/ ~v40) /\
 (~v2 \/ ~v19 \/ v31) /\
 (v5 \/ v18 \/ ~v30) /\
 (~v31 \/ ~v43 \/ ~v50) /\
 (v10 \/ ~v30 \/ v43) /\
 (v10 \/ ~v41 \/ v43) /\
 (v19 \/ v21 \/ v29) /\
 (v37 \/ v42 \/ v45) /\
 (~v20 \/ v27 \/ v40) /\
 (~v21 \/ ~v36 \/ v48) /\
 (v31 \/ ~v36 \/ ~v48) /\
 (v3 \/ ~v9 \/ ~v18) /\
 (v16 \/ ~v40 \/ ~v47) /\
 (v1 \/ ~v18 \/ v21) /\
 (v2 \/ v28 \/ v32) /\
 (~v1 \/ ~v24 \/ ~v50) /\
 (~v12 \/ v35 \/ v49) /\
 (~v6 \/ ~v36 \/ v45) /\
 (v7 \/ v12 \/ ~v43) /\
 (v7 \/ v30 \/ ~v43) /\
 (~v5 \/ v9 \/ ~v17) /\
 (v3 \/ v14 \/ v50) /\
 (~v12 \/ v17 \/ ~v49) /\
 (v24 \/ v34 \/ v49) /\
 (v14 \/ ~v20 \/ v24) /\
 (~v9 \/ v35 \/ ~v49) /\
 (~v4 \/ ~v47 \/ v50) /\
 (v4 \/ v44 \/ ~v44) /\
 (v28 \/ ~v28 \/ ~v38) /\
 (v2 \/ v4 \/ ~v48) /\
 (~v20 \/ v35 \/ ~v44) /\
 (v30 \/ ~v31 \/ ~v43) /\
 (~v14 \/ ~v29 \/ v35) /\
 (~v20 \/ v35 \/ ~v35) /\
 (v19 \/ ~v22 \/ ~v24) /\
 (~v25 \/ ~v28 \/ v48) /\
 (~v14 \/ ~v34 \/ v44) /\
 (v9 \/ v20 \/ v44) /\
 (~v3 \/ v9 \/ ~v29) /\
 (v17 \/ v34 \/ ~v34) /\
 (v12 \/ v48 \/ v48) /\
 (~v12 \/ ~v25 \/ ~v43) /\
 (~v25 \/ ~v31 \/ v48) /\
 (v14 \/ ~v16 \/ v49) /\
 (~v3 \/ ~v4 \/ ~v35))` ;

val aim_50_1_6_no_2 = bdd_oracle
`~
((v5 \/ v17 \/ v37) /\
 (v24 \/ v28 \/ v37) /\
 (v24 \/ ~v28 \/ v40) /\
 (v4 \/ ~v28 \/ ~v40) /\
 (v4 \/ ~v24 \/ v29) /\
 (v13 \/ ~v24 \/ ~v29) /\
 (~v13 \/ ~v24 \/ ~v29) /\
 (~v4 \/ v10 \/ ~v17) /\
 (~v4 \/ ~v10 \/ ~v17) /\
 (v26 \/ v33 \/ ~v37) /\
 (v5 \/ ~v26 \/ v34) /\
 (v33 \/ ~v34 \/ v48) /\
 (v33 \/ ~v37 \/ ~v48) /\
 (v5 \/ ~v33 \/ ~v37) /\
 (v2 \/ ~v5 \/ v10) /\
 (v2 \/ ~v5 \/ ~v10) /\
 (~v2 \/ v15 \/ v47) /\
 (v15 \/ v30 \/ ~v47) /\
 (~v2 \/ ~v15 \/ v30) /\
 (v20 \/ ~v30 \/ v42) /\
 (~v2 \/ v20 \/ ~v30) /\
 (v13 \/ ~v20 \/ v29) /\
 (v13 \/ v16 \/ ~v20) /\
 (~v13 \/ ~v20 \/ v31) /\
 (~v13 \/ v16 \/ ~v31) /\
 (~v16 \/ v23 \/ v38) /\
 (~v16 \/ v19 \/ ~v38) /\
 (~v19 \/ v23 \/ ~v38) /\
 (v14 \/ ~v23 \/ v34) /\
 (v1 \/ v14 \/ ~v34) /\
 (~v1 \/ v9 \/ v14) /\
 (~v1 \/ ~v9 \/ ~v23) /\
 (~v14 \/ v21 \/ ~v23) /\
 (~v14 \/ ~v16 \/ ~v21) /\
 (v25 \/ ~v35 \/ v41) /\
 (~v25 \/ v41 \/ v50) /\
 (~v35 \/ v49 \/ ~v50) /\
 (~v25 \/ ~v49 \/ ~v50) /\
 (~v19 \/ ~v48 \/ ~v49) /\
 (v3 \/ ~v39 \/ v44) /\
 (v1 \/ v3 \/ ~v44) /\
 (v9 \/ v35 \/ v44) /\
 (~v9 \/ ~v31 \/ v44) /\
 (v22 \/ v25 \/ ~v44) /\
 (~v12 \/ ~v43 \/ v46) /\
 (~v12 \/ ~v28 \/ ~v46) /\
 (v6 \/ v35 \/ v48) /\
 (v11 \/ v18 \/ ~v48) /\
 (v22 \/ v38 \/ ~v42) /\
 (v22 \/ ~v35 \/ ~v42) /\
 (~v3 \/ v11 \/ v41) /\
 (v27 \/ v28 \/ ~v43) /\
 (~v15 \/ ~v21 \/ v31) /\
 (~v33 \/ v39 \/ v50) /\
 (~v8 \/ ~v22 \/ ~v47) /\
 (~v22 \/ ~v40 \/ ~v47) /\
 (v39 \/ v44 \/ ~v46) /\
 (~v25 \/ ~v26 \/ v47) /\
 (v38 \/ v43 \/ v45) /\
 (~v6 \/ ~v14 \/ ~v45) /\
 (~v7 \/ v12 \/ v36) /\
 (v8 \/ ~v11 \/ v45) /\
 (v27 \/ ~v38 \/ ~v50) /\
 (v7 \/ ~v11 \/ ~v36) /\
 (~v7 \/ ~v41 \/ v42) /\
 (v7 \/ v21 \/ v23) /\
 (~v18 \/ v32 \/ v46) /\
 (v8 \/ v19 \/ ~v36) /\
 (~v32 \/ ~v45 \/ ~v50) /\
 (v7 \/ v17 \/ v21) /\
 (v6 \/ v18 \/ v43) /\
 (~v6 \/ v24 \/ ~v27) /\
 (v40 \/ ~v41 \/ v49) /\
 (~v11 \/ v12 \/ v26) /\
 (~v3 \/ v32 \/ ~v36) /\
 (~v6 \/ v36 \/ ~v44) /\
 (~v3 \/ v36 \/ v42) /\
 (~v8 \/ ~v11 \/ ~v32) /\
 (~v18 \/ ~v27 \/ ~v38) /\
 (~v18 \/ ~v27 \/ ~v39))` ;

val vg2_be  = bdd_oracle
 `(ge0 = ~in2 /\ in1 /\ in0 \/ ~in1 /\ ~in0) /\
  (ge1 = in1 \/ in0) /\
  (ge3 = in6 /\ ~in5 /\ ~in4 /\ ~in2 \/ ge1 /\ in3 /\ in2 \/ ge0 /\ in7) /\
  (ge2 = in9 /\ ~in5 /\ ~in4 /\ ~in2 \/ ge1 /\ in8 /\ in2 \/ ge0 /\ in10) /\
  (ge23 = in17 /\ in16 /\ in12 /\ in11) /\
  (ge24 = ge3 /\ in19 /\ in18) /\
  (ge21 = ~in17 /\ ~in16 /\ ~in12 /\ ~in11) /\
  (ge22 = ge2 /\ ~in19 /\ ~in18) /\
  (ge25 = ge24 /\ ge23) /\
  (ge6 = ~in14 /\ ~in13) /\
  (ge14 = ~in24 \/ ~in23 /\ in13) /\
  (ge4 = ge22 /\ ge21) /\
  (ge5 = ge25) /\
  (ge9 = ge6 /\ ~in22) /\
  (ge26 = in15 \/ in24 /\ ~in14) /\
  (ge7 = in22 /\ in14 /\ in13) /\
  (ge27 = ~in15 \/ ge14 /\ in14) /\
  (ge10 = ge4 /\ ~in15) /\
  (ge8 = ge5 /\ in15) /\
  (ge13 = ge6 /\ in23 \/ ge9 /\ in21 \/ ge26) /\
  (ge15 = ge7 /\ ~in21 \/ ge27) /\
  (ge11 = ~in19 \/ in18 /\ ~in17) /\
  (ge12 = in19 \/ ~in18 /\ in17) /\
  (ge20 = ge2 /\ in12 \/ ge3 /\ ~in12) /\
  (ge16 = ~in24 /\ ~in23 /\ ~in21 /\ ~in20) /\
  (ge17 = ge10 /\ ge9) /\
  (ge18 = in24 /\ in23 /\ in21 /\ in20) /\
  (ge19 = ge8 /\ ge7) /\
  (out0 = ge3) /\
  (out1 = ge2) /\
  (out2 = ge8 \/ ge10) /\
  (out3 = ge19 /\ ge18 \/ ge17 /\ ge16) /\
  (out4 = ge11 /\ ge3 /\ in11 \/ ge12 /\ ge2 /\ ~in11 \/ ge20) /\
  (out5 = ge13 /\ ge2 \/ ge15 /\ ge3) /\
  (out6 = ge5) /\
  (out7 = ge4) /\
  (wres0 = ~in2 /\ in1 /\ in0 \/ ~in1 /\ ~in0) /\
  (wres1 = in1 \/ in0) /\
  (wres6 = ~in14 /\ ~in13) /\
  (wres3 =
   wres0 /\ in7 \/ wres1 /\ in3 /\ in2 \/ in6 /\ ~in5 /\ ~in4 /\ ~in2) /\
  (wres2 =
   wres0 /\ in10 \/ wres1 /\ in8 /\ in2 \/ in9 /\ ~in5 /\ ~in4 /\ ~in2) /\
  (wres9 = wres6 /\ ~in22) /\
  (wres7 = in22 /\ in14 /\ in13) /\
  (wres14 = ~in24 \/ ~in23 /\ in13) /\
  (wres5 = wres3 /\ in19 /\ in18 /\ in17 /\ in16 /\ in12 /\ in11) /\
  (wres4 = wres2 /\ ~in19 /\ ~in18 /\ ~in17 /\ ~in16 /\ ~in12 /\ ~in11) /\
  (wres13 = wres6 /\ in23 \/ wres9 /\ in21 \/ in15 \/ in24 /\ ~in14) /\
  (wres15 = wres7 /\ ~in21 \/ ~in15 \/ wres14 /\ in14) /\
  (wres11 = ~in19 \/ in18 /\ ~in17) /\
  (wres12 = in19 \/ ~in18 /\ in17) /\
  (wres8 = wres5 /\ in15) /\
  (wres10 = wres4 /\ ~in15)
  ==> (out7 = wres4) /\
      (out6 = wres5) /\
      (out5 = wres13 /\ wres2 \/ wres15 /\ wres3) /\
      (out4 =
       wres2 /\ in12 \/
       wres3 /\ ~in12 \/
       wres11 /\ wres3 /\ in11 \/
       wres12 /\ wres2 /\ ~in11) /\
      (out3 =
       wres8 /\ wres7 /\ in24 /\ in23 /\ in21 /\ in20 \/
       wres10 /\ wres9 /\ ~in24 /\ ~in23 /\ ~in21 /\ ~in20) /\
      (out2 = wres8 \/ wres10) /\
      (out1 = wres2) /\
      (out0 = wres3)` ;

val misg_be  = bdd_oracle
 `(ge1 = ~in45 \/ ~in40) /\
  (ge10 = ~in45 /\ ~in36 \/ ge1 /\ ~in43) /\
  (ge6 = ~in43 \/ ~in36) /\
  (ge16 = ge10 /\ ~in38 \/ ~in53) /\
  (ge3 = ~in54 \/ ~in34) /\
  (ge11 = ge6 /\ ge1 /\ ~in44 \/ ge16) /\
  (ge4 = ~in39 \/ ~in40) /\
  (ge2 = ~in45 /\ ~in39 \/ ~in40) /\
  (ge5 = ~in38 \/ ~in44 /\ ~in37) /\
  (ge8 = ~in43 /\ ~in35 \/ ~in36) /\
  (ge14 = ~in49 \/ ge11 /\ ge3) /\
  (ge0 = in54 /\ in33 /\ in20) /\
  (ge7 = ~in37 \/ ~in38) /\
  (ge9 = ge4 /\ ~in37 \/ ~in39 /\ ~in38) /\
  (ge15 = ge14 \/ ~in47 \/ ~in32 \/ ge8 /\ ge5 /\ ge2) /\
  (ge13 = ~in49 \/ in10 \/ ~in22) /\
  (ge12 = in10 \/ in13 /\ in11) /\
  (out0 = in7 /\ in6 \/ in5 /\ in4 \/ in3 /\ in2 \/ in1 /\ in0) /\
  (out1 = ~in48) /\
  (out2 = ~in9 \/ ge12) /\
  (out3 = ~in8 \/ ~in14) /\
  (out4 = ~in15) /\
  (out5 = ~in16) /\
  (out6 = ~in17) /\
  (out7 = ~in12) /\
  (out8 = ge13 \/ ~in21) /\
  (out9 = ~in23 \/ ~in24) /\
  (out10 = in20 /\ in19 /\ in18) /\
  (out11 = ~in26 \/ ~in25) /\
  (out12 = ~in28 \/ in27 \/ in17) /\
  (out13 = ~in29 \/ in27) /\
  (out14 = ~in50 /\ in49 \/ in27) /\
  (out15 = in30 \/ in31) /\
  (out16 = ~in51) /\
  (out17 = ~in52) /\
  (out18 = ~in41 \/ ~in42) /\
  (out19 = ~in46 \/ ge0) /\
  (out20 = ge15 \/ ge7 /\ ge4 /\ ~in53 /\ ~in35 \/ ge9 /\ ~in53 /\ ~in36) /\
  (out21 = ~in55) /\
  (out22 = ~in32 \/ ge0) /\
  (wres1 = ~in45 \/ ~in40) /\
  (wres4 = ~in39 \/ ~in40) /\
  (wres6 = ~in43 \/ ~in36) /\
  (wres10 = ~in45 /\ ~in36 \/ wres1 /\ ~in43) /\
  (wres0 = in54 /\ in33 /\ in20) /\
  (wres2 = ~in45 /\ ~in39 \/ ~in40) /\
  (wres3 = ~in54 \/ ~in34) /\
  (wres5 = ~in38 \/ ~in44 /\ ~in37) /\
  (wres7 = ~in37 \/ ~in38) /\
  (wres8 = ~in36 \/ ~in43 /\ ~in35) /\
  (wres9 = wres4 /\ ~in37 \/ ~in39 /\ ~in38) /\
  (wres11 = wres10 /\ ~in38 \/ wres6 /\ wres1 /\ ~in44 \/ ~in53)
  ==> (out22 = ~in32 \/ wres0) /\
      (out21 = ~in55) /\
      (out20 =
       ~in47 \/
       wres7 /\ wres4 /\ ~in53 /\ ~in35 \/
       wres8 /\ wres5 /\ wres2 \/
       wres9 /\ ~in53 /\ ~in36 \/
       ~in32 \/
       wres11 /\ wres3 \/
       ~in49) /\
      (out19 = ~in46 \/ wres0) /\
      (out18 = ~in41 \/ ~in42) /\
      (out17 = ~in52) /\
      (out16 = ~in51) /\
      (out15 = in30 \/ in31) /\
      (out14 = ~in50 /\ in49 \/ in27) /\
      (out13 = ~in29 \/ in27) /\
      (out12 = ~in28 \/ in27 \/ in17) /\
      (out11 = ~in26 \/ ~in25) /\
      (out10 = in20 /\ in19 /\ in18) /\
      (out9 = ~in23 \/ ~in24) /\
      (out8 = ~in21 \/ ~in22 \/ ~in49 \/ in10) /\
      (out7 = ~in12) /\
      (out6 = ~in17) /\
      (out5 = ~in16) /\
      (out4 = ~in15) /\
      (out3 = ~in8 \/ ~in14) /\
      (out2 = in13 /\ in11 \/ ~in9 \/ in10) /\
      (out1 = ~in48) /\
      (out0 = in7 /\ in6 \/ in5 /\ in4 \/ in3 /\ in2 \/ in1 /\ in0)` ;

val x1dn_be  = bdd_oracle
 `(ge0 = ~in8 /\ ~in7 \/ in8 /\ in7 /\ ~in6) /\
  (ge1 = in8 \/ in7) /\
  (ge3 = in14 /\ ~in11 /\ ~in10 /\ ~in6 \/ ge1 /\ in15 /\ in6 \/ ge0 /\ in13) /\
  (ge2 = ~in11 /\ ~in10 /\ in9 /\ ~in6 \/ ge1 /\ in12 /\ in6 \/ ge0 /\ in5) /\
  (ge20 = in3 /\ in2 /\ in1 /\ in0) /\
  (ge21 = ge3 /\ in23 /\ in4) /\
  (ge18 = ~in3 /\ ~in2 /\ ~in1 /\ ~in0) /\
  (ge19 = ge2 /\ ~in23 /\ ~in4) /\
  (ge22 = ge21 /\ ge20) /\
  (ge4 = ge19 /\ ge18) /\
  (ge5 = ge22) /\
  (ge6 = ~in22 /\ ~in20 /\ ~in18) /\
  (ge9 = ge4 /\ ~in16) /\
  (ge7 = in22 /\ in20 /\ in18) /\
  (ge8 = ge5 /\ in16) /\
  (ge12 = in20 /\ ~in19 \/ ~in17) /\
  (ge14 = ~in20 /\ in19 \/ in17) /\
  (ge25 = ~in26 /\ ~in21 /\ ~in19 /\ ~in17) /\
  (ge26 = ge9 /\ ge6) /\
  (ge27 = in26 /\ in21 /\ in19 /\ in17) /\
  (ge28 = ge8 /\ ge7) /\
  (ge23 = ~in16 \/ ge12 /\ in18) /\
  (ge24 = in16 \/ ge14 /\ ~in18) /\
  (ge16 = ge28 /\ ge27 \/ ge26 /\ ge25) /\
  (ge13 = ge7 /\ ~in21 \/ ge23) /\
  (ge15 = ge6 /\ in21 \/ ge24) /\
  (ge10 = ~in4 \/ in3 /\ ~in2) /\
  (ge11 = in4 \/ ~in3 /\ in2) /\
  (ge17 = ge2 /\ in0 \/ ge3 /\ ~in0) /\
  (out0 = ge10 /\ ge3 /\ in1 \/ ge11 /\ ge2 /\ ~in1 \/ ge17) /\
  (out1 = ge13 /\ ge3 \/ ge15 /\ ge2) /\
  (out2 = ge8 \/ ge9) /\
  (out3 = ge5) /\
  (out4 = ge4) /\
  (out5 = ge16 /\ ~in25 \/ ge16 /\ ~in24) /\
  (wres0 = ~in8 /\ ~in7 \/ in8 /\ in7 /\ ~in6) /\
  (wres1 = in8 \/ in7) /\
  (wres3 =
   wres0 /\ in13 \/ wres1 /\ in15 /\ in6 \/ in14 /\ ~in11 /\ ~in10 /\ ~in6) /\
  (wres2 =
   wres1 /\ in12 /\ in6 \/ ~in11 /\ ~in10 /\ in9 /\ ~in6 \/ wres0 /\ in5) /\
  (wres5 = wres3 /\ in23 /\ in4 /\ in3 /\ in2 /\ in1 /\ in0) /\
  (wres4 = wres2 /\ ~in23 /\ ~in4 /\ ~in3 /\ ~in2 /\ ~in1 /\ ~in0) /\
  (wres6 = ~in22 /\ ~in20 /\ ~in18) /\
  (wres7 = in22 /\ in20 /\ in18) /\
  (wres8 = wres5 /\ in16) /\
  (wres9 = wres4 /\ ~in16) /\
  (wres12 = in20 /\ ~in19 \/ ~in17) /\
  (wres14 = ~in20 /\ in19 \/ in17) /\
  (wres16 =
   wres8 /\ wres7 /\ in26 /\ in21 /\ in19 /\ in17 \/
   wres9 /\ wres6 /\ ~in26 /\ ~in21 /\ ~in19 /\ ~in17) /\
  (wres13 = wres7 /\ ~in21 \/ wres12 /\ in18 \/ ~in16) /\
  (wres15 = wres6 /\ in21 \/ wres14 /\ ~in18 \/ in16) /\
  (wres10 = ~in4 \/ in3 /\ ~in2) /\
  (wres11 = in4 \/ ~in3 /\ in2)
  ==> (out5 = wres16 /\ ~in25 \/ wres16 /\ ~in24) /\
      (out4 = wres4) /\
      (out3 = wres5) /\
      (out2 = wres8 \/ wres9) /\
      (out1 = wres13 /\ wres3 \/ wres15 /\ wres2) /\
      (out0 =
       wres2 /\ in0 \/
       wres3 /\ ~in0 \/
       wres10 /\ wres3 /\ in1 \/
       wres11 /\ wres2 /\ ~in1)` ;

val counter_be  = bdd_oracle
 `(b6 = a1 /\ ~a2 \/ ~a1 /\ a2 \/ ~a0 /\ a1 \/ a3) /\
  (b5 = a0 /\ ~a1 /\ a2 \/ ~a0 /\ a1 \/ a1 /\ ~a2 \/ ~a0 /\ ~a2 \/ a3) /\
  (b4 = a0 \/ a2 \/ ~a1) /\
  (b3 = ~a2 /\ ~a3 \/ a0 /\ a1 \/ ~a0 /\ ~a1 \/ a3) /\
  (b2 = ~a0 /\ ~a2 \/ a0 /\ a2 \/ a1 \/ a3) /\
  (b1 = ~a0 /\ a2 \/ a3 \/ ~a1 /\ a2 \/ ~a0 /\ ~a1) /\
  (b0 = ~a0 /\ a1 \/ ~a0 /\ ~a2) /\
  (ta3 =
   cb /\ a3 \/
   ~ca /\ a3 \/
   ca /\ ~cb /\ a0 /\ a1 /\ a2 \/
   ca /\ ~cb /\ ~a0 /\ a3) /\
  (ta2 =
   cb /\ a2 \/
   ~ca /\ a2 \/
   ca /\ ~cb /\ a0 /\ a1 /\ ~a2 \/
   ca /\ ~cb /\ ~a0 /\ a1 /\ a2 \/
   ca /\ ~cb /\ ~a1 /\ a2) /\
  (ta1 =
   cb /\ a1 \/
   ~ca /\ a1 \/
   ca /\ ~cb /\ ~a0 /\ a1 /\ ~a3 \/
   ca /\ ~cb /\ a0 /\ ~a1 /\ ~a3) /\
  (ta0 = cb /\ a0 \/ ~ca /\ a0 \/ ca /\ ~cb /\ ~a0) /\
  (tcb = ca)
  ==> (tcb = ca) /\
      (ta0 = cb /\ a0 \/ ~ca /\ a0 \/ ca /\ ~cb /\ ~a0) /\
      (ta1 =
       ~a0 /\ a1 /\ ~a3 \/
       ca /\ ~cb /\ a0 /\ ~a1 /\ ~a3 \/
       cb /\ a1 \/
       ~ca /\ a1) /\
      (ta2 =
       ~a0 /\ a2 \/
       a0 /\ ~a1 /\ a2 \/
       cb /\ a0 /\ a1 /\ a2 \/
       ~ca /\ a0 /\ a1 /\ a2 \/
       ca /\ ~cb /\ a0 /\ a1 /\ ~a2) /\
      (ta3 =
       ~a0 /\ a3 \/
       cb /\ a0 /\ a3 \/
       ~ca /\ a3 \/
       ca /\ ~cb /\ a0 /\ a1 /\ a2) /\
      (b0 = ~a0 /\ ~a1 /\ ~a2 \/ ~a0 /\ a1) /\
      (b1 =
       ~a0 /\ a3 \/
       a0 /\ a3 \/
       ~a0 /\ a2 \/
       a0 /\ ~a1 /\ a2 \/
       ~a0 /\ ~a1 /\ ~a2) /\
      (b2 =
       ~a0 /\ a3 \/
       a0 /\ a3 \/
       ~a0 /\ a1 /\ ~a3 \/
       ca /\ ~cb /\ a0 /\ a1 /\ a2 \/
       a0 /\ ~a1 /\ a2 \/
       cb /\ a0 /\ a1 /\ a2 \/
       ~ca /\ a0 /\ a1 /\ a2 \/
       a1 /\ ~a2 \/
       ~a0 /\ ~a1 /\ ~a2) /\
      (b3 =
       ~a0 /\ a3 \/
       a0 /\ a3 \/
       ~a2 \/
       ca /\ ~cb /\ a0 /\ a1 /\ a2 \/
       ~a0 /\ ~a1 /\ a2 \/
       cb /\ a0 /\ a1 /\ a2 \/
       ~ca /\ a0 /\ a1 /\ a2) /\
      (b4 =
       a0 /\ a3 \/
       ca /\ ~cb /\ a0 /\ ~a1 /\ ~a3 \/
       ca /\ ~cb /\ a0 /\ a1 /\ a2 \/
       ~a0 /\ a2 \/
       ca /\ ~cb /\ a0 /\ a1 /\ ~a2 \/
       ~a0 /\ ~a1 /\ ~a2 \/
       cb /\ a0 \/
       ~ca /\ a0) /\
      (b5 =
       ~a0 /\ a3 \/
       a0 /\ a3 \/
       a0 /\ ~a1 /\ a2 \/
       a1 /\ ~a2 \/
       ~a0 /\ ~a1 /\ ~a2 \/
       ~a0 /\ a1) /\
      (b6 =
       ~a0 /\ a3 \/
       a0 /\ a3 \/
       a0 /\ ~a1 /\ a2 \/
       ~a0 /\ ~a1 /\ a2 \/
       a1 /\ ~a2 \/
       ~a0 /\ a1)` ;

val sqn_be  = bdd_oracle
 `(ge0 = in6 /\ in1 \/ ~in6 /\ ~in1) /\
  (ge8 = ~in3 /\ ~in1) /\
  (ge5 = in6 \/ in5) /\
  (ge9 = ~ge0 \/ in2 \/ ~in5) /\
  (ge1 = in3 \/ ~in0) /\
  (ge11 = ge8 /\ in4) /\
  (ge3 = ~in4 \/ ~in2) /\
  (ge34 = ~ge5 /\ in4 \/ ~ge9) /\
  (ge2 = ~in4 /\ in1) /\
  (ge14 = ~ge1 /\ ~in4) /\
  (ge19 = ge11 /\ ~ge5) /\
  (ge13 = ge8 /\ ~ge3 /\ ~in0) /\
  (ge20 = ~in5 /\ in2 \/ ge34) /\
  (ge12 = ge2 /\ ~in3) /\
  (ge27 = ge14 /\ in6 \/ ge19) /\
  (ge10 = ~in6 \/ in5) /\
  (ge28 = ge13 \/ ge20 /\ ~ge1) /\
  (ge6 = ~in5 \/ in6) /\
  (ge15 = ge2 /\ in2) /\
  (ge29 = ge27 \/ ge12 /\ ge5) /\
  (ge4 = in3 /\ ~in0) /\
  (ge21 = ~ge10 /\ ~in1 \/ ~in5 /\ ~in2) /\
  (ge30 = ge28 \/ ge14 /\ in2) /\
  (ge31 = ge29 \/ ge15 /\ ~ge6) /\
  (ge7 = ~in6 \/ ~in5) /\
  (ge17 = ~ge3 /\ ~in1) /\
  (ge18 = ge4 /\ in2) /\
  (ge16 = ge2 /\ in0) /\
  (ge23 = ge19 \/ ge9 /\ ~ge1) /\
  (ge32 = ge15 /\ ~in6 /\ ~in0 \/ ge21 /\ ge4 /\ ~in4 \/ ge30 \/ ge31) /\
  (ge33 =
   ge18 /\ ~ge6 /\ ~in4 \/
   ge17 /\ ~ge7 /\ in3 \/
   ~ge7 /\ ge4 /\ ~ge3 \/
   ge11 /\ in5 /\ ~in0) /\
  (ge25 = ge14 /\ ~ge6 \/ ge13 /\ ~ge5 \/ ge16 /\ ~in5 \/ ge15 /\ ge1) /\
  (ge26 =
   ge12 /\ in5 /\ ~in2 \/
   ge10 /\ ge4 /\ in1 \/
   ge17 /\ ~ge6 /\ in0 \/
   ge2 /\ ~in6) /\
  (ge24 = ge23 \/ ge16 /\ ge7) /\
  (out0 =
   ge6 /\ in4 /\ ~in1 /\ in0 \/ ge18 /\ ge0 /\ ~in5 \/ ge12 /\ ~ge10 \/ ge24) /\
  (out1 = ge26 \/ ge25 \/ ~ge5 /\ ge4 /\ ge3 \/ ge7 /\ ~ge1 /\ in1) /\
  (out2 = ge33 \/ ge32) /\
  (wres8 = ~in3 /\ ~in1) /\
  (wres0 = in6 /\ in1 \/ ~in6 /\ ~in1) /\
  (wres2 = ~in4 /\ in1) /\
  (wres3 = ~in4 \/ ~in2) /\
  (wres1 = in3 \/ ~in0) /\
  (wres4 = in3 /\ ~in0) /\
  (wres5 = in6 \/ in5) /\
  (wres11 = wres8 /\ in4) /\
  (wres9 = ~wres0 \/ in2 \/ ~in5) /\
  (wres10 = ~in6 \/ in5) /\
  (wres6 = ~in5 \/ in6) /\
  (wres7 = ~in6 \/ ~in5) /\
  (wres12 = wres2 /\ ~in3) /\
  (wres13 = wres8 /\ ~wres3 /\ ~in0) /\
  (wres14 = ~wres1 /\ ~in4) /\
  (wres15 = wres2 /\ in2) /\
  (wres17 = ~wres3 /\ ~in1) /\
  (wres18 = wres4 /\ in2) /\
  (wres19 = wres11 /\ ~wres5) /\
  (wres20 = ~in5 /\ in2 \/ ~wres5 /\ in4 \/ ~wres9) /\
  (wres21 = ~wres10 /\ ~in1 \/ ~in5 /\ ~in2) /\
  (wres16 = wres2 /\ in0)
  ==> (out2 =
       wres11 /\ in5 /\ ~in0 \/
       ~wres7 /\ wres4 /\ ~wres3 \/
       wres12 /\ wres5 \/
       wres13 \/
       wres14 /\ in2 \/
       wres14 /\ in6 \/
       wres15 /\ ~wres6 \/
       wres15 /\ ~in6 /\ ~in0 \/
       wres17 /\ ~wres7 /\ in3 \/
       wres18 /\ ~wres6 /\ ~in4 \/
       wres20 /\ ~wres1 \/
       wres21 /\ wres4 /\ ~in4 \/
       wres19) /\
      (out1 =
       ~wres5 /\ wres4 /\ wres3 \/
       wres7 /\ ~wres1 /\ in1 \/
       wres2 /\ ~in6 \/
       wres10 /\ wres4 /\ in1 \/
       wres12 /\ in5 /\ ~in2 \/
       wres13 /\ ~wres5 \/
       wres14 /\ ~wres6 \/
       wres15 /\ wres1 \/
       wres16 /\ ~in5 \/
       wres17 /\ ~wres6 /\ in0) /\
      (out0 =
       wres6 /\ in4 /\ ~in1 /\ in0 \/
       wres9 /\ ~wres1 \/
       wres12 /\ ~wres10 \/
       wres16 /\ wres7 \/
       wres18 /\ wres0 /\ ~in5 \/
       wres19)` ;

val add2_be  = bdd_oracle
 `(n3 = a_0_) /\
  (n4 = a_3_) /\
  (n5 = a_1_) /\
  (n6 = a_2_) /\
  (n7 = anda) /\
  (n8 = exora) /\
  (n9 = b_3_) /\
  (n10 = b_1_) /\
  (n11 = b_0_) /\
  (n12 = b_2_) /\
  (n13 = andb) /\
  (n14 = exorb) /\
  (n15 = carryin) /\
  (n42 = ~n13) /\
  (n48 = ~n14) /\
  (n41 = ~n7) /\
  (n47 = ~n8) /\
  (n46 = ~n15) /\
  (n49 = ~n46) /\
  (n86 = ~n9 \/ ~n42) /\
  (n94 = ~n48) /\
  (n85 = ~n4 \/ ~n41) /\
  (n93 = ~n47) /\
  (n60 = ~n10 \/ ~n42) /\
  (n68 = ~n48) /\
  (n59 = ~n5 \/ ~n41) /\
  (n67 = ~n47) /\
  (n54 = ~n11 \/ ~n42) /\
  (n44 = ~n48) /\
  (n53 = ~n3 \/ ~n41) /\
  (n43 = ~n47) /\
  (n80 = ~n12 \/ ~n42) /\
  (n72 = ~n48) /\
  (n79 = ~n6 \/ ~n41) /\
  (n71 = ~n47) /\
  (n35 = ~n86) /\
  (n37 = ~n85) /\
  (n27 = ~n60) /\
  (n29 = ~n59) /\
  (n25 = ~n54) /\
  (n23 = ~n53) /\
  (n33 = ~n80) /\
  (n31 = ~n79) /\
  (n89 = n35 /\ n48 \/ ~n35 /\ ~n48) /\
  (n88 = n37 /\ n47 \/ ~n37 /\ ~n47) /\
  (n63 = n27 /\ n48 \/ ~n27 /\ ~n48) /\
  (n62 = n29 /\ n47 \/ ~n29 /\ ~n47) /\
  (n52 = n25 /\ n48 \/ ~n25 /\ ~n48) /\
  (n51 = n23 /\ n47 \/ ~n23 /\ ~n47) /\
  (n78 = n33 /\ n48 \/ ~n33 /\ ~n48) /\
  (n77 = n31 /\ n47 \/ ~n31 /\ ~n47) /\
  (n36 = ~n89) /\
  (n38 = ~n88) /\
  (n28 = ~n63) /\
  (n30 = ~n62) /\
  (n26 = ~n52) /\
  (n24 = ~n51) /\
  (n34 = ~n78) /\
  (n32 = ~n77) /\
  (n92 = ~n38) /\
  (n66 = ~n30) /\
  (n40 = ~n24) /\
  (n70 = ~n32) /\
  (n91 = n36 /\ n38 \/ ~n36 /\ ~n38) /\
  (n65 = n28 /\ n30 \/ ~n28 /\ ~n30) /\
  (n45 = n26 /\ n24 \/ ~n26 /\ ~n24) /\
  (n73 = n34 /\ n32 \/ ~n34 /\ ~n32) /\
  (n83 = ~n91) /\
  (n57 = ~n65) /\
  (n39 = ~n45) /\
  (n69 = ~n73) /\
  (n90 = ~n83) /\
  (n64 = ~n57) /\
  (n55 = ~n39) /\
  (n81 = ~n69) /\
  (n50 = n49 /\ ~n39 \/ ~n49 /\ n39) /\
  (n56 = ~n39 /\ ~n24 \/ ~n55 /\ ~n46) /\
  (n58 = ~n56) /\
  (n17 = ~n50) /\
  (n74 = ~n64 /\ ~n56 \/ ~n66 /\ ~n57) /\
  (n61 = n58 /\ n57 \/ ~n58 /\ ~n57) /\
  (n82 = ~n69 /\ ~n32 \/ ~n81 /\ ~n74) /\
  (n75 = ~n74) /\
  (n95 = ~n82) /\
  (n96 = ~n90 /\ ~n82 \/ ~n92 /\ ~n83) /\
  (n16 = ~n61) /\
  (n84 = ~n82) /\
  (n76 = n75 /\ ~n69 \/ ~n75 /\ n69) /\
  (n97 = n96 /\ n82 \/ ~n96 /\ ~n82) /\
  (n19 = ~n96) /\
  (n87 = n84 /\ n83 \/ ~n84 /\ ~n83) /\
  (n18 = ~n76) /\
  (n20 = ~n97) /\
  (n22 = ~n87) /\
  (n21 = ~n22) /\
  (sign = n21) /\
  (overflow = n20) /\
  (carryout = n19) /\
  (o_3_ = n22) /\
  (o_2_ = n18) /\
  (o_1_ = n16) /\
  (o_0_ = n17) /\
  (buf1 = ~anda) /\
  (buf2 = ~andb) /\
  (buf3 = ~exora) /\
  (buf4 = ~exorb) /\
  (buf5 = ~carryin) /\
  (n1_0_ = buf1 /\ a_0_) /\
  (n1_1_ = buf1 /\ a_1_) /\
  (n1_2_ = buf1 /\ a_2_) /\
  (n1_3_ = buf1 /\ a_3_) /\
  (n3_0_ = buf2 /\ b_0_) /\
  (n3_1_ = buf2 /\ b_1_) /\
  (n3_2_ = buf2 /\ b_2_) /\
  (n3_3_ = buf2 /\ b_3_) /\
  (n2_0_ = buf3 /\ ~n1_0_ \/ ~buf3 /\ n1_0_) /\
  (n2_1_ = buf3 /\ ~n1_1_ \/ ~buf3 /\ n1_1_) /\
  (n2_2_ = buf3 /\ ~n1_2_ \/ ~buf3 /\ n1_2_) /\
  (n2_3_ = buf3 /\ ~n1_3_ \/ ~buf3 /\ n1_3_) /\
  (n4_0_ = buf4 /\ ~n3_0_ \/ ~buf4 /\ n3_0_) /\
  (n4_1_ = buf4 /\ ~n3_1_ \/ ~buf4 /\ n3_1_) /\
  (n4_2_ = buf4 /\ ~n3_2_ \/ ~buf4 /\ n3_2_) /\
  (n4_3_ = buf4 /\ ~n3_3_ \/ ~buf4 /\ n3_3_) /\
  (cout1 = buf5 /\ n4_0_ \/ buf5 /\ n2_0_ \/ n4_0_ /\ n2_0_) /\
  (cout2 = cout1 /\ n4_1_ \/ cout1 /\ n2_1_ \/ n4_1_ /\ n2_1_) /\
  (cout3 = cout2 /\ n4_2_ \/ cout2 /\ n2_2_ \/ n4_2_ /\ n2_2_) /\
  (hulp0 = ~(n2_0_ = ~(n4_0_ = buf5))) /\
  (hulp1 = ~(n2_1_ = ~(n4_1_ = cout1))) /\
  (hulp2 = ~(n2_2_ = ~(n4_2_ = cout2))) /\
  (hulp3 = ~(n2_3_ = ~(n4_3_ = cout3))) /\
  (hulp4 = cout3 /\ n4_3_ \/ cout3 /\ n2_3_ \/ n4_3_ /\ n2_3_)
  ==> (o_0_ = hulp0) /\
      (o_1_ = hulp1) /\
      (o_2_ = hulp2) /\
      (o_3_ = hulp3) /\
      (carryout = ~hulp4) /\
      (overflow = cout3 = hulp4) /\
      (sign = ~hulp3)` ;

val dc2_be  = bdd_oracle
 `(ge0 = ~in4 /\ ~in0) /\
  (ge10 = ge0 /\ in5 /\ ~in2) /\
  (ge2 = ~in6 /\ ~in5 /\ in4 /\ ~in0) /\
  (ge4 = ge0 /\ in5 /\ in2) /\
  (ge22 = ge0 /\ ~in5) /\
  (ge23 = ge10 /\ ~in6) /\
  (ge6 = ge0 /\ ~in3) /\
  (ge21 = ge4 /\ in3 \/ ge2 /\ in3 /\ in2) /\
  (ge44 = ge22 /\ in6 \/ ge23) /\
  (ge11 = ge6 /\ ~in5) /\
  (ge1 = ~in4 /\ ~in2 /\ ~in1) /\
  (ge8 = ge21 \/ ge44) /\
  (ge24 = ge11 /\ in1) /\
  (ge3 = ~in6 /\ ~in5 /\ ~in1) /\
  (ge18 = ge0 /\ in2) /\
  (ge19 = ge11 /\ in2) /\
  (ge20 = ge1 /\ in3) /\
  (ge45 = ge1 /\ ~in5 \/ ge4) /\
  (ge16 = ~in2 /\ in1) /\
  (ge33 = ge8 /\ in1 \/ ge24) /\
  (ge5 = ge2 \/ in3 /\ ~in0) /\
  (ge29 = ge19 \/ ge18 /\ ge3) /\
  (ge14 = ge3 /\ in3) /\
  (ge41 = ge6 /\ in6 \/ ge20 /\ ~in6) /\
  (ge7 = in6 /\ in3) /\
  (ge25 = ge22 /\ ~in2 \/ ge45) /\
  (ge13 = ~in6 /\ ~in5 /\ ~in0) /\
  (ge12 = ~in3 /\ ~in1) /\
  (ge34 = ge33 \/ ge16 /\ ge6) /\
  (ge15 = ~in2 /\ in0) /\
  (ge30 = ge29 \/ ge16 /\ ge5) /\
  (ge42 = ge41 \/ ge14 /\ ~in2) /\
  (ge17 = ge1 /\ in5) /\
  (ge37 = ge25 /\ ge7 \/ ge19) /\
  (ge38 = ge23 \/ ge13 /\ in2) /\
  (ge35 = ge34 \/ ge12 /\ ge4) /\
  (ge31 = ge30 \/ ge15 /\ ge12) /\
  (ge27 = ge24 \/ ge21 /\ ~in1) /\
  (ge43 = ge0 /\ ~in6 /\ in3 \/ ge13 /\ in3 \/ ge42) /\
  (ge39 = ge37 \/ ge17 /\ ~in3) /\
  (ge40 = ge38 \/ ge17 /\ ~in6) /\
  (ge9 = ~in6 \/ ~in5) /\
  (ge36 = ge35 \/ ge12 /\ ge2) /\
  (ge32 = ge31 \/ ge10 /\ ge7) /\
  (ge28 = ge27 \/ ge16 /\ ~in0) /\
  (ge26 = ge4 /\ in1 \/ ge15 /\ ~in1) /\
  (out0 = ge5 /\ in2 /\ in1 \/ ge26) /\
  (out1 =
   ge15 /\ ge14 /\ in4 \/ ge17 /\ ge7 /\ in0 \/ ge18 /\ ge7 /\ ~in1 \/ ge28) /\
  (out2 =
   ge12 /\ in2 /\ ~in0 \/ ge9 /\ ge1 /\ in0 \/ ge2 /\ in3 /\ ~in2 \/ ge32) /\
  (out3 = ge3 /\ in4 /\ ~in3 /\ ~in2 \/ ge14 /\ ge0 \/ ge20 /\ ge9 \/ ge36) /\
  (out4 = ge6 /\ in5 /\ ~in2 \/ ge40 \/ ge39) /\
  (out5 = ge43 \/ ge1 /\ in6 /\ ~in3) /\
  (out6 = in7) /\
  (wres0 = ~in4 /\ ~in0) /\
  (wres6 = wres0 /\ ~in3) /\
  (wres2 = ~in6 /\ ~in5 /\ in4 /\ ~in0) /\
  (wres4 = wres0 /\ in5 /\ in2) /\
  (wres10 = wres0 /\ in5 /\ ~in2) /\
  (wres3 = ~in6 /\ ~in5 /\ ~in1) /\
  (wres1 = ~in4 /\ ~in2 /\ ~in1) /\
  (wres11 = wres6 /\ ~in5) /\
  (wres22 = wres0 /\ ~in5) /\
  (wres21 = wres4 /\ in3 \/ wres2 /\ in3 /\ in2) /\
  (wres23 = wres10 /\ ~in6) /\
  (wres13 = ~in6 /\ ~in5 /\ ~in0) /\
  (wres14 = wres3 /\ in3) /\
  (wres20 = wres1 /\ in3) /\
  (wres7 = in6 /\ in3) /\
  (wres17 = wres1 /\ in5) /\
  (wres19 = wres11 /\ in2) /\
  (wres25 = wres22 /\ ~in2 \/ wres1 /\ ~in5 \/ wres4) /\
  (wres8 = wres21 \/ wres22 /\ in6 \/ wres23) /\
  (wres9 = ~in6 \/ ~in5) /\
  (wres12 = ~in3 /\ ~in1) /\
  (wres16 = ~in2 /\ in1) /\
  (wres24 = wres11 /\ in1) /\
  (wres5 = wres2 \/ in3 /\ ~in0) /\
  (wres15 = ~in2 /\ in0) /\
  (wres18 = wres0 /\ in2)
  ==> (out6:bool = in7) /\
      (out5 =
       wres1 /\ in6 /\ ~in3 \/
       wres0 /\ ~in6 /\ in3 \/
       wres6 /\ in6 \/
       wres13 /\ in3 \/
       wres14 /\ ~in2 \/
       wres20 /\ ~in6) /\
      (out4 =
       wres13 /\ in2 \/
       wres17 /\ ~in6 \/
       wres17 /\ ~in3 \/
       wres6 /\ in5 /\ ~in2 \/
       wres23 \/
       wres25 /\ wres7 \/
       wres19) /\
      (out3 =
       wres14 /\ wres0 \/
       wres16 /\ wres6 \/
       wres20 /\ wres9 \/
       wres12 /\ wres2 \/
       wres12 /\ wres4 \/
       wres3 /\ in4 /\ ~in3 /\ ~in2 \/
       wres8 /\ in1 \/
       wres24) /\
      (out2 =
       wres10 /\ wres7 \/
       wres9 /\ wres1 /\ in0 \/
       wres12 /\ in2 /\ ~in0 \/
       wres2 /\ in3 /\ ~in2 \/
       wres15 /\ wres12 \/
       wres16 /\ wres5 \/
       wres18 /\ wres3 \/
       wres19) /\
      (out1 =
       wres15 /\ wres14 /\ in4 \/
       wres16 /\ ~in0 \/
       wres17 /\ wres7 /\ in0 \/
       wres18 /\ wres7 /\ ~in1 \/
       wres21 /\ ~in1 \/
       wres24) /\
      (out0 = wres4 /\ in1 \/ wres5 /\ in2 /\ in1 \/ wres15 /\ ~in1)`;

val f51m_be  = bdd_oracle
 `(ge10 = in6 \/ ~in7) /\
  (ge5 = ~in5 /\ ~in4 /\ in2) /\
  (ge11 = ~in3 /\ in2) /\
  (ge21 = ~ge10 /\ in5) /\
  (ge23 = ge5 /\ ~in3) /\
  (ge7 = in7 /\ in6) /\
  (ge20 = ~in7 /\ ~in4) /\
  (ge35 = ge21 /\ ge11 \/ ge23) /\
  (ge8 = ~in6 /\ ~in5) /\
  (ge12 = ~in4 /\ ~in2) /\
  (ge19 = ge7 /\ in3) /\
  (ge36 = ge35 \/ ge20 /\ ge11) /\
  (ge44 = in4 \/ in7 /\ in6) /\
  (ge1 = in7 /\ in6 \/ in3) /\
  (ge18 = ge8 /\ ~in2) /\
  (ge37 = ge36 \/ ge19 /\ ge12) /\
  (ge43 = ~in3 \/ ~in6 /\ ~in5) /\
  (ge3 = in5 \/ in1 \/ ge44) /\
  (ge14 = ~ge1 /\ ~in4) /\
  (ge38 = ge37 \/ ge18 /\ in4) /\
  (ge9 = in4 \/ in5) /\
  (ge17 = in2 /\ in1) /\
  (ge0 = ~in7 /\ ~in6 \/ ~in5) /\
  (ge2 = ~in4 \/ ge43) /\
  (ge26 = ge14 \/ ~ge3) /\
  (ge22 = ~in7 /\ ~in6) /\
  (ge39 = ge38 \/ ge5 /\ ~in6) /\
  (ge47 = ge14 \/ ge7 /\ ge5) /\
  (ge29 = ge12 \/ ge18) /\
  (ge48 = ~ge3 \/ ge17 /\ ge9) /\
  (ge6 = ~ge0 /\ in4 \/ in3) /\
  (ge16 = ~in2 /\ in1) /\
  (ge45 = ~ge2 /\ ~in2 \/ ge26 /\ in2) /\
  (ge33 = ge8 \/ ge7 \/ ge22) /\
  (ge49 = ge8 \/ ~ge0 /\ in4) /\
  (ge50 = ge22 /\ ~in3 \/ ge19) /\
  (ge40 = ge39 \/ ge5 /\ ~in7) /\
  (ge4 = in7 /\ in6 /\ in5 \/ in4) /\
  (ge15 = ge11 /\ ~in1) /\
  (ge28 = ~ge2 \/ ge47) /\
  (ge30 = ge29 /\ ~in1 \/ ge48) /\
  (ge24 = ~ge6 \/ ge2 /\ ~in1) /\
  (ge46 = ge16 /\ ge6 \/ ge45) /\
  (ge42 = ge21 /\ ~in4 \/ ge33 /\ in4) /\
  (ge13 = in4 /\ ~in3) /\
  (ge31 = ~ge9 /\ ~in7 \/ ge49) /\
  (ge32 = ge50 \/ ge14) /\
  (ge41 = ge40 \/ ~ge2 /\ in2) /\
  (ge34 = ge16 /\ ~ge6 \/ ge28 /\ in1 \/ ge15 /\ ge4 \/ ge30 /\ in3) /\
  (ge25 = ge3 /\ in3 /\ in2 \/ ge17 /\ ge4 \/ ge24 /\ ~in2) /\
  (ge27 = ge15 \/ ge23 \/ ge46) /\
  (out0 = ge25 /\ in0 \/ ge27 /\ ~in0) /\
  (out1 = ge34 \/ ge13 /\ ~ge0 /\ ~in1) /\
  (out2 =
   in6 /\ in5 /\ in4 /\ in2 \/
   ge12 /\ ge1 /\ in5 \/
   ge13 /\ ge0 /\ ~in2 \/
   ge41) /\
  (out3 =
   ge13 /\ in6 /\ ~in5 \/ ge7 /\ ~in5 /\ ~in3 \/ ge31 /\ in3 \/ ge32 /\ in5) /\
  (out4 = ge20 /\ in6 \/ ge42) /\
  (out5 = ge8 /\ in7 \/ ge10 /\ in5) /\
  (out6 = ~in7 /\ in6 \/ ~ge10) /\
  (out7 = ~in7) /\
  (wres8 = ~in6 /\ ~in5) /\
  (wres0 = ~in7 /\ ~in6 \/ ~in5) /\
  (wres1 = in7 /\ in6 \/ in3) /\
  (wres7 = in7 /\ in6) /\
  (wres12 = ~in4 /\ ~in2) /\
  (wres18 = wres8 /\ ~in2) /\
  (wres2 = ~in6 /\ ~in5 \/ ~in4 \/ ~in3) /\
  (wres6 = ~wres0 /\ in4 \/ in3) /\
  (wres11 = ~in3 /\ in2) /\
  (wres5 = ~in5 /\ ~in4 /\ in2) /\
  (wres3 = in5 \/ in4 \/ in1 \/ in7 /\ in6) /\
  (wres14 = ~wres1 /\ ~in4) /\
  (wres10 = in6 \/ ~in7) /\
  (wres22 = ~in7 /\ ~in6) /\
  (wres9 = in5 \/ in4) /\
  (wres19 = wres7 /\ in3) /\
  (wres17 = in2 /\ in1) /\
  (wres29 = wres12 \/ wres18) /\
  (wres4 = in7 /\ in6 /\ in5 \/ in4) /\
  (wres24 = ~wres6 \/ wres2 /\ ~in1) /\
  (wres15 = wres11 /\ ~in1) /\
  (wres16 = ~in2 /\ in1) /\
  (wres23 = wres5 /\ ~in3) /\
  (wres26 = wres14 \/ ~wres3) /\
  (wres20 = ~in7 /\ ~in4) /\
  (wres21 = ~wres10 /\ in5) /\
  (wres33 = wres8 \/ wres7 \/ wres22) /\
  (wres13 = in4 /\ ~in3) /\
  (wres31 = ~wres9 /\ ~in7 \/ wres8 \/ ~wres0 /\ in4) /\
  (wres32 = wres14 \/ wres22 /\ ~in3 \/ wres19) /\
  (wres28 = wres7 /\ wres5 \/ ~wres2 \/ wres14) /\
  (wres30 = ~wres3 \/ wres29 /\ ~in1 \/ wres17 /\ wres9) /\
  (wres25 = wres17 /\ wres4 \/ wres3 /\ in3 /\ in2 \/ wres24 /\ ~in2) /\
  (wres27 =
   wres15 \/ wres16 /\ wres6 \/ wres26 /\ in2 \/ ~wres2 /\ ~in2 \/ wres23)
  ==> (out7 = ~in7) /\
      (out6 = ~in7 /\ in6 \/ ~wres10) /\
      (out5 = wres8 /\ in7 \/ wres10 /\ in5) /\
      (out4 = wres21 /\ ~in4 \/ wres20 /\ in6 \/ wres33 /\ in4) /\
      (out3 =
       wres13 /\ in6 /\ ~in5 \/
       wres7 /\ ~in5 /\ ~in3 \/
       wres31 /\ in3 \/
       wres32 /\ in5) /\
      (out2 =
       in6 /\ in5 /\ in4 /\ in2 \/
       wres5 /\ ~in6 \/
       ~wres2 /\ in2 \/
       wres12 /\ wres1 /\ in5 \/
       wres5 /\ ~in7 \/
       wres13 /\ wres0 /\ ~in2 \/
       wres18 /\ in4 \/
       wres19 /\ wres12 \/
       wres20 /\ wres11 \/
       wres21 /\ wres11 \/
       wres23) /\
      (out1 =
       wres16 /\ ~wres6 \/
       wres13 /\ ~wres0 /\ ~in1 \/
       wres28 /\ in1 \/
       wres15 /\ wres4 \/
       wres30 /\ in3) /\
      (out0 = wres25 /\ in0 \/ wres27 /\ ~in0)` ;

val aim_100_1_6_no_3 = bdd_oracle
`~
((v5 \/ v31 \/ v91) /\
 (v31 \/ v38 \/ v40) /\
 (~v38 \/ v40 \/ ~v91) /\
 (v31 \/ ~v40 \/ ~v91) /\
 (v30 \/ ~v31 \/ v39) /\
 (~v30 \/ v39 \/ v88) /\
 (~v31 \/ v39 \/ ~v88) /\
 (~v39 \/ v69 \/ v82) /\
 (~v39 \/ v69 \/ ~v82) /\
 (v10 \/ v60 \/ v94) /\
 (~v10 \/ v24 \/ v74) /\
 (~v10 \/ v60 \/ ~v74) /\
 (v20 \/ v26 \/ ~v60) /\
 (~v20 \/ v52 \/ v87) /\
 (v52 \/ ~v60 \/ ~v87) /\
 (v26 \/ ~v52 \/ v94) /\
 (~v26 \/ v45 \/ v57) /\
 (~v26 \/ ~v45 \/ v57) /\
 (~v26 \/ ~v57 \/ v100) /\
 (v24 \/ ~v60 \/ ~v100) /\
 (v11 \/ ~v24 \/ v38) /\
 (v5 \/ v11 \/ ~v38) /\
 (v5 \/ ~v11 \/ ~v24) /\
 (v4 \/ v42 \/ ~v69) /\
 (v4 \/ ~v42 \/ v100) /\
 (~v42 \/ ~v69 \/ ~v100) /\
 (v71 \/ v83 \/ ~v94) /\
 (~v4 \/ ~v71 \/ v83) /\
 (~v4 \/ ~v83 \/ ~v94) /\
 (~v5 \/ v59 \/ v73) /\
 (~v5 \/ v59 \/ ~v73) /\
 (v13 \/ ~v59 \/ v78) /\
 (v15 \/ v77 \/ v92) /\
 (v53 \/ ~v77 \/ v92) /\
 (v28 \/ ~v53 \/ v98) /\
 (~v28 \/ ~v53 \/ v98) /\
 (v22 \/ v89 \/ ~v98) /\
 (v22 \/ ~v53 \/ ~v89) /\
 (v12 \/ ~v22 \/ v58) /\
 (v12 \/ ~v58 \/ ~v98) /\
 (~v12 \/ ~v22 \/ ~v53) /\
 (v15 \/ v18 \/ v36) /\
 (v21 \/ ~v36 \/ ~v92) /\
 (v18 \/ ~v21 \/ ~v36) /\
 (~v18 \/ ~v92 \/ v96) /\
 (~v18 \/ ~v78 \/ ~v96) /\
 (v13 \/ ~v15 \/ ~v78) /\
 (v1 \/ v8 \/ v42) /\
 (v56 \/ v61 \/ v91) /\
 (v2 \/ ~v56 \/ v61) /\
 (v2 \/ v8 \/ v61) /\
 (~v2 \/ ~v42 \/ v61) /\
 (v1 \/ ~v42 \/ ~v61) /\
 (~v8 \/ ~v13 \/ v64) /\
 (v32 \/ ~v64 \/ v88) /\
 (~v8 \/ ~v32 \/ ~v64) /\
 (~v8 \/ v28 \/ ~v88) /\
 (~v28 \/ ~v64 \/ ~v88) /\
 (~v1 \/ ~v13 \/ ~v59) /\
 (~v35 \/ ~v40 \/ v65) /\
 (~v40 \/ ~v65 \/ v77) /\
 (~v35 \/ ~v77 \/ ~v83) /\
 (v33 \/ v62 \/ v78) /\
 (v47 \/ v53 \/ ~v65) /\
 (v30 \/ v37 \/ v58) /\
 (~v37 \/ v58 \/ v71) /\
 (~v12 \/ ~v37 \/ v71) /\
 (v20 \/ v30 \/ v51) /\
 (v20 \/ ~v51 \/ ~v71) /\
 (~v32 \/ ~v61 \/ v89) /\
 (v27 \/ ~v63 \/ v65) /\
 (~v22 \/ ~v48 \/ v50) /\
 (~v89 \/ ~v97 \/ v98) /\
 (v49 \/ ~v50 \/ ~v82) /\
 (~v16 \/ ~v46 \/ v95) /\
 (~v16 \/ ~v46 \/ ~v95) /\
 (~v17 \/ ~v37 \/ ~v76) /\
 (v51 \/ ~v93 \/ ~v99) /\
 (v27 \/ v76 \/ v79) /\
 (~v52 \/ v76 \/ v79) /\
 (~v1 \/ ~v25 \/ v68) /\
 (v34 \/ ~v58 \/ ~v75) /\
 (~v15 \/ ~v20 \/ ~v90) /\
 (v33 \/ v64 \/ v85) /\
 (~v11 \/ v64 \/ ~v85) /\
 (~v18 \/ ~v33 \/ ~v48) /\
 (v54 \/ ~v63 \/ v75) /\
 (v3 \/ ~v49 \/ ~v95) /\
 (~v3 \/ v74 \/ ~v95) /\
 (~v33 \/ v44 \/ ~v54) /\
 (~v44 \/ ~v50 \/ ~v54) /\
 (~v2 \/ v82 \/ v96) /\
 (v16 \/ v49 \/ v82) /\
 (~v19 \/ ~v41 \/ ~v44) /\
 (v46 \/ ~v49 \/ v81) /\
 (~v3 \/ ~v23 \/ v25) /\
 (v29 \/ v34 \/ v63) /\
 (~v25 \/ ~v34 \/ ~v75) /\
 (~v23 \/ v44 \/ ~v70) /\
 (~v29 \/ ~v38 \/ ~v82) /\
 (~v7 \/ ~v49 \/ ~v77) /\
 (v6 \/ v44 \/ v81) /\
 (v17 \/ ~v19 \/ ~v86) /\
 (~v29 \/ ~v73 \/ v93) /\
 (v11 \/ ~v52 \/ ~v85) /\
 (~v44 \/ v46 \/ v64) /\
 (~v17 \/ ~v34 \/ v95) /\
 (v17 \/ v47 \/ ~v57) /\
 (~v81 \/ ~v96 \/ v97) /\
 (v3 \/ ~v34 \/ v99) /\
 (v43 \/ ~v56 \/ ~v76) /\
 (~v27 \/ v72 \/ ~v79) /\
 (~v6 \/ ~v27 \/ v70) /\
 (v55 \/ v67 \/ v73) /\
 (v16 \/ ~v74 \/ ~v84) /\
 (~v43 \/ v90 \/ v97) /\
 (v50 \/ v56 \/ ~v93) /\
 (~v47 \/ ~v70 \/ ~v90) /\
 (v14 \/ v16 \/ ~v79) /\
 (v45 \/ ~v66 \/ v80) /\
 (v66 \/ ~v66 \/ ~v68) /\
 (v10 \/ ~v80 \/ v87) /\
 (~v55 \/ ~v81 \/ v93) /\
 (v37 \/ ~v45 \/ v72) /\
 (v19 \/ v68 \/ ~v97) /\
 (~v9 \/ ~v70 \/ ~v93) /\
 (v7 \/ v35 \/ v54) /\
 (~v41 \/ ~v41 \/ ~v55) /\
 (v14 \/ ~v14 \/ v70) /\
 (v23 \/ ~v23 \/ ~v62) /\
 (v23 \/ ~v67 \/ ~v80) /\
 (v10 \/ v36 \/ ~v51) /\
 (v21 \/ ~v68 \/ v85) /\
 (~v6 \/ v43 \/ ~v55) /\
 (v32 \/ v48 \/ v86) /\
 (v21 \/ ~v41 \/ v99) /\
 (v14 \/ v81 \/ v97) /\
 (~v9 \/ ~v43 \/ ~v72) /\
 (v7 \/ ~v9 \/ ~v79) /\
 (~v41 \/ v84 \/ ~v90) /\
 (v25 \/ ~v72 \/ v86) /\
 (~v9 \/ ~v46 \/ v63) /\
 (v6 \/ ~v14 \/ v38) /\
 (v7 \/ ~v21 \/ v35) /\
 (v9 \/ ~v87 \/ v99) /\
 (~v20 \/ ~v58 \/ v80) /\
 (~v3 \/ v75 \/ ~v86) /\
 (v19 \/ ~v62 \/ v84) /\
 (~v14 \/ ~v67 \/ v82) /\
 (~v27 \/ v48 \/ ~v68) /\
 (~v25 \/ v45 \/ ~v84) /\
 (~v7 \/ v41 \/ v67) /\
 (~v30 \/ ~v47 \/ v48) /\
 (v66 \/ v97 \/ ~v99) /\
 (v9 \/ v41 \/ v55) /\
 (~v29 \/ v36 \/ ~v86) /\
 (v50 \/ v62 \/ ~v81) /\
 (v29 \/ ~v86 \/ v90) /\
 (~v48 \/ v54 \/ ~v55) /\
 (v19 \/ ~v34 \/ v89))` ;

val dubois20 = bdd_oracle
`~
((v39 \/ v40 \/ v1) /\
 (~v39 \/ ~v40 \/ v1) /\
 (v39 \/ ~v40 \/ ~v1) /\
 (~v39 \/ v40 \/ ~v1) /\
 (v1 \/ v41 \/ v2) /\
 (~v1 \/ ~v41 \/ v2) /\
 (v1 \/ ~v41 \/ ~v2) /\
 (~v1 \/ v41 \/ ~v2) /\
 (v2 \/ v42 \/ v3) /\
 (~v2 \/ ~v42 \/ v3) /\
 (v2 \/ ~v42 \/ ~v3) /\
 (~v2 \/ v42 \/ ~v3) /\
 (v3 \/ v43 \/ v4) /\
 (~v3 \/ ~v43 \/ v4) /\
 (v3 \/ ~v43 \/ ~v4) /\
 (~v3 \/ v43 \/ ~v4) /\
 (v4 \/ v44 \/ v5) /\
 (~v4 \/ ~v44 \/ v5) /\
 (v4 \/ ~v44 \/ ~v5) /\
 (~v4 \/ v44 \/ ~v5) /\
 (v5 \/ v45 \/ v6) /\
 (~v5 \/ ~v45 \/ v6) /\
 (v5 \/ ~v45 \/ ~v6) /\
 (~v5 \/ v45 \/ ~v6) /\
 (v6 \/ v46 \/ v7) /\
 (~v6 \/ ~v46 \/ v7) /\
 (v6 \/ ~v46 \/ ~v7) /\
 (~v6 \/ v46 \/ ~v7) /\
 (v7 \/ v47 \/ v8) /\
 (~v7 \/ ~v47 \/ v8) /\
 (v7 \/ ~v47 \/ ~v8) /\
 (~v7 \/ v47 \/ ~v8) /\
 (v8 \/ v48 \/ v9) /\
 (~v8 \/ ~v48 \/ v9) /\
 (v8 \/ ~v48 \/ ~v9) /\
 (~v8 \/ v48 \/ ~v9) /\
 (v9 \/ v49 \/ v10) /\
 (~v9 \/ ~v49 \/ v10) /\
 (v9 \/ ~v49 \/ ~v10) /\
 (~v9 \/ v49 \/ ~v10) /\
 (v10 \/ v50 \/ v11) /\
 (~v10 \/ ~v50 \/ v11) /\
 (v10 \/ ~v50 \/ ~v11) /\
 (~v10 \/ v50 \/ ~v11) /\
 (v11 \/ v51 \/ v12) /\
 (~v11 \/ ~v51 \/ v12) /\
 (v11 \/ ~v51 \/ ~v12) /\
 (~v11 \/ v51 \/ ~v12) /\
 (v12 \/ v52 \/ v13) /\
 (~v12 \/ ~v52 \/ v13) /\
 (v12 \/ ~v52 \/ ~v13) /\
 (~v12 \/ v52 \/ ~v13) /\
 (v13 \/ v53 \/ v14) /\
 (~v13 \/ ~v53 \/ v14) /\
 (v13 \/ ~v53 \/ ~v14) /\
 (~v13 \/ v53 \/ ~v14) /\
 (v14 \/ v54 \/ v15) /\
 (~v14 \/ ~v54 \/ v15) /\
 (v14 \/ ~v54 \/ ~v15) /\
 (~v14 \/ v54 \/ ~v15) /\
 (v15 \/ v55 \/ v16) /\
 (~v15 \/ ~v55 \/ v16) /\
 (v15 \/ ~v55 \/ ~v16) /\
 (~v15 \/ v55 \/ ~v16) /\
 (v16 \/ v56 \/ v17) /\
 (~v16 \/ ~v56 \/ v17) /\
 (v16 \/ ~v56 \/ ~v17) /\
 (~v16 \/ v56 \/ ~v17) /\
 (v17 \/ v57 \/ v18) /\
 (~v17 \/ ~v57 \/ v18) /\
 (v17 \/ ~v57 \/ ~v18) /\
 (~v17 \/ v57 \/ ~v18) /\
 (v18 \/ v58 \/ v19) /\
 (~v18 \/ ~v58 \/ v19) /\
 (v18 \/ ~v58 \/ ~v19) /\
 (~v18 \/ v58 \/ ~v19) /\
 (v19 \/ v59 \/ v60) /\
 (~v19 \/ ~v59 \/ v60) /\
 (v19 \/ ~v59 \/ ~v60) /\
 (~v19 \/ v59 \/ ~v60) /\
 (v20 \/ v59 \/ v60) /\
 (~v20 \/ ~v59 \/ v60) /\
 (v20 \/ ~v59 \/ ~v60) /\
 (~v20 \/ v59 \/ ~v60) /\
 (v21 \/ v58 \/ v20) /\
 (~v21 \/ ~v58 \/ v20) /\
 (v21 \/ ~v58 \/ ~v20) /\
 (~v21 \/ v58 \/ ~v20) /\
 (v22 \/ v57 \/ v21) /\
 (~v22 \/ ~v57 \/ v21) /\
 (v22 \/ ~v57 \/ ~v21) /\
 (~v22 \/ v57 \/ ~v21) /\
 (v23 \/ v56 \/ v22) /\
 (~v23 \/ ~v56 \/ v22) /\
 (v23 \/ ~v56 \/ ~v22) /\
 (~v23 \/ v56 \/ ~v22) /\
 (v24 \/ v55 \/ v23) /\
 (~v24 \/ ~v55 \/ v23) /\
 (v24 \/ ~v55 \/ ~v23) /\
 (~v24 \/ v55 \/ ~v23) /\
 (v25 \/ v54 \/ v24) /\
 (~v25 \/ ~v54 \/ v24) /\
 (v25 \/ ~v54 \/ ~v24) /\
 (~v25 \/ v54 \/ ~v24) /\
 (v26 \/ v53 \/ v25) /\
 (~v26 \/ ~v53 \/ v25) /\
 (v26 \/ ~v53 \/ ~v25) /\
 (~v26 \/ v53 \/ ~v25) /\
 (v27 \/ v52 \/ v26) /\
 (~v27 \/ ~v52 \/ v26) /\
 (v27 \/ ~v52 \/ ~v26) /\
 (~v27 \/ v52 \/ ~v26) /\
 (v28 \/ v51 \/ v27) /\
 (~v28 \/ ~v51 \/ v27) /\
 (v28 \/ ~v51 \/ ~v27) /\
 (~v28 \/ v51 \/ ~v27) /\
 (v29 \/ v50 \/ v28) /\
 (~v29 \/ ~v50 \/ v28) /\
 (v29 \/ ~v50 \/ ~v28) /\
 (~v29 \/ v50 \/ ~v28) /\
 (v30 \/ v49 \/ v29) /\
 (~v30 \/ ~v49 \/ v29) /\
 (v30 \/ ~v49 \/ ~v29) /\
 (~v30 \/ v49 \/ ~v29) /\
 (v31 \/ v48 \/ v30) /\
 (~v31 \/ ~v48 \/ v30) /\
 (v31 \/ ~v48 \/ ~v30) /\
 (~v31 \/ v48 \/ ~v30) /\
 (v32 \/ v47 \/ v31) /\
 (~v32 \/ ~v47 \/ v31) /\
 (v32 \/ ~v47 \/ ~v31) /\
 (~v32 \/ v47 \/ ~v31) /\
 (v33 \/ v46 \/ v32) /\
 (~v33 \/ ~v46 \/ v32) /\
 (v33 \/ ~v46 \/ ~v32) /\
 (~v33 \/ v46 \/ ~v32) /\
 (v34 \/ v45 \/ v33) /\
 (~v34 \/ ~v45 \/ v33) /\
 (v34 \/ ~v45 \/ ~v33) /\
 (~v34 \/ v45 \/ ~v33) /\
 (v35 \/ v44 \/ v34) /\
 (~v35 \/ ~v44 \/ v34) /\
 (v35 \/ ~v44 \/ ~v34) /\
 (~v35 \/ v44 \/ ~v34) /\
 (v36 \/ v43 \/ v35) /\
 (~v36 \/ ~v43 \/ v35) /\
 (v36 \/ ~v43 \/ ~v35) /\
 (~v36 \/ v43 \/ ~v35) /\
 (v37 \/ v42 \/ v36) /\
 (~v37 \/ ~v42 \/ v36) /\
 (v37 \/ ~v42 \/ ~v36) /\
 (~v37 \/ v42 \/ ~v36) /\
 (v38 \/ v41 \/ v37) /\
 (~v38 \/ ~v41 \/ v37) /\
 (v38 \/ ~v41 \/ ~v37) /\
 (~v38 \/ v41 \/ ~v37) /\
 (v39 \/ v40 \/ ~v38) /\
 (~v39 \/ ~v40 \/ ~v38) /\
 (v39 \/ ~v40 \/ v38) /\
 (~v39 \/ v40 \/ v38))` ;

val add3_be  = bdd_oracle
 `(aftbuf1 = ~anda) /\
  (aftbuf2 = ~andb) /\
  (aftbuf3 = ~exora) /\
  (aftbuf4 = ~exorb) /\
  (aftbuf5 = ~carryin) /\
  (n1_0_ = aftbuf1 /\ a_0_) /\
  (n1_1_ = aftbuf1 /\ a_1_) /\
  (n1_2_ = aftbuf1 /\ a_2_) /\
  (n1_3_ = aftbuf1 /\ a_3_) /\
  (n1_4_ = aftbuf1 /\ a_4_) /\
  (n1_5_ = aftbuf1 /\ a_5_) /\
  (n1_6_ = aftbuf1 /\ a_6_) /\
  (n1_7_ = aftbuf1 /\ a_7_) /\
  (n3_0_ = aftbuf2 /\ b_0_) /\
  (n3_1_ = aftbuf2 /\ b_1_) /\
  (n3_2_ = aftbuf2 /\ b_2_) /\
  (n3_3_ = aftbuf2 /\ b_3_) /\
  (n3_4_ = aftbuf2 /\ b_4_) /\
  (n3_5_ = aftbuf2 /\ b_5_) /\
  (n3_6_ = aftbuf2 /\ b_6_) /\
  (n3_7_ = aftbuf2 /\ b_7_) /\
  (n2_0_ = aftbuf3 /\ ~n1_0_ \/ ~aftbuf3 /\ n1_0_) /\
  (n2_1_ = aftbuf3 /\ ~n1_1_ \/ ~aftbuf3 /\ n1_1_) /\
  (n2_2_ = aftbuf3 /\ ~n1_2_ \/ ~aftbuf3 /\ n1_2_) /\
  (n2_3_ = aftbuf3 /\ ~n1_3_ \/ ~aftbuf3 /\ n1_3_) /\
  (n2_4_ = aftbuf3 /\ ~n1_4_ \/ ~aftbuf3 /\ n1_4_) /\
  (n2_5_ = aftbuf3 /\ ~n1_5_ \/ ~aftbuf3 /\ n1_5_) /\
  (n2_6_ = aftbuf3 /\ ~n1_6_ \/ ~aftbuf3 /\ n1_6_) /\
  (n2_7_ = aftbuf3 /\ ~n1_7_ \/ ~aftbuf3 /\ n1_7_) /\
  (n4_0_ = aftbuf4 /\ ~n3_0_ \/ ~aftbuf4 /\ n3_0_) /\
  (n4_1_ = aftbuf4 /\ ~n3_1_ \/ ~aftbuf4 /\ n3_1_) /\
  (n4_2_ = aftbuf4 /\ ~n3_2_ \/ ~aftbuf4 /\ n3_2_) /\
  (n4_3_ = aftbuf4 /\ ~n3_3_ \/ ~aftbuf4 /\ n3_3_) /\
  (n4_4_ = aftbuf4 /\ ~n3_4_ \/ ~aftbuf4 /\ n3_4_) /\
  (n4_5_ = aftbuf4 /\ ~n3_5_ \/ ~aftbuf4 /\ n3_5_) /\
  (n4_6_ = aftbuf4 /\ ~n3_6_ \/ ~aftbuf4 /\ n3_6_) /\
  (n4_7_ = aftbuf4 /\ ~n3_7_ \/ ~aftbuf4 /\ n3_7_) /\
  (cout1 = aftbuf5 /\ n4_0_ \/ aftbuf5 /\ n2_0_ \/ n4_0_ /\ n2_0_) /\
  (cout2 = cout1 /\ n4_1_ \/ cout1 /\ n2_1_ \/ n4_1_ /\ n2_1_) /\
  (cout3 = cout2 /\ n4_2_ \/ cout2 /\ n2_2_ \/ n4_2_ /\ n2_2_) /\
  (cout4 = cout3 /\ n4_3_ \/ cout3 /\ n2_3_ \/ n4_3_ /\ n2_3_) /\
  (cout5 = cout4 /\ n4_4_ \/ cout4 /\ n2_4_ \/ n4_4_ /\ n2_4_) /\
  (cout6 = cout5 /\ n4_5_ \/ cout5 /\ n2_5_ \/ n4_5_ /\ n2_5_) /\
  (cout7 = cout6 /\ n4_6_ \/ cout6 /\ n2_6_ \/ n4_6_ /\ n2_6_) /\
  (hulp0 = ~(n2_0_ = ~(n4_0_ = aftbuf5))) /\
  (hulp1 = ~(n2_1_ = ~(n4_1_ = cout1))) /\
  (hulp2 = ~(n2_2_ = ~(n4_2_ = cout2))) /\
  (hulp3 = ~(n2_3_ = ~(n4_3_ = cout3))) /\
  (hulp4 = ~(n2_4_ = ~(n4_4_ = cout4))) /\
  (hulp5 = ~(n2_5_ = ~(n4_5_ = cout5))) /\
  (hulp6 = ~(n2_6_ = ~(n4_6_ = cout6))) /\
  (hulp7 = ~(n2_7_ = ~(n4_7_ = cout7))) /\
  (hulp8 = cout7 /\ n4_7_ \/ cout7 /\ n2_7_ \/ n4_7_ /\ n2_7_) /\
  (sign = ~hulp7) /\
  (overflow = cout7 = hulp8) /\
  (carryout = ~hulp8) /\
  (o_7_ = hulp7) /\
  (o_6_ = hulp6) /\
  (o_5_ = hulp5) /\
  (o_4_ = hulp4) /\
  (o_3_ = hulp3) /\
  (o_2_ = hulp2) /\
  (o_1_ = hulp1) /\
  (o_0_ = hulp0) /\
  (n3 = a_1_) /\
  (n4 = a_4_) /\
  (n5 = a_6_) /\
  (n6 = a_5_) /\
  (n7 = a_0_) /\
  (n8 = a_2_) /\
  (n9 = a_7_) /\
  (n10 = a_3_) /\
  (n11 = anda) /\
  (n12 = exora) /\
  (n13 = b_4_) /\
  (n14 = b_6_) /\
  (n15 = b_3_) /\
  (n16 = b_0_) /\
  (n17 = b_1_) /\
  (n18 = b_7_) /\
  (n19 = b_5_) /\
  (n20 = b_2_) /\
  (n21 = andb) /\
  (n22 = exorb) /\
  (n23 = carryin) /\
  (n74 = ~n23) /\
  (n70 = ~n21) /\
  (n76 = ~n22) /\
  (n69 = ~n11) /\
  (n75 = ~n12) /\
  (n165 = ~n9 \/ ~n69) /\
  (n173 = ~n75) /\
  (n166 = ~n18 \/ ~n70) /\
  (n174 = ~n76) /\
  (n160 = ~n14 \/ ~n70) /\
  (n152 = ~n76) /\
  (n159 = ~n5 \/ ~n69) /\
  (n151 = ~n75) /\
  (n134 = ~n13 \/ ~n70) /\
  (n126 = ~n76) /\
  (n133 = ~n4 \/ ~n69) /\
  (n125 = ~n75) /\
  (n113 = ~n10 \/ ~n69) /\
  (n121 = ~n75) /\
  (n114 = ~n15 \/ ~n70) /\
  (n122 = ~n76) /\
  (n140 = ~n19 \/ ~n70) /\
  (n148 = ~n76) /\
  (n139 = ~n6 \/ ~n69) /\
  (n147 = ~n75) /\
  (n87 = ~n3 \/ ~n69) /\
  (n95 = ~n75) /\
  (n88 = ~n17 \/ ~n70) /\
  (n96 = ~n76) /\
  (n108 = ~n20 \/ ~n70) /\
  (n100 = ~n76) /\
  (n107 = ~n8 \/ ~n69) /\
  (n99 = ~n75) /\
  (n77 = ~n74) /\
  (n82 = ~n16 \/ ~n70) /\
  (n72 = ~n76) /\
  (n81 = ~n7 \/ ~n69) /\
  (n71 = ~n75) /\
  (n65 = ~n165) /\
  (n63 = ~n166) /\
  (n61 = ~n160) /\
  (n59 = ~n159) /\
  (n53 = ~n134) /\
  (n51 = ~n133) /\
  (n49 = ~n113) /\
  (n47 = ~n114) /\
  (n55 = ~n140) /\
  (n57 = ~n139) /\
  (n41 = ~n87) /\
  (n39 = ~n88) /\
  (n45 = ~n108) /\
  (n43 = ~n107) /\
  (n37 = ~n82) /\
  (n35 = ~n81) /\
  (n168 = n65 = n75) /\
  (n169 = n63 = n76) /\
  (n158 = n61 = n76) /\
  (n157 = n59 = n75) /\
  (n132 = n53 = n76) /\
  (n131 = n51 = n75) /\
  (n116 = n49 = n75) /\
  (n117 = n47 = n76) /\
  (n143 = n55 = n76) /\
  (n142 = n57 = n75) /\
  (n90 = n41 = n75) /\
  (n91 = n39 = n76) /\
  (n106 = n45 = n76) /\
  (n105 = n43 = n75) /\
  (n80 = n37 = n76) /\
  (n79 = n35 = n75) /\
  (n66 = ~n168) /\
  (n64 = ~n169) /\
  (n62 = ~n158) /\
  (n60 = ~n157) /\
  (n54 = ~n132) /\
  (n52 = ~n131) /\
  (n50 = ~n116) /\
  (n48 = ~n117) /\
  (n56 = ~n143) /\
  (n58 = ~n142) /\
  (n42 = ~n90) /\
  (n40 = ~n91) /\
  (n46 = ~n106) /\
  (n44 = ~n105) /\
  (n38 = ~n80) /\
  (n36 = ~n79) /\
  (n172 = ~n66) /\
  (n150 = ~n60) /\
  (n124 = ~n52) /\
  (n120 = ~n50) /\
  (n146 = ~n58) /\
  (n94 = ~n42) /\
  (n98 = ~n44) /\
  (n68 = ~n36) /\
  (n171 = n64 = n66) /\
  (n153 = n62 = n60) /\
  (n127 = n54 = n52) /\
  (n119 = n48 = n50) /\
  (n145 = n56 = n58) /\
  (n93 = n40 = n42) /\
  (n101 = n46 = n44) /\
  (n73 = n38 = n36) /\
  (n163 = ~n171) /\
  (n149 = ~n153) /\
  (n123 = ~n127) /\
  (n111 = ~n119) /\
  (n137 = ~n145) /\
  (n85 = ~n93) /\
  (n97 = ~n101) /\
  (n67 = ~n73) /\
  (n170 = ~n163) /\
  (n161 = ~n149) /\
  (n135 = ~n123) /\
  (n118 = ~n111) /\
  (n144 = ~n137) /\
  (n92 = ~n85) /\
  (n109 = ~n97) /\
  (n83 = ~n67) /\
  (n84 = ~n67 /\ ~n36 \/ ~n83 /\ ~n74) /\
  (n78 = ~(n77 = n67)) /\
  (n86 = ~n84) /\
  (n102 = ~n92 /\ ~n84 \/ ~n94 /\ ~n85) /\
  (n28 = ~n78) /\
  (n110 = ~n97 /\ ~n44 \/ ~n109 /\ ~n102) /\
  (n89 = n86 = n85) /\
  (n103 = ~n102) /\
  (n112 = ~n110) /\
  (n128 = ~n118 /\ ~n110 \/ ~n120 /\ ~n111) /\
  (n24 = ~n89) /\
  (n104 = ~(n103 = n97)) /\
  (n115 = n112 = n111) /\
  (n129 = ~n128) /\
  (n136 = ~n123 /\ ~n52 \/ ~n135 /\ ~n128) /\
  (n26 = ~n104) /\
  (n25 = ~n115) /\
  (n130 = ~(n129 = n123)) /\
  (n154 = ~n144 /\ ~n136 \/ ~n146 /\ ~n137) /\
  (n138 = ~n136) /\
  (n27 = ~n130) /\
  (n162 = ~n149 /\ ~n60 \/ ~n161 /\ ~n154) /\
  (n155 = ~n154) /\
  (n141 = n138 = n137) /\
  (n164 = ~n162) /\
  (n175 = ~n162) /\
  (n176 = ~n170 /\ ~n162 \/ ~n172 /\ ~n163) /\
  (n156 = ~(n155 = n149)) /\
  (n30 = ~n141) /\
  (n167 = n164 = n163) /\
  (n177 = n176 = n162) /\
  (n31 = ~n176) /\
  (n29 = ~n156) /\
  (n34 = ~n167) /\
  (n32 = ~n177) /\
  (n33 = ~n34)
  ==> (o_1_ = n24) /\
      (o_3_ = n25) /\
      (o_2_ = n26) /\
      (o_4_ = n27) /\
      (o_0_ = n28) /\
      (o_6_ = n29) /\
      (o_5_ = n30) /\
      (carryout = n31) /\
      (overflow = n32) /\
      (sign = n33) /\
      (o_7_ = n34)` ;

val add4_be  = bdd_oracle
 `(n3 = a_0_) /\
  (n4 = a_2_) /\
  (n5 = a_4_) /\
  (n6 = a_5_) /\
  (n7 = a_6_) /\
  (n8 = a_8_) /\
  (n9 = a_3_) /\
  (n10 = a_7_) /\
  (n11 = a_9_) /\
  (n12 = a_11_) /\
  (n13 = a_1_) /\
  (n14 = a_10_) /\
  (n15 = anda) /\
  (n16 = exora) /\
  (n17 = b_3_) /\
  (n18 = b_4_) /\
  (n19 = b_6_) /\
  (n20 = b_1_) /\
  (n21 = b_7_) /\
  (n22 = b_9_) /\
  (n23 = b_2_) /\
  (n24 = b_5_) /\
  (n25 = b_8_) /\
  (n26 = b_10_) /\
  (n27 = b_11_) /\
  (n28 = b_0_) /\
  (n29 = andb) /\
  (n30 = exorb) /\
  (n31 = carryin) /\
  (n98 = ~n29) /\
  (n104 = ~n30) /\
  (n97 = ~n15) /\
  (n103 = ~n16) /\
  (n102 = ~n31) /\
  (n105 = ~n102) /\
  (n243 = ~n14 \/ ~n97) /\
  (n235 = ~n103) /\
  (n244 = ~n26 \/ ~n98) /\
  (n236 = ~n104) /\
  (n224 = ~n22 \/ ~n98) /\
  (n232 = ~n104) /\
  (n223 = ~n11 \/ ~n97) /\
  (n231 = ~n103) /\
  (n217 = ~n8 \/ ~n97) /\
  (n209 = ~n103) /\
  (n218 = ~n25 \/ ~n98) /\
  (n210 = ~n104) /\
  (n197 = ~n21 \/ ~n98) /\
  (n206 = ~n104) /\
  (n196 = ~n10 \/ ~n97) /\
  (n205 = ~n103) /\
  (n190 = ~n19 \/ ~n98) /\
  (n182 = ~n104) /\
  (n189 = ~n7 \/ ~n97) /\
  (n181 = ~n103) /\
  (n251 = ~n27 \/ ~n98) /\
  (n259 = ~n104) /\
  (n250 = ~n12 \/ ~n97) /\
  (n258 = ~n103) /\
  (n163 = ~n18 \/ ~n98) /\
  (n155 = ~n104) /\
  (n162 = ~n5 \/ ~n97) /\
  (n154 = ~n103) /\
  (n170 = ~n24 \/ ~n98) /\
  (n178 = ~n104) /\
  (n169 = ~n6 \/ ~n97) /\
  (n177 = ~n103) /\
  (n136 = ~n23 \/ ~n98) /\
  (n128 = ~n104) /\
  (n135 = ~n4 \/ ~n97) /\
  (n127 = ~n103) /\
  (n116 = ~n20 \/ ~n98) /\
  (n124 = ~n104) /\
  (n115 = ~n13 \/ ~n97) /\
  (n123 = ~n103) /\
  (n110 = ~n28 \/ ~n98) /\
  (n100 = ~n104) /\
  (n109 = ~n3 \/ ~n97) /\
  (n99 = ~n103) /\
  (n142 = ~n17 \/ ~n98) /\
  (n150 = ~n104) /\
  (n141 = ~n9 \/ ~n97) /\
  (n149 = ~n103) /\
  (n87 = ~n243) /\
  (n89 = ~n244) /\
  (n83 = ~n224) /\
  (n85 = ~n223) /\
  (n79 = ~n217) /\
  (n81 = ~n218) /\
  (n75 = ~n197) /\
  (n77 = ~n196) /\
  (n73 = ~n190) /\
  (n71 = ~n189) /\
  (n91 = ~n251) /\
  (n93 = ~n250) /\
  (n65 = ~n163) /\
  (n63 = ~n162) /\
  (n67 = ~n170) /\
  (n69 = ~n169) /\
  (n57 = ~n136) /\
  (n55 = ~n135) /\
  (n51 = ~n116) /\
  (n53 = ~n115) /\
  (n49 = ~n110) /\
  (n47 = ~n109) /\
  (n59 = ~n142) /\
  (n61 = ~n141) /\
  (n241 = n87 /\ n103 \/ ~n87 /\ ~n103) /\
  (n242 = n89 /\ n104 \/ ~n89 /\ ~n104) /\
  (n227 = n83 /\ n104 \/ ~n83 /\ ~n104) /\
  (n226 = n85 /\ n103 \/ ~n85 /\ ~n103) /\
  (n215 = n79 /\ n103 \/ ~n79 /\ ~n103) /\
  (n216 = n81 /\ n104 \/ ~n81 /\ ~n104) /\
  (n200 = n75 /\ n104 \/ ~n75 /\ ~n104) /\
  (n199 = n77 /\ n103 \/ ~n77 /\ ~n103) /\
  (n188 = n73 /\ n104 \/ ~n73 /\ ~n104) /\
  (n187 = n71 /\ n103 \/ ~n71 /\ ~n103) /\
  (n254 = n91 /\ n104 \/ ~n91 /\ ~n104) /\
  (n253 = n93 /\ n103 \/ ~n93 /\ ~n103) /\
  (n160 = n65 /\ n104 \/ ~n65 /\ ~n104) /\
  (n159 = n63 /\ n103 \/ ~n63 /\ ~n103) /\
  (n173 = n67 /\ n104 \/ ~n67 /\ ~n104) /\
  (n172 = n69 /\ n103 \/ ~n69 /\ ~n103) /\
  (n134 = n57 /\ n104 \/ ~n57 /\ ~n104) /\
  (n133 = n55 /\ n103 \/ ~n55 /\ ~n103) /\
  (n119 = n51 /\ n104 \/ ~n51 /\ ~n104) /\
  (n118 = n53 /\ n103 \/ ~n53 /\ ~n103) /\
  (n108 = n49 /\ n104 \/ ~n49 /\ ~n104) /\
  (n107 = n47 /\ n103 \/ ~n47 /\ ~n103) /\
  (n145 = n59 /\ n104 \/ ~n59 /\ ~n104) /\
  (n144 = n61 /\ n103 \/ ~n61 /\ ~n103) /\
  (n88 = ~n241) /\
  (n90 = ~n242) /\
  (n84 = ~n227) /\
  (n86 = ~n226) /\
  (n80 = ~n215) /\
  (n82 = ~n216) /\
  (n76 = ~n200) /\
  (n78 = ~n199) /\
  (n74 = ~n188) /\
  (n72 = ~n187) /\
  (n92 = ~n254) /\
  (n94 = ~n253) /\
  (n66 = ~n160) /\
  (n64 = ~n159) /\
  (n68 = ~n173) /\
  (n70 = ~n172) /\
  (n58 = ~n134) /\
  (n56 = ~n133) /\
  (n52 = ~n119) /\
  (n54 = ~n118) /\
  (n50 = ~n108) /\
  (n48 = ~n107) /\
  (n60 = ~n145) /\
  (n62 = ~n144) /\
  (n234 = ~n88) /\
  (n230 = ~n86) /\
  (n208 = ~n80) /\
  (n204 = ~n78) /\
  (n180 = ~n72) /\
  (n257 = ~n94) /\
  (n152 = ~n64) /\
  (n176 = ~n70) /\
  (n126 = ~n56) /\
  (n122 = ~n54) /\
  (n96 = ~n48) /\
  (n148 = ~n62) /\
  (n237 = n90 /\ n88 \/ ~n90 /\ ~n88) /\
  (n229 = n84 /\ n86 \/ ~n84 /\ ~n86) /\
  (n211 = n82 /\ n80 \/ ~n82 /\ ~n80) /\
  (n203 = n76 /\ n78 \/ ~n76 /\ ~n78) /\
  (n183 = n74 /\ n72 \/ ~n74 /\ ~n72) /\
  (n256 = n92 /\ n94 \/ ~n92 /\ ~n94) /\
  (n156 = n66 /\ n64 \/ ~n66 /\ ~n64) /\
  (n175 = n68 /\ n70 \/ ~n68 /\ ~n70) /\
  (n129 = n58 /\ n56 \/ ~n58 /\ ~n56) /\
  (n121 = n52 /\ n54 \/ ~n52 /\ ~n54) /\
  (n101 = n50 /\ n48 \/ ~n50 /\ ~n48) /\
  (n147 = n60 /\ n62 \/ ~n60 /\ ~n62) /\
  (n233 = ~n237) /\
  (n221 = ~n229) /\
  (n207 = ~n211) /\
  (n193 = ~n203) /\
  (n179 = ~n183) /\
  (n248 = ~n256) /\
  (n151 = ~n156) /\
  (n166 = ~n175) /\
  (n125 = ~n129) /\
  (n113 = ~n121) /\
  (n95 = ~n101) /\
  (n139 = ~n147) /\
  (n245 = ~n233) /\
  (n228 = ~n221) /\
  (n219 = ~n207) /\
  (n167 = ~n166 \/ ~n151 \/ ~n179 \/ ~n193) /\
  (n202 = ~n193) /\
  (n191 = ~n179) /\
  (n255 = ~n248) /\
  (n164 = ~n151) /\
  (n174 = ~n166) /\
  (n137 = ~n125) /\
  (n120 = ~n113) /\
  (n111 = ~n95) /\
  (n146 = ~n139) /\
  (n106 = n105 /\ ~n95 \/ ~n105 /\ n95) /\
  (n161 = ~n167) /\
  (n112 = ~n95 /\ ~n48 \/ ~n111 /\ ~n102) /\
  (n114 = ~n112) /\
  (n39 = ~n106) /\
  (n130 = ~n120 /\ ~n112 \/ ~n122 /\ ~n113) /\
  (n117 = n114 /\ n113 \/ ~n114 /\ ~n113) /\
  (n131 = ~n130) /\
  (n138 = ~n125 /\ ~n56 \/ ~n137 /\ ~n130) /\
  (n32 = ~n117) /\
  (n132 = n131 /\ ~n125 \/ ~n131 /\ n125) /\
  (n153 = ~n146 /\ ~n138 \/ ~n148 /\ ~n139) /\
  (n140 = ~n138) /\
  (n37 = ~n132) /\
  (n157 = ~n153) /\
  (n165 = ~n151 /\ ~n64 \/ ~n164 /\ ~n153) /\
  (n143 = n140 /\ n139 \/ ~n140 /\ ~n139) /\
  (n158 = n157 /\ ~n151 \/ ~n157 /\ n151) /\
  (n184 = ~n174 /\ ~n165 \/ ~n176 /\ ~n166) /\
  (n168 = ~n165) /\
  (n33 = ~n143) /\
  (n43 = ~n158) /\
  (n185 = ~n184) /\
  (n192 = ~n179 /\ ~n72 \/ ~n191 /\ ~n184) /\
  (n171 = n168 /\ n166 \/ ~n168 /\ ~n166) /\
  (n195 = ~n192) /\
  (n186 = n185 /\ ~n179 \/ ~n185 /\ n179) /\
  (n201 = ~n202 /\ ~n192 \/ ~n204 /\ ~n193) /\
  (n34 = ~n171) /\
  (n198 = n195 /\ n193 \/ ~n195 /\ ~n193) /\
  (n35 = ~n186) /\
  (n194 = ~n167 /\ ~n153 \/ ~n161 /\ ~n201) /\
  (n36 = ~n198) /\
  (n212 = ~n194) /\
  (n213 = ~n212) /\
  (n220 = ~n207 /\ ~n80 \/ ~n219 /\ ~n212) /\
  (n214 = n213 /\ ~n207 \/ ~n213 /\ n207) /\
  (n222 = ~n220) /\
  (n238 = ~n228 /\ ~n220 \/ ~n230 /\ ~n221) /\
  (n38 = ~n214) /\
  (n225 = n222 /\ n221 \/ ~n222 /\ ~n221) /\
  (n239 = ~n238) /\
  (n246 = ~n233 /\ ~n88 \/ ~n245 /\ ~n238) /\
  (n40 = ~n225) /\
  (n240 = n239 /\ ~n233 \/ ~n239 /\ n233) /\
  (n261 = ~n255 /\ ~n246 \/ ~n257 /\ ~n248) /\
  (n249 = ~n246) /\
  (n262 = n261 /\ n246 \/ ~n261 /\ ~n246) /\
  (n41 = ~n240) /\
  (n44 = ~n261) /\
  (n252 = n249 /\ n248 \/ ~n249 /\ ~n248) /\
  (n45 = ~n262) /\
  (n42 = ~n252) /\
  (n46 = ~n42) /\
  (o_4_ = n43) /\
  (o_11_ = n42) /\
  (o_10_ = n41) /\
  (o_9_ = n40) /\
  (o_0_ = n39) /\
  (o_8_ = n38) /\
  (o_2_ = n37) /\
  (o_7_ = n36) /\
  (o_6_ = n35) /\
  (o_5_ = n34) /\
  (o_3_ = n33) /\
  (o_1_ = n32) /\
  (aftbuf1 = ~anda) /\
  (aftbuf2 = ~andb) /\
  (aftbuf3 = ~exora) /\
  (aftbuf4 = ~exorb) /\
  (aftbuf5 = ~carryin) /\
  (n1_0_ = aftbuf1 /\ a_0_) /\
  (n1_1_ = aftbuf1 /\ a_1_) /\
  (n1_2_ = aftbuf1 /\ a_2_) /\
  (n1_3_ = aftbuf1 /\ a_3_) /\
  (n1_4_ = aftbuf1 /\ a_4_) /\
  (n1_5_ = aftbuf1 /\ a_5_) /\
  (n1_6_ = aftbuf1 /\ a_6_) /\
  (n1_7_ = aftbuf1 /\ a_7_) /\
  (n1_8_ = aftbuf1 /\ a_8_) /\
  (n1_9_ = aftbuf1 /\ a_9_) /\
  (n1_10_ = aftbuf1 /\ a_10_) /\
  (n1_11_ = aftbuf1 /\ a_11_) /\
  (n3_0_ = aftbuf2 /\ b_0_) /\
  (n3_1_ = aftbuf2 /\ b_1_) /\
  (n3_2_ = aftbuf2 /\ b_2_) /\
  (n3_3_ = aftbuf2 /\ b_3_) /\
  (n3_4_ = aftbuf2 /\ b_4_) /\
  (n3_5_ = aftbuf2 /\ b_5_) /\
  (n3_6_ = aftbuf2 /\ b_6_) /\
  (n3_7_ = aftbuf2 /\ b_7_) /\
  (n3_8_ = aftbuf2 /\ b_8_) /\
  (n3_9_ = aftbuf2 /\ b_9_) /\
  (n3_10_ = aftbuf2 /\ b_10_) /\
  (n3_11_ = aftbuf2 /\ b_11_) /\
  (n2_0_ = aftbuf3 /\ ~n1_0_ \/ ~aftbuf3 /\ n1_0_) /\
  (n2_1_ = aftbuf3 /\ ~n1_1_ \/ ~aftbuf3 /\ n1_1_) /\
  (n2_2_ = aftbuf3 /\ ~n1_2_ \/ ~aftbuf3 /\ n1_2_) /\
  (n2_3_ = aftbuf3 /\ ~n1_3_ \/ ~aftbuf3 /\ n1_3_) /\
  (n2_4_ = aftbuf3 /\ ~n1_4_ \/ ~aftbuf3 /\ n1_4_) /\
  (n2_5_ = aftbuf3 /\ ~n1_5_ \/ ~aftbuf3 /\ n1_5_) /\
  (n2_6_ = aftbuf3 /\ ~n1_6_ \/ ~aftbuf3 /\ n1_6_) /\
  (n2_7_ = aftbuf3 /\ ~n1_7_ \/ ~aftbuf3 /\ n1_7_) /\
  (n2_8_ = aftbuf3 /\ ~n1_8_ \/ ~aftbuf3 /\ n1_8_) /\
  (n2_9_ = aftbuf3 /\ ~n1_9_ \/ ~aftbuf3 /\ n1_9_) /\
  (n2_10_ = aftbuf3 /\ ~n1_10_ \/ ~aftbuf3 /\ n1_10_) /\
  (n2_11_ = aftbuf3 /\ ~n1_11_ \/ ~aftbuf3 /\ n1_11_) /\
  (n4_0_ = aftbuf4 /\ ~n3_0_ \/ ~aftbuf4 /\ n3_0_) /\
  (n4_1_ = aftbuf4 /\ ~n3_1_ \/ ~aftbuf4 /\ n3_1_) /\
  (n4_2_ = aftbuf4 /\ ~n3_2_ \/ ~aftbuf4 /\ n3_2_) /\
  (n4_3_ = aftbuf4 /\ ~n3_3_ \/ ~aftbuf4 /\ n3_3_) /\
  (n4_4_ = aftbuf4 /\ ~n3_4_ \/ ~aftbuf4 /\ n3_4_) /\
  (n4_5_ = aftbuf4 /\ ~n3_5_ \/ ~aftbuf4 /\ n3_5_) /\
  (n4_6_ = aftbuf4 /\ ~n3_6_ \/ ~aftbuf4 /\ n3_6_) /\
  (n4_7_ = aftbuf4 /\ ~n3_7_ \/ ~aftbuf4 /\ n3_7_) /\
  (n4_8_ = aftbuf4 /\ ~n3_8_ \/ ~aftbuf4 /\ n3_8_) /\
  (n4_9_ = aftbuf4 /\ ~n3_9_ \/ ~aftbuf4 /\ n3_9_) /\
  (n4_10_ = aftbuf4 /\ ~n3_10_ \/ ~aftbuf4 /\ n3_10_) /\
  (n4_11_ = aftbuf4 /\ ~n3_11_ \/ ~aftbuf4 /\ n3_11_) /\
  (cout1 = aftbuf5 /\ n4_0_ \/ aftbuf5 /\ n2_0_ \/ n4_0_ /\ n2_0_) /\
  (cout2 = cout1 /\ n4_1_ \/ cout1 /\ n2_1_ \/ n4_1_ /\ n2_1_) /\
  (cout3 = cout2 /\ n4_2_ \/ cout2 /\ n2_2_ \/ n4_2_ /\ n2_2_) /\
  (cout4 = cout3 /\ n4_3_ \/ cout3 /\ n2_3_ \/ n4_3_ /\ n2_3_) /\
  (cout5 = cout4 /\ n4_4_ \/ cout4 /\ n2_4_ \/ n4_4_ /\ n2_4_) /\
  (cout6 = cout5 /\ n4_5_ \/ cout5 /\ n2_5_ \/ n4_5_ /\ n2_5_) /\
  (cout7 = cout6 /\ n4_6_ \/ cout6 /\ n2_6_ \/ n4_6_ /\ n2_6_) /\
  (cout8 = cout7 /\ n4_7_ \/ cout7 /\ n2_7_ \/ n4_7_ /\ n2_7_) /\
  (cout9 = cout8 /\ n4_8_ \/ cout8 /\ n2_8_ \/ n4_8_ /\ n2_8_) /\
  (cout10 = cout9 /\ n4_9_ \/ cout9 /\ n2_9_ \/ n4_9_ /\ n2_9_) /\
  (cout11 = cout10 /\ n4_10_ \/ cout10 /\ n2_10_ \/ n4_10_ /\ n2_10_) /\
  (hulp0 = ~(n2_0_ = ~(n4_0_ = aftbuf5))) /\
  (hulp1 = ~(n2_1_ = ~(n4_1_ = cout1))) /\
  (hulp2 = ~(n2_2_ = ~(n4_2_ = cout2))) /\
  (hulp3 = ~(n2_3_ = ~(n4_3_ = cout3))) /\
  (hulp4 = ~(n2_4_ = ~(n4_4_ = cout4))) /\
  (hulp5 = ~(n2_5_ = ~(n4_5_ = cout5))) /\
  (hulp6 = ~(n2_6_ = ~(n4_6_ = cout6))) /\
  (hulp7 = ~(n2_7_ = ~(n4_7_ = cout7))) /\
  (hulp8 = ~(n2_8_ = ~(n4_8_ = cout8))) /\
  (hulp9 = ~(n2_9_ = ~(n4_9_ = cout9))) /\
  (hulp10 = ~(n2_10_ = ~(n4_10_ = cout10))) /\
  (hulp11 = ~(n2_11_ = ~(n4_11_ = cout11))) /\
  (hulp12 = cout11 /\ n4_11_ \/ cout11 /\ n2_11_ \/ n4_11_ /\ n2_11_)
  ==> (o_0_ = hulp0) /\
      (o_1_ = hulp1) /\
      (o_2_ = hulp2) /\
      (o_3_ = hulp3) /\
      (o_4_ = hulp4) /\
      (o_5_ = hulp5) /\
      (o_6_ = hulp6) /\
      (o_7_ = hulp7) /\
      (o_8_ = hulp8) /\
      (o_9_ = hulp9) /\
      (o_10_ = hulp10) /\
      (o_11_ = hulp11)` ;
