signature type_grammar =
sig

  datatype grammar_rule =
    SUFFIX of string list
  | INFIX of {opname : string, parse_string : string} list *
             HOLgrammars.associativity
  datatype type_structure =
           TYOP of {Thy : string, Tyop : string, Args : type_structure list}
         | PARAM of int

  type grammar
  val initialise_typrinter :
      (grammar -> Portable.ppstream -> Type.hol_type -> unit) -> unit

  val rules : grammar -> (int * grammar_rule) list
  val abbreviations : grammar -> (string,type_structure) Binarymap.dict

  val empty_grammar : grammar

  val new_binary_tyop :
    grammar -> {precedence : int,
                infix_form : string option,
                opname : string,
                associativity : HOLgrammars.associativity} -> grammar
  val new_tyop : grammar -> string -> grammar
  val new_abbreviation : grammar -> string * type_structure -> grammar

  val std_suffix_precedence : int

  val merge_grammars : grammar * grammar -> grammar

  val prettyprint_grammar : ppstream -> grammar -> unit

end;
