(*---------------------------------------------------------------------------*
 *                                                                           *
 *               SMOOTH APPLICATIVE MERGE SORT                               *
 *                                                                           *
 * from Richard O'Keefe, as found in Paulson's ML book                       *
 *---------------------------------------------------------------------------*)

(*
     hol98 -I kls_list
*)

app load ["bossLib", "tflLib", "QLib",
          "permTheory", "sortingTheory", "kls_listTheory" ];

open tflLib kls_listTheory sortingTheory permTheory bossLib;
infix 8 by;

(*---------------------------------------------------------------------------*
 *     Merge two lists using R.                                              *
 *---------------------------------------------------------------------------*)
val merge_def = 
 Define
    `(merge R [] x = x)
 /\  (merge R (CONS h t) [] = CONS h t) 
 /\  (merge R (CONS h1 t1) (CONS h2 t2) = 
        (R h1 h2 => CONS h1 (merge R t1 (CONS h2 t2))
                  | CONS h2 (merge R (CONS h1 t1) t2)))`;


(*---------------------------------------------------------------------------*
 *     Reverse a list.                                                       *
 *---------------------------------------------------------------------------*)
val rev_def = 
 Define
    `(rev []         rl = rl)
  /\ (rev (CONS h t) rl = rev t (CONS h rl))`;

val reverse_def = 
 Define 
    `reverse L = rev L []`;


(*---------------------------------------------------------------------------*
 *     Merge adjacent lists.                                                 *
 *---------------------------------------------------------------------------*)
val mergepairs_def =
 Define
    `(mergepairs R [] k = [])
 /\  (mergepairs R [l] k = [l]) 
 /\  (mergepairs R (CONS l1 (CONS l2 rst)) k =
       ((k MOD 2 = 1) => CONS l1 (CONS l2 rst)
                      |  mergepairs R (CONS (merge R l1 l2) rst) (k DIV 2)))`;


(*---------------------------------------------------------------------------*
 *     Unbundled bottom-up merge sort                                        *
 *---------------------------------------------------------------------------*)
val msort_def = 
 Define
    `(msort R [] ll k = HD(mergepairs R ll 0))
  /\ (msort R (CONS h t) ll k 
       = msort R t (mergepairs R (CONS [h] ll) (k+1)) (k+1))`;


(*---------------------------------------------------------------------------*
 *     Break the next run off the front of the list.                         *
 *---------------------------------------------------------------------------*)
val nextrun_def =
 Define
    `(nextrun R run [] = (reverse run, []))
  /\ (nextrun R run (CONS h t) 
       = (R h (HD run) => (reverse run, CONS h t)
                       |  nextrun R (CONS h run) t))`;


(*---------------------------------------------------------------------------*
 *     Unbundled "smooth" bottom-up merge sort.                              *
 *---------------------------------------------------------------------------*)
val samsortl_def = 
 Define
    `(samsortl R [] ll k = HD(mergepairs R ll 0)) 
 /\  (samsortl R (CONS h t) ll k 
       = let (run,rst) = nextrun R [h] t
         in
           samsortl R rst (mergepairs R (CONS run ll) (k+1)) (k+1))`;


(*---------------------------------------------------------------------------*
 *     Bundled bottom-up smooth merge sort.                                  *
 *---------------------------------------------------------------------------*)
val samsort_def = 
 Define 
    `samsort R alist = samsortl R alist [] 0`;



(* Now all we have to do is prove termination and properties! *)
