(*----------------------------------------------------------------------------*
 *                                                                            *
 *            Mutual recursion : even and odd                                 *
 *                                                                            *
 * This isn't such an interesting example, since the induction theorems       *
 * obtained are just standard mathematical induction!                         *
 *----------------------------------------------------------------------------*)

app load ["bossLib", "Q"; open bossLib;

Hol_datatype `tag = Even of num | Odd of num`;

val EO = Define `(EO (Even 0) = T)              /\
                 (EO (Even(SUC x)) = EO(Odd x)) /\
                 (EO (Odd 0) = F)               /\
                 (EO (Odd(SUC x)) = EO(Even x))`;

val even_def = Define `even n = EO(Even n)`;
val odd_def  = Define `odd n  = EO(Odd n)`;

(*---------------------------------------------------------------------------
 *  |- (even 0 = T) /\
 *    (!x. even (SUC x) = odd x) /\
 *     (odd 0 = F) /\
 *     (!x. odd (SUC x) = even x) : thm
 *---------------------------------------------------------------------------*)
val (even_odd_rules as [even0,evenSUC,odd0,oddSUC]) = 
   map GEN_ALL
    (CONJUNCTS (Rewrite.PURE_REWRITE_RULE [GSYM even_def, GSYM odd_def] 
                 (CONJUNCT1 EO)));

