/*************************************************************************
  $Header: /home/jl/phd/bdd/RCS/cache.c,v 1.1 1997/11/04 10:15:15 jl Exp jl $
  FILE:  cache.c
  DESCR: Cache class for caching apply/exist etc. results in BDD package
  AUTH:  Jorn Lind
  DATE:  (C) june 1997
*************************************************************************/
#include <stdlib.h>
#include "kernel.h"
#include "cache.h"

/*************************************************************************
*************************************************************************/

int BddCache_init(BddCache *cache, int size)
{
   int n;
   
   if ((cache->table=(BddCacheData*)malloc(sizeof(BddCacheData)*size)) == NULL)
      return bdd_error(BDD_MEMORY);
   
   for (n=0 ; n<size ; n++)
      cache->table[n].a = -1;
   cache->tablesize = size;
   
   return 0;
}


void BddCache_done(BddCache *cache)
{
   free(cache->table);
   cache->table = NULL;
   cache->tablesize = 0;
}


void BddCache_reset(BddCache *cache)
{
   register BddCacheData *n;
   for (n=cache->table+cache->tablesize-1 ; n>=cache->table ; n--)
      n->a = -1;
}


/* EOF */
