(*==========================================================================*)
(* Build structure for the ML type of natural numbers                       *)
(*==========================================================================*)

structure NumType :> NumType =
struct

open Exception

fun failwith function = raise HOL_ERR{origin_structure = "NumType",
                                      origin_function = function,
                                      message = ""};
type num = Portable_Int.int;

local

(*--------------------------------------------------------------------------*)
(* Function to compute the Greatest Common Divisor of two integers.         *)
(*--------------------------------------------------------------------------*)

fun gcd (i,j) =
   let exception non_neg
       fun gcd' (i,j) =
          let val r = (i mod j)
          in  if (r = 0)
              then j
              else gcd' (j,r)
          end
   in  (if ((i < 0) orelse (j < 0))
        then raise non_neg
        else if (i < j) then gcd' (j,i) else gcd' (i,j)
       ) handle non_neg => failwith "gcd"
              | Portable_Int.Mod => failwith "gcd"
   end;

(*--------------------------------------------------------------------------*)
(* Function to compute the Lowest Common Multiple of two integers.          *)
(*--------------------------------------------------------------------------*)

fun lcm (i,j) = (i * j) div (gcd (i,j)) handle HOL_ERR _ => failwith "lcm"
                                       | Portable_Int.Div => failwith "lcm";

in

(*--------------------------------------------------------------------------*)
(* Make the definitions                                                     *)
(*--------------------------------------------------------------------------*)

val num0 = 0
and num1 = 1
and op + = Portable_Int.+
and op - = Portable_Int.-
and op * = Portable_Int.*
and op div = Portable_Int.div
and lcm = lcm
and op < = Portable_Int.<


(*---------------------------------------------------------------------------
 * I am not sure why this is needed in the move to 109.26 - kls.
 *---------------------------------------------------------------------------*)
fun eek n1 n2 = (n1=n2)
end;

end; (* NumType *)
