signature Theory = 
sig

type fixity = Term.fixity

(* Adding to the current theory *)
  val new_type     : {Name:string, Arity:int} -> unit
  val new_constant : {Name:string, Ty:Type.hol_type} -> unit
  val new_infix    : {Name:string, Ty:Type.hol_type, Prec:int} -> unit
  val new_binder   : {Name:string, Ty:Type.hol_type} -> unit
  val new_axiom    : string * Term.term -> Thm.thm
  val save_thm     : string * Thm.thm -> Thm.thm

(* Information on constants *)
  val is_type     : string -> bool
  val is_constant : string -> bool
  val is_binder   : string -> bool
  val is_infix    : string -> bool
  val arity       : string -> int
  val fixity      : string -> fixity
  val precedence  : string -> int

(* Delete from the current theory *)

  val delete_type       : string -> unit
  val delete_const      : string -> unit
  val delete_axiom      : string -> unit
  val delete_theorem    : string -> unit

(* Information on the current theory *)
  val current_theory : unit -> string
  val parents        : string -> string list
  val ancestry       : string -> string list
  val types          : string -> {Name :string, Arity :int} list
  val constants      : string -> Term.term list
  val infixes        : string -> Term.term list
  val binders        : string -> Term.term list
  val axioms         : unit -> (string * Thm.thm) list
  val definitions    : unit -> (string * Thm.thm) list
  val theorems       : unit -> (string * Thm.thm) list
  val axiom          : string -> Thm.thm
  val definition     : string -> Thm.thm
  val theorem        : string -> Thm.thm

(* Viewing the current theory *)
  val print_theory              : unit -> unit
  val print_theory_to_file      : string -> unit
  val print_theory_to_outstream : Portable.outstream -> Portable.outstream

(* Operations that change the current theory *)
  val new_theory : string -> unit

(* Operations that write the theory to disk *)
  val prim_export_theory : 
   {sig_ps    :(Portable_PrettyPrint.ppstream -> unit)option,
    struct_ps :(Portable_PrettyPrint.ppstream -> unit)option} -> unit
  val export_theory : unit -> unit

(* Support operations for theories-as-structures *)
  val link_parents       : string*int*int -> (string*int*int)list -> unit
  val incorporate_types  : string -> (string*int) list -> unit
  val incorporate_consts : string -> (string*Type.hol_type*fixity)list -> unit

 (* Information hiding *)
  val expose_store_definition 
   :(string * (string,string list)Lib.sum * Thm.thm * Term.term -> Thm.thm)ref
    -> unit

 val uptodate_type  : Type.hol_type -> bool
 val uptodate_term  : Term.term -> bool
 val uptodate_thm   : Thm.thm -> bool
 val scrub          : unit -> unit

 (* Altering parse status of constants *)
 val set_fixity : string -> Term.fixity -> unit

 (* Changing internal bindings of ML-level names to constants *)
 val set_MLname : string -> string -> unit
end;
