(* ML-Yacc Parser Generator (c) 1989 Andrew W. Appel, David R. Tarditi 
 *
 * $Log: join.sml,v $
# Revision 1.1.1.1  1997/01/14  01:38:04  george
#   Version 109.24
#
 * Revision 1.1.1.1  1996/01/31  16:01:42  george
 * Version 109
 * 
 *)

structure RawParser :> RawParser =
struct
    exception ParseError = LRParser.ParseError

    type arg = RawParserData.arg
    type pos = RawParserData.pos
    type result = RawParserData.result
    type svalue = RawParserData.svalue

    val makeLexer = Stream.streamify o RawLex.makeLexer

    fun parse (lookahead,lexer,error,arg) =
      let val (a,b) = LRParser.parse 
                        {table = RawParserData.table,
                         lexer = lexer,
                         lookahead = lookahead,
                         saction = RawActions.actions,
                         arg = arg,
                         void = RawActions.void,
                         ec = {is_keyword = RawEC.is_keyword,
                               noShift = RawEC.noShift,
                               preferred_change = RawEC.preferred_change,
                               errtermvalue = RawEC.errtermvalue,
                               error = error,
                               showTerminal = RawEC.showTerminal,
                         terms = RawEC.terms}}
      in
       (RawActions.extract a,b)
      end;
     
     val sameToken = Token.sameToken
end;

