structure UserDeclarations =
struct

type pos = int;
val line:pos = 0;
type svalue = RawTokens.svalue;
type ('a,'b) token = ('a,'b) RawTokens.token;
type lexresult = (svalue,pos) RawTokens.token;

fun error(s,_,_) = 
   Portable.output(Portable.std_out,"Theory lexer error: "^s^"\n");
fun eof () = RawTokens.EOF(line,line);

val string_list = ref ([]:string list);

fun break_atom s = Lib.string_to_int
                      (String.substring(s,1,Portable_String.size s - 1))

exception LEX_ERR of string;

end (* end of user routines *)
