structure RawLex :> RawLex =
struct

exception LexError (* raised if illegal leaf action tried *)

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}

datatype yystartstate = STARTSTATE of int
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 3;

type result = UserDeclarations.lexresult
exception LexerError (* raised if illegal leaf action tried *)


(* transition & final state table *)

val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\005\005\005\005\005\005\005\005\005\017\019\005\017\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\017\005\016\005\014\012\005\005\011\010\005\005\005\005\009\005\
\\007\007\007\007\007\007\007\007\007\007\005\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\006\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\005"
),
 (3, 
"\020\020\020\020\020\020\020\020\020\020\024\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\023\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\021\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020"
),
 (7, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\008\008\008\008\008\008\008\008\008\008\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (12, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (14, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\015\015\015\015\015\015\015\015\015\015\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (17, 
"\000\000\000\000\000\000\000\000\000\018\018\000\018\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\018\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (21, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\022\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in 
Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [(N 27)], trans = 0},
{fin = [(N 8),(N 27)], trans = 0},
{fin = [(N 17),(N 27)], trans = 7},
{fin = [(N 17)], trans = 7},
{fin = [(N 10),(N 27)], trans = 0},
{fin = [(N 14),(N 27)], trans = 0},
{fin = [(N 12),(N 27)], trans = 0},
{fin = [(N 27)], trans = 12},
{fin = [(N 25)], trans = 12},
{fin = [(N 27)], trans = 14},
{fin = [(N 21)], trans = 14},
{fin = [(N 6),(N 27)], trans = 0},
{fin = [(N 4),(N 27)], trans = 17},
{fin = [(N 4)], trans = 17},
{fin = [(N 1),(N 4)], trans = 17},
{fin = [(N 36)], trans = 0},
{fin = [(N 36)], trans = 21},
{fin = [(N 32)], trans = 0},
{fin = [(N 34),(N 36)], trans = 0},
{fin = [(N 29)], trans = 0}])
end

fun makeLexer yyinput = 
let 
  val yyb = ref "\n" 		(* buffer *)
  val yybl = ref 1		(*buffer length *)
  val yybufpos = ref 1		(* location of next character to use *)
  val yygone = ref 1		(* position in file of beginning of buffer *)
  val yydone = ref false	(* eof found yet? *)
  val yybegin = ref 1		(* Current 'start state' for lexer *)

  val YYBEGIN = fn (STARTSTATE x) => yybegin := x

 fun lex () : result =
  let fun continue() = lex() 
      fun scan (s,AcceptingLeaves : yyfinstate list list,l,i0) =
       let fun action (i,nil) = raise LexError
	    | action (i,nil::l) = action (i-1,l)
            | action (i,(node::acts)::l) =
	      case node 
              of N yyk 
                 => 
                 let val yytext = String.substring(!yyb,i0,i-i0)
		      val yypos = i0+ !yygone
                      open UserDeclarations
                 in 
                  yybufpos := i; 
                  case yyk  (* Application actions *)
                  of 1 => (continue())
                   | 10 => (RawTokens.dot(line,line))
                   | 12 => (RawTokens.lparen(line,line))
                   | 14 => (RawTokens.rparen(line,line))
                   | 17 => (RawTokens.num(yytext,line,line))
                   | 21 => (RawTokens.dB_index(break_atom yytext,line,line))
                   | 25 => RawTokens.atom_index(break_atom yytext,line,line)
                   | 27 => (raise LEX_ERR "INITIAL.catchall")
                   | 29 => (string_list := yytext::(!string_list); continue())
                   | 32 => (string_list := "\""::(!string_list); continue())
                   | 34 => (YYBEGIN INITIAL; 
                            RawTokens.string_
                             (Portable.implode
                                (rev(yytext::(!string_list))),line,line))
                   | 36 => (string_list :=  yytext::(!string_list); continue())
                   | 4 => (continue())
                   | 6 => (YYBEGIN STRING; string_list := [yytext]; continue())
                   | 8 => (RawTokens.lambda(line,line))
                   | _ => raise LexerError
                 end (* action *)
	  val {fin,trans} = Vector.sub(tab, s)
	  val NewAcceptingLeaves = fin::AcceptingLeaves
       in 
           if (l = !yybl)
           then
	     if trans = #trans(Vector.sub(tab,0))
             then action(l,NewAcceptingLeaves) 
             else let val newchars = if !yydone then "" else yyinput 1024
                  in if (size newchars)=0
		     then (yydone := true;
		           if (l=i0) then UserDeclarations.eof ()
		           else action(l,NewAcceptingLeaves))
		     else (if i0=l then yyb := newchars
		           else yyb := String.substring(!yyb,i0,l-i0)^newchars;
		           yygone := !yygone+i0;
		           yybl := size (!yyb);
		           scan (s,AcceptingLeaves,l-i0,0))
	          end
	   else let val NewChar = Char.ord(String.sub(!yyb,l))
		    val NewState = if NewChar<128 
                               then Char.ord(String.sub(trans,NewChar)) 
                               else Char.ord(String.sub(trans,128))
		in 
                  if NewState=0 
                  then action(l,NewAcceptingLeaves)
                  else scan(NewState,NewAcceptingLeaves,l+1,i0)
	        end
	end (* body of scan *)
   in 
     scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
   end 
in 
  lex 
end   (* makeLexer *)

end
