structure ParserData =
struct

local open LRTable 
in 
val table = 
let val actionRows =
"\
\\001\000\001\000\011\000\002\000\009\000\005\000\008\000\006\000\007\000\
\\007\000\006\000\008\000\005\000\000\000\
\\001\000\002\000\009\000\005\000\008\000\006\000\007\000\007\000\006\000\
\\008\000\005\000\000\000\
\\001\000\003\000\014\000\000\000\
\\001\000\003\000\017\000\000\000\
\\001\000\004\000\015\000\000\000\
\\001\000\006\000\007\000\000\000\
\\001\000\009\000\000\000\010\000\000\000\000\000\
\\019\000\000\000\
\\020\000\000\000\
\\021\000\000\000\
\\022\000\000\000\
\\023\000\000\000\
\\024\000\000\000\
\\025\000\000\000\
\\026\000\000\000\
\"

val actionRowNumbers =
"\001\000\009\000\007\000\010\000\
\\011\000\014\000\008\000\000\000\
\\001\000\005\000\002\000\004\000\
\\012\000\001\000\003\000\013\000\
\\006\000"

val gotoT =
"\
\\001\000\016\000\002\000\002\000\003\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\008\000\003\000\001\000\000\000\
\\002\000\010\000\003\000\001\000\000\000\
\\003\000\011\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\"

val numstates = 17
val numrules = 8
val s = ref "" and index = ref 0
val string_to_int = fn () => 
   let val i = !index
   in 
     index := i+2; 
     Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
   end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ = let fun g i = (Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
              fun f i =
                 if i=numstates then g i
                 else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in 
           f 0 handle Subscript => ()
          end
in
 val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end

val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows = string_to_table
                 (string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = 
     let val actionRowLookUp =
               let val a = Array.fromList(actionRows) 
               in fn i => Array.sub(a,i) 
               end
     in Array.fromList(map actionRowLookUp actionRowNumbers)
     end
in 
   LRTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
                      numStates=numstates,initialState=STATE 0}
end (* let val actionRows *)
end (* local  ... in val table = ... *)

local open Header 
in
  type pos = int
  type arg = Term.term Vector.vector
  type svalue = MlyValue.svalue
  type result = Term.term
end

end (* ParserData *)
