structure HolParserData =
struct


local open LRTable 
in 
val table = 
 let val actionRows =
"\
\\001\000\001\000\155\000\002\000\155\000\004\000\157\000\007\000\155\000\
\\009\000\155\000\010\000\155\000\011\000\155\000\013\000\155\000\
\\014\000\155\000\015\000\155\000\016\000\155\000\017\000\155\000\
\\018\000\155\000\019\000\155\000\020\000\155\000\021\000\155\000\
\\022\000\155\000\023\000\155\000\024\000\155\000\025\000\155\000\
\\026\000\155\000\027\000\155\000\028\000\155\000\029\000\155\000\
\\030\000\155\000\031\000\155\000\033\000\155\000\034\000\155\000\
\\035\000\155\000\000\000\
\\001\000\001\000\156\000\002\000\156\000\004\000\159\000\007\000\156\000\
\\009\000\156\000\010\000\156\000\011\000\156\000\013\000\156\000\
\\014\000\156\000\015\000\156\000\016\000\156\000\017\000\156\000\
\\018\000\156\000\019\000\156\000\020\000\156\000\021\000\156\000\
\\022\000\156\000\023\000\156\000\024\000\156\000\025\000\156\000\
\\026\000\156\000\027\000\156\000\028\000\156\000\029\000\156\000\
\\030\000\156\000\031\000\156\000\033\000\156\000\034\000\156\000\
\\035\000\156\000\000\000\
\\001\000\001\000\018\000\002\000\017\000\007\000\016\000\009\000\015\000\
\\010\000\014\000\014\000\013\000\016\000\012\000\019\000\011\000\
\\020\000\010\000\024\000\009\000\029\000\008\000\033\000\007\000\000\000\
\\001\000\001\000\018\000\002\000\017\000\007\000\016\000\009\000\015\000\
\\010\000\014\000\014\000\013\000\016\000\012\000\020\000\010\000\
\\024\000\009\000\029\000\008\000\033\000\007\000\000\000\
\\001\000\001\000\028\000\009\000\027\000\010\000\026\000\000\000\
\\001\000\001\000\038\000\004\000\037\000\006\000\036\000\009\000\035\000\
\\012\000\034\000\000\000\
\\001\000\001\000\078\000\002\000\077\000\033\000\076\000\000\000\
\\001\000\002\000\073\000\011\000\072\000\019\000\050\000\000\000\
\\001\000\004\000\037\000\006\000\036\000\009\000\035\000\012\000\034\000\000\000\
\\001\000\004\000\054\000\000\000\
\\001\000\011\000\063\000\000\000\
\\001\000\011\000\100\000\000\000\
\\001\000\013\000\083\000\018\000\082\000\025\000\057\000\026\000\056\000\
\\027\000\055\000\000\000\
\\001\000\013\000\106\000\000\000\
\\001\000\015\000\062\000\000\000\
\\001\000\017\000\059\000\000\000\
\\001\000\017\000\097\000\000\000\
\\001\000\020\000\065\000\021\000\064\000\000\000\
\\001\000\021\000\098\000\000\000\
\\001\000\024\000\051\000\000\000\
\\001\000\024\000\053\000\000\000\
\\001\000\028\000\067\000\000\000\
\\001\000\031\000\048\000\000\000\
\\001\000\034\000\000\000\035\000\000\000\000\000\
\\114\000\000\000\
\\115\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\116\000\000\000\
\\117\000\000\000\
\\118\000\000\000\
\\119\000\000\000\
\\120\000\001\000\018\000\002\000\017\000\007\000\016\000\009\000\015\000\
\\010\000\014\000\014\000\013\000\016\000\012\000\020\000\010\000\
\\023\000\022\000\024\000\009\000\029\000\008\000\033\000\007\000\000\000\
\\121\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\122\000\019\000\046\000\000\000\
\\123\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\124\000\019\000\019\000\000\000\
\\125\000\000\000\
\\126\000\000\000\
\\127\000\000\000\
\\128\000\000\000\
\\129\000\000\000\
\\130\000\000\000\
\\131\000\000\000\
\\132\000\000\000\
\\133\000\000\000\
\\134\000\000\000\
\\135\000\000\000\
\\136\000\000\000\
\\137\000\000\000\
\\138\000\000\000\
\\139\000\000\000\
\\140\000\000\000\
\\141\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\142\000\000\000\
\\143\000\002\000\073\000\019\000\050\000\000\000\
\\144\000\000\000\
\\145\000\030\000\089\000\000\000\
\\146\000\000\000\
\\147\000\000\000\
\\148\000\001\000\028\000\009\000\027\000\010\000\026\000\019\000\050\000\000\000\
\\149\000\001\000\018\000\002\000\017\000\007\000\016\000\009\000\015\000\
\\010\000\014\000\014\000\013\000\016\000\012\000\020\000\010\000\
\\024\000\009\000\029\000\008\000\033\000\007\000\000\000\
\\150\000\022\000\061\000\000\000\
\\150\000\022\000\061\000\028\000\060\000\000\000\
\\151\000\000\000\
\\152\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\153\000\026\000\056\000\027\000\055\000\000\000\
\\154\000\026\000\056\000\000\000\
\\158\000\000\000\
\\160\000\000\000\
\\161\000\000\000\
\\162\000\000\000\
\\163\000\000\000\
\\164\000\000\000\
\\165\000\018\000\107\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\166\000\000\000\
\\167\000\000\000\
\\168\000\028\000\092\000\000\000\
\\169\000\000\000\
\\170\000\000\000\
\\171\000\032\000\094\000\000\000\
\\172\000\032\000\093\000\000\000\
\\173\000\000\000\
\\174\000\000\000\
\\175\000\000\000\
\\176\000\023\000\110\000\025\000\057\000\026\000\056\000\027\000\055\000\000\000\
\\177\000\000\000\
\"

val actionRowNumbers =
"\002\000\027\000\034\000\030\000\
\\024\000\038\000\004\000\039\000\
\\040\000\005\000\059\000\059\000\
\\003\000\037\000\004\000\036\000\
\\035\000\008\000\028\000\032\000\
\\003\000\022\000\058\000\019\000\
\\004\000\050\000\049\000\020\000\
\\026\000\001\000\009\000\025\000\
\\008\000\069\000\067\000\068\000\
\\074\000\015\000\061\000\014\000\
\\060\000\010\000\017\000\033\000\
\\008\000\021\000\003\000\057\000\
\\008\000\003\000\007\000\006\000\
\\000\000\008\000\008\000\008\000\
\\012\000\043\000\003\000\059\000\
\\042\000\041\000\003\000\003\000\
\\031\000\003\000\047\000\051\000\
\\055\000\004\000\048\000\084\000\
\\075\000\073\000\077\000\079\000\
\\078\000\064\000\065\000\063\000\
\\008\000\070\000\016\000\062\000\
\\046\000\018\000\029\000\004\000\
\\011\000\053\000\006\000\008\000\
\\008\000\013\000\072\000\044\000\
\\003\000\056\000\052\000\004\000\
\\076\000\081\000\083\000\080\000\
\\066\000\008\000\045\000\054\000\
\\008\000\071\000\082\000\023\000"

val gotoT =
"\
\\001\000\111\000\002\000\004\000\003\000\003\000\004\000\002\000\
\\005\000\001\000\000\000\
\\000\000\
\\000\000\
\\004\000\019\000\005\000\018\000\000\000\
\\000\000\
\\000\000\
\\006\000\023\000\007\000\022\000\009\000\021\000\000\000\
\\000\000\
\\000\000\
\\012\000\031\000\013\000\030\000\015\000\029\000\016\000\028\000\
\\017\000\027\000\000\000\
\\002\000\038\000\003\000\003\000\004\000\002\000\005\000\001\000\
\\011\000\037\000\000\000\
\\002\000\040\000\003\000\003\000\004\000\002\000\005\000\001\000\
\\011\000\039\000\000\000\
\\002\000\041\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\006\000\042\000\007\000\022\000\000\000\
\\000\000\
\\000\000\
\\012\000\043\000\013\000\030\000\015\000\029\000\000\000\
\\000\000\
\\000\000\
\\002\000\045\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\006\000\047\000\007\000\022\000\000\000\
\\000\000\
\\007\000\050\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\012\000\056\000\013\000\030\000\015\000\029\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\012\000\064\000\013\000\030\000\015\000\029\000\000\000\
\\000\000\
\\002\000\066\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\012\000\067\000\013\000\030\000\015\000\029\000\000\000\
\\002\000\068\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\010\000\069\000\000\000\
\\018\000\073\000\019\000\072\000\000\000\
\\000\000\
\\012\000\077\000\013\000\030\000\015\000\029\000\000\000\
\\012\000\078\000\013\000\030\000\015\000\029\000\000\000\
\\012\000\079\000\013\000\030\000\015\000\029\000\000\000\
\\000\000\
\\000\000\
\\002\000\082\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\002\000\040\000\003\000\003\000\004\000\002\000\005\000\001\000\
\\011\000\083\000\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\002\000\085\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\002\000\086\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\089\000\008\000\088\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\012\000\094\000\013\000\030\000\014\000\093\000\015\000\029\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\006\000\023\000\007\000\022\000\009\000\097\000\000\000\
\\000\000\
\\010\000\099\000\000\000\
\\018\000\100\000\019\000\072\000\000\000\
\\012\000\102\000\013\000\030\000\015\000\029\000\020\000\101\000\000\000\
\\012\000\102\000\013\000\030\000\015\000\029\000\020\000\103\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\106\000\003\000\003\000\004\000\002\000\005\000\001\000\000\000\
\\000\000\
\\000\000\
\\007\000\089\000\008\000\107\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\012\000\094\000\013\000\030\000\014\000\109\000\015\000\029\000\000\000\
\\000\000\
\\000\000\
\\012\000\102\000\013\000\030\000\015\000\029\000\020\000\110\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 112
val numrules = 64
val s = ref "" and index = ref 0
val string_to_int = fn () => 
    let val i = !index
    in index := i+2; 
       Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
    end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ = let fun g i = (Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
              fun f i =
                 if i=numstates then g i
                 else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in 
             f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end

val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows = string_to_table
                   (string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp =
                       let val a=Array.fromList(actionRows) 
                       in fn i=>Array.sub(a,i) 
                       end
              in Array.fromList(map actionRowLookUp actionRowNumbers)
              end
in 
   LRTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
                      numStates=numstates,initialState=STATE 0}
end
end

local open HolHeader 
in
  type pos = int
  type arg = (int,Type.hol_type) Lib.istream
  type svalue = HolMlyValue.svalue
  type result = parse
end

end;
