structure HolLex :> HolLex =
struct

exception LexError (* raised if illegal leaf action tried *)
exception LexerError (* raised if illegal leaf action tried *)

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
type result = HolUserDeclarations.lexresult


datatype yystartstate = STARTSTATE of int

(* start state definitions *)
val COMMENT = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 9;
val TYCOMMENT = STARTSTATE 5;
val TYPE = STARTSTATE 3;

(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\011\011\011\011\011\011\011\011\011\032\034\011\032\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\032\015\031\015\028\015\015\011\026\025\015\015\024\015\023\015\
\\018\018\018\018\018\018\018\018\018\018\015\015\015\015\015\015\
\\015\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\022\015\021\020\015\
\\011\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\017\015\014\012\011\
\\011"
),
 (3, 
"\035\035\035\035\035\035\035\035\035\063\065\035\063\035\035\035\
\\035\035\035\035\035\035\035\035\035\035\035\035\035\035\035\035\
\\063\039\035\062\059\039\039\057\055\054\039\053\052\050\049\039\
\\042\042\042\042\042\042\042\042\042\042\039\039\039\047\039\039\
\\039\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\046\039\045\044\039\
\\035\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\041\039\038\036\035\
\\035"
),
 (5, 
"\066\066\066\066\066\066\066\066\066\066\072\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\070\066\068\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\067\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066"
),
 (7, 
"\073\073\073\073\073\073\073\073\073\073\079\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\077\073\075\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\074\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073"
),
 (9, 
"\080\080\080\080\080\080\080\080\080\080\086\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\085\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\082\080\081\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080"
),
 (12, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\013\000\013\000\013\013\000\000\000\013\013\013\013\000\013\
\\000\000\000\000\000\000\000\000\000\000\013\013\013\013\013\013\
\\013\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\000\013\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\013\000\
\\000"
),
 (15, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\013\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\016\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\016\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\013\000\
\\000"
),
 (18, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\019\000\000\000\000\000\000\000\000\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (26, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\027\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (28, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\030\016\000\016\
\\019\019\019\019\019\019\019\019\019\019\016\016\016\016\016\016\
\\016\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\000\016\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\029\000\
\\000"
),
 (32, 
"\000\000\000\000\000\000\000\000\000\033\033\000\033\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (36, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\037\000\037\000\037\037\000\000\000\037\037\037\037\000\037\
\\000\000\000\000\000\000\000\000\000\000\037\037\037\037\037\037\
\\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\037\000\000\037\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\037\000\037\000\
\\000"
),
 (39, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\040\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
),
 (42, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\043\000\000\000\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\043\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\
\\000"
),
 (47, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\048\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
),
 (50, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\051\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
),
 (55, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (57, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000"
),
 (58, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\058\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000"
),
 (59, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\061\040\000\040\
\\043\043\043\043\043\043\043\043\043\043\040\040\040\040\040\040\
\\040\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\040\000\000\040\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\040\000\060\000\
\\000"
),
 (63, 
"\000\000\000\000\000\000\000\000\000\064\064\000\064\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (68, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\069\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (70, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\071\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (75, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\076\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (77, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\078\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (82, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\084\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\083\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [], trans = 7},
{fin = [], trans = 7},
{fin = [], trans = 9},
{fin = [], trans = 9},
{fin = [(N 49)], trans = 0},
{fin = [(N 33),(N 42),(N 49)], trans = 12},
{fin = [(N 33)], trans = 12},
{fin = [(N 19),(N 49)], trans = 0},
{fin = [(N 33),(N 37),(N 49)], trans = 15},
{fin = [(N 33),(N 37)], trans = 15},
{fin = [(N 17),(N 49)], trans = 0},
{fin = [(N 29),(N 49)], trans = 18},
{fin = [(N 29)], trans = 18},
{fin = [(N 25),(N 49)], trans = 0},
{fin = [(N 23),(N 49)], trans = 0},
{fin = [(N 21),(N 49)], trans = 0},
{fin = [(N 11),(N 49)], trans = 0},
{fin = [(N 33),(N 47),(N 49)], trans = 12},
{fin = [(N 15),(N 49)], trans = 0},
{fin = [(N 13),(N 49)], trans = 26},
{fin = [(N 7)], trans = 0},
{fin = [(N 49)], trans = 28},
{fin = [(N 33),(N 40)], trans = 12},
{fin = [(N 33),(N 45)], trans = 12},
{fin = [(N 9),(N 49)], trans = 0},
{fin = [(N 4),(N 49)], trans = 32},
{fin = [(N 4)], trans = 32},
{fin = [(N 1),(N 4)], trans = 32},
{fin = [(N 113)], trans = 0},
{fin = [(N 97),(N 106),(N 113)], trans = 36},
{fin = [(N 97)], trans = 36},
{fin = [(N 90),(N 113)], trans = 0},
{fin = [(N 97),(N 101),(N 113)], trans = 39},
{fin = [(N 97),(N 101)], trans = 39},
{fin = [(N 88),(N 113)], trans = 0},
{fin = [(N 65),(N 113)], trans = 42},
{fin = [(N 65)], trans = 42},
{fin = [(N 67),(N 113)], trans = 0},
{fin = [(N 86),(N 113)], trans = 0},
{fin = [(N 84),(N 113)], trans = 0},
{fin = [(N 97),(N 101),(N 113)], trans = 47},
{fin = [(N 93),(N 97),(N 101)], trans = 39},
{fin = [(N 78),(N 113)], trans = 0},
{fin = [(N 97),(N 101),(N 113)], trans = 50},
{fin = [(N 70),(N 97),(N 101)], trans = 39},
{fin = [(N 76),(N 97),(N 111),(N 113)], trans = 36},
{fin = [(N 72),(N 97),(N 101),(N 113)], trans = 39},
{fin = [(N 82),(N 113)], trans = 0},
{fin = [(N 80),(N 113)], trans = 55},
{fin = [(N 57)], trans = 0},
{fin = [(N 113)], trans = 57},
{fin = [(N 61)], trans = 58},
{fin = [(N 113)], trans = 59},
{fin = [(N 97),(N 104)], trans = 36},
{fin = [(N 97),(N 109)], trans = 36},
{fin = [(N 74),(N 97),(N 101),(N 113)], trans = 39},
{fin = [(N 54),(N 113)], trans = 63},
{fin = [(N 54)], trans = 63},
{fin = [(N 51),(N 54)], trans = 63},
{fin = [(N 125)], trans = 0},
{fin = [(N 123),(N 125)], trans = 0},
{fin = [(N 125)], trans = 68},
{fin = [(N 121)], trans = 0},
{fin = [(N 125)], trans = 70},
{fin = [(N 118)], trans = 0},
{fin = [(N 115)], trans = 0},
{fin = [(N 137)], trans = 0},
{fin = [(N 135),(N 137)], trans = 0},
{fin = [(N 137)], trans = 75},
{fin = [(N 133)], trans = 0},
{fin = [(N 137)], trans = 77},
{fin = [(N 130)], trans = 0},
{fin = [(N 127)], trans = 0},
{fin = [(N 151)], trans = 0},
{fin = [(N 149),(N 151)], trans = 0},
{fin = [(N 151)], trans = 82},
{fin = [(N 147)], trans = 0},
{fin = [(N 142)], trans = 0},
{fin = [(N 144),(N 151)], trans = 0},
{fin = [(N 139)], trans = 0}])
end


fun makeLexer yyinput = 
 let val yyb = ref "\n" 		(* buffer *)
     val yybl = ref 1		(*buffer length *)
     val yybufpos = ref 1		(* location of next character to use *)
     val yygone = ref 1		(* position in file of beginning of buffer *)
     val yydone = ref false		(* eof found yet? *)
     val yybegin = ref 1		(*Current 'start state' for lexer *)
     val YYBEGIN = fn (STARTSTATE x) => yybegin := x

     fun lex (yyarg as (aqlist : HolUserDeclarations.arg)) =
       let fun continue() :result = 
          let fun scan (s,AcceptingLeaves :yyfinstate list list,l,i0) =
             let fun action (i,nil) = raise LexError
                   | action (i,nil::l) = action (i-1,l)
	           | action (i,(node::acts)::l) =
		     case node of N yyk 
                     => (let val yytext = String.substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			     fun REJECT() = action(i,acts::l)
			     open HolUserDeclarations
                         in (yybufpos := i; 
                             case yyk of 
                             1 => (continue())
                         | 101 => ( YYBEGIN INITIAL;
                                    case yytext 
                                    of ";"  => HolTokens.semi_colon(line,line)
                                     | "=>" => HolTokens.eq_gt(line,line)
                                     | "="  => HolTokens.eq(line,line)
                                     | "|"  => HolTokens.bar(line,line)
                                     | "::" => HolTokens.dcolon(line,line)
                                     |  _   => 
                                       if (Parse_support.is_binder yytext)
                                       then HolTokens.binder(yytext,line,line)
                                  else HolTokens.symbolic_ident(yytext,line,line))
                         | 104 => (YYBEGIN INITIAL;HolTokens.ident("~",line,line))
                         | 106 => (YYBEGIN INITIAL;HolTokens.ident("~",line,line))
                         | 109 => (YYBEGIN INITIAL;
                                   HolTokens.symbolic_ident("$,",line,line))
                         | 11 => (HolTokens.dot(line,line))
                         | 111 => (YYBEGIN INITIAL;
                                   HolTokens.symbolic_ident(",",line,line))
                         | 113 => (raise LEX_ERR "TYPE.catchall")
                         | 115 => (continue())
                         | 118 => (inc comment_paren_count; continue())
                         | 121 => (dec comment_paren_count;
                                   if (!comment_paren_count = 0) 
                                   then YYBEGIN TYPE else (); continue())
                         | 123 => (let val (L as ref (_::t)) = aqlist
                                       val () = L := t
                                   in continue() end)
                         | 125 => (continue())
                         | 127 => (continue())
                         | 13 => (HolTokens.lparen(line,line))
                         | 130 => (inc comment_paren_count; continue())
                         | 133 => (dec comment_paren_count;
                                   if (!comment_paren_count = 0) 
                                   then YYBEGIN INITIAL else (); continue())
                         | 135 => (let val (L as ref (_::t)) = aqlist
                                       val () = L := t
                                   in continue() end)
                         | 137 => (continue())
                         | 139 => (string_list :=  yytext::(!string_list); 
                                   continue())
                         | 142 => (string_list := yytext::(!string_list); 
                                   continue())
                         | 144 => (YYBEGIN INITIAL; 
                                   HolTokens.string_
                                    (Portable.implode
                                      (rev(yytext::(!string_list))),line,line))
                         | 147 => (let val (L as ref (_::t)) = aqlist
                                      val () = L := t
                                    val () = string_list := "^"::(!string_list)
                                   in continue() end)
                         | 149 => (let val (L as ref (x::t)) = aqlist
                                       val () = L := t
                                       val () = string_list := string_aq x
                                                               ::(!string_list)
                                   in continue() end)
                         | 15  => (HolTokens.rparen(line,line))
                         | 151 => (string_list := yytext::(!string_list); 
                                   continue())
                         | 17 => (HolTokens.lbrace(line,line))
                         | 19 => (HolTokens.rbrace(line,line))
                         | 21 => (HolTokens.lbracket(line,line))
                         | 23 => (HolTokens.rbracket(line,line))
                         | 25 => (let val (L as ref (x::t)) = aqlist
                                      val _ = L := t
                                  in HolTokens.aq(x,line,line)
                                  end handle _ => raise AQ_ERR "lexer.INITIAL")
                         | 29 => (case yytext of 
                                  "let" => HolTokens.let_(line,line)
                                | "in" => HolTokens.in_(line,line)
                                | "and" => HolTokens.and_(line,line)
                                | "of" => (case (!Globals.in_type_spec) of 
                                           NONE => raise LEX_ERR
                                               (Lib.quote"of"^" is a keyword.")
                                        | (SOME"") => raise LEX_ERR
                                               (Lib.quote"of"^" is a keyword.")
                                        | (SOME _) => (YYBEGIN TYPE; 
                                                       type_paren_count := 0;
                                                       HolTokens.of_(line,line)))
                                        |    _ => 
                                           if (Parse_support.is_binder yytext)
                                           then HolTokens.binder(yytext,line,line)
                                           else HolTokens.ident(yytext,line,line))
                         | 33 => ( if (has_tilde yytext
                                   andalso (Lib.mem (drop_dollar yytext) 
                                                    (!Globals.tilde_symbols)))
                                   then 
                                     if (Parse_support.is_binder yytext)
                                     then HolTokens.binder(yytext,line,line)
                                   else HolTokens.symbolic_ident(yytext,line,line)
                                   else REJECT())
                         | 37 => ( case yytext of 
                                   ";" => HolTokens.semi_colon(line,line)
                                 | "=>" => HolTokens.eq_gt(line,line)
                                 | "="  => HolTokens.eq(line,line)
                                 | "|"  => HolTokens.bar(line,line)
                                 | "::" => HolTokens.dcolon(line,line)
                                 | ":" => ((case(!Globals.in_type_spec) of 
                                           NONE => (YYBEGIN TYPE;  
                                                    type_paren_count := 0)
                                           | _ => ()); HolTokens.colon(line,line))
                                 |   _  => if (Parse_support.is_binder yytext)
                                           then HolTokens.binder(yytext,line,line)
                                  else HolTokens.symbolic_ident(yytext,line,line))
                         | 4 => (continue())
                         | 40 => (HolTokens.ident("~",line,line))
                         | 42 => (HolTokens.ident("~",line,line))
                         | 45 => (HolTokens.symbolic_ident("$,",line,line))
                         | 47 => (HolTokens.symbolic_ident(",",line,line))
                         | 49 => (raise LEX_ERR "INITIAL.catchall")
                         | 51 => (continue())
                         | 54 => (continue())
                         | 57 => ( YYBEGIN TYCOMMENT; comment_paren_count := 1;
                                   continue())
                         | 61 => (HolTokens.type_var_ident(yytext,line,line))
                         | 65 => (case yytext of 
                                  "let" => (YYBEGIN INITIAL; 
                                            HolTokens.let_(line,line))
                                | "in"  => (YYBEGIN INITIAL; 
                                            HolTokens.in_(line,line))
                                | "and" => (YYBEGIN INITIAL; 
                                            HolTokens.and_(line,line))
                                |    _ => HolTokens.type_ident(yytext,line,line))
                         | 67 => (let val (L as ref (x::t)) = aqlist
                                      val () = L := t
                                  in HolTokens.aq(x,line,line) end
                                  handle _ => raise AQ_ERR "lexer.TYPE")
                         | 7 => ( YYBEGIN COMMENT; comment_paren_count := 1; 
                                  continue())
                         | 70 => (HolTokens.arrow(line,line))
                         | 72 => (HolTokens.type_plus(line,line))
                         | 74 => (HolTokens.type_hash(line,line))
                         | 76 => (if (!type_paren_count = 0)
                                  then (YYBEGIN INITIAL; 
                                        HolTokens.symbolic_ident(",",line,line))
                                  else HolTokens.type_comma(line,line))
                         | 78 => (YYBEGIN INITIAL; HolTokens.dot(line,line))
                         | 80 => (inc type_paren_count; 
                                  HolTokens.type_lparen(line,line))
                         | 82 => (if (!type_paren_count = 0)
                                  then (YYBEGIN INITIAL; 
                                        HolTokens.rparen(line,line))
                                  else (dec type_paren_count; 
                                        HolTokens.type_rparen(line,line)))
                         | 84 => (YYBEGIN INITIAL; HolTokens.lbracket(line,line))
                         | 86 => (YYBEGIN INITIAL; HolTokens.rbracket(line,line))
                         | 88 => (YYBEGIN INITIAL; HolTokens.lbrace(line,line))
                         | 9 => ( YYBEGIN STRING; string_list := [yytext]; 
                                  continue())
                         | 90 => (YYBEGIN INITIAL; HolTokens.rbrace(line,line))
                         | 93 => ((case (!Globals.in_type_spec)
                                     of (SOME _) => ()
                                      | NONE => YYBEGIN INITIAL);
                                  HolTokens.eq_gt(line,line))
                         | 97 => ( if (has_tilde yytext 
                                   andalso (Lib.mem (drop_dollar yytext) 
                                           (!Globals.tilde_symbols)))
                                   then( YYBEGIN INITIAL;
                                         if (Parse_support.is_binder yytext)
                                         then HolTokens.binder(yytext,line,line)
                                  else HolTokens.symbolic_ident(yytext,line,line))
                                   else REJECT())
                         | _ => raise LexerError

		) end )

	val {fin,trans} = Vector.sub(tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(tab,0))
	       then action(l,NewAcceptingLeaves) 
               else let val newchars = if !yydone then "" else yyinput 1024
	            in if (size newchars)=0
		       then (yydone := true;
		             if (l=i0) then HolUserDeclarations.eof yyarg
		                       else action(l,NewAcceptingLeaves))
		       else (if i0=l then yyb := newchars
                             else yyb := String.substring(!yyb,i0,l-i0)^newchars;
		             yygone := !yygone+i0;
		             yybl := size (!yyb);
		             scan (s,AcceptingLeaves,l-i0,0))
	            end
	  else let val NewChar = Char.ord(String.sub(!yyb,l))
                   val NewState = if NewChar<128 
                                  then Char.ord(String.sub(trans,NewChar)) 
                                  else Char.ord(String.sub(trans,128))
               in if NewState=0 then action(l,NewAcceptingLeaves)
		  else scan(NewState,NewAcceptingLeaves,l+1,i0)
               end
       end
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end

end;
