functor HOL_LEX(structure Tokens : hol_TOKENS
                         structure Parse_support : Parse_support_sig
                         sharing
                           Tokens.Parse_support = Parse_support)=
   struct
    structure UserDeclarations =
      struct
structure Parse_support = Parse_support;
structure Tokens = Tokens;

type pos = int;
val line:pos = 0;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) Tokens.token;


fun error(s,_,_) = output(std_out,"HOL lexer error: "^s^"\n");

fun eof (_:Tokens.Parse_support.Preterm.Term.term list ref) = Tokens.EOF(line,line);
val type_paren_count = ref 0;
val comment_paren_count = ref 0;
val string_list = ref ([]:string list);
exception AQ_ERR of string;
exception LEX_ERR of string;

fun has_tilde s =
   let val tilde = ord "~"
       fun f i = ((ordof(s,i) = tilde) orelse f(i+1))
   in f 0 handle _ => false
   end;

fun drop_dollar s =
   let val dollar = ord "$"
   in if (ordof(s,0) = dollar)
      then substring(s,1,String.size s - 1)
      else s
   end;

(*
 * fun break s = snd
 *    (itlist (fn ch => fn (current_frag,seen) =>
 *              if (ch = "~")
 *              then if (null current_frag)
 *                   then ([],(ch::seen))
 *                   else ([],(ch::(implode current_frag)::seen))
 *              else ((ch::current_frag),seen))
 *            (""::explode s) ([],[]));
 ****)


(* Confusion warning: symbolic_ident means roughly 

       Maybe a $ followed by any sequence of symbols
*)
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\011\011\011\011\011\011\011\011\011\030\032\011\030\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\030\015\029\015\027\015\015\011\025\024\015\015\015\015\023\015\
\\018\018\018\018\018\018\018\018\018\018\015\015\015\015\015\015\
\\015\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\022\015\021\020\015\
\\011\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\017\015\014\012\011\
\\011"
val s3 =
"\033\033\033\033\033\033\033\033\033\060\062\033\060\033\033\033\
\\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\
\\060\037\033\059\057\037\037\055\053\052\037\051\050\048\047\037\
\\040\040\040\040\040\040\040\040\040\040\037\037\037\045\037\037\
\\037\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\044\037\043\042\037\
\\033\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\039\037\036\034\033\
\\033"
val s5 =
"\063\063\063\063\063\063\063\063\063\063\068\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\066\063\064\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063"
val s7 =
"\069\069\069\069\069\069\069\069\069\069\074\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\072\069\070\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069"
val s9 =
"\075\075\075\075\075\075\075\075\075\075\079\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\078\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\076\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\013\000\013\000\013\013\000\000\000\013\013\013\013\000\013\
\\000\000\000\000\000\000\000\000\000\000\013\013\013\013\013\013\
\\013\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\000\013\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\013\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\016\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\016\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\016\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\013\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\019\000\000\000\000\000\000\000\000\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
val s25 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\026\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\016\016\000\016\
\\019\019\019\019\019\019\019\019\019\019\016\016\016\016\016\016\
\\016\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\000\016\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\028\000\
\\000"
val s30 =
"\000\000\000\000\000\000\000\000\000\031\031\000\031\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s34 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\035\000\035\000\035\035\000\000\000\035\035\035\035\000\035\
\\000\000\000\000\000\000\000\000\000\000\035\035\035\035\035\035\
\\035\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\035\000\000\035\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\035\000\035\000\
\\000"
val s37 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\038\000\038\000\038\038\000\000\000\038\038\038\038\000\038\
\\000\000\000\000\000\000\000\000\000\000\038\038\038\038\038\038\
\\038\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\000\038\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\035\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\041\000\000\000\000\000\000\000\000\
\\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\000\
\\000\041\041\041\041\041\041\041\041\041\041\041\041\041\041\041\
\\041\041\041\041\041\041\041\041\041\041\041\000\000\000\000\041\
\\000\041\041\041\041\041\041\041\041\041\041\041\041\041\041\041\
\\041\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\
\\000"
val s45 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\038\000\038\000\038\038\000\000\000\038\038\038\038\000\038\
\\000\000\000\000\000\000\000\000\000\000\038\038\038\038\046\038\
\\038\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\000\038\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\035\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\038\000\038\000\038\038\000\000\000\038\038\038\038\000\038\
\\000\000\000\000\000\000\000\000\000\000\038\038\038\038\049\038\
\\038\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\000\038\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\038\000\035\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\054\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\000\000\000\000\000\
\\000\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\056\056\056\056\056\056\056\056\056\056\000\000\000\000\000\000\
\\000\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\000\000\000\000\056\
\\000\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\000\000\000\000\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\038\000\038\000\038\038\000\000\000\038\038\038\038\000\038\
\\041\041\041\041\041\041\041\041\041\041\038\038\038\038\038\038\
\\038\041\041\041\041\041\041\041\041\041\041\041\041\041\041\041\
\\041\041\041\041\041\041\041\041\041\041\041\000\038\000\000\038\
\\000\041\041\041\041\041\041\041\041\041\041\041\041\041\041\041\
\\041\041\041\041\041\041\041\041\041\041\041\000\038\000\058\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\061\061\000\061\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\061\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\065\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\067\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s70 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\071\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s72 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\073\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\077\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [], trans = s9},
{fin = [], trans = s9},
{fin = [(N 44)], trans = s0},
{fin = [(N 33),(N 42),(N 44)], trans = s12},
{fin = [(N 33)], trans = s12},
{fin = [(N 19),(N 44)], trans = s0},
{fin = [(N 33),(N 37),(N 44)], trans = s15},
{fin = [(N 33),(N 37)], trans = s15},
{fin = [(N 17),(N 44)], trans = s0},
{fin = [(N 29),(N 44)], trans = s18},
{fin = [(N 29)], trans = s18},
{fin = [(N 25),(N 44)], trans = s0},
{fin = [(N 23),(N 44)], trans = s0},
{fin = [(N 21),(N 44)], trans = s0},
{fin = [(N 11),(N 44)], trans = s0},
{fin = [(N 15),(N 44)], trans = s0},
{fin = [(N 13),(N 44)], trans = s25},
{fin = [(N 7)], trans = s0},
{fin = [(N 44)], trans = s27},
{fin = [(N 33),(N 40)], trans = s12},
{fin = [(N 9),(N 44)], trans = s0},
{fin = [(N 4),(N 44)], trans = s30},
{fin = [(N 4)], trans = s30},
{fin = [(N 1),(N 4)], trans = s30},
{fin = [(N 103)], trans = s0},
{fin = [(N 92),(N 101),(N 103)], trans = s34},
{fin = [(N 92)], trans = s34},
{fin = [(N 85),(N 103)], trans = s0},
{fin = [(N 92),(N 96),(N 103)], trans = s37},
{fin = [(N 92),(N 96)], trans = s37},
{fin = [(N 83),(N 103)], trans = s0},
{fin = [(N 60),(N 103)], trans = s40},
{fin = [(N 60)], trans = s40},
{fin = [(N 62),(N 103)], trans = s0},
{fin = [(N 81),(N 103)], trans = s0},
{fin = [(N 79),(N 103)], trans = s0},
{fin = [(N 92),(N 96),(N 103)], trans = s45},
{fin = [(N 88),(N 92),(N 96)], trans = s37},
{fin = [(N 73),(N 103)], trans = s0},
{fin = [(N 92),(N 96),(N 103)], trans = s48},
{fin = [(N 65),(N 92),(N 96)], trans = s37},
{fin = [(N 71),(N 92),(N 96),(N 103)], trans = s37},
{fin = [(N 67),(N 92),(N 96),(N 103)], trans = s37},
{fin = [(N 77),(N 103)], trans = s0},
{fin = [(N 75),(N 103)], trans = s53},
{fin = [(N 52)], trans = s0},
{fin = [(N 103)], trans = s55},
{fin = [(N 56)], trans = s56},
{fin = [(N 103)], trans = s57},
{fin = [(N 92),(N 99)], trans = s34},
{fin = [(N 69),(N 92),(N 96),(N 103)], trans = s37},
{fin = [(N 49),(N 103)], trans = s60},
{fin = [(N 49)], trans = s60},
{fin = [(N 46),(N 49)], trans = s60},
{fin = [(N 113)], trans = s0},
{fin = [(N 113)], trans = s64},
{fin = [(N 111)], trans = s0},
{fin = [(N 113)], trans = s66},
{fin = [(N 108)], trans = s0},
{fin = [(N 105)], trans = s0},
{fin = [(N 123)], trans = s0},
{fin = [(N 123)], trans = s70},
{fin = [(N 121)], trans = s0},
{fin = [(N 123)], trans = s72},
{fin = [(N 118)], trans = s0},
{fin = [(N 115)], trans = s0},
{fin = [(N 132)], trans = s0},
{fin = [(N 132)], trans = s76},
{fin = [(N 128)], trans = s0},
{fin = [(N 130),(N 132)], trans = s0},
{fin = [(N 125)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 9;
val TYCOMMENT = STARTSTATE 5;
val TYPE = STARTSTATE 3;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
	exception Reject	(* for implementing REJECT *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

	val REJECT = fn () => raise Internal.Reject

fun lex (yyarg as (lala : Parse_support.Preterm.Term.term list ref)) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (continue())
| 101 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| 103 => (raise LEX_ERR "TYPE.catchall")
| 105 => (continue())
| 108 => (inc comment_paren_count; continue())
| 11 => (Tokens.dot(line,line))
| 111 => (dec comment_paren_count;
                    if (!comment_paren_count = 0)
                    then YYBEGIN TYPE
                    else ();
                    continue())
| 113 => (continue())
| 115 => (continue())
| 118 => (inc comment_paren_count; continue())
| 121 => (dec comment_paren_count;
                  if (!comment_paren_count = 0)
                  then YYBEGIN INITIAL
                  else ();
                  continue())
| 123 => (continue())
| 125 => (string_list :=  yytext::(!string_list); continue())
| 128 => (string_list := yytext::(!string_list); continue())
| 13 => (Tokens.lparen(line,line))
| 130 => (YYBEGIN INITIAL; 
              Tokens.string_(implode(rev(yytext::(!string_list))),line,line))
| 132 => (string_list :=  yytext::(!string_list); continue())
| 15 => (Tokens.rparen(line,line))
| 17 => (Tokens.lbrace(line,line))
| 19 => (Tokens.rbrace(line,line))
| 21 => (Tokens.lbracket(line,line))
| 23 => (Tokens.rbracket(line,line))
| 25 => (let val (L as ref (x::t)) = lala
                     val _ = L := t
                 in Tokens.aq(x,line,line)
                 end
                 handle _ => raise AQ_ERR "lexer.INITIAL")
| 29 => (case yytext
         of "let" => Tokens.let_(line,line)
          | "in" => Tokens.in_(line,line)
          | "and" => Tokens.and_(line,line)
          | "of" => (case (!Globals.in_type_spec)
                       of NONE => raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME"")=>raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME _) => (YYBEGIN TYPE; type_paren_count := 0;
                                      Tokens.of_(line,line)))
          |    _ => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.ident(yytext,line,line))
| 33 => ( if (has_tilde yytext
         andalso (mem (drop_dollar yytext) (!Globals.tilde_symbols)))
     then if (Parse_support.is_binder yytext)
          then Tokens.binder(yytext,line,line)
          else Tokens.symbolic_ident(yytext,line,line)
     else REJECT())
| 37 => ( case yytext 
         of ";" => Tokens.semi_colon(line,line)
          | "=>" => Tokens.eq_gt(line,line)
          | "="  => Tokens.eq(line,line)
          | "|"  => Tokens.bar(line,line)
          | "::" => Tokens.dcolon(line,line)
          | ":" => ((case(!Globals.in_type_spec)
                       of NONE => (YYBEGIN TYPE;  type_paren_count := 0)
                        | _ => ());
                    Tokens.colon(line,line))
          |   _  => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.symbolic_ident(yytext,line,line))
| 4 => (continue())
| 40 => (Tokens.ident("~",line,line))
| 42 => (Tokens.ident("~",line,line))
| 44 => (raise LEX_ERR "INITIAL.catchall")
| 46 => (continue())
| 49 => (continue())
| 52 => ( YYBEGIN TYCOMMENT; comment_paren_count := 1; continue())
| 56 => (Tokens.type_var_ident(yytext,line,line))
| 60 => (case yytext
                    of "let" => (YYBEGIN INITIAL; Tokens.let_(line,line))
                     | "in" => (YYBEGIN INITIAL; Tokens.in_(line,line))
                     | "and" => (YYBEGIN INITIAL; Tokens.and_(line,line))
                     |    _ => Tokens.type_ident(yytext,line,line))
| 62 => (let val (L as ref (x::t)) = lala
                  val () = L := t
              in Tokens.aq(x,line,line)
              end
              handle _ => raise AQ_ERR "lexer.TYPE")
| 65 => (Tokens.type_right_arrow(line,line))
| 67 => (Tokens.type_plus(line,line))
| 69 => (Tokens.type_hash(line,line))
| 7 => ( YYBEGIN COMMENT; comment_paren_count := 1; continue())
| 71 => (if (!type_paren_count = 0)
              then (YYBEGIN INITIAL; Tokens.symbolic_ident(",",line,line))
              else Tokens.type_comma(line,line))
| 73 => (YYBEGIN INITIAL; Tokens.dot(line,line))
| 75 => (inc type_paren_count; Tokens.type_lparen(line,line))
| 77 => (if (!type_paren_count = 0)
               then (YYBEGIN INITIAL; Tokens.rparen(line,line))
               else (dec type_paren_count; Tokens.type_rparen(line,line)))
| 79 => (YYBEGIN INITIAL; Tokens.lbracket(line,line))
| 81 => (YYBEGIN INITIAL; Tokens.rbracket(line,line))
| 83 => (YYBEGIN INITIAL; Tokens.lbrace(line,line))
| 85 => (YYBEGIN INITIAL; Tokens.rbrace(line,line))
| 88 => ((case (!Globals.in_type_spec)
                  of (SOME _) => ()
                   | NONE => YYBEGIN INITIAL);
               Tokens.eq_gt(line,line))
| 9 => ( YYBEGIN STRING; string_list := [yytext]; continue())
| 92 => ( if (has_tilde yytext 
         andalso (mem (drop_dollar yytext) (!Globals.tilde_symbols)))
     then( YYBEGIN INITIAL;
           if (Parse_support.is_binder yytext)
           then Tokens.binder(yytext,line,line)
           else Tokens.symbolic_ident(yytext,line,line))
     else REJECT())
| 96 => ( YYBEGIN INITIAL;
          case yytext 
            of ";"  => Tokens.semi_colon(line,line)
             | "=>" => Tokens.eq_gt(line,line)
             | "="  => Tokens.eq(line,line)
             | "|"  => Tokens.bar(line,line)
             | "::" => Tokens.dcolon(line,line)
             |   _  => if (Parse_support.is_binder yytext)
                       then Tokens.binder(yytext,line,line)
                       else Tokens.symbolic_ident(yytext,line,line))
| 99 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| _ => raise Internal.LexerError

		) end handle Reject => action(i,acts::l))

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
