functor HOL_LEX(structure Tokens : hol_TOKENS
                         structure Parse_support : Parse_support_sig
                         sharing
                           Tokens.Parse_support = Parse_support)=
   struct
    structure UserDeclarations =
      struct
structure Parse_support = Parse_support;
structure Tokens = Tokens;

type pos = int;
val line:pos = 0;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) Tokens.token;


fun error(s,_,_) = output(std_out,"HOL lexer error: "^s^"\n");

fun eof (_:Tokens.Parse_support.Preterm.Term.term list ref) = Tokens.EOF(line,line);
val type_paren_count = ref 0;
val comment_paren_count = ref 0;
val string_list = ref ([]:string list);
exception AQ_ERR of string;
exception LEX_ERR of string;

fun has_tilde s =
   let val tilde = ord "~"
       fun f i = ((ordof(s,i) = tilde) orelse f(i+1))
   in f 0 handle _ => false
   end;

(*
fun break s = snd
   (itlist (fn ch => fn (current_frag,seen) =>
             if (ch = "~")
             then if (null current_frag)
                  then ([],(ch::seen))
                  else ([],(ch::(implode current_frag)::seen))
             else ((ch::current_frag),seen))
           (""::explode s) ([],[]));
*)


(* Confusion warning: symbolic_ident means roughly 

       Maybe a $ followed by any sequence of symbols
*)
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\011\011\011\011\011\011\011\011\011\035\037\011\035\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\035\023\034\023\032\023\023\011\030\029\023\023\023\023\028\023\
\\021\021\021\021\021\021\021\021\021\021\023\023\023\023\023\023\
\\023\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\026\023\025\024\023\
\\011\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\019\015\014\012\011\
\\011"
val s3 =
"\038\038\038\038\038\038\038\038\038\070\072\038\070\038\038\038\
\\038\038\038\038\038\038\038\038\038\038\038\038\038\038\038\038\
\\070\050\038\069\067\050\050\065\063\062\050\061\060\058\057\050\
\\048\048\048\048\048\048\048\048\048\048\050\050\050\055\050\050\
\\050\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\053\050\052\051\050\
\\038\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\046\042\041\039\038\
\\038"
val s5 =
"\073\073\073\073\073\073\073\073\073\073\078\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\076\073\074\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\073\
\\073"
val s7 =
"\079\079\079\079\079\079\079\079\079\079\084\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\082\079\080\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\079\
\\079"
val s9 =
"\085\085\085\085\085\085\085\085\085\085\089\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\088\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\086\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\013\000\013\000\013\013\000\000\000\013\013\013\013\000\013\
\\000\000\000\000\000\000\000\000\000\000\013\013\013\013\013\013\
\\013\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\000\013\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\013\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\017\000\017\000\017\017\000\000\000\017\017\017\017\000\017\
\\000\000\000\000\000\000\000\000\000\000\017\017\017\017\017\017\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\018\000\017\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\016\013\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\017\000\017\000\017\017\000\000\000\017\017\017\017\000\017\
\\000\000\000\000\000\000\000\000\000\000\017\017\017\017\017\017\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\000\000\017\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\000\013\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\022\000\000\000\000\000\000\000\000\
\\022\022\022\022\022\022\022\022\022\022\000\000\000\000\000\000\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\000\000\000\022\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\000\000\000\000\
\\000"
val s26 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\027\000\000\000\
\\000"
val s30 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\031\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\017\000\017\000\017\017\000\000\000\017\017\017\017\000\017\
\\022\022\022\022\022\022\022\022\022\022\017\017\017\017\017\017\
\\017\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\017\000\000\017\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\017\000\033\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\036\036\000\036\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\036\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\040\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\040\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\040\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\000\044\000\044\044\000\000\000\044\044\044\044\000\044\
\\000\000\000\000\000\000\000\000\000\000\044\044\044\044\044\044\
\\044\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\045\000\044\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\043\040\000\
\\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\000\044\000\044\044\000\000\000\044\044\044\044\000\044\
\\000\000\000\000\000\000\000\000\000\000\044\044\044\044\044\044\
\\044\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\000\044\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\040\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\047\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\049\000\000\000\000\000\000\000\000\
\\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\000\
\\000\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\000\000\000\049\
\\000\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\054\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\000\044\000\044\044\000\000\000\044\044\044\044\000\044\
\\000\000\000\000\000\000\000\000\000\000\044\044\044\044\056\044\
\\044\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\000\044\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\040\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\000\044\000\044\044\000\000\000\044\044\044\044\000\044\
\\000\000\000\000\000\000\000\000\000\000\044\044\044\044\059\044\
\\044\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\000\044\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\044\000\040\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\064\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s65 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\000\000\000\000\000\
\\000\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\000\000\000\000\000\
\\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\066\066\066\066\066\066\066\066\066\066\000\000\000\000\000\000\
\\000\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\000\000\000\000\066\
\\000\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\000\000\000\000\000\
\\000"
val s67 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\000\044\000\044\044\000\000\000\044\044\044\044\000\044\
\\049\049\049\049\049\049\049\049\049\049\044\044\044\044\044\044\
\\044\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\044\000\000\044\
\\000\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\044\000\068\000\
\\000"
val s70 =
"\000\000\000\000\000\000\000\000\000\071\071\000\071\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\071\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s74 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\075\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\077\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s80 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\081\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s82 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\083\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s86 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\087\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [], trans = s9},
{fin = [], trans = s9},
{fin = [(N 56)], trans = s0},
{fin = [(N 45),(N 54),(N 56)], trans = s12},
{fin = [(N 45)], trans = s12},
{fin = [(N 19),(N 56)], trans = s0},
{fin = [(N 45),(N 49),(N 56)], trans = s15},
{fin = [(N 29)], trans = s0},
{fin = [(N 45),(N 49)], trans = s17},
{fin = [(N 35)], trans = s0},
{fin = [(N 17),(N 56)], trans = s19},
{fin = [(N 26)], trans = s0},
{fin = [(N 41),(N 56)], trans = s21},
{fin = [(N 41)], trans = s21},
{fin = [(N 45),(N 49),(N 56)], trans = s17},
{fin = [(N 37),(N 56)], trans = s0},
{fin = [(N 23),(N 56)], trans = s0},
{fin = [(N 21),(N 56)], trans = s26},
{fin = [(N 32)], trans = s0},
{fin = [(N 11),(N 56)], trans = s0},
{fin = [(N 15),(N 56)], trans = s0},
{fin = [(N 13),(N 56)], trans = s30},
{fin = [(N 7)], trans = s0},
{fin = [(N 56)], trans = s32},
{fin = [(N 45),(N 52)], trans = s12},
{fin = [(N 9),(N 56)], trans = s0},
{fin = [(N 4),(N 56)], trans = s35},
{fin = [(N 4)], trans = s35},
{fin = [(N 1),(N 4)], trans = s35},
{fin = [(N 127)], trans = s0},
{fin = [(N 116),(N 125),(N 127)], trans = s39},
{fin = [(N 116)], trans = s39},
{fin = [(N 97),(N 127)], trans = s0},
{fin = [(N 116),(N 120),(N 127)], trans = s42},
{fin = [(N 109)], trans = s0},
{fin = [(N 116),(N 120)], trans = s44},
{fin = [(N 103)], trans = s0},
{fin = [(N 95),(N 127)], trans = s46},
{fin = [(N 106)], trans = s0},
{fin = [(N 72),(N 127)], trans = s48},
{fin = [(N 72)], trans = s48},
{fin = [(N 116),(N 120),(N 127)], trans = s44},
{fin = [(N 74),(N 127)], trans = s0},
{fin = [(N 93),(N 127)], trans = s0},
{fin = [(N 91),(N 127)], trans = s53},
{fin = [(N 100)], trans = s0},
{fin = [(N 116),(N 120),(N 127)], trans = s55},
{fin = [(N 112),(N 116),(N 120)], trans = s44},
{fin = [(N 85),(N 127)], trans = s0},
{fin = [(N 116),(N 120),(N 127)], trans = s58},
{fin = [(N 77),(N 116),(N 120)], trans = s44},
{fin = [(N 83),(N 116),(N 120),(N 127)], trans = s44},
{fin = [(N 79),(N 116),(N 120),(N 127)], trans = s44},
{fin = [(N 89),(N 127)], trans = s0},
{fin = [(N 87),(N 127)], trans = s63},
{fin = [(N 64)], trans = s0},
{fin = [(N 127)], trans = s65},
{fin = [(N 68)], trans = s66},
{fin = [(N 127)], trans = s67},
{fin = [(N 116),(N 123)], trans = s39},
{fin = [(N 81),(N 116),(N 120),(N 127)], trans = s44},
{fin = [(N 61),(N 127)], trans = s70},
{fin = [(N 61)], trans = s70},
{fin = [(N 58),(N 61)], trans = s70},
{fin = [(N 137)], trans = s0},
{fin = [(N 137)], trans = s74},
{fin = [(N 135)], trans = s0},
{fin = [(N 137)], trans = s76},
{fin = [(N 132)], trans = s0},
{fin = [(N 129)], trans = s0},
{fin = [(N 147)], trans = s0},
{fin = [(N 147)], trans = s80},
{fin = [(N 145)], trans = s0},
{fin = [(N 147)], trans = s82},
{fin = [(N 142)], trans = s0},
{fin = [(N 139)], trans = s0},
{fin = [(N 156)], trans = s0},
{fin = [(N 156)], trans = s86},
{fin = [(N 152)], trans = s0},
{fin = [(N 154),(N 156)], trans = s0},
{fin = [(N 149)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 9;
val TYCOMMENT = STARTSTATE 5;
val TYPE = STARTSTATE 3;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (lala : Parse_support.Preterm.Term.term list ref)) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			fun REJECT() = action(i,acts::l)
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (continue())
| 100 => (YYBEGIN INITIAL; Tokens.hoare_lbracket(line,line))
| 103 => (YYBEGIN INITIAL; Tokens.hoare_rbracket(line,line))
| 106 => (YYBEGIN INITIAL; Tokens.hoare_lbrace(line,line))
| 109 => (YYBEGIN INITIAL; Tokens.hoare_rbrace(line,line))
| 11 => (Tokens.dot(line,line))
| 112 => ((case (!Globals.in_type_spec)
                  of (SOME _) => ()
                   | NONE => YYBEGIN INITIAL);
               Tokens.eq_gt(line,line))
| 116 => ( if ((has_tilde yytext) andalso not(mem yytext (!Globals.tilde_symbols)))
     then( YYBEGIN INITIAL;
           if (Parse_support.is_binder yytext)
           then Tokens.binder(yytext,line,line)
           else Tokens.symbolic_ident(yytext,line,line))
     else REJECT())
| 120 => ( YYBEGIN INITIAL;
          case yytext 
            of 
      (* Hoare logic symbolic identifiers *)
               ";;" => Tokens.hoare_command_sep(line,line)          
             | ":=" => Tokens.hoare_assign(line,line)          
      (* end Hoare logic symbolic identifiers *)

             | ";"  => Tokens.semi_colon(line,line)
             | "=>" => Tokens.eq_gt(line,line)
             | "=" => Tokens.eq(line,line)
             | "|"  => Tokens.bar(line,line)
             |   _  => if (Parse_support.is_binder yytext)
                       then Tokens.binder(yytext,line,line)
                       else Tokens.symbolic_ident(yytext,line,line))
| 123 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| 125 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| 127 => (raise LEX_ERR "TYPE.catchall")
| 129 => (continue())
| 13 => (Tokens.lparen(line,line))
| 132 => (inc comment_paren_count; continue())
| 135 => (dec comment_paren_count;
                    if (!comment_paren_count = 0)
                    then YYBEGIN TYPE
                    else ();
                    continue())
| 137 => (continue())
| 139 => (continue())
| 142 => (inc comment_paren_count; continue())
| 145 => (dec comment_paren_count;
                  if (!comment_paren_count = 0)
                  then YYBEGIN INITIAL
                  else ();
                  continue())
| 147 => (continue())
| 149 => (string_list :=  yytext::(!string_list); continue())
| 15 => (Tokens.rparen(line,line))
| 152 => (string_list := yytext::(!string_list); continue())
| 154 => (YYBEGIN INITIAL; 
              Tokens.string_(implode(rev(yytext::(!string_list))),line,line))
| 156 => (string_list :=  yytext::(!string_list); continue())
| 17 => (Tokens.lbrace(line,line))
| 19 => (Tokens.rbrace(line,line))
| 21 => (Tokens.lbracket(line,line))
| 23 => (Tokens.rbracket(line,line))
| 26 => (Tokens.hoare_lbrace(line,line))
| 29 => (Tokens.hoare_rbrace(line,line))
| 32 => (Tokens.hoare_lbracket(line,line))
| 35 => (Tokens.hoare_rbracket(line,line))
| 37 => (let val (L as ref (x::t)) = lala
                     val _ = L := t
                 in Tokens.aq(x,line,line)
                 end
                 handle _ => raise AQ_ERR "lexer.INITIAL")
| 4 => (continue())
| 41 => (case yytext
         of 
     (* Hoare logic identifiers *)
            "skip" => Tokens.hoare_skip(line,line)
          | "abort" => Tokens.hoare_abort(line,line)
          | "if" => Tokens.hoare_if(line,line)
          | "then" => Tokens.hoare_then(line,line)
          | "else" => Tokens.hoare_else(line,line)
          | "fi" => Tokens.hoare_fi(line,line)
          | "assert" => Tokens.hoare_assert(line,line)
          | "invariant" => Tokens.hoare_invariant(line,line)
          | "variant" => Tokens.hoare_variant(line,line)
          | "while" => Tokens.hoare_while(line,line)
          | "do" => Tokens.hoare_do(line,line)
          | "done" => Tokens.hoare_done(line,line)
     (* end Hoare logic identifiers *)

          | "let" => Tokens.let_(line,line)
          | "in" => Tokens.in_(line,line)
          | "and" => Tokens.and_(line,line)
          | "of" => (case (!Globals.in_type_spec)
                       of NONE => raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME"")=>raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME _) => (YYBEGIN TYPE; type_paren_count := 0;
                                      Tokens.of_(line,line)))
          |    _ => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.ident(yytext,line,line))
| 45 => ( if ((has_tilde yytext) andalso (mem yytext (!Globals.tilde_symbols)))
     then if (Parse_support.is_binder yytext)
          then Tokens.binder(yytext,line,line)
          else Tokens.symbolic_ident(yytext,line,line)
     else REJECT())
| 49 => ( case yytext 
         of 
      (* Hoare logic symbolic identifiers *)
            ";;" => Tokens.hoare_command_sep(line,line)          
          | ":=" => Tokens.hoare_assign(line,line)          
      (* end Hoare logic symbolic identifiers *)

          | ";" => Tokens.semi_colon(line,line)
          | "=>" => Tokens.eq_gt(line,line)
          | "="  => Tokens.eq(line,line)
          | "|"  => Tokens.bar(line,line)
          | ":" => ((case(!Globals.in_type_spec)
                       of NONE => (YYBEGIN TYPE;  type_paren_count := 0)
                        | _ => ());
                    Tokens.colon(line,line))
          |   _  => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.symbolic_ident(yytext,line,line))
| 52 => (Tokens.ident("~",line,line))
| 54 => (Tokens.ident("~",line,line))
| 56 => (raise LEX_ERR "INITIAL.catchall")
| 58 => (continue())
| 61 => (continue())
| 64 => ( YYBEGIN TYCOMMENT; comment_paren_count := 1; continue())
| 68 => (Tokens.type_var_ident(yytext,line,line))
| 7 => ( YYBEGIN COMMENT; comment_paren_count := 1; continue())
| 72 => (case yytext
                    of 
                (* Hoare logic keywords *)
                       "skip" => Tokens.hoare_skip(line,line)
                     | "abort" => Tokens.hoare_abort(line,line)
                     | "if" => Tokens.hoare_if(line,line)
                     | "then" => Tokens.hoare_then(line,line)
                     | "else" => Tokens.hoare_else(line,line)
                     | "fi" => Tokens.hoare_fi(line,line)
                     | "assert" => Tokens.hoare_assert(line,line)
                     | "invariant" => Tokens.hoare_invariant(line,line)
                     | "variant" => Tokens.hoare_variant(line,line)
                     | "while" => Tokens.hoare_while(line,line)
                     | "do" => Tokens.hoare_do(line,line)
                     | "done" => Tokens.hoare_done(line,line)
                (* end Hoare logic keywords *)

                     | "let" => (YYBEGIN INITIAL; Tokens.let_(line,line))
                     | "in" => (YYBEGIN INITIAL; Tokens.in_(line,line))
                     | "and" => (YYBEGIN INITIAL; Tokens.and_(line,line))
                     |    _ => Tokens.type_ident(yytext,line,line))
| 74 => (let val (L as ref (x::t)) = lala
                  val () = L := t
              in Tokens.aq(x,line,line)
              end
              handle _ => raise AQ_ERR "lexer.TYPE")
| 77 => (Tokens.type_right_arrow(line,line))
| 79 => (Tokens.type_plus(line,line))
| 81 => (Tokens.type_hash(line,line))
| 83 => (if (!type_paren_count = 0)
              then (YYBEGIN INITIAL; Tokens.symbolic_ident(",",line,line))
              else Tokens.type_comma(line,line))
| 85 => (YYBEGIN INITIAL; Tokens.dot(line,line))
| 87 => (inc type_paren_count; Tokens.type_lparen(line,line))
| 89 => (if (!type_paren_count = 0)
               then (YYBEGIN INITIAL; Tokens.rparen(line,line))
               else (dec type_paren_count; Tokens.type_rparen(line,line)))
| 9 => ( YYBEGIN STRING; string_list := [yytext]; continue())
| 91 => (YYBEGIN INITIAL; Tokens.lbracket(line,line))
| 93 => (YYBEGIN INITIAL; Tokens.rbracket(line,line))
| 95 => (YYBEGIN INITIAL; Tokens.lbrace(line,line))
| 97 => (YYBEGIN INITIAL; Tokens.rbrace(line,line))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
